/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.handler.manager;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.eventspy.AbstractEventSpy;
import org.apache.maven.execution.ExecutionEvent;

@Named
@Singleton
public class LegacyArtifactHandlerManager
extends AbstractEventSpy {
    private final Map<String, ArtifactHandler> artifactHandlers;
    private final Map<String, ArtifactHandler> allHandlers = new ConcurrentHashMap<String, ArtifactHandler>();

    @Inject
    public LegacyArtifactHandlerManager(Map<String, ArtifactHandler> artifactHandlers) {
        this.artifactHandlers = Objects.requireNonNull(artifactHandlers);
    }

    @Override
    public void onEvent(Object event) {
        ExecutionEvent executionEvent;
        if (event instanceof ExecutionEvent && (executionEvent = (ExecutionEvent)event).getType() == ExecutionEvent.Type.SessionEnded) {
            this.allHandlers.clear();
        }
    }

    public ArtifactHandler getArtifactHandler(String type) {
        Objects.requireNonNull(type, "null type");
        ArtifactHandler handler = this.allHandlers.get(type);
        if (handler == null) {
            handler = this.artifactHandlers.get(type);
            if (handler == null) {
                handler = new DefaultArtifactHandler(type);
            } else {
                this.allHandlers.put(type, handler);
            }
        }
        return handler;
    }
}

