/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component._ComponentUtils;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;

public class UIViewRoot
extends UIComponentBase {
    public static final String COMPONENT_TYPE = "javax.faces.ViewRoot";
    public static final String COMPONENT_FAMILY = "javax.faces.ViewRoot";
    public static final String UNIQUE_ID_PREFIX = "_id";
    private static final int ANY_PHASE_ORDINAL = PhaseId.ANY_PHASE.getOrdinal();
    private long _uniqueIdCounter = 0L;
    private String _renderKitId = null;
    private String _viewId = null;
    private Locale _locale = null;
    private List _events = null;

    public String getViewId() {
        return this._viewId;
    }

    public void setViewId(String viewId) {
        this._viewId = viewId;
    }

    public void queueEvent(FacesEvent event) {
        if (event == null) {
            throw new NullPointerException("event");
        }
        if (this._events == null) {
            this._events = new ArrayList();
        }
        this._events.add(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _broadcastForPhase(PhaseId phaseId) {
        if (this._events == null) {
            return;
        }
        boolean abort = false;
        int phaseIdOrdinal = phaseId.getOrdinal();
        ListIterator listiterator = this._events.listIterator();
        while (listiterator.hasNext()) {
            FacesEvent event = (FacesEvent)listiterator.next();
            int ordinal = event.getPhaseId().getOrdinal();
            if (ordinal != ANY_PHASE_ORDINAL && ordinal != phaseIdOrdinal) continue;
            UIComponent source = event.getComponent();
            try {
                source.broadcast(event);
            }
            catch (AbortProcessingException e) {
                abort = true;
                break;
            }
            finally {
                try {
                    listiterator.remove();
                }
                catch (ConcurrentModificationException cme) {
                    int eventIndex = listiterator.previousIndex();
                    this._events.remove(eventIndex);
                    listiterator = this._events.listIterator();
                }
            }
        }
        if (abort) {
            this.clearEvents();
        }
    }

    private void clearEvents() {
        this._events = null;
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        super.processDecodes(context);
        this._broadcastForPhase(PhaseId.APPLY_REQUEST_VALUES);
        if (context.getRenderResponse() || context.getResponseComplete()) {
            this.clearEvents();
        }
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        super.processValidators(context);
        this._broadcastForPhase(PhaseId.PROCESS_VALIDATIONS);
        if (context.getRenderResponse() || context.getResponseComplete()) {
            this.clearEvents();
        }
    }

    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        super.processUpdates(context);
        this._broadcastForPhase(PhaseId.UPDATE_MODEL_VALUES);
        if (context.getRenderResponse() || context.getResponseComplete()) {
            this.clearEvents();
        }
    }

    public void processApplication(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        this._broadcastForPhase(PhaseId.INVOKE_APPLICATION);
        if (context.getRenderResponse() || context.getResponseComplete()) {
            this.clearEvents();
        }
    }

    public void encodeBegin(FacesContext context) throws IOException {
        this.clearEvents();
        super.encodeBegin(context);
    }

    public String createUniqueId() {
        ExternalContext extCtx = this.getFacesContext().getExternalContext();
        return extCtx.encodeNamespace(UNIQUE_ID_PREFIX + this._uniqueIdCounter++);
    }

    public Locale getLocale() {
        if (this._locale != null) {
            return this._locale;
        }
        ValueBinding vb = this.getValueBinding("locale");
        FacesContext facesContext = this.getFacesContext();
        if (vb == null) {
            return facesContext.getApplication().getViewHandler().calculateLocale(facesContext);
        }
        Object locale = vb.getValue(facesContext);
        if (locale == null) {
            return facesContext.getApplication().getViewHandler().calculateLocale(facesContext);
        }
        if (locale instanceof Locale) {
            return (Locale)locale;
        }
        if (locale instanceof String) {
            return UIViewRoot.getLocale((String)locale);
        }
        throw new IllegalArgumentException("locale binding");
    }

    public void setLocale(Locale locale) {
        this._locale = locale;
    }

    private static Locale getLocale(String locale) {
        int cnt = 0;
        int pos = 0;
        int prev = 0;
        String[] lv = new String[3];
        Locale l = null;
        while ((pos = locale.indexOf(95, prev)) != -1) {
            lv[cnt++] = locale.substring(prev, pos);
            prev = pos + 1;
        }
        lv[cnt++] = locale.substring(prev, locale.length());
        switch (cnt) {
            case 1: {
                l = new Locale(lv[0]);
                break;
            }
            case 2: {
                l = new Locale(lv[0], lv[1]);
                break;
            }
            case 3: {
                l = new Locale(lv[0], lv[1], lv[2]);
            }
        }
        return l;
    }

    public String getFamily() {
        return "javax.faces.ViewRoot";
    }

    public String getRenderKitId() {
        if (this._renderKitId != null) {
            return this._renderKitId;
        }
        ValueBinding vb = this.getValueBinding("renderKitId");
        return vb != null ? _ComponentUtils.getStringValue(this.getFacesContext(), vb) : null;
    }

    public void setRenderKitId(String renderKitId) {
        this._renderKitId = renderKitId;
    }

    public void setRendered(boolean state) {
        super.setRendered(state);
    }

    public boolean isRendered() {
        return super.isRendered();
    }

    public void setId(String id) {
        super.setId(id);
    }

    public String getId() {
        return super.getId();
    }

    public String getClientId(FacesContext context) {
        return super.getClientId(context);
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this._locale, this._renderKitId, this._viewId, new Long(this._uniqueIdCounter)};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this._locale = (Locale)values[1];
        this._renderKitId = (String)values[2];
        this._viewId = (String)values[3];
        this._uniqueIdCounter = values[4] == null ? 0L : (Long)values[4];
    }
}

