/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.lifecycle;

import jakarta.faces.context.FacesContext;
import jakarta.faces.lifecycle.ClientWindow;
import java.util.HashMap;
import java.util.Map;
import org.apache.myfaces.lifecycle.TokenGenerator;

public class UrlClientWindow
extends ClientWindow {
    private String windowId;
    private TokenGenerator tokenGenerator;
    private Map<String, String> queryParamsMap;

    public UrlClientWindow(TokenGenerator tokenGenerator) {
        this.tokenGenerator = tokenGenerator;
    }

    @Override
    public void decode(FacesContext context) {
        String windowId = this.calculateWindowId(context);
        if (windowId != null) {
            this.setId(windowId);
        } else {
            this.setId(this.tokenGenerator._getNextToken());
        }
    }

    protected String calculateWindowId(FacesContext context) {
        String windowId = context.getExternalContext().getRequestParameterMap().get("jakarta.faces.ClientWindow");
        if (windowId != null) {
            return windowId;
        }
        windowId = context.getExternalContext().getRequestParameterMap().get("jfwid");
        if (windowId != null) {
            return windowId;
        }
        return null;
    }

    @Override
    public String getId() {
        return this.windowId;
    }

    public void setId(String id) {
        this.windowId = id;
        this.queryParamsMap = null;
    }

    @Override
    public Map<String, String> getQueryURLParameters(FacesContext context) {
        String id;
        if (this.queryParamsMap == null && (id = context.getExternalContext().getClientWindow().getId()) != null) {
            this.queryParamsMap = new HashMap<String, String>(2, 1.0f);
            this.queryParamsMap.put("jfwid", id);
        }
        return this.queryParamsMap;
    }
}

