/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit;

import jakarta.el.PropertyNotFoundException;
import jakarta.el.ValueExpression;
import jakarta.faces.FacesException;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.application.ProjectStage;
import jakarta.faces.application.Resource;
import jakarta.faces.application.ResourceHandler;
import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIOutput;
import jakarta.faces.component.UISelectMany;
import jakarta.faces.component.UISelectOne;
import jakarta.faces.component.ValueHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.ConverterException;
import jakarta.faces.model.SelectItem;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.core.api.shared.ComponentUtils;
import org.apache.myfaces.core.api.shared.SelectItemsIterator;
import org.apache.myfaces.core.api.shared.SharedRendererUtils;
import org.apache.myfaces.core.api.shared.lang.Assert;
import org.apache.myfaces.util.lang.HashMapUtils;

public final class RendererUtils {
    private static final Logger log = Logger.getLogger(RendererUtils.class.getName());
    public static final String EMPTY_STRING = "";
    public static final String SEQUENCE_PARAM = "jsf_sequence";
    public static final String RES_NOT_FOUND = "RES_NOT_FOUND";

    private RendererUtils() {
    }

    public static Boolean getBooleanValue(UIComponent component) {
        Object value = RendererUtils.getObjectValue(component);
        if (value instanceof String) {
            value = Boolean.valueOf((String)value);
        }
        if (value == null || value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new IllegalArgumentException("Expected submitted value of type Boolean for Component : " + ComponentUtils.getPathToComponent((UIComponent)component));
    }

    public static Object getObjectValue(UIComponent component) {
        Object value;
        if (!(component instanceof ValueHolder)) {
            throw new IllegalArgumentException("Component : " + ComponentUtils.getPathToComponent((UIComponent)component) + " is not a ValueHolder");
        }
        if (component instanceof EditableValueHolder && (value = ((EditableValueHolder)component).getSubmittedValue()) != null) {
            return value;
        }
        return ((ValueHolder)component).getValue();
    }

    public static String getStringValue(FacesContext context, ValueExpression ve) {
        Object value = ve.getValue(context.getELContext());
        if (value != null) {
            if (value instanceof String) {
                return (String)value;
            }
            return value.toString();
        }
        return null;
    }

    public static String getStringValue(FacesContext facesContext, UIComponent component) {
        EditableValueHolder holder;
        Object submittedValue;
        if (!(component instanceof ValueHolder)) {
            throw new IllegalArgumentException("Component : " + ComponentUtils.getPathToComponent((UIComponent)component) + " is not a ValueHolder");
        }
        if (component instanceof EditableValueHolder && (submittedValue = ((EditableValueHolder)component).getSubmittedValue()) != null) {
            if (submittedValue instanceof String) {
                return (String)submittedValue;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("returning '" + submittedValue + "'");
            }
            return submittedValue.toString();
        }
        Object value = component instanceof EditableValueHolder ? ((holder = (EditableValueHolder)component).isLocalValueSet() ? holder.getLocalValue() : RendererUtils.getValue(component)) : RendererUtils.getValue(component);
        Converter converter = ((ValueHolder)component).getConverter();
        if (converter == null && value != null) {
            try {
                converter = facesContext.getApplication().createConverter(value.getClass());
                if (log.isLoggable(Level.FINE)) {
                    log.fine("the created converter is " + converter);
                }
            }
            catch (FacesException e) {
                log.log(Level.SEVERE, "No converter for class " + value.getClass().getName() + " found (component id=" + component.getId() + ").", e);
            }
        }
        if (converter == null) {
            if (value == null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("returning an empty string");
                }
                return EMPTY_STRING;
            }
            if (value instanceof String) {
                return (String)value;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("returning an .toString");
            }
            return value.toString();
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("returning converter get as string " + converter);
        }
        return converter.getAsString(facesContext, component, value);
    }

    public static String getStringFromSubmittedValueOrLocalValueReturnNull(FacesContext facesContext, UIComponent component) {
        try {
            EditableValueHolder holder;
            Object submittedValue;
            if (!(component instanceof ValueHolder)) {
                throw new IllegalArgumentException("Component : " + ComponentUtils.getPathToComponent((UIComponent)component) + "is not a ValueHolder");
            }
            if (component instanceof EditableValueHolder && (submittedValue = ((EditableValueHolder)component).getSubmittedValue()) != null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("returning 1 '" + submittedValue + "'");
                }
                return submittedValue.toString();
            }
            Object value = component instanceof EditableValueHolder ? ((holder = (EditableValueHolder)component).isLocalValueSet() ? holder.getLocalValue() : RendererUtils.getValue(component)) : RendererUtils.getValue(component);
            Converter converter = ((ValueHolder)component).getConverter();
            if (converter == null && value != null) {
                try {
                    converter = facesContext.getApplication().createConverter(value.getClass());
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("the created converter is " + converter);
                    }
                }
                catch (FacesException e) {
                    log.log(Level.SEVERE, "No converter for class " + value.getClass().getName() + " found (component id=" + component.getId() + ").", e);
                }
            }
            if (converter == null) {
                if (value == null) {
                    return null;
                }
                if (value instanceof String) {
                    return (String)value;
                }
                if (log.isLoggable(Level.FINE)) {
                    log.fine("returning an .toString");
                }
                return value.toString();
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("returning converter get as string " + converter);
            }
            return converter.getAsString(facesContext, component, value);
        }
        catch (PropertyNotFoundException ex) {
            log.log(Level.SEVERE, "Property not found - called by component : " + ComponentUtils.getPathToComponent((UIComponent)component), ex);
            throw ex;
        }
    }

    private static Object getValue(UIComponent component) {
        Object value = ((ValueHolder)component).getValue();
        return value;
    }

    public static boolean isDefaultAttributeValue(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof Boolean) {
            return (Boolean)value == false;
        }
        if (value instanceof Number) {
            if (value instanceof Integer) {
                return ((Number)value).intValue() == Integer.MIN_VALUE;
            }
            if (value instanceof Double) {
                return ((Number)value).doubleValue() == Double.MIN_VALUE;
            }
            if (value instanceof Long) {
                return ((Number)value).longValue() == Long.MIN_VALUE;
            }
            if (value instanceof Byte) {
                return ((Number)value).byteValue() == -128;
            }
            if (value instanceof Float) {
                return ((Number)value).floatValue() == Float.MIN_VALUE;
            }
            if (value instanceof Short) {
                return ((Number)value).shortValue() == Short.MIN_VALUE;
            }
        }
        return false;
    }

    public static Converter findUIOutputConverter(FacesContext facesContext, UIOutput component) throws FacesException {
        Converter converter = component.getConverter();
        if (converter != null) {
            return converter;
        }
        ValueExpression expression = component.getValueExpression("value");
        if (expression == null) {
            return null;
        }
        Class valueType = expression.getType(facesContext.getELContext());
        if (valueType == null) {
            return null;
        }
        if (Object.class.equals((Object)valueType)) {
            return null;
        }
        try {
            return facesContext.getApplication().createConverter(valueType);
        }
        catch (FacesException e) {
            log.log(Level.SEVERE, "No Converter for type " + valueType.getName() + " found", e);
            return null;
        }
    }

    public static Converter findUISelectManyConverter(FacesContext facesContext, UISelectMany component, boolean considerValueType) {
        Converter converter = component.getConverter();
        if (converter != null) {
            return converter;
        }
        if (considerValueType && (converter = SharedRendererUtils.getValueTypeConverter((FacesContext)facesContext, (UISelectMany)component)) != null) {
            return converter;
        }
        ValueExpression ve = component.getValueExpression("value");
        if (ve == null) {
            return null;
        }
        Class valueType = null;
        Object value = ve.getValue(facesContext.getELContext());
        Class clazz = valueType = value != null ? value.getClass() : ve.getType(facesContext.getELContext());
        if (valueType == null) {
            return null;
        }
        if (Collection.class.isAssignableFrom(valueType) || Object.class.equals((Object)valueType)) {
            return SharedRendererUtils.getSelectItemsValueConverter((Iterator)new SelectItemsIterator((UIComponent)component, facesContext), (FacesContext)facesContext);
        }
        if (!valueType.isArray()) {
            throw new IllegalArgumentException("ValueExpression for UISelectMany : " + ComponentUtils.getPathToComponent((UIComponent)component) + " must be of type Collection or Array");
        }
        Class<?> arrayComponentType = valueType.getComponentType();
        if (String.class.equals(arrayComponentType)) {
            return null;
        }
        if (Object.class.equals(arrayComponentType)) {
            return SharedRendererUtils.getSelectItemsValueConverter((Iterator)new SelectItemsIterator((UIComponent)component, facesContext), (FacesContext)facesContext);
        }
        try {
            return facesContext.getApplication().createConverter(arrayComponentType);
        }
        catch (FacesException e) {
            log.log(Level.SEVERE, "No Converter for type " + arrayComponentType.getName() + " found", e);
            return null;
        }
    }

    public static void checkParamValidity(FacesContext facesContext, UIComponent uiComponent, Class compClass) {
        Assert.notNull((Object)facesContext, (String)"facesContext");
        Assert.notNull((Object)uiComponent, (String)"uiComponent");
        if (compClass != null && !compClass.isInstance(uiComponent)) {
            throw new IllegalArgumentException("uiComponent : " + ComponentUtils.getPathToComponent((UIComponent)uiComponent) + " is not instance of " + compClass.getName() + " as it should be");
        }
    }

    public static void renderChildren(FacesContext facesContext, UIComponent component) throws IOException {
        int childCount = component.getChildCount();
        if (childCount > 0) {
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = (UIComponent)component.getChildren().get(i);
                child.encodeAll(facesContext);
            }
        }
    }

    public static List getSelectItemList(UISelectOne uiSelectOne) {
        return RendererUtils.internalGetSelectItemList((UIComponent)uiSelectOne, FacesContext.getCurrentInstance());
    }

    public static List<SelectItem> getSelectItemList(UISelectOne uiSelectOne, FacesContext facesContext) {
        return RendererUtils.internalGetSelectItemList((UIComponent)uiSelectOne, facesContext);
    }

    public static List<SelectItem> getSelectItemList(UISelectMany uiSelectMany, FacesContext facesContext) {
        return RendererUtils.internalGetSelectItemList((UIComponent)uiSelectMany, facesContext);
    }

    private static List<SelectItem> internalGetSelectItemList(UIComponent uiComponent, FacesContext facesContext) {
        ArrayList<SelectItem> list = new ArrayList<SelectItem>();
        SelectItemsIterator iter = new SelectItemsIterator(uiComponent, facesContext);
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    public static Set getSubmittedValuesAsSet(FacesContext context, UIComponent component, Converter converter, UISelectMany uiSelectMany) {
        Object submittedValues = uiSelectMany.getSubmittedValue();
        if (submittedValues == null) {
            return null;
        }
        if (converter != null) {
            converter = new PassThroughAsStringConverter(converter);
        }
        return RendererUtils.internalSubmittedOrSelectedValuesAsSet(context, component, converter, uiSelectMany, submittedValues, false);
    }

    public static Set getSelectedValuesAsSet(FacesContext context, UIComponent component, Converter converter, UISelectMany uiSelectMany) {
        Object selectedValues = uiSelectMany.getValue();
        return RendererUtils.internalSubmittedOrSelectedValuesAsSet(context, component, converter, uiSelectMany, selectedValues, true);
    }

    private static Set internalSubmittedOrSelectedValuesAsSet(FacesContext context, UIComponent component, Converter converter, UISelectMany uiSelectMany, Object values, boolean allowNonArrayOrCollectionValue) {
        if (values == null || EMPTY_STRING.equals(values)) {
            return Collections.EMPTY_SET;
        }
        if (values instanceof Object[]) {
            Object[] ar = (Object[])values;
            if (ar.length == 0) {
                return Collections.EMPTY_SET;
            }
            HashSet<String> set = new HashSet<String>(HashMapUtils.calcCapacity(ar.length));
            for (int i = 0; i < ar.length; ++i) {
                set.add(SharedRendererUtils.getConvertedStringValue((FacesContext)context, (UIComponent)component, (Converter)converter, (Object)ar[i]));
            }
            return set;
        }
        if (values.getClass().isArray()) {
            int len = Array.getLength(values);
            HashSet<String> set = new HashSet<String>(HashMapUtils.calcCapacity(len));
            for (int i = 0; i < len; ++i) {
                set.add(SharedRendererUtils.getConvertedStringValue((FacesContext)context, (UIComponent)component, (Converter)converter, (Object)Array.get(values, i)));
            }
            return set;
        }
        if (values instanceof Collection) {
            Collection col = (Collection)values;
            if (col.isEmpty()) {
                return Collections.EMPTY_SET;
            }
            HashSet<String> set = new HashSet<String>(HashMapUtils.calcCapacity(col.size()));
            Iterator i = col.iterator();
            while (i.hasNext()) {
                set.add(SharedRendererUtils.getConvertedStringValue((FacesContext)context, (UIComponent)component, (Converter)converter, i.next()));
            }
            return set;
        }
        if (allowNonArrayOrCollectionValue) {
            HashSet<Object> set = new HashSet<Object>(HashMapUtils.calcCapacity(1));
            set.add(values);
            return set;
        }
        throw new IllegalArgumentException("Value of UISelectMany component with path : " + ComponentUtils.getPathToComponent((UIComponent)uiSelectMany) + " is not of type Array or List");
    }

    public static Object getConvertedUISelectOneValue(FacesContext facesContext, UISelectOne output, Object submittedValue) {
        Converter converter;
        if (submittedValue != null && !(submittedValue instanceof String)) {
            throw new IllegalArgumentException("Submitted value of type String for component : " + ComponentUtils.getPathToComponent((UIComponent)output) + "expected");
        }
        if (submittedValue != null && EMPTY_STRING.equals(submittedValue)) {
            submittedValue = null;
        }
        try {
            converter = RendererUtils.findUIOutputConverter(facesContext, (UIOutput)output);
        }
        catch (FacesException e) {
            throw new ConverterException((Throwable)e);
        }
        return converter == null ? submittedValue : converter.getAsObject(facesContext, (UIComponent)output, (String)submittedValue);
    }

    public static Object getConvertedUIOutputValue(FacesContext facesContext, UIOutput output, Object submittedValue) throws ConverterException {
        Converter converter;
        if (submittedValue != null && !(submittedValue instanceof String)) {
            submittedValue = submittedValue.toString();
        }
        try {
            converter = RendererUtils.findUIOutputConverter(facesContext, output);
        }
        catch (FacesException e) {
            throw new ConverterException((Throwable)e);
        }
        return converter == null ? submittedValue : converter.getAsObject(facesContext, (UIComponent)output, (String)submittedValue);
    }

    public static Object getConvertedUISelectManyValue(FacesContext facesContext, UISelectMany selectMany, Object submittedValue) throws ConverterException {
        return RendererUtils.getConvertedUISelectManyValue(facesContext, selectMany, submittedValue, false);
    }

    public static Object getConvertedUISelectManyValue(FacesContext facesContext, UISelectMany selectMany, Object submittedValue, boolean considerValueType) throws ConverterException {
        if (submittedValue == null) {
            return null;
        }
        if (!(submittedValue instanceof String[])) {
            throw new ConverterException("Submitted value of type String[] for component : " + ComponentUtils.getPathToComponent((UIComponent)selectMany) + "expected");
        }
        return SharedRendererUtils.getConvertedUISelectManyValue((FacesContext)facesContext, (UISelectMany)selectMany, (String[])((String[])submittedValue), (boolean)considerValueType);
    }

    public static boolean getBooleanValue(String attribute, Object value, boolean defaultValue) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        if (value != null) {
            log.severe("value for attribute " + attribute + " must be instanceof 'Boolean' or 'String', is of type : " + value.getClass());
            return defaultValue;
        }
        return defaultValue;
    }

    public static String getIconSrc(FacesContext facesContext, UIComponent component, String attributeName) {
        Map attributes = component.getAttributes();
        String resourceName = (String)attributes.get("name");
        if (resourceName != null && resourceName.length() > 0) {
            ResourceHandler resourceHandler = facesContext.getApplication().getResourceHandler();
            String libraryName = (String)component.getAttributes().get("library");
            Resource resource = libraryName != null && libraryName.length() > 0 ? resourceHandler.createResource(resourceName, libraryName) : resourceHandler.createResource(resourceName);
            if (resource == null) {
                if (facesContext.isProjectStage(ProjectStage.Development)) {
                    String summary = "Unable to find resource: " + resourceName;
                    if (libraryName != null) {
                        summary = summary + " from library: " + libraryName;
                    }
                    facesContext.addMessage(component.getClientId(facesContext), new FacesMessage(FacesMessage.SEVERITY_WARN, summary, summary));
                }
                return RES_NOT_FOUND;
            }
            return resource.getRequestPath();
        }
        String value = (String)component.getAttributes().get(attributeName);
        return RendererUtils.toResourceUri(facesContext, value);
    }

    public static String toResourceUri(FacesContext facesContext, Object o) {
        if (o == null) {
            return null;
        }
        String uri = o.toString();
        if (uri.length() == 0) {
            return null;
        }
        if (uri.contains("/jakarta.faces.resource")) {
            return uri;
        }
        if (uri.startsWith("//")) {
            return uri.substring(1);
        }
        String resourceURL = facesContext.getApplication().getViewHandler().getResourceURL(facesContext, uri);
        return facesContext.getExternalContext().encodeResourceURL(resourceURL);
    }

    private static class PassThroughAsStringConverter
    implements Converter {
        private final Converter converter;

        public PassThroughAsStringConverter(Converter converter) {
            this.converter = converter;
        }

        public Object getAsObject(FacesContext context, UIComponent component, String value) throws ConverterException {
            return this.converter.getAsObject(context, component, value);
        }

        public String getAsString(FacesContext context, UIComponent component, Object value) throws ConverterException {
            return (String)value;
        }
    }
}

