/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf.impl.util;

import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.net.URLEncoder;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.enterprise.inject.Typed;
import javax.faces.FactoryFinder;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import org.apache.myfaces.extensions.cdi.core.impl.util.CodiUtils;
import org.apache.myfaces.extensions.cdi.jsf.impl.config.view.PageParameterContext;
import org.apache.myfaces.extensions.cdi.jsf.impl.util.RequestCache;
import org.apache.myfaces.extensions.cdi.jsf.impl.util.RequestParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Typed
public abstract class JsfUtils {
    public static final String FACES_CONTEXT_MANUAL_WRAPPER_KEY = "javax.faces.context.FacesContext:manuallyWrappedByCodi";

    private JsfUtils() {
    }

    public static void resetConversationCache() {
        RequestCache.resetConversationCache();
    }

    public static void resetCaches() {
        RequestCache.resetCache();
    }

    public static void registerPhaseListener(PhaseListener phaseListener) {
        LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        Iterator lifecycleIds = lifecycleFactory.getLifecycleIds();
        while (lifecycleIds.hasNext()) {
            String currentId = (String)lifecycleIds.next();
            Lifecycle currentLifecycle = lifecycleFactory.getLifecycle(currentId);
            currentLifecycle.addPhaseListener(phaseListener);
        }
    }

    public static ResourceBundle getDefaultFacesMessageBundle(Locale locale) {
        return ResourceBundle.getBundle("javax.faces.Messages", locale);
    }

    public static ResourceBundle getCustomFacesMessageBundle(Locale locale) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        String bundleName = facesContext.getApplication().getMessageBundle();
        if (bundleName == null) {
            return null;
        }
        return ResourceBundle.getBundle(bundleName, locale);
    }

    public static String encodeURLParameterValue(String value, ExternalContext externalContext) {
        try {
            return URLEncoder.encode(value, externalContext.getResponseCharacterEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException("Encoding type=" + externalContext.getResponseCharacterEncoding() + " not supported", e);
        }
    }

    public static String addParameters(ExternalContext externalContext, String url, boolean addRequestParameter, boolean addPageParameter, boolean encodeValues) {
        StringBuilder finalUrl = new StringBuilder(url);
        boolean existingParameters = url.contains("?");
        boolean urlContainsWindowId = url.contains("windowId=");
        for (RequestParameter requestParam : JsfUtils.getParameters(externalContext, true, addRequestParameter, addPageParameter)) {
            String key = requestParam.getKey();
            if ("windowId".equals(key) && urlContainsWindowId) continue;
            for (String parameterValue : requestParam.getValues()) {
                if (url.contains(key + "=" + parameterValue) || url.contains(key + "=" + JsfUtils.encodeURLParameterValue(parameterValue, externalContext))) continue;
                if (!existingParameters) {
                    finalUrl.append("?");
                    existingParameters = true;
                } else {
                    finalUrl.append("&");
                }
                finalUrl.append(key);
                finalUrl.append("=");
                if (encodeValues) {
                    finalUrl.append(JsfUtils.encodeURLParameterValue(parameterValue, externalContext));
                    continue;
                }
                finalUrl.append(parameterValue);
            }
        }
        return finalUrl.toString();
    }

    public static Set<RequestParameter> getParameters(ExternalContext externalContext, boolean filterViewState, boolean addRequestParameter, boolean addPageParameter) {
        PageParameterContext pageParameterContext;
        HashSet<RequestParameter> result = new HashSet<RequestParameter>();
        if (externalContext == null || externalContext.getRequestParameterValuesMap() == null || externalContext.getRequest() == null) {
            return result;
        }
        if (addRequestParameter) {
            for (Map.Entry entry : externalContext.getRequestParameterValuesMap().entrySet()) {
                String key = (String)entry.getKey();
                if (filterViewState && "javax.faces.ViewState".equals(key)) continue;
                result.add(new RequestParameter(key, (String[])entry.getValue()));
            }
        }
        if (addPageParameter && (pageParameterContext = (PageParameterContext)CodiUtils.getContextualReferenceByClass(PageParameterContext.class, (boolean)true, (Annotation[])new Annotation[0])) != null) {
            for (Map.Entry<Object, Object> entry : pageParameterContext.getPageParameters().entrySet()) {
                result.add(new RequestParameter((String)entry.getKey(), new String[]{(String)entry.getValue()}));
            }
        }
        return result;
    }

    public static <T> T getValueOfExpression(String expression, Class<T> targetType) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        return (T)facesContext.getApplication().evaluateExpressionGet(facesContext, expression, targetType);
    }

    public static String getValueOfExpressionAsString(String expression) {
        Object result = JsfUtils.getValueOfExpression(expression, Object.class);
        return result != null ? result.toString() : "null";
    }
}

