/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit;

import java.io.IOException;
import java.util.Locale;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.render.Renderer;
import org.apache.myfaces.tobago.component.SupportsMarkup;
import org.apache.myfaces.tobago.config.Configurable;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.context.ResourceManager;
import org.apache.myfaces.tobago.internal.context.ResourceManagerFactory;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RendererBase
extends Renderer {
    private static final Logger LOG = LoggerFactory.getLogger(RendererBase.class);
    private ResourceManager resourceManager;

    public void prepareRender(FacesContext facesContext, UIComponent component) throws IOException {
        if (component instanceof SupportsMarkup) {
            SupportsMarkup supportsMarkup = (SupportsMarkup)component;
            Markup markup = ComponentUtils.updateMarkup(component, supportsMarkup.getMarkup());
            supportsMarkup.setCurrentMarkup(markup);
        }
    }

    public boolean getPrepareRendersChildren() {
        return false;
    }

    public void prepareRendersChildren(FacesContext context, UIComponent component) throws IOException {
    }

    @Deprecated
    protected String getRendererName(String rendererType) {
        return rendererType.substring(0, 1).toLowerCase(Locale.ENGLISH) + rendererType.substring(1);
    }

    @Deprecated
    public int getConfiguredValue(FacesContext facesContext, UIComponent component, String key) {
        return this.getResourceManager().getThemeMeasure(facesContext, (Configurable)component, key).getPixel();
    }

    protected Object getCurrentValueAsObject(UIInput input) {
        Object submittedValue = input.getSubmittedValue();
        if (submittedValue != null) {
            return submittedValue;
        }
        return this.getValue((UIComponent)input);
    }

    protected String getCurrentValue(FacesContext facesContext, UIComponent component) {
        EditableValueHolder editableValueHolder;
        Object submittedValue;
        if (component instanceof EditableValueHolder && ((submittedValue = (editableValueHolder = (EditableValueHolder)component).getSubmittedValue()) != null || !editableValueHolder.isValid())) {
            return (String)submittedValue;
        }
        String currentValue = null;
        Object currentObj = this.getValue(component);
        if (currentObj != null) {
            currentValue = this.getFormattedValue(facesContext, component, currentObj);
        }
        return currentValue;
    }

    protected String getFormattedValue(FacesContext context, UIComponent component, Object currentValue) throws ConverterException {
        if (currentValue == null) {
            return "";
        }
        if (!(component instanceof ValueHolder)) {
            return currentValue.toString();
        }
        Converter converter = ((ValueHolder)component).getConverter();
        if (converter == null) {
            if (currentValue instanceof String) {
                return (String)currentValue;
            }
            if (currentValue instanceof Measure) {
                return ((Measure)currentValue).serialize();
            }
            Class<?> converterType = currentValue.getClass();
            converter = context.getApplication().createConverter(converterType);
        }
        if (converter == null) {
            return currentValue.toString();
        }
        return converter.getAsString(context, component, currentValue);
    }

    protected Object getValue(UIComponent component) {
        if (component instanceof ValueHolder) {
            return ((ValueHolder)component).getValue();
        }
        return null;
    }

    public Converter getConverter(FacesContext context, UIComponent component) {
        ValueExpression valueExpression;
        Converter converter = null;
        if (component instanceof ValueHolder) {
            converter = ((ValueHolder)component).getConverter();
        }
        if (converter == null && (valueExpression = component.getValueExpression("value")) != null) {
            Class converterType = valueExpression.getType(context.getELContext());
            if (converterType == null || converterType == String.class || converterType == Object.class) {
                return null;
            }
            try {
                converter = context.getApplication().createConverter(converterType);
            }
            catch (FacesException e) {
                LOG.error("No Converter found for type " + converterType);
            }
        }
        return converter;
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        if (!(submittedValue instanceof String)) {
            return submittedValue;
        }
        Converter converter = this.getConverter(context, component);
        if (converter != null) {
            return converter.getAsObject(context, component, (String)submittedValue);
        }
        return submittedValue;
    }

    public void onComponentCreated(FacesContext facesContext, UIComponent component, UIComponent parent) {
    }

    protected synchronized ResourceManager getResourceManager() {
        if (this.resourceManager == null) {
            this.resourceManager = ResourceManagerFactory.getResourceManager(FacesContext.getCurrentInstance());
        }
        return this.resourceManager;
    }
}

