/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.event;

import javax.el.ValueExpression;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.event.TabChangeEvent;
import org.apache.myfaces.tobago.event.TabChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueExpressionTabChangeListener
implements TabChangeListener,
StateHolder {
    private static final Logger LOG = LoggerFactory.getLogger(ValueExpressionTabChangeListener.class);
    private String type;
    private ValueExpression valueExpression;

    public ValueExpressionTabChangeListener() {
    }

    public ValueExpressionTabChangeListener(String type, ValueExpression valueExpression) {
        this.type = type;
        this.valueExpression = valueExpression;
    }

    @Override
    public void processTabChange(TabChangeEvent tabChangeEvent) {
        TabChangeListener handler = this.getTabChangeListener();
        if (handler != null) {
            handler.processTabChange(tabChangeEvent);
        } else {
            LOG.error("Ignoring TabChangeEvent. No TabChangeListener found.");
        }
    }

    public Object saveState(FacesContext context) {
        Object[] state = new Object[]{UIComponentBase.saveAttachedState((FacesContext)context, (Object)this.valueExpression), this.type};
        return state;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.valueExpression = (ValueExpression)UIComponentBase.restoreAttachedState((FacesContext)context, (Object)values[0]);
        this.type = (String)values[1];
    }

    public boolean isTransient() {
        return false;
    }

    public void setTransient(boolean newTransientValue) {
    }

    private TabChangeListener getTabChangeListener() {
        Object obj;
        TabChangeListener handler = null;
        if (this.valueExpression != null && (obj = this.valueExpression.getValue(FacesContext.getCurrentInstance().getELContext())) != null && obj instanceof TabChangeListener) {
            handler = (TabChangeListener)obj;
        }
        if (handler == null && this.type != null && (handler = this.createTabChangeListener(this.type)) != null && this.valueExpression != null) {
            this.valueExpression.setValue(FacesContext.getCurrentInstance().getELContext(), (Object)handler);
        }
        return handler;
    }

    private TabChangeListener createTabChangeListener(String className) {
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(className);
            return (TabChangeListener)clazz.newInstance();
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
            return null;
        }
    }
}

