/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.convert;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.apache.myfaces.tobago.component.Attributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DurationConverter
implements Converter {
    private static final Logger LOG = LoggerFactory.getLogger(DurationConverter.class);
    public static final String CONVERTER_ID = "org.apache.myfaces.tobago.Duration";

    public String getAsString(FacesContext facesContext, UIComponent component, Object object) throws ConverterException {
        if (object == null || object instanceof String) {
            return (String)object;
        }
        double aDouble = ((Number)object).doubleValue();
        boolean negative = false;
        if (aDouble < 0.0) {
            negative = true;
            aDouble = -aDouble;
        }
        double factor = DurationConverter.getUnitFactor(component);
        DecimalFormat format = new DecimalFormat("00");
        long value = Double.valueOf(aDouble *= factor).longValue();
        int seconds = (int)(value % 60L);
        int minutes = (int)((value /= 60L) % 60L);
        String string = (value /= 60L) > 0L ? (negative ? "-" : "") + value + ":" + format.format(minutes) + ":" + format.format(seconds) : (negative ? "-" : "") + minutes + ":" + format.format(seconds);
        if (LOG.isDebugEnabled()) {
            LOG.debug("string = '{}'", (Object)string);
        }
        return string;
    }

    public Object getAsObject(FacesContext facesContext, UIComponent component, String string) throws ConverterException {
        int seconds;
        int minutes;
        boolean negative = string.indexOf(45) > -1;
        StringTokenizer tokenizer = new StringTokenizer(string, " :-");
        ArrayList<String> elements = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            elements.add(tokenizer.nextToken());
        }
        int hours = 0;
        switch (elements.size()) {
            case 3: {
                hours = Integer.parseInt((String)elements.get(0));
                minutes = Integer.parseInt((String)elements.get(1));
                seconds = Integer.parseInt((String)elements.get(2));
                break;
            }
            case 2: {
                minutes = Integer.parseInt((String)elements.get(0));
                seconds = Integer.parseInt((String)elements.get(1));
                break;
            }
            default: {
                throw new ConverterException("Cannot parse string='" + string + "'");
            }
        }
        double factor = DurationConverter.getUnitFactor(component);
        long value = (long)((double)(((long)hours * 60L + (long)minutes) * 60L + (long)seconds) / factor);
        if (negative) {
            return -value;
        }
        return value;
    }

    private static double getUnitFactor(UIComponent component) {
        Unit unit;
        String unitString = ComponentUtils.getStringAttribute(component, Attributes.unit);
        try {
            unit = Unit.valueOf(unitString);
        }
        catch (Exception e) {
            LOG.warn("Unsupported unit: '{}'", (Object)unitString);
            unit = Unit.milli;
        }
        switch (unit) {
            case nano: {
                return 1.0E-9;
            }
            default: {
                return 0.001;
            }
            case second: {
                return 1.0;
            }
            case minute: {
                return 60.0;
            }
            case hour: {
                return 3600.0;
            }
            case day: {
                return 86400.0;
            }
            case year: 
        }
        return 3.1556736E7;
    }

    private static enum Unit {
        nano,
        milli,
        second,
        minute,
        hour,
        day,
        year;

    }
}

