/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import java.io.IOException;
import java.util.ArrayList;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.Attributes;
import org.apache.myfaces.tobago.component.RendererTypes;
import org.apache.myfaces.tobago.internal.component.AbstractUIBadge;
import org.apache.myfaces.tobago.internal.component.AbstractUICommand;
import org.apache.myfaces.tobago.internal.component.AbstractUIFormBase;
import org.apache.myfaces.tobago.internal.component.AbstractUILink;
import org.apache.myfaces.tobago.internal.component.AbstractUISelectBooleanCheckbox;
import org.apache.myfaces.tobago.internal.component.AbstractUISelectManyCheckbox;
import org.apache.myfaces.tobago.internal.component.AbstractUISelectOneRadio;
import org.apache.myfaces.tobago.internal.component.AbstractUISeparator;
import org.apache.myfaces.tobago.internal.component.AbstractUIStyle;
import org.apache.myfaces.tobago.internal.renderkit.renderer.ButtonInsideButtonsRenderer;
import org.apache.myfaces.tobago.internal.renderkit.renderer.DecodingCommandRendererBase;
import org.apache.myfaces.tobago.internal.renderkit.renderer.LinkInsideCommandRenderer;
import org.apache.myfaces.tobago.internal.util.AccessKeyLogger;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.renderkit.LabelWithAccessKey;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.Arias;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlButtonTypes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommandRendererBase
extends DecodingCommandRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(CommandRendererBase.class);

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        String title;
        AbstractUICommand command = (AbstractUICommand)component;
        String clientId = command.getClientId(facesContext);
        boolean disabled = command.isDisabled();
        LabelWithAccessKey label = new LabelWithAccessKey(command);
        boolean anchor = (command.getLink() != null || command.getOutcome() != null) && !disabled;
        String target = command.getTarget();
        boolean parentOfCommands = command.isParentOfCommands();
        boolean dropdownSubmenu = this instanceof LinkInsideCommandRenderer;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        this.encodeBeginOuter(facesContext, command);
        if (anchor) {
            writer.startElement(HtmlElements.A);
        } else {
            writer.startElement(HtmlElements.BUTTON);
            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlButtonTypes.BUTTON);
        }
        writer.writeIdAttribute(command.getFieldId(facesContext));
        writer.writeNameAttribute(clientId);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, disabled);
        if (!disabled) {
            int tabIndex;
            if (anchor) {
                String href = RenderUtils.generateUrl(facesContext, command);
                writer.writeAttribute(HtmlAttributes.HREF, href, true);
                writer.writeAttribute(HtmlAttributes.TARGET, target, true);
                command.setOmit(true);
            }
            writer.writeCommandMapAttribute(JsonUtils.encode(RenderUtils.getBehaviorCommands(facesContext, command)));
            if (label.getAccessKey() != null) {
                writer.writeAttribute(HtmlAttributes.ACCESSKEY, Character.toString(label.getAccessKey().charValue()), false);
                AccessKeyLogger.addAccessKey(facesContext, label.getAccessKey(), clientId);
            }
            if ((tabIndex = ComponentUtils.getIntAttribute((UIComponent)command, Attributes.tabIndex)) != 0) {
                writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TABINDEX, tabIndex);
            }
        }
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)command);
        if (parentOfCommands) {
            writer.writeAttribute(DataAttributes.TOGGLE, "dropdown", false);
        }
        if ((title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, (UIComponent)command)) != null) {
            writer.writeAttribute(HtmlAttributes.TITLE, title, true);
        }
        writer.writeClassAttribute((CssItem)this.getRendererCssClass(), this.getRendererCssClass().createMarkup(command.getMarkup()), parentOfCommands ? null : this.getOuterCssItems(facesContext, command), this.getCssItems(facesContext, command), new CssItem[]{parentOfCommands && !dropdownSubmenu ? BootstrapClass.DROPDOWN_TOGGLE : null, command.getCustomClass()});
        boolean defaultCommand = ComponentUtils.getBooleanAttribute((UIComponent)command, Attributes.defaultCommand);
        if (defaultCommand) {
            AbstractUIFormBase form = ComponentUtils.findAncestor((UIComponent)command, AbstractUIFormBase.class);
            writer.writeAttribute(DataAttributes.DEFAULT, form.getClientId(facesContext), false);
        }
        String image = ComponentUtils.getStringAttribute((UIComponent)command, Attributes.image);
        HtmlRendererUtils.encodeIconOrImage(writer, image);
        if (label.getLabel() != null) {
            writer.startElement(HtmlElements.SPAN);
            HtmlRendererUtils.writeLabelWithAccessKey(writer, label);
            writer.endElement(HtmlElements.SPAN);
            this.encodeBadge(facesContext, command);
        }
        if (anchor) {
            writer.endElement(HtmlElements.A);
        } else {
            writer.endElement(HtmlElements.BUTTON);
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
        block11: {
            block10: {
                AbstractUICommand command = (AbstractUICommand)component;
                boolean parentOfCommands = command.isParentOfCommands();
                TobagoResponseWriter writer = this.getResponseWriter(facesContext);
                if (!parentOfCommands) break block10;
                ArrayList<UIComponent> renderLater = null;
                writer.startElement(HtmlElements.DIV);
                writer.writeClassAttribute((CssItem)BootstrapClass.DROPDOWN_MENU, this.getDropdownCssItems(facesContext, command), new CssItem[0]);
                writer.writeAttribute(Arias.LABELLEDBY, command.getFieldId(facesContext), false);
                for (UIComponent child : component.getChildren()) {
                    if (!child.isRendered() || child instanceof UIParameter || child instanceof AbstractUIBadge) continue;
                    if (child instanceof AbstractUIStyle) {
                        if (renderLater == null) {
                            renderLater = new ArrayList<UIComponent>();
                        }
                        renderLater.add(child);
                        continue;
                    }
                    if (child instanceof AbstractUILink) {
                        child.setRendererType(RendererTypes.LinkInsideCommand.name());
                        child.encodeAll(facesContext);
                        continue;
                    }
                    if (child instanceof AbstractUISelectBooleanCheckbox) {
                        child.setRendererType(RendererTypes.SelectBooleanCheckboxInsideCommand.name());
                        child.encodeAll(facesContext);
                        continue;
                    }
                    if (child instanceof AbstractUISelectManyCheckbox) {
                        child.setRendererType(RendererTypes.SelectManyCheckboxInsideCommand.name());
                        child.encodeAll(facesContext);
                        continue;
                    }
                    if (child instanceof AbstractUISelectOneRadio) {
                        child.setRendererType(RendererTypes.SelectOneRadioInsideCommand.name());
                        child.encodeAll(facesContext);
                        continue;
                    }
                    if (child instanceof AbstractUISeparator) {
                        child.setRendererType(RendererTypes.SeparatorInsideCommand.name());
                        child.encodeAll(facesContext);
                        continue;
                    }
                    writer.startElement(HtmlElements.DIV);
                    writer.writeClassAttribute(BootstrapClass.DROPDOWN_ITEM);
                    child.encodeAll(facesContext);
                    writer.endElement(HtmlElements.DIV);
                }
                writer.endElement(HtmlElements.DIV);
                if (renderLater == null) break block11;
                for (UIComponent child : renderLater) {
                    child.encodeAll(facesContext);
                }
                break block11;
            }
            for (UIComponent child : component.getChildren()) {
                if (child instanceof AbstractUIBadge) continue;
                child.encodeAll(facesContext);
            }
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUICommand command = (AbstractUICommand)component;
        this.encodeEndOuter(facesContext, command);
    }

    protected void encodeBeginOuter(FacesContext facesContext, AbstractUICommand command) throws IOException {
        String clientId = command.getClientId(facesContext);
        boolean parentOfCommands = command.isParentOfCommands();
        boolean dropdownSubmenu = this instanceof LinkInsideCommandRenderer;
        boolean childOfButtonGroup = this instanceof ButtonInsideButtonsRenderer;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        if (parentOfCommands) {
            writer.startElement(HtmlElements.SPAN);
            writer.writeIdAttribute(clientId);
            writer.writeAttribute(DataAttributes.MARKUP, JsonUtils.encode(command.getMarkup()), false);
            writer.writeClassAttribute((CssItem)((Object)(childOfButtonGroup ? null : (dropdownSubmenu ? TobagoClass.DROPDOWN__SUBMENU : BootstrapClass.DROPDOWN))), this.getOuterCssItems(facesContext, command), new CssItem[0]);
        }
    }

    protected void encodeEndOuter(FacesContext facesContext, AbstractUICommand command) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        if (command.isParentOfCommands()) {
            writer.endElement(HtmlElements.SPAN);
        }
    }

    protected CssItem[] getOuterCssItems(FacesContext facesContext, AbstractUICommand command) {
        return null;
    }

    abstract TobagoClass getRendererCssClass();

    protected CssItem[] getCssItems(FacesContext facesContext, AbstractUICommand command) {
        return null;
    }

    protected CssItem[] getDropdownCssItems(FacesContext facesContext, AbstractUICommand command) {
        return null;
    }

    protected void encodeBadge(FacesContext facesContext, AbstractUICommand command) throws IOException {
    }
}

