/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import jakarta.el.ValueExpression;
import jakarta.faces.FacesException;
import jakarta.faces.application.ProjectStage;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIInput;
import jakarta.faces.component.UISelectItem;
import jakarta.faces.component.UISelectItems;
import jakarta.faces.component.UISelectMany;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.ConverterException;
import jakarta.faces.model.SelectItem;
import jakarta.faces.model.SelectItemGroup;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.myfaces.tobago.internal.component.AbstractUISelectManyBase;
import org.apache.myfaces.tobago.internal.renderkit.renderer.DecorationPositionRendererBase;
import org.apache.myfaces.tobago.internal.util.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SelectManyRendererBase<T extends AbstractUISelectManyBase>
extends DecorationPositionRendererBase<T> {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final String COLLECTION_TYPE_KEY = "collectionType";
    static final String VALUE_TYPE_KEY = "valueType";

    @Override
    protected boolean isOutputOnly(T component) {
        return ((AbstractUISelectManyBase)component).isDisabled() || ((AbstractUISelectManyBase)component).isReadonly();
    }

    @Override
    public void decodeInternal(FacesContext facesContext, T component) {
        if (this.isOutputOnly(component)) {
            return;
        }
        Object[] newValues = (String[])facesContext.getExternalContext().getRequestParameterValuesMap().get(component.getClientId(facesContext));
        if (LOG.isDebugEnabled()) {
            LOG.debug("decode: key='" + component.getClientId(facesContext) + "' value='" + Arrays.toString(newValues) + "'");
            LOG.debug("size ... '" + (newValues != null ? newValues.length : -1) + "'");
            if (newValues != null) {
                for (Object newValue : newValues) {
                    LOG.debug("newValues[i] = '" + (String)newValue + "'");
                }
            }
        }
        if (newValues == null) {
            newValues = ArrayUtils.EMPTY_STRING_ARRAY;
        }
        component.setSubmittedValue((Object)newValues);
        this.decodeClientBehaviors(facesContext, component);
    }

    public String[] getSubmittedValues(UIInput input) {
        return (String[])input.getSubmittedValue();
    }

    @Override
    public Object getConvertedValueInternal(FacesContext facesContext, T component, Object submittedValue) throws ConverterException {
        if (submittedValue == null) {
            return null;
        }
        if (!(submittedValue instanceof String[])) {
            throw new ConverterException("Submitted value not of type String[] for component : " + component.getClientId(facesContext) + "expected");
        }
        return SelectManyRendererBase.getConvertedUISelectManyValue(facesContext, component, (String[])submittedValue);
    }

    static Object getConvertedUISelectManyValue(FacesContext facesContext, UISelectMany component, String[] submittedValue) throws ConverterException {
        return SelectManyRendererBase.getConvertedUISelectManyValue(facesContext, component, submittedValue, false);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Object getConvertedUISelectManyValue(FacesContext facesContext, UISelectMany component, String[] submittedValue, boolean considerValueType) throws ConverterException {
        void var5_20;
        Converter converter;
        block29: {
            if (submittedValue == null) {
                throw new NullPointerException("submittedValue");
            }
            ValueExpression expression = component.getValueExpression("value");
            Object var5_5 = null;
            converter = component.getConverter();
            if (converter == null && considerValueType) {
                converter = SelectManyRendererBase.getValueTypeConverter(facesContext, component);
            }
            if (expression != null) {
                Class<?> modelType = expression.getType(facesContext.getELContext());
                if (modelType == null) {
                    return submittedValue;
                }
                if (modelType.isArray()) {
                    Class<?> componentType = modelType.getComponentType();
                    if (String.class.equals(componentType)) {
                        return submittedValue;
                    }
                    if (converter == null && (converter = facesContext.getApplication().createConverter(componentType)) == null && !Object.class.equals(componentType)) {
                        throw new ConverterException("Could not obtain a Converter for " + componentType.getName());
                    }
                    Object object = Array.newInstance(componentType, submittedValue.length);
                } else {
                    Object collectionTypeAttr;
                    if (!Collection.class.isAssignableFrom(modelType) && !Object.class.equals((Object)modelType)) throw new ConverterException("ValueExpression for UISelectMany must be of type Collection or Array.");
                    if (converter == null) {
                        SelectItemsIterator iterator = new SelectItemsIterator((UIComponent)component, facesContext);
                        converter = SelectManyRendererBase.getSelectItemsValueConverter(iterator, facesContext);
                    }
                    if ((collectionTypeAttr = component.getAttributes().get(COLLECTION_TYPE_KEY)) != null) {
                        Class<?> collectionType = SelectManyRendererBase.getClassFromAttribute(facesContext, collectionTypeAttr);
                        if (collectionType == null) {
                            throw new FacesException("The attribute collectionType of component " + component.getClientId(facesContext) + " does not evaluate to a String, a Class object or a ValueExpression pointing to a String or a Class object.");
                        }
                        if (!Collection.class.isAssignableFrom(collectionType)) {
                            throw new FacesException("The attribute collectionType of component " + component.getClientId(facesContext) + " does not point to a valid type of Collection.");
                        }
                        try {
                            Object obj = collectionType.newInstance();
                        }
                        catch (Exception e) {
                            throw new FacesException("The Collection " + collectionType.getName() + "can not be instantiated.", (Throwable)e);
                        }
                    }
                    if (Collection.class.isAssignableFrom(modelType)) {
                        void var5_9;
                        Collection componentValue = (Collection)component.getValue();
                        if (componentValue instanceof Cloneable) {
                            try {
                                Method cloneMethod = componentValue.getClass().getMethod("clone", new Class[0]);
                                Collection clone = (Collection)cloneMethod.invoke((Object)componentValue, new Object[0]);
                                clone.clear();
                                Collection collection = clone;
                            }
                            catch (Exception e) {
                                LOG.error("Could not clone " + componentValue.getClass().getName(), (Throwable)e);
                            }
                        }
                        if (var5_9 == null) {
                            try {
                                Object obj = (componentValue != null ? componentValue.getClass() : modelType).newInstance();
                            }
                            catch (Exception e) {
                                if (SortedSet.class.isAssignableFrom(modelType)) {
                                    TreeSet treeSet = new TreeSet();
                                    break block29;
                                }
                                if (Queue.class.isAssignableFrom(modelType)) {
                                    LinkedList linkedList = new LinkedList();
                                    break block29;
                                }
                                if (Set.class.isAssignableFrom(modelType)) {
                                    HashSet hashSet = new HashSet(submittedValue.length);
                                    break block29;
                                }
                                ArrayList arrayList = new ArrayList(submittedValue.length);
                            }
                        }
                    } else {
                        if (converter == null) {
                            return submittedValue;
                        }
                        Object[] objectArray = new Object[submittedValue.length];
                    }
                }
            } else {
                Object[] objectArray = new Object[submittedValue.length];
            }
        }
        boolean isArray = var5_20.getClass().isArray();
        for (int i = 0; i < submittedValue.length; ++i) {
            Object value = converter != null ? converter.getAsObject(facesContext, (UIComponent)component, submittedValue[i]) : submittedValue[i];
            if (isArray) {
                Array.set(var5_20, i, value);
                continue;
            }
            ((Collection)var5_20).add(value);
        }
        return var5_20;
    }

    static Class<?> getClassFromAttribute(FacesContext facesContext, Object attribute) throws FacesException {
        Object attr;
        Class type = null;
        Object object = attr = attribute instanceof ValueExpression ? ((ValueExpression)attribute).getValue(facesContext.getELContext()) : attribute;
        if (attr instanceof String) {
            try {
                type = Class.forName((String)attr);
            }
            catch (ClassNotFoundException cnfe) {
                throw new FacesException("Unable to find class " + attr + " on the classpath.", (Throwable)cnfe);
            }
        } else if (attr instanceof Class) {
            type = (Class)attr;
        }
        return type;
    }

    static Converter getValueTypeConverter(FacesContext facesContext, UISelectMany component) {
        Converter converter = null;
        Object valueTypeAttr = component.getAttributes().get(VALUE_TYPE_KEY);
        if (valueTypeAttr != null) {
            Class<?> valueType = SelectManyRendererBase.getClassFromAttribute(facesContext, valueTypeAttr);
            if (valueType == null) {
                throw new FacesException("The attribute valueType of component " + component.getClientId(facesContext) + " does not evaluate to a String, a Class object or a ValueExpression pointing to a String or a Class object.");
            }
            converter = facesContext.getApplication().createConverter(valueType);
            if (converter == null) {
                facesContext.getExternalContext().log("Found attribute valueType on component " + SelectManyRendererBase.getPathToComponent((UIComponent)component) + ", but could not get a by-type converter for type " + valueType.getName());
            }
        }
        return converter;
    }

    static Converter getSelectItemsValueConverter(Iterator<SelectItem> iterator, FacesContext facesContext) {
        Converter converter = null;
        while (converter == null && iterator.hasNext()) {
            SelectItem item = iterator.next();
            if (item.isNoSelectionOption()) continue;
            if (item instanceof SelectItemGroup) {
                Iterator<SelectItem> groupIterator = Arrays.asList(((SelectItemGroup)item).getSelectItems()).iterator();
                converter = SelectManyRendererBase.getSelectItemsValueConverter(groupIterator, facesContext);
                continue;
            }
            Class<?> selectItemsType = item.getValue().getClass();
            if (String.class.equals(selectItemsType)) {
                return null;
            }
            try {
                converter = facesContext.getApplication().createConverter(selectItemsType);
            }
            catch (FacesException facesException) {}
        }
        return converter;
    }

    static String getPathToComponent(UIComponent component) {
        StringBuilder builder = new StringBuilder();
        if (component == null) {
            builder.append("{Component-Path : ");
            builder.append("[null]}");
            return builder.toString();
        }
        SelectManyRendererBase.getPathToComponent(component, builder);
        builder.insert(0, "{Component-Path : ");
        builder.append("}");
        return builder.toString();
    }

    private static void getPathToComponent(UIComponent component, StringBuilder builder) {
        if (component == null) {
            return;
        }
        StringBuilder intBuilder = new StringBuilder();
        intBuilder.append("[Class: ");
        intBuilder.append(component.getClass().getName());
        if (component instanceof UIViewRoot) {
            intBuilder.append(",ViewId: ");
            intBuilder.append(((UIViewRoot)component).getViewId());
        } else {
            intBuilder.append(",Id: ");
            intBuilder.append(component.getId());
        }
        intBuilder.append("]");
        builder.insert(0, intBuilder.toString());
        SelectManyRendererBase.getPathToComponent(component.getParent(), builder);
    }

    private static class EmptyIterator<T>
    implements Iterator<T> {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public T next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class SelectItemsIterator
    implements Iterator<SelectItem> {
        private static final Iterator<UIComponent> EMPTY_UICOMPONENT_ITERATOR = new EmptyIterator<UIComponent>();
        private static final String VAR_ATTR = "var";
        private static final String ITEM_VALUE_ATTR = "itemValue";
        private static final String ITEM_LABEL_ATTR = "itemLabel";
        private static final String ITEM_DESCRIPTION_ATTR = "itemDescription";
        private static final String ITEM_DISABLED_ATTR = "itemDisabled";
        private static final String ITEM_LABEL_ESCAPED_ATTR = "itemLabelEscaped";
        private static final String NO_SELECTION_VALUE_ATTR = "noSelectionValue";
        private final Iterator<UIComponent> children;
        private Iterator<?> nestedItems;
        private SelectItem nextItem;
        private UIComponent currentComponent;
        private UISelectItems currentUISelectItems;
        private FacesContext facesContext;

        SelectItemsIterator(UIComponent selectItemsParent, FacesContext facesContext) {
            this.children = selectItemsParent.getChildCount() > 0 ? selectItemsParent.getChildren().iterator() : EMPTY_UICOMPONENT_ITERATOR;
            this.facesContext = facesContext;
        }

        @Override
        public boolean hasNext() {
            if (this.nextItem != null) {
                return true;
            }
            if (this.nestedItems != null) {
                if (this.nestedItems.hasNext()) {
                    return true;
                }
                this.nestedItems = null;
                this.currentComponent = null;
            }
            if (this.children.hasNext()) {
                UIComponent child = this.children.next();
                while (!(child instanceof UISelectItem) && !(child instanceof UISelectItems)) {
                    if (this.children.hasNext()) {
                        child = this.children.next();
                        continue;
                    }
                    return false;
                }
                if (child instanceof UISelectItem) {
                    UISelectItem uiSelectItem = (UISelectItem)child;
                    Object item = uiSelectItem.getValue();
                    if (item == null) {
                        Object itemValue = uiSelectItem.getItemValue();
                        String label = uiSelectItem.getItemLabel();
                        String description = uiSelectItem.getItemDescription();
                        boolean disabled = uiSelectItem.isItemDisabled();
                        boolean escape = uiSelectItem.isItemEscaped();
                        boolean noSelectionOption = uiSelectItem.isNoSelectionOption();
                        if (label == null) {
                            label = itemValue.toString();
                        }
                        item = new SelectItem(itemValue, label, description, disabled, escape, noSelectionOption);
                    } else if (!(item instanceof SelectItem)) {
                        ValueExpression expression = uiSelectItem.getValueExpression("value");
                        throw new IllegalArgumentException("ValueExpression '" + (expression == null ? null : expression.getExpressionString()) + "' of UISelectItem : " + this.getPathToComponent(child) + " does not reference an Object of type SelectItem");
                    }
                    this.nextItem = (SelectItem)item;
                    this.currentComponent = child;
                    return true;
                }
                if (child instanceof UISelectItems) {
                    this.currentUISelectItems = (UISelectItems)child;
                    Object value = this.currentUISelectItems.getValue();
                    this.currentComponent = child;
                    if (value instanceof SelectItem) {
                        this.nextItem = (SelectItem)value;
                        return true;
                    }
                    if (value != null && value.getClass().isArray()) {
                        int length = Array.getLength(value);
                        ArrayList<Object> items = new ArrayList<Object>(length);
                        for (int i = 0; i < length; ++i) {
                            items.add(Array.get(value, i));
                        }
                        this.nestedItems = items.iterator();
                        return this.hasNext();
                    }
                    if (value instanceof Iterable) {
                        this.nestedItems = ((Iterable)value).iterator();
                        return this.hasNext();
                    }
                    if (value instanceof Map) {
                        Map map = (Map)value;
                        ArrayList<SelectItem> items = new ArrayList<SelectItem>(map.size());
                        for (Map.Entry entry : map.entrySet()) {
                            items.add(new SelectItem(entry.getValue(), entry.getKey().toString()));
                        }
                        this.nestedItems = items.iterator();
                        return this.hasNext();
                    }
                    if (this.facesContext.isProjectStage(ProjectStage.Production) && LOG.isDebugEnabled() || LOG.isWarnEnabled()) {
                        ValueExpression expression = this.currentUISelectItems.getValueExpression("value");
                        Object[] objects = new Object[]{expression == null ? null : expression.getExpressionString(), this.getPathToComponent(child), value == null ? null : value.getClass().getName()};
                        String message = "ValueExpression {0} of UISelectItems with component-path {1} does not reference an Object of type SelectItem, array, Iterable or Map, but of type: {2}";
                        if (this.facesContext.isProjectStage(ProjectStage.Production)) {
                            LOG.debug("ValueExpression {0} of UISelectItems with component-path {1} does not reference an Object of type SelectItem, array, Iterable or Map, but of type: {2}", objects);
                        } else {
                            LOG.warn("ValueExpression {0} of UISelectItems with component-path {1} does not reference an Object of type SelectItem, array, Iterable or Map, but of type: {2}", objects);
                        }
                    }
                } else {
                    this.currentComponent = null;
                }
            }
            return false;
        }

        @Override
        public SelectItem next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.nextItem != null) {
                SelectItem value = this.nextItem;
                this.nextItem = null;
                return value;
            }
            if (this.nestedItems != null) {
                Object item = this.nestedItems.next();
                if (!(item instanceof SelectItem)) {
                    Object itemDescription;
                    Object itemLabel;
                    Object itemValue;
                    Map attributeMap = this.currentUISelectItems.getAttributes();
                    boolean wroteRequestMapVarValue = false;
                    Object oldRequestMapVarValue = null;
                    String var = (String)attributeMap.get(VAR_ATTR);
                    if (var != null && !"".equals(var)) {
                        oldRequestMapVarValue = this.facesContext.getExternalContext().getRequestMap().put(var, item);
                        wroteRequestMapVarValue = true;
                    }
                    if ((itemValue = attributeMap.get(ITEM_VALUE_ATTR)) == null) {
                        itemValue = item;
                    }
                    if ((itemLabel = attributeMap.get(ITEM_LABEL_ATTR)) == null) {
                        if (itemValue != null) {
                            itemLabel = itemValue.toString();
                        }
                    } else {
                        itemLabel = itemLabel.toString();
                    }
                    if ((itemDescription = attributeMap.get(ITEM_DESCRIPTION_ATTR)) != null) {
                        itemDescription = itemDescription.toString();
                    }
                    Boolean itemDisabled = this.getBooleanAttribute((UIComponent)this.currentUISelectItems, ITEM_DISABLED_ATTR, false);
                    Boolean itemLabelEscaped = this.getBooleanAttribute((UIComponent)this.currentUISelectItems, ITEM_LABEL_ESCAPED_ATTR, true);
                    Object noSelectionValue = attributeMap.get(NO_SELECTION_VALUE_ATTR);
                    item = new SelectItem(itemValue, (String)itemLabel, (String)itemDescription, itemDisabled.booleanValue(), itemLabelEscaped.booleanValue(), itemValue.equals(noSelectionValue));
                    if (wroteRequestMapVarValue) {
                        if (oldRequestMapVarValue != null) {
                            this.facesContext.getExternalContext().getRequestMap().put(var, oldRequestMapVarValue);
                        } else {
                            this.facesContext.getExternalContext().getRequestMap().remove(var);
                        }
                    }
                }
                return (SelectItem)item;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public UIComponent getCurrentComponent() {
            return this.currentComponent;
        }

        private boolean getBooleanAttribute(UIComponent component, String attrName, boolean defaultValue) {
            Object value = component.getAttributes().get(attrName);
            if (value == null) {
                return defaultValue;
            }
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            return Boolean.valueOf(value.toString());
        }

        private String getPathToComponent(UIComponent component) {
            StringBuilder builder = new StringBuilder();
            if (component == null) {
                builder.append("{Component-Path : ");
                builder.append("[null]}");
                return builder.toString();
            }
            this.getPathToComponent(component, builder);
            builder.insert(0, "{Component-Path : ");
            builder.append("}");
            return builder.toString();
        }

        private void getPathToComponent(UIComponent component, StringBuilder builder) {
            if (component == null) {
                return;
            }
            StringBuilder intBuilder = new StringBuilder();
            intBuilder.append("[Class: ");
            intBuilder.append(component.getClass().getName());
            if (component instanceof UIViewRoot) {
                intBuilder.append(",ViewId: ");
                intBuilder.append(((UIViewRoot)component).getViewId());
            } else {
                intBuilder.append(",Id: ");
                intBuilder.append(component.getId());
            }
            intBuilder.append("]");
            builder.insert(0, intBuilder);
            this.getPathToComponent(component.getParent(), builder);
        }
    }
}

