/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.component;

import jakarta.faces.component.UIOutput;
import jakarta.faces.event.ComponentSystemEvent;
import jakarta.faces.event.ComponentSystemEventListener;
import jakarta.faces.event.ListenerFor;
import jakarta.faces.event.PostAddToViewEvent;
import jakarta.faces.event.PostRestoreStateEvent;
import jakarta.faces.event.PreRenderViewEvent;
import java.lang.invoke.MethodHandles;
import org.apache.myfaces.tobago.context.TobagoContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ListenerFor(systemEventClass=PostAddToViewEvent.class)
public abstract class AbstractUIConfig
extends UIOutput {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void processEvent(ComponentSystemEvent event) {
        super.processEvent(event);
        if (event instanceof PreRenderViewEvent || event instanceof PostRestoreStateEvent) {
            Integer waitOverlayDelayAjax;
            Integer waitOverlayDelayFull;
            Boolean focusOnError = this.getFocusOnError();
            if (focusOnError != null) {
                TobagoContext.getInstance(event.getFacesContext()).setFocusOnError(focusOnError);
            }
            if ((waitOverlayDelayFull = this.getWaitOverlayDelayFull()) != null) {
                TobagoContext.getInstance(event.getFacesContext()).setWaitOverlayDelayFull(waitOverlayDelayFull);
            }
            if ((waitOverlayDelayAjax = this.getWaitOverlayDelayAjax()) != null) {
                TobagoContext.getInstance(event.getFacesContext()).setWaitOverlayDelayAjax(waitOverlayDelayAjax);
            }
        } else if (event instanceof PostAddToViewEvent) {
            this.getFacesContext().getViewRoot().subscribeToEvent(PreRenderViewEvent.class, (ComponentSystemEventListener)this);
        }
    }

    public abstract Boolean getFocusOnError();

    public abstract Integer getWaitOverlayDelayFull();

    public abstract Integer getWaitOverlayDelayAjax();
}

