/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.layout.CorePanelCaptionGroup;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;

public class PanelCaptionGroupRenderer
extends XhtmlRenderer {
    private PropertyKey _captionTextKey;

    public PanelCaptionGroupRenderer() {
        this(CorePanelCaptionGroup.TYPE);
    }

    protected PanelCaptionGroupRenderer(FacesBean.Type type) {
        super(type);
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._captionTextKey = type.findKey("captionText");
    }

    protected String getCaptionText(FacesBean bean) {
        return PanelCaptionGroupRenderer.toString((Object)this.resolveProperty(bean, this._captionTextKey));
    }

    protected String getRootStyle() {
        return "af|panelCaptionGroup";
    }

    protected String getCaptionStyle() {
        return "af|panelCaptionGroup::caption";
    }

    protected void encodeAll(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("fieldset", component);
        this.renderAllAttributes(context, arc, bean, false);
        this.renderStyleAttributes(context, arc, bean, this.getRootStyle());
        UIComponent captionFacet = PanelCaptionGroupRenderer.getFacet((UIComponent)component, (String)"caption");
        String captionText = this.getCaptionText(bean);
        if (captionFacet != null || captionText != null) {
            writer.startElement("legend", null);
            PanelCaptionGroupRenderer.renderStyleClass((FacesContext)context, (RenderingContext)arc, (String)this.getCaptionStyle());
            if (captionFacet != null) {
                this.encodeChild(context, captionFacet);
            } else {
                writer.writeText((Object)captionText, "captionText");
            }
            writer.endElement("legend");
        }
        this.encodeAllChildren(context, component);
        writer.endElement("fieldset");
    }
}

