/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.skin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.myfaces.trinidad.context.Version;
import org.apache.myfaces.trinidadinternal.skin.SkinSelectorPropertiesNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SkinStyleSheetNode {
    private Map<String, String> _namespaceMap;
    private List<SkinSelectorPropertiesNode> _skinSelectorNodeList;
    private int _direction;
    private Map<Integer, Set<Version>> _agentVersions;
    private int[] _platforms;
    private Set<String> _accProperties;

    SkinStyleSheetNode(List<SkinSelectorPropertiesNode> skinSelectorNodeList, Map<String, String> namespaceMap, int direction, Map<Integer, Set<Version>> agentVersions, Set<String> accProperties) {
        this._skinSelectorNodeList = skinSelectorNodeList;
        this._namespaceMap = namespaceMap;
        this._direction = direction;
        this._agentVersions = agentVersions;
        this._accProperties = accProperties;
    }

    SkinStyleSheetNode(Map<String, String> namespaceMap, int direction, Map<Integer, Set<Version>> agentVersions, int[] platforms, Set<String> accProperties) {
        this._namespaceMap = namespaceMap;
        this._direction = direction;
        this._agentVersions = agentVersions;
        this._platforms = platforms;
        this._accProperties = accProperties;
    }

    public void add(SkinSelectorPropertiesNode node) {
        if (this._skinSelectorNodeList == null) {
            this._skinSelectorNodeList = new ArrayList<SkinSelectorPropertiesNode>();
        }
        this._skinSelectorNodeList.add(node);
    }

    public Map<String, String> getNamespaceMap() {
        return this._namespaceMap;
    }

    public List<SkinSelectorPropertiesNode> getSelectorNodeList() {
        return this._skinSelectorNodeList;
    }

    public int getDirection() {
        return this._direction;
    }

    public Map<Integer, Set<Version>> getAgentVersions() {
        return this._agentVersions;
    }

    public int[] getPlatforms() {
        return this._platforms;
    }

    public Set<String> getAcessibilityProperties() {
        return this._accProperties;
    }

    public boolean matches(int direction, Map<Integer, Set<Version>> agentVersions, int[] platforms, Set<String> accProperties) {
        boolean accMatch;
        boolean platformsMatch;
        boolean agentsMatch;
        return direction == this._direction && (agentsMatch = this._mapsEqual(agentVersions, this._agentVersions)) && (platformsMatch = this._intArraysEqual(platforms, this._platforms)) && (accMatch = this._setsEqual(accProperties, this._accProperties));
    }

    private boolean _intArraysEqual(int[] a1, int[] a2) {
        if (a1 != null) {
            Arrays.sort(a1);
        }
        if (a2 != null) {
            Arrays.sort(a2);
        }
        return Arrays.equals(a1, a2);
    }

    private boolean _setsEqual(Set<?> s1, Set<?> s2) {
        return s1 == null ? s2 == null : ((Object)s1).equals(s2);
    }

    private boolean _mapsEqual(Map<?, ?> m1, Map<?, ?> m2) {
        return m1 == null ? m2 == null : ((Object)m1).equals(m2);
    }
}

