/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.util.nls;

import java.util.Locale;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.context.LocaleContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;

public final class LocaleUtils {
    public static final int DIRECTION_DEFAULT = 0;
    public static final int DIRECTION_LEFTTORIGHT = 1;
    public static final int DIRECTION_RIGHTTOLEFT = 2;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(LocaleUtils.class);

    public static int getReadingDirection(LocaleContext localeContext) {
        return localeContext.isRightToLeft() ? 2 : 1;
    }

    public static int getReadingDirectionForLocale(Locale loc) {
        String language;
        if (loc == null) {
            loc = Locale.getDefault();
        }
        if ((language = loc.getLanguage()).equals("ar") || language.equals("he") || language.equals("iw")) {
            return 2;
        }
        return 1;
    }

    public static Locale getLocaleForIANAString(String ianaString) {
        String language;
        if (ianaString == null || "".equals(ianaString)) {
            return null;
        }
        String country = "";
        String variant = "";
        int dashIndex = ianaString.indexOf(45);
        if (dashIndex < 0) {
            language = ianaString;
        } else {
            language = ianaString.substring(0, dashIndex);
            int start = dashIndex + 1;
            if ((dashIndex = ianaString.indexOf(45, start)) < 0) {
                country = ianaString.substring(start);
            } else {
                country = ianaString.substring(start, dashIndex);
                variant = ianaString.substring(dashIndex + 1);
            }
        }
        if (language.length() != 2) {
            language = "";
            _LOG.warning("INVALID_LOCALE_LANG_LENGTH", (Object)ianaString);
        } else if (Character.isUpperCase(language.charAt(0)) || Character.isUpperCase(language.charAt(1))) {
            language = "";
            _LOG.warning("INVALID_LOCALE_LANG_CASE", (Object)ianaString);
        }
        if (language.length() == 0) {
            Locale defaultLocale = FacesContext.getCurrentInstance().getViewRoot().getLocale();
            return defaultLocale;
        }
        if (country.length() > 0) {
            if (country.length() != 2) {
                country = "";
                _LOG.warning("INVALID_LOCALE_COUNTRY_LENGTH", (Object)ianaString);
            } else if (Character.isLowerCase(country.charAt(0)) || Character.isLowerCase(country.charAt(1))) {
                country = "";
                _LOG.warning("INVALID_LOCALE_COUNTRY_CASE", (Object)ianaString);
            }
        }
        if (variant.indexOf(47) > 0) {
            variant = "";
            _LOG.warning("INVALID_LOCALE_VARIANT_HAS_SLASH", (Object)ianaString);
        }
        return new Locale(language, country, variant);
    }
}

