/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.share.expl;

import java.awt.Color;
import java.lang.reflect.Array;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ClassLoaderUtils;
import org.apache.myfaces.trinidadinternal.share.expl.ExpressionContext;
import org.apache.myfaces.trinidadinternal.share.text.ColorFormat;
import org.apache.myfaces.trinidadinternal.share.text.RGBColorFormat;
import org.apache.myfaces.trinidadinternal.share.xml.NamespaceURI;
import org.apache.myfaces.trinidadinternal.share.xml.XMLUtils;
import org.apache.myfaces.trinidadinternal.style.CoreStyle;
import org.apache.myfaces.trinidadinternal.style.util.CSSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Coercions {
    private static final ColorFormat _COLOR_FMT = new RGBColorFormat("#RRGGBB");
    private static final Color _TRANSPARENT_COLOR = new Color(0, 0, 0, 0);
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(Coercions.class);

    public static Object coerce(ExpressionContext context, String text, Class<?> type) throws IllegalArgumentException {
        if (type != null) {
            if (type == Object.class) {
                return text;
            }
            if (type == Boolean.class || type == Boolean.TYPE) {
                return Coercions.toBoolean(text);
            }
            if (type == Byte.class || type == Byte.TYPE) {
                return Coercions.toByte(text);
            }
            if (type == Short.class || type == Short.TYPE) {
                return Coercions.toShort(text);
            }
            if (type == Integer.class || type == Integer.TYPE) {
                return Coercions.toInteger(text);
            }
            if (type == Long.class || type == Long.TYPE) {
                return Coercions.toLong(text);
            }
            if (type == Float.class || type == Float.TYPE) {
                return Coercions.toFloat(text);
            }
            if (type == Double.class || type == Double.TYPE) {
                return Coercions.toDouble(text);
            }
            if (type == Number.class) {
                return Coercions.toNumber(text);
            }
            if (type == Character.class || type == Character.TYPE) {
                Character c = Coercions.toCharacter(text);
                if (text != null && c == null) {
                    throw new IllegalArgumentException(_LOG.getMessage("NOT_A_CHARACTER"));
                }
                return c;
            }
            if (type == String.class) {
                return text;
            }
            if (type == int[].class) {
                String[] array = XMLUtils.parseNameTokens(text);
                int[] ints = new int[array.length];
                for (int i = 0; i < array.length; ++i) {
                    ints[i] = Integer.parseInt(array[i]);
                }
                return ints;
            }
            if (type == Integer[].class) {
                String[] array = XMLUtils.parseNameTokens(text);
                Integer[] ints = new Integer[array.length];
                for (int i = 0; i < array.length; ++i) {
                    ints[i] = Integer.parseInt(array[i]);
                }
                return ints;
            }
            if (type == String[].class) {
                return XMLUtils.parseNameTokens(text);
            }
            if (type == List.class) {
                return XMLUtils.parseNameTokensAsList(text);
            }
            if (type == Set.class) {
                return XMLUtils.parseNameTokensAsSet(text);
            }
            if (type == Date.class) {
                try {
                    return Coercions._getDateFormat().parse(text);
                }
                catch (ParseException pe) {
                    return text;
                }
            }
            if (type == Color.class) {
                return Coercions.toColor(text);
            }
            if (type == NamespaceURI.class) {
                return NamespaceURI.create(context, text, "");
            }
            if (type == CoreStyle.class) {
                return CSSUtils.parseStyle(text);
            }
            if (type == Class.class) {
                try {
                    return ClassLoaderUtils.loadClass((String)text);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new IllegalArgumentException(_LOG.getMessage("CANNOT_FIND_CLASS", (Object)text));
                }
            }
            if (type == Object.class) {
                return text;
            }
            if (Enum.class.isAssignableFrom(type)) {
                return Enum.valueOf(type, text);
            }
            throw new IllegalArgumentException(_LOG.getMessage("CANNOT_BE_PARSED", new Object[]{text, type.getName()}));
        }
        throw new NullPointerException(_LOG.getMessage("NULL_TYPE"));
    }

    public static Object coerce(Object value, Class<?> type) {
        if (type != null) {
            if (value == null) {
                return null;
            }
            if (type.isAssignableFrom(value.getClass())) {
                return value;
            }
            if (type == Object.class) {
                return value;
            }
            if (type == Boolean.class || type == Boolean.TYPE) {
                return Coercions.toBoolean(value);
            }
            if (type == Byte.class || type == Byte.TYPE) {
                return Coercions.toByte(value);
            }
            if (type == Short.class || type == Short.TYPE) {
                return Coercions.toShort(value);
            }
            if (type == Integer.class || type == Integer.TYPE) {
                return Coercions.toInteger(value);
            }
            if (type == Long.class || type == Long.TYPE) {
                return Coercions.toLong(value);
            }
            if (type == Float.class || type == Float.TYPE) {
                return Coercions.toFloat(value);
            }
            if (type == Double.class || type == Double.TYPE) {
                return Coercions.toDouble(value);
            }
            if (type == Character.class || type == Character.TYPE) {
                return Coercions.toCharacter(value);
            }
            if (type == String.class) {
                return Coercions.toString(value);
            }
            if (type == Number.class) {
                return Coercions.toNumber(Coercions.toString(value));
            }
            if (type.isArray()) {
                Class<?> arrayType = type.getComponentType();
                Object[] res = Array.newInstance(arrayType, 1);
                if (value instanceof List) {
                    res = ((List)value).toArray((Object[])res);
                } else if (value.getClass().isArray()) {
                    res = value;
                } else {
                    Object arrayValue = Coercions.coerce(value, arrayType);
                    Array.set(res, 0, arrayValue);
                }
                return res;
            }
            if (Enum.class.isAssignableFrom(type)) {
                return Enum.valueOf(type, value.toString());
            }
            throw new IllegalArgumentException(_LOG.getMessage("CANNOT_COERCE_VALUE_OF_TYPE", new Object[]{value.getClass(), type.getName()}));
        }
        throw new NullPointerException(_LOG.getMessage("NULL_TYPE"));
    }

    public static Boolean toBoolean(Object value) {
        if (value != null) {
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            return "true".equals(value.toString());
        }
        return null;
    }

    public static Character toCharacter(Object value) {
        if (value != null) {
            String valueText;
            if (value instanceof Character) {
                return (Character)value;
            }
            if (value instanceof String && (valueText = value.toString()).length() != 0) {
                return Character.valueOf(valueText.charAt(0));
            }
        }
        return null;
    }

    public static Byte toByte(Object value) {
        if (value != null) {
            if (value instanceof Byte) {
                return (Byte)value;
            }
            if (value instanceof Number) {
                return ((Number)value).byteValue();
            }
            byte byteValue = Byte.parseByte(value.toString());
            return byteValue;
        }
        return null;
    }

    public static Short toShort(Object value) {
        if (value != null) {
            if (value instanceof Short) {
                return (Short)value;
            }
            if (value instanceof Number) {
                return ((Number)value).shortValue();
            }
            short shortValue = Short.parseShort(value.toString());
            return shortValue;
        }
        return null;
    }

    public static Integer toInteger(Object value) {
        if (value != null) {
            if (value instanceof Integer) {
                return (Integer)value;
            }
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            int intValue = Integer.parseInt(value.toString());
            return intValue;
        }
        return null;
    }

    public static Long toLong(Object value) {
        if (value != null) {
            if (value instanceof Long) {
                return (Long)value;
            }
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            long longValue = Long.parseLong(value.toString());
            return longValue;
        }
        return null;
    }

    public static Float toFloat(Object value) {
        if (value != null) {
            if (value instanceof Float) {
                return (Float)value;
            }
            if (value instanceof Number) {
                return Float.valueOf(((Number)value).floatValue());
            }
            float floatValue = Float.parseFloat(value.toString());
            return Float.valueOf(floatValue);
        }
        return null;
    }

    public static Double toDouble(Object value) {
        if (value != null) {
            if (value instanceof Double) {
                return (Double)value;
            }
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            double doubleValue = Double.parseDouble(value.toString());
            return doubleValue;
        }
        return null;
    }

    public static Number toNumber(Object value) {
        if (((String)value).indexOf(".") == -1) {
            return Coercions.toInteger(value);
        }
        return Coercions.toDouble(value);
    }

    public static String toString(Object value) {
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    public static Color toColor(Object value) {
        if (value != null) {
            if (value instanceof Color) {
                return (Color)value;
            }
            if (value instanceof Number) {
                return new Color(((Number)value).intValue(), true);
            }
            if (value instanceof String) {
                try {
                    String colorString = (String)value;
                    if ("#trans".equalsIgnoreCase(colorString)) {
                        return new ParsedColor(_TRANSPARENT_COLOR, colorString);
                    }
                    if (colorString.length() == 7) {
                        return new ParsedColor(_COLOR_FMT.parse(colorString), colorString);
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            throw new IllegalArgumentException(_LOG.getMessage("CANNOT_BE_COERCED", value));
        }
        return null;
    }

    private Coercions() {
    }

    private static DateFormat _getDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd");
    }

    private static final class ParsedColor
    extends Color {
        private String _toString;
        private static final long serialVersionUID = 1L;

        public ParsedColor(Color color, String toString) {
            super(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
            this._toString = toString;
        }

        public String toString() {
            return this._toString;
        }
    }
}

