/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.output.CoreMedia;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.util.IntegerUtils;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaRenderer
extends XhtmlRenderer {
    private static final String _AIFF_MIME_TYPE = "audio/aiff";
    private static final String _ART_MIME_TYPE = "image/x-art";
    private static final String _ASF_MIME_TYPE = "video/x-ms-asf";
    private static final String _AVI_MIME_TYPE = "video/avi";
    private static final String _BMP_MIME_TYPE = "image/bmp";
    private static final String _GIF_MIME_TYPE = "image/gif";
    private static final String _HTML_MIME_TYPE = "text/html";
    private static final String _IEF_IMAGE_MIME_TYPE = "image/ief";
    private static final String _JPEG_MIME_TYPE = "image/jpeg";
    private static final String _MIDI_MIME_TYPE = "audio/mid";
    private static final String _MPEG_AUDIO_MIME_TYPE = "audio/mpeg";
    private static final String _MPEG_VIDEO_MIME_TYPE = "video/mpeg";
    private static final String _MPEG2_VIDEO_MIME_TYPE = "video/x-mpeg2";
    private static final String _PLAIN_TEXT_MIME_TYPE = "text/plain";
    private static final String _PORTABLE_ANYMAP_MIME_TYPE = "image/x-portable-anymap";
    private static final String _PORTABLE_BITMAP_MIME_TYPE = "image/x-portable-bitmap";
    private static final String _PORTABLE_GRAYMAP_MIME_TYPE = "image/x-portable-graymap";
    private static final String _PICT_MIME_TYPE = "image/pict";
    private static final String _PNG_MIME_TYPE = "image/png";
    private static final String _QUICKTIME_MIME_TYPE = "video/quicktime";
    private static final String _CMU_RASTER_MIME_TYPE = "image/x-cmu-raster";
    private static final String _REAL_AUDIO_MIME_TYPE = "audio/x-realaudio";
    private static final String _REAL_AUDIO_PLUGIN_MIME_TYPE = "audio/x-pn-realaudio-plugin";
    private static final String _REAL_AUDIO_PN_MIME_TYPE = "audio/x-pn-realaudio";
    private static final String _REAL_VIDEO_MIME_TYPE = "video/x-realaudio";
    private static final String _REAL_VIDEO_PLUGIN_MIME_TYPE = "video/x-pn-realaudio-plugin";
    private static final String _REAL_VIDEO_PN_MIME_TYPE = "video/x-pn-realaudio";
    private static final String _RGB_MIME_TYPE = "image/x-rgb";
    private static final String _SGI_MOVIE_MIME_TYPE = "video/x-sgi-movie";
    private static final String _SMIL_MIME_TYPE = "application/smil";
    private static final String _TIFF_MIME_TYPE = "image/tiff";
    private static final String _ULAW_MIME_TYPE = "audio/basic";
    private static final String _WAV_MIME_TYPE = "audio/wav";
    private static final String _WMA_MIME_TYPE = "audio/x-ms-wma";
    private static final String _WMV_MIME_TYPE = "video/x-ms-wmv";
    private static final String _WVX_MIME_TYPE = "video/x-ms-wvx";
    private static final String _X_BITMAP_MIME_TYPE = "image/x-xbitmap";
    private static final String _X_PIXMAP_MIME_TYPE = "image/x-xpixmap";
    private static final String _X_WINDOW_DUMP_MIME_TYPE = "image/x-xwindowdump";
    private static final String[] _MIME_TYPE_REMAPPER = new String[]{"audio/vnd.rn-realaudio", "audio/x-pn-realaudio", "video/vnd.rn-realvideo", "video/x-pn-realaudio", "audio/x-aiff", "audio/aiff", "audio/x-mpeg", "audio/mpeg", "audio/x-wav", "audio/wav", "video/msvideo", "video/avi", "video/x-mpeg", "video/mpeg", "video/x-msvideo", "video/avi"};
    private static final String _RP_CLASS_ID = "clsid:CFCDAA03-8BE4-11cf-B84B-0020AFBBCCFA";
    private static final String _QT_CLASS_ID = "clsid:02BF25D5-8C17-4B23-BC80-D3488ABDDC6B";
    private static final String _QT_CODE_BASE = "http://www.apple.com/qtactivex/qtplugin.cab";
    private static final String _WMP_6_4_CLASS_ID = "clsid:22D6F312-B0F6-11D0-94AB-0080C74C7E95";
    private static final String _WMP_CODE_BASE = "http://activex.microsoft.com/activex/controls/mplayer/en/nsmp2inf.cab#Version=6,0,02,902";
    private static final Integer _MIN_QT_HEIGHT = 2;
    private static final int _QT_CONTROL_HEIGHT = 16;
    private static final int _WMP_CONTROL_HEIGHT = 40;
    private static final PlayerData _LINK_PLAYER_DATA = new PlayerData("link", false, "true", "false", true, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    private static final PlayerData _IMAGE_PLAYER_DATA = new PlayerData("image", false, "true", "false", true, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    private static final ControlData _QUICKTIME_ALL_CONTROL_DATA = new ControlData(null, false, 16, 275);
    private static final PlayerData _QUICKTIME_PLAYER_DATA = new PlayerData("quicktime", true, "true", "false", false, _MIN_QT_HEIGHT, "autoplay", "src", "loop", "true", null, "http://www.apple.com/quicktime/download/", "http://www.apple.com/qtactivex/qtplugin.cab", null, "clsid:02BF25D5-8C17-4B23-BC80-D3488ABDDC6B", null, null, null, new Object[]{"audio", new ControlSet(new Object[]{"none", new ControlData(new String[]{"kioskmode", "true", "controller", "false"}, false, 0, 0), "noneVisible", new ControlData(new String[]{"controller", "false"}, false, 0, 0), "minimal", new ControlData(null, false, 16, 18), "typical", _QUICKTIME_ALL_CONTROL_DATA, "all", _QUICKTIME_ALL_CONTROL_DATA}), "video", new ControlSet(new Object[]{"none", new ControlData(new String[]{"kioskmode", "true", "controller", "false"}, false, 0, 0), "noneVisible", new ControlData(new String[]{"controller", "false"}, false, 0, 0), "minimal", _QUICKTIME_ALL_CONTROL_DATA, "typical", _QUICKTIME_ALL_CONTROL_DATA, "all", _QUICKTIME_ALL_CONTROL_DATA})}, new String[]{"audio/x-ms-wma", "video/x-ms-wmv", "audio/x-realaudio", "audio/x-pn-realaudio", "audio/x-pn-realaudio-plugin", "video/x-realaudio", "video/x-pn-realaudio", "video/x-pn-realaudio-plugin"});
    private static final Number _WMP_ALL_CONTROLS_WIDTH = 275;
    private static final Number _WMP_MINIMAL_CONTROLS_WIDTH = 72;
    private static final int _WMP_MINIMAL_CONTROLS_HEIGHT = 21;
    private static final int _WMP_ALL_CONTROLS_HEIGHT = 170;
    private static final ControlData _WMP_6_4_NONE_VISIBLE_CONTROL_DATA = new ControlData(new String[]{"showcontrols", "false"}, true, 0, 0);
    private static final ControlSet _WINDOWS_6_4_CONTROL_SET = new ControlSet(new Object[]{"none", _WMP_6_4_NONE_VISIBLE_CONTROL_DATA, "noneVisible", _WMP_6_4_NONE_VISIBLE_CONTROL_DATA, "minimal", new ControlData(new String[]{"showcontrols", "true", "showaudiocontrols", "false", "showpositioncontrols", "false", "showtracker", "false"}, false, 21, _WMP_MINIMAL_CONTROLS_WIDTH), "typical", new ControlData(null, true, 40, _WMP_ALL_CONTROLS_WIDTH), "all", new ControlData(new String[]{"showdisplay", "true", "showgotobar", "true", "showstatusbar", "true"}, true, 170, _WMP_ALL_CONTROLS_WIDTH)});
    private static final PlayerData _WINDOWS_6_4_PLAYER_DATA = new PlayerData("windows", true, "1", "0", false, null, "autostart", "filename", "playcount", 0, "playcount", "http://www.microsoft.com/Windows/MediaPlayer/", "http://activex.microsoft.com/activex/controls/mplayer/en/nsmp2inf.cab#Version=6,0,02,902", "application/x-mplayer2", "clsid:22D6F312-B0F6-11D0-94AB-0080C74C7E95", "application/x-oleobject", null, null, new Object[]{"audio", _WINDOWS_6_4_CONTROL_SET, "video", _WINDOWS_6_4_CONTROL_SET}, new String[]{"video/quicktime", "audio/x-realaudio", "audio/x-pn-realaudio", "audio/x-pn-realaudio-plugin", "video/x-realaudio", "video/x-pn-realaudio", "video/x-pn-realaudio-plugin"});
    private static final Number _REAL_MINIMAL_WIDTH = 44;
    private static final int _REAL_MINIMAL_HEIGHT = 26;
    private static final Number _REAL_TYPICAL_WIDTH = 220;
    private static final int _REAL_TYPICAL_HEIGHT = 36;
    private static final Number _REAL_ALL_WIDTH = 375;
    private static final int _REAL_ALL_HEIGHT = 100;
    private static final ControlData _NULL_CONTROL_DATA = new ControlData(null, false, 0, 0);
    private static final ControlData _REAL_VIDEO_IMAGE_WINDOW_CONTROL_DATA = new ControlData(new String[]{"controls", "ImageWindow", "maintainAspect", "true"}, false, 0, 0);
    private static final ControlData _REAL_MINIMAL_CONTROL_DATA = new ControlData(new String[]{"controls", "PlayButton"}, false, 26, _REAL_MINIMAL_WIDTH);
    private static final ControlData _REAL_TYPICAL_CONTROL_DATA = new ControlData(new String[]{"controls", "ControlPanel"}, false, 36, _REAL_TYPICAL_WIDTH);
    private static final ControlData _REAL_ALL_CONTROL_DATA = new ControlData(new String[]{"controls", "All"}, false, 100, _REAL_ALL_WIDTH);
    private static final ControlData _REAL_AUDIO_NONE_VISIBLE_CONTROL_DATA = new ControlData(new String[]{"controls", ""}, false, 0, 0);
    private static final PlayerData _REAL_PLAYER_DATA = new PlayerData("real", false, "true", "false", false, null, "autostart", "src", "loop", "true", "numloop", "http://www.real.com/player/", "http://www.real.com/player/", "audio/x-pn-realaudio-plugin", "clsid:CFCDAA03-8BE4-11cf-B84B-0020AFBBCCFA", null, "console", _REAL_VIDEO_IMAGE_WINDOW_CONTROL_DATA, new Object[]{"audio", new ControlSet(new Object[]{"none", _REAL_AUDIO_NONE_VISIBLE_CONTROL_DATA, "noneVisible", _REAL_AUDIO_NONE_VISIBLE_CONTROL_DATA, "minimal", _REAL_MINIMAL_CONTROL_DATA, "typical", _REAL_TYPICAL_CONTROL_DATA, "all", _REAL_ALL_CONTROL_DATA}), "video", new ControlSet(new Object[]{"none", _NULL_CONTROL_DATA, "noneVisible", _NULL_CONTROL_DATA, "minimal", _REAL_MINIMAL_CONTROL_DATA, "typical", _REAL_TYPICAL_CONTROL_DATA, "all", _REAL_ALL_CONTROL_DATA})}, null);
    private static final Object[] _PLAYER_DATA = new Object[]{"link", _LINK_PLAYER_DATA, "quicktime", _QUICKTIME_PLAYER_DATA, "windows", _WINDOWS_6_4_PLAYER_DATA, "real", _REAL_PLAYER_DATA};
    private static final String[] _EXTENSION_TO_MIME_TYPE = new String[]{"aif", "audio/aiff", "aifc", "audio/aiff", "aiff", "audio/aiff", "art", "image/x-art", "asf", "video/x-ms-asf", "asx", "video/x-ms-asf", "au", "audio/basic", "avi", "video/avi", "bmp", "image/bmp", "gif", "image/gif", "htm", "text/html", "html", "text/html", "ief", "image/ief", "jfif", "image/jpeg", "jpe", "image/jpeg", "jpg", "image/jpeg", "jpeg", "image/jpeg", "kar", "audio/mid", "m15", "video/mpeg", "m75", "video/mpeg", "m1a", "video/mpeg", "m1s", "video/mpeg", "m1v", "video/mpeg", "mid", "audio/mid", "midi", "audio/mid", "mov", "video/quicktime", "movie", "video/x-sgi-movie", "mpe", "video/mpeg", "mpg", "video/mpeg", "mpga", "audio/mpeg", "mpeg", "video/mpeg", "mp2", "audio/mpeg", "mp3", "audio/mpeg", "mpa", "audio/mpeg", "mpm", "audio/mpeg", "mp2v", "video/x-mpeg2", "mpv2", "video/x-mpeg2", "pbm", "image/x-portable-bitmap", "pgm", "image/x-portable-graymap", "pnm", "image/x-portable-anymap", "pic", "image/pict", "pict", "image/pict", "png", "image/png", "qt", "video/quicktime", "ra", "audio/x-realaudio", "ram", "audio/x-pn-realaudio", "ras", "image/x-cmu-raster", "rgb", "image/x-rgb", "rm", "audio/x-pn-realaudio", "rpg", "audio/x-pn-realaudio-plugin", "rpm", "audio/x-pn-realaudio-plugin", "rv", "video/x-realaudio", "smf", "audio/mid", "smi", "application/smil", "smil", "application/smil", "snd", "audio/basic", "tif", "image/tiff", "tiff", "image/tiff", "txt", "text/plain", "ulw", "audio/basic", "wav", "audio/wav", "wma", "audio/x-ms-wma", "wmv", "video/x-ms-wmv", "wvx", "video/x-ms-wvx", "xbm", "image/x-xbitmap", "xpm", "image/x-xpixmap", "xwd", "image/x-xwindowdump"};
    private static final Object[] _PREFERRED_MIME_PLAYERS = new Object[]{"audio/aiff", "quicktime", "video/x-ms-asf", "windows", "video/avi", "windows", "video/quicktime", "quicktime", "audio/x-realaudio", "real", "audio/x-pn-realaudio", "real", "audio/x-pn-realaudio-plugin", "real", "video/x-realaudio", "real", "video/x-pn-realaudio", "real", "video/x-pn-realaudio-plugin", "real", "audio/x-ms-wma", "windows", "video/x-ms-wmv", "windows", "video/x-ms-wvx", "windows"};
    private static final Integer _WINDOWS_OS = 1;
    private static final Integer _MAC_OS = 2;
    private static final Integer _SOLARIS_OS = 4;
    private static final Object[] _SUPPORTED_OS_PLAYERS = new Object[]{_WINDOWS_OS, new Object[]{"windows", "quicktime", "real"}, _MAC_OS, new Object[]{"quicktime", "windows", "real"}, _SOLARIS_OS, new Object[]{"windows"}};
    private static Object[] _DEFAULT_INNER_SIZES = new Object[]{"audio", new Number[]{0, 0}, "video", new Number[]{200, 150}};
    private static final int _DEFAULT_INNER_WIDTH_INDEX = 0;
    private static final int _DEFAULT_INNER_HEIGHT_INDEX = 1;
    private static HashMap<Object, Object> _sPreferredMimePlayers;
    private static HashMap<Integer, String> _sPreferredOSPlayers;
    private static HashMap<Integer, HashSet<Object>> _sSupportedOSPlayers;
    private static HashMap<Object, Object> _sMimeTypeRemapper;
    private static HashMap<Object, Object> _sExtensionMap;
    private static HashMap<Object, Object> _sPlayerData;
    private static HashMap<Object, Object> _sDefaultInnerSizes;
    private PropertyKey _sourceKey;
    private PropertyKey _playerKey;
    private PropertyKey _contentTypeKey;
    private PropertyKey _autostartKey;
    private PropertyKey _playCountKey;
    private PropertyKey _controlsKey;
    private PropertyKey _standbyTextKey;
    private PropertyKey _widthKey;
    private PropertyKey _heightKey;
    private PropertyKey _innerWidthKey;
    private PropertyKey _innerHeightKey;

    public MediaRenderer() {
        super(CoreMedia.TYPE);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._sourceKey = type.findKey("source");
        this._playerKey = type.findKey("player");
        this._contentTypeKey = type.findKey("contentType");
        this._autostartKey = type.findKey("autostart");
        this._playCountKey = type.findKey("playCount");
        this._controlsKey = type.findKey("controls");
        this._standbyTextKey = type.findKey("standbyText");
        this._widthKey = type.findKey("width");
        this._heightKey = type.findKey("height");
        this._innerWidthKey = type.findKey("innerWidth");
        this._innerHeightKey = type.findKey("innerHeight");
    }

    protected String getSource(FacesBean bean) {
        return MediaRenderer.toResourceUri((FacesContext)FacesContext.getCurrentInstance(), (Object)bean.getProperty(this._sourceKey));
    }

    protected String getPlayer(FacesBean bean) {
        return MediaRenderer.toString((Object)bean.getProperty(this._playerKey));
    }

    protected String getContentType(FacesBean bean) {
        return MediaRenderer.toString((Object)bean.getProperty(this._contentTypeKey));
    }

    protected String getControls(FacesBean bean) {
        return MediaRenderer.toString((Object)bean.getProperty(this._controlsKey));
    }

    protected String getStandbyText(FacesBean bean) {
        return MediaRenderer.toString((Object)bean.getProperty(this._standbyTextKey));
    }

    protected boolean getAutostart(FacesBean bean) {
        Object o = bean.getProperty(this._autostartKey);
        if (o == null) {
            o = this._autostartKey.getDefault();
        }
        return Boolean.TRUE.equals(o);
    }

    protected Number getPlayCount(FacesBean bean) {
        Object o = bean.getProperty(this._playCountKey);
        if (o == null) {
            o = this._playCountKey.getDefault();
        }
        if (o instanceof Number) {
            return (Number)o;
        }
        return null;
    }

    protected String getWidth(FacesBean bean) {
        return MediaRenderer.toString((Object)bean.getProperty(this._widthKey));
    }

    protected String getHeight(FacesBean bean) {
        return MediaRenderer.toString((Object)bean.getProperty(this._heightKey));
    }

    protected String getInnerWidth(FacesBean bean) {
        return MediaRenderer.toString((Object)bean.getProperty(this._innerWidthKey));
    }

    protected String getInnerHeight(FacesBean bean) {
        return MediaRenderer.toString((Object)bean.getProperty(this._innerHeightKey));
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeAll(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean) throws IOException {
        if (this.canSkipRendering(context, arc, component)) {
            return;
        }
        String mimeType = this._getMimeType(bean);
        String primaryContentType = this._getPrimaryContentType(mimeType);
        PlayerData playerData = this._getPlayerData(arc, bean, mimeType, primaryContentType);
        ResponseWriter writer = context.getResponseWriter();
        String source = this.getSource(bean);
        String contentType = this.getContentType(bean);
        String id = this.getClientId(context, component);
        if (_LINK_PLAYER_DATA == playerData) {
            this._renderLink(context, arc, component, bean, id, source, null, contentType);
        } else {
            boolean canAutosize;
            boolean isImage;
            ControlSet controlSet = playerData.getControlSet(primaryContentType);
            ControlData imageWindowControlData = playerData.getImageWindowControlData(primaryContentType);
            ControlData controlData = controlSet != null ? controlSet.getControlData(this.getControls(bean)) : null;
            boolean useEmbedTag = true;
            boolean useObjectTag = true;
            boolean bl = isImage = _IMAGE_PLAYER_DATA == playerData;
            if (isImage) {
                useEmbedTag = false;
                useObjectTag = false;
            } else {
                useEmbedTag = this.useEmbed(arc);
                useObjectTag = !useEmbedTag;
            }
            String width = this.getWidth(bean);
            if (width == null) {
                width = this.getInnerWidth(bean);
            }
            boolean bl2 = canAutosize = playerData.canAlwaysAutosize || controlData.canAutosize && !useEmbedTag;
            if (width == null && !canAutosize) {
                Number defaultInnerWidth = this.getDefaultInnerWidth(primaryContentType);
                width = (defaultInnerWidth.intValue() > controlData.preferredWidth.intValue() ? (Number)defaultInnerWidth : (Number)controlData.preferredWidth).toString();
            }
            String autostartValue = null;
            String playCountParamName = null;
            Object playCountParamValue = null;
            if (!isImage) {
                boolean autostarts;
                int playCount;
                Number playCountValue = this.getPlayCount(bean);
                if (playCountValue != null && (playCount = playCountValue.intValue()) != 1 && playCount >= 0) {
                    if (playCount == 0) {
                        playCountParamName = playerData.infiniteLoopParamName;
                        playCountParamValue = playerData.infiniteLoopParamValue;
                    } else {
                        playCountParamName = playerData.playCountParamName;
                        playCountParamValue = playCountValue;
                    }
                }
                if ((autostarts = this.getAutostart(bean)) != playerData.autostartByDefault) {
                    autostartValue = autostarts ? playerData.autostartTrueValue : playerData.autostartFalseValue;
                }
            }
            String standbyText = this.getStandbyText(bean);
            String height = null;
            if (imageWindowControlData != null) {
                height = this._getInnerHeight(bean, canAutosize, primaryContentType, controlData, playerData);
                String wireImageToControlsParamValue = id;
                this._render(context, arc, component, bean, contentType, id, wireImageToControlsParamValue, source, standbyText, width, height, autostartValue, playCountParamName, playCountParamValue, playerData, imageWindowControlData, useEmbedTag, useObjectTag, isImage, false);
                if (controlData != _NULL_CONTROL_DATA) {
                    writer.startElement("div", component);
                    writer.endElement("div");
                    height = IntegerUtils.getString((int)controlData.height);
                    this._render(context, arc, component, bean, contentType, id, wireImageToControlsParamValue, null, null, width, height, null, null, null, playerData, controlData, useEmbedTag, useObjectTag, isImage, true);
                }
            } else {
                height = this._getHeight(bean, canAutosize, primaryContentType, controlData, playerData);
                this._render(context, arc, component, bean, contentType, id, null, source, standbyText, width, height, autostartValue, playCountParamName, playCountParamValue, playerData, controlData, useEmbedTag, useObjectTag, isImage, false);
            }
            if (useEmbedTag) {
                writer.startElement("noembed", component);
                this._renderLink(context, arc, component, bean, null, source, null, contentType);
                writer.endElement("noembed");
            }
        }
    }

    protected Number getDefaultInnerWidth(String primaryContentType) {
        return this._getDefaultSizeArray(primaryContentType)[0];
    }

    protected Number getDefaultInnerHeight(String primaryContentType) {
        return this._getDefaultSizeArray(primaryContentType)[1];
    }

    protected boolean useEmbed(RenderingContext arc) {
        TrinidadAgent agent = (TrinidadAgent)arc.getAgent();
        return agent.getAgentType() != 0 || agent.getAgentApplication() != TrinidadAgent.Application.IEXPLORER || agent.getAgentOS() != 1;
    }

    private Number[] _getDefaultSizeArray(String primaryContentType) {
        Object sizeArray = _sDefaultInnerSizes.get(primaryContentType);
        if (sizeArray == null) {
            sizeArray = _sDefaultInnerSizes.get("video");
        }
        return (Number[])sizeArray;
    }

    private void _renderLink(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean, String id, String source, String iconUrl, String contentType) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (source == null) {
            if (id != null) {
                writer.startElement("span", component);
                writer.writeAttribute("id", (Object)id, null);
                this.renderAllAttributes(context, arc, bean);
                writer.endElement("span");
            }
        } else {
            String shortDesc;
            writer.startElement("a", component);
            if (id != null) {
                writer.writeAttribute("id", (Object)id, null);
                this.renderAllAttributes(context, arc, bean);
            }
            this.renderEncodedActionURI(context, "href", source);
            writer.writeAttribute("type", (Object)contentType, null);
            if (iconUrl != null) {
                writer.startElement("img", component);
                this.renderEncodedResourceURI(context, "src", iconUrl);
                writer.endElement("img");
            }
            if ((shortDesc = this.getShortDesc(bean)) != null) {
                writer.writeText((Object)shortDesc, "shortDesc");
            }
            writer.endElement("a");
        }
    }

    private void _renderParamAttribute(FacesContext context, String paramName, Object paramValue, boolean isURL) throws IOException {
        if (paramValue != null) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("param", null);
            writer.writeAttribute("name", (Object)paramName, null);
            if (isURL) {
                this.renderEncodedResourceURI(context, "value", paramValue);
            } else {
                writer.writeAttribute("value", paramValue, null);
            }
            writer.endElement("param");
        }
    }

    private PlayerData _getPlayerData(RenderingContext arc, FacesBean bean, String mimeType, String primaryMimeType) {
        PlayerData playerData = null;
        TrinidadAgent agent = (TrinidadAgent)arc.getAgent();
        int agentOSInt = agent.getAgentOS();
        HashSet<Object> supportedPlayers = _sSupportedOSPlayers.get(agentOSInt);
        boolean isImage = "image".equals(primaryMimeType);
        if (supportedPlayers != null) {
            Object preferredPlayer;
            String playerString = this.getPlayer(bean);
            if (playerString != null) {
                if ("link".equals(playerString)) {
                    playerData = _LINK_PLAYER_DATA;
                } else if (!isImage && supportedPlayers.contains(playerString) && (playerData = (PlayerData)_sPlayerData.get(playerString)) != null && mimeType != null && !playerData.isSupportedMimeType(mimeType)) {
                    playerData = null;
                }
            }
            if (isImage) {
                playerData = _IMAGE_PLAYER_DATA;
            } else if (!"video".equals(primaryMimeType) && !"audio".equals(primaryMimeType)) {
                playerData = _LINK_PLAYER_DATA;
            }
            if (playerData == null && (preferredPlayer = _sPreferredMimePlayers.get(mimeType)) != null && supportedPlayers.contains(preferredPlayer)) {
                playerData = (PlayerData)_sPlayerData.get(preferredPlayer);
            }
            if (playerData == null && (preferredPlayer = _sPreferredOSPlayers.get(agentOSInt)) != null && !(playerData = (PlayerData)_sPlayerData.get(preferredPlayer)).isSupportedMimeType(mimeType)) {
                playerData = null;
            }
        }
        if (playerData == null) {
            playerData = _LINK_PLAYER_DATA;
        }
        return playerData;
    }

    private String _getPrimaryContentType(String mimeType) {
        int slashIndex;
        if (mimeType != null && (slashIndex = mimeType.indexOf(47)) != -1) {
            return mimeType.substring(0, slashIndex);
        }
        return null;
    }

    private String _getSecondaryContentType(String mimeType) {
        int slashIndex;
        if (mimeType != null && (slashIndex = mimeType.indexOf(47)) != -1) {
            return mimeType.substring(slashIndex + 1);
        }
        return null;
    }

    private String _getMimeType(FacesBean bean) {
        Object mimeTypeObject;
        String extension;
        String mimeType = this.getContentType(bean);
        String primaryForced = null;
        if (mimeType != null) {
            int mimeLength;
            if ((mimeType = mimeType.toLowerCase(Locale.US)).charAt((mimeLength = mimeType.length()) - 1) == '*' && mimeType.charAt(mimeLength - 2) == '/') {
                primaryForced = mimeType.substring(0, mimeLength - 2);
            } else {
                Object remapped = _sMimeTypeRemapper.get(mimeType);
                if (remapped != null) {
                    return remapped.toString();
                }
                return mimeType;
            }
        }
        if ((extension = this._getSourceExtension(bean)) != null && (mimeTypeObject = _sExtensionMap.get(extension)) != null) {
            mimeType = mimeTypeObject.toString();
            if (primaryForced != null) {
                mimeType = primaryForced + '/' + this._getSecondaryContentType(mimeType);
            }
        }
        return mimeType;
    }

    private String _getSourceExtension(FacesBean bean) {
        int extensionIndex;
        String sourceURLString = this.getSource(bean);
        if (sourceURLString != null && (extensionIndex = sourceURLString.lastIndexOf(46)) != -1 && extensionIndex != sourceURLString.length() - 1) {
            return sourceURLString.substring(extensionIndex + 1).toLowerCase();
        }
        return null;
    }

    private static HashSet<Object> _createHashSet(Object[] contents) {
        if (contents != null) {
            int contentLength = contents.length;
            HashSet<Object> set = new HashSet<Object>((int)((double)contentLength * 1.5));
            for (int i = 0; i < contentLength; ++i) {
                set.add(contents[i]);
            }
            return set;
        }
        return null;
    }

    private static HashMap<Object, Object> _createHashMap(Object[] contents) {
        if (contents != null) {
            int contentLength = contents.length;
            HashMap<Object, Object> map = new HashMap<Object, Object>((int)((double)contentLength * 0.75));
            for (int i = 0; i < contentLength; i += 2) {
                map.put(contents[i], contents[i + 1]);
            }
            return map;
        }
        return null;
    }

    private String _getInnerHeight(FacesBean bean, boolean canAutosize, String primaryContentType, ControlData controlData, PlayerData playerData) {
        boolean useMinHeight;
        String height = this._getHeightNoMin(bean, canAutosize, primaryContentType, controlData);
        boolean bl = useMinHeight = height == null;
        if (!useMinHeight) {
            int intHeight = this._getIntHeight(height);
            if (playerData.minHeight != null && intHeight < playerData.minHeight.intValue()) {
                useMinHeight = true;
            } else if (intHeight < Integer.MAX_VALUE) {
                return IntegerUtils.getString((int)(intHeight - controlData.height));
            }
        }
        if (useMinHeight) {
            return IntegerUtils.getString((int)(playerData.minHeight.intValue() - controlData.height));
        }
        return height;
    }

    private String _getHeightNoMin(FacesBean bean, boolean canAutosize, String primaryContentType, ControlData controlData) {
        String height = this.getHeight(bean);
        if (height == null) {
            int extraHeight;
            String innerHeight = this.getInnerHeight(bean);
            if (!canAutosize && innerHeight == null) {
                innerHeight = this.getDefaultInnerHeight(primaryContentType).toString();
            }
            int n = extraHeight = controlData != null ? controlData.height : 0;
            if (innerHeight != null && extraHeight != 0) {
                try {
                    int innerHeightInt = Integer.parseInt(innerHeight);
                    height = Integer.toString(innerHeightInt + extraHeight);
                }
                catch (NumberFormatException nfe) {
                    height = innerHeight;
                }
            } else {
                height = innerHeight;
            }
        }
        return height;
    }

    private String _getHeight(FacesBean bean, boolean canAutosize, String primaryContentType, ControlData controlData, PlayerData playerData) {
        String height = this._getHeightNoMin(bean, canAutosize, primaryContentType, controlData);
        if (playerData.minHeight != null) {
            boolean useMinHeight;
            boolean bl = useMinHeight = height == null;
            if (!useMinHeight) {
                int intHeight = this._getIntHeight(height);
                boolean bl2 = useMinHeight = playerData.minHeight.intValue() > intHeight;
            }
            if (useMinHeight) {
                height = playerData.minHeight.toString();
            }
        }
        return height;
    }

    private int _getIntHeight(Object height) {
        int intHeight;
        if (height instanceof Number) {
            intHeight = ((Number)height).intValue();
        } else {
            String stringHeight = height.toString();
            if (stringHeight.indexOf(37) == -1) {
                try {
                    intHeight = new Integer(stringHeight);
                }
                catch (NumberFormatException e) {
                    intHeight = Integer.MAX_VALUE;
                }
            } else {
                intHeight = Integer.MAX_VALUE;
            }
        }
        return intHeight;
    }

    private void _render(FacesContext context, RenderingContext arc, UIComponent component, FacesBean bean, String contentType, String id, String wireImageToControls, String source, String standbyText, String width, String height, String autostartValue, String playCountParamName, Object playCountParamValue, PlayerData playerData, ControlData controlData, boolean useEmbedTag, boolean useObjectTag, boolean isImage, boolean isNotMainID) throws IOException {
        int i;
        String[] paramNameValues;
        String elementName = isImage ? "img" : (useEmbedTag ? "embed" : "object");
        String sourceAttrName = "src";
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement(elementName, component);
        this.renderAllAttributes(context, arc, bean);
        writer.writeAttribute("width", (Object)width, null);
        writer.writeAttribute("height", (Object)height, null);
        if (!isImage) {
            if (useEmbedTag) {
                writer.writeAttribute("name", (Object)id, null);
                writer.writeAttribute("type", (Object)playerData.playerMimeType, null);
                writer.writeAttribute("pluginspage", (Object)playerData.pluginsPage, null);
                writer.writeAttribute(playerData.autostartParamName, (Object)autostartValue, null);
                writer.writeAttribute(playCountParamName, playCountParamValue, null);
                writer.writeAttribute(playerData.wireImageToControlsParamName, (Object)wireImageToControls, null);
                if (controlData != null && (paramNameValues = controlData.paramNameValues) != null) {
                    for (i = 0; i < paramNameValues.length; i += 2) {
                        writer.writeAttribute(paramNameValues[i], (Object)paramNameValues[i + 1], null);
                    }
                }
            } else {
                if (!isNotMainID) {
                    writer.writeAttribute("id", (Object)id, null);
                }
                sourceAttrName = null;
                if (playerData.overrideContentType != null) {
                    contentType = playerData.overrideContentType;
                }
                writer.writeAttribute("standby", (Object)standbyText, null);
                writer.writeAttribute("type", (Object)contentType, null);
                writer.writeAttribute("classid", (Object)playerData.classID, null);
                writer.writeAttribute("codebase", (Object)playerData.codeBase, null);
            }
        }
        if (sourceAttrName != null) {
            this.renderEncodedResourceURI(context, sourceAttrName, source);
        }
        if (useObjectTag) {
            this._renderParamAttribute(context, playerData.sourceParamName, source, true);
            this._renderParamAttribute(context, playerData.autostartParamName, autostartValue, false);
            this._renderParamAttribute(context, playCountParamName, playCountParamValue, false);
            if (playerData.wireImageToControlsParamName != null) {
                this._renderParamAttribute(context, playerData.wireImageToControlsParamName, wireImageToControls, false);
            }
            if (controlData != null && (paramNameValues = controlData.paramNameValues) != null) {
                for (i = 0; i < paramNameValues.length; i += 2) {
                    this._renderParamAttribute(context, paramNameValues[i], paramNameValues[i + 1], false);
                }
            }
            this._renderLink(context, arc, component, bean, null, source, null, contentType);
        }
        writer.endElement(elementName);
    }

    static {
        _sPlayerData = MediaRenderer._createHashMap(_PLAYER_DATA);
        _sPreferredMimePlayers = MediaRenderer._createHashMap(_PREFERRED_MIME_PLAYERS);
        int supportedOSPlayersLength = _SUPPORTED_OS_PLAYERS.length;
        int hashSize = (int)((double)supportedOSPlayersLength * 0.75);
        _sSupportedOSPlayers = new HashMap(hashSize);
        _sPreferredOSPlayers = new HashMap(hashSize);
        for (int i = 0; i < supportedOSPlayersLength; i += 2) {
            Integer os = (Integer)_SUPPORTED_OS_PLAYERS[i];
            Object[] players = (Object[])_SUPPORTED_OS_PLAYERS[i + 1];
            if (players == null || players.length <= 0) continue;
            _sSupportedOSPlayers.put(os, MediaRenderer._createHashSet(players));
            _sPreferredOSPlayers.put(os, (String)players[0]);
        }
        _sMimeTypeRemapper = MediaRenderer._createHashMap(_MIME_TYPE_REMAPPER);
        _sExtensionMap = MediaRenderer._createHashMap(_EXTENSION_TO_MIME_TYPE);
        _sDefaultInnerSizes = MediaRenderer._createHashMap(_DEFAULT_INNER_SIZES);
    }

    private static class PlayerData {
        public final String player;
        public final boolean autostartByDefault;
        public final String autostartTrueValue;
        public final String autostartFalseValue;
        public final boolean canAlwaysAutosize;
        public final Number minHeight;
        public final String autostartParamName;
        public final String sourceParamName;
        public final String infiniteLoopParamName;
        public final Object infiniteLoopParamValue;
        public final String playCountParamName;
        public final String pluginsPage;
        public final String codeBase;
        public final String playerMimeType;
        public final String classID;
        public final String overrideContentType;
        public final String wireImageToControlsParamName;
        private final ControlData _imageWindowControlData;
        private final HashMap<Object, Object> _controlSets;
        private final HashSet<Object> _unsupportedMimeTypes;

        public PlayerData(String player, boolean autostartByDefault, String autostartTrueValue, String autostartFalseValue, boolean canAlwaysAutosize, Number minHeight, String autostartParamName, String sourceParamName, String infiniteLoopParamName, Object infiniteLoopParamValue, String playCountParamName, String pluginsPage, String codeBase, String playerMimeType, String classID, String overrideContentType, String wireImageToControlsParamName, ControlData imageWindowControlData, Object[] controlSets, Object[] unsupportedMimeTypes) {
            if (minHeight != null && minHeight.intValue() < 0) {
                throw new IllegalArgumentException();
            }
            this.player = player;
            this.autostartByDefault = autostartByDefault;
            this.autostartTrueValue = autostartTrueValue;
            this.autostartFalseValue = autostartFalseValue;
            this.canAlwaysAutosize = canAlwaysAutosize;
            this.minHeight = minHeight;
            this.autostartParamName = autostartParamName;
            this.sourceParamName = sourceParamName;
            this.infiniteLoopParamName = infiniteLoopParamName;
            this.infiniteLoopParamValue = infiniteLoopParamValue;
            this.playCountParamName = playCountParamName;
            this.pluginsPage = pluginsPage;
            this.codeBase = codeBase;
            this.classID = classID;
            this.playerMimeType = playerMimeType;
            this.overrideContentType = overrideContentType;
            this.wireImageToControlsParamName = wireImageToControlsParamName;
            this._imageWindowControlData = imageWindowControlData;
            this._controlSets = MediaRenderer._createHashMap(controlSets);
            this._unsupportedMimeTypes = MediaRenderer._createHashSet(unsupportedMimeTypes);
        }

        public ControlData getImageWindowControlData(String primaryContentType) {
            if ("video".equals(primaryContentType)) {
                return this._imageWindowControlData;
            }
            return null;
        }

        public ControlSet getControlSet(String primaryContentType) {
            if (this._controlSets != null) {
                Object controls = null;
                if (primaryContentType != null) {
                    controls = this._controlSets.get(primaryContentType);
                }
                if (controls == null) {
                    controls = this._controlSets.get("video");
                }
                return (ControlSet)controls;
            }
            return null;
        }

        public boolean isSupportedMimeType(String mimeType) {
            if (mimeType != null && mimeType.length() != 0 && this._unsupportedMimeTypes != null) {
                return !this._unsupportedMimeTypes.contains(mimeType);
            }
            return true;
        }
    }

    private static class ControlSet {
        private final HashMap<Object, Object> _controls;

        public ControlSet(Object[] controls) {
            this._controls = MediaRenderer._createHashMap(controls);
        }

        public ControlData getControlData(Object controlValue) {
            Object controlData = null;
            if (controlValue != null) {
                controlData = this._controls.get(controlValue.toString());
            }
            if (controlData == null) {
                controlData = this._controls.get("typical");
            }
            return (ControlData)controlData;
        }
    }

    private static class ControlData {
        public String[] paramNameValues;
        public boolean canAutosize;
        public int height;
        public Number preferredWidth;

        public ControlData(String[] paramNameValues, boolean canAutosize, int height, Number preferredWidth) {
            if (height < 0) {
                throw new IllegalArgumentException();
            }
            if (preferredWidth.intValue() < 0) {
                throw new IllegalArgumentException();
            }
            this.paramNameValues = paramNameValues;
            this.canAutosize = canAutosize;
            this.height = height;
            this.preferredWidth = preferredWidth;
        }
    }
}

