/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.change;

import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.change.ChangeManager;
import org.apache.myfaces.trinidad.change.ChangeUtils;
import org.apache.myfaces.trinidad.change.ComponentChange;
import org.apache.myfaces.trinidad.change.DocumentChange;
import org.apache.myfaces.trinidad.component.UIXComponent;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ComponentUtils;
import org.w3c.dom.Node;

public final class MoveChildComponentChange
extends ComponentChange
implements DocumentChange {
    private transient UIComponent _commonParent;
    private final String _movableChildScopedId;
    private final String _sourceParentScopedId;
    private final String _destinationContainerScopedId;
    private final String _commonParentScopedId;
    private final String _insertBeforeId;
    private final String _sourceAbsoluteScopedId;
    private final String _destinationAbsoluteScopedId;
    private final String _sourceAbsoluteLogicalScopedId;
    private final String _destinationAbsoluteLogicalScopedId;
    private static final long serialVersionUID = 1L;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(MoveChildComponentChange.class);

    public MoveChildComponentChange(UIComponent movableChild, UIComponent destinationContainer) {
        this(movableChild, destinationContainer, null);
    }

    public MoveChildComponentChange(UIComponent movableChild, UIComponent destinationContainer, UIComponent insertBeforeComponent) {
        if (movableChild == null) {
            throw new IllegalArgumentException(_LOG.getMessage("MOVABLE_CHILD_REQUIRED"));
        }
        if (destinationContainer == null) {
            throw new IllegalArgumentException(_LOG.getMessage("DESTINATION_CONTAINER_REQUIRED"));
        }
        UIViewRoot viewRoot = FacesContext.getCurrentInstance().getViewRoot();
        String sourceAbsoluteLogicalScopedId = ComponentUtils.getLogicalScopedIdForComponent(movableChild, (UIComponent)viewRoot);
        String destinationContainerLogicalPrefix = this._getScopedIdPrefix(destinationContainer, ComponentUtils.getLogicalScopedIdForComponent(destinationContainer, (UIComponent)viewRoot));
        String movableChildId = movableChild.getId();
        String destinationAbsoluteLogicalScopedId = destinationContainerLogicalPrefix != null ? destinationContainerLogicalPrefix + ':' + movableChildId : movableChildId;
        this._commonParent = MoveChildComponentChange._getClosestCommonParentUIXComponent(movableChild, destinationContainer);
        if (this._commonParent == null) {
            throw new IllegalArgumentException(_LOG.getMessage("COMMON_PARENT_NOT_FOUND"));
        }
        this._movableChildScopedId = ComponentUtils.getScopedIdForComponent(movableChild, this._commonParent);
        this._sourceParentScopedId = ComponentUtils.getScopedIdForComponent(movableChild.getParent(), this._commonParent);
        this._destinationContainerScopedId = ComponentUtils.getScopedIdForComponent(destinationContainer, this._commonParent);
        this._commonParentScopedId = ComponentUtils.getScopedIdForComponent(this._commonParent, null);
        if (this._movableChildScopedId == null || this._sourceParentScopedId == null || this._destinationContainerScopedId == null || this._commonParentScopedId == null) {
            throw new IllegalArgumentException(_LOG.getMessage("MOVE_PARTICIPANTS_WITHOUT_ID"));
        }
        String commonParentPrefix = this._getScopedIdPrefix(this._commonParent, this._commonParentScopedId);
        this._sourceAbsoluteScopedId = commonParentPrefix != null ? commonParentPrefix + ':' + this._movableChildScopedId : this._movableChildScopedId;
        this._sourceAbsoluteLogicalScopedId = this._sourceAbsoluteScopedId.equals(sourceAbsoluteLogicalScopedId) ? null : sourceAbsoluteLogicalScopedId;
        String destinationContainerPrefix = this._getScopedIdPrefix(destinationContainer, this._destinationContainerScopedId);
        StringBuilder destinationScopedIdBuilder = new StringBuilder();
        if (commonParentPrefix != null) {
            destinationScopedIdBuilder.append(commonParentPrefix).append(':');
        }
        if (destinationContainerPrefix != null) {
            destinationScopedIdBuilder.append(destinationContainerPrefix).append(':');
        }
        this._destinationAbsoluteScopedId = destinationScopedIdBuilder.append(movableChildId).toString();
        this._destinationAbsoluteLogicalScopedId = this._destinationAbsoluteScopedId.equals(destinationAbsoluteLogicalScopedId) ? null : destinationAbsoluteLogicalScopedId;
        this._insertBeforeId = insertBeforeComponent == null ? null : insertBeforeComponent.getId();
    }

    private String _getScopedIdPrefix(UIComponent component, String scopedId) {
        if (component instanceof NamingContainer) {
            return scopedId;
        }
        int separatorIndex = scopedId.lastIndexOf(58);
        if (separatorIndex >= 0) {
            return scopedId.substring(0, separatorIndex);
        }
        return null;
    }

    public UIComponent add(FacesContext facesContext, ChangeManager changeManager) {
        UIComponent commonParent = this._commonParent;
        if (commonParent == null) {
            commonParent = facesContext.getViewRoot().findComponent(this._commonParentScopedId);
        }
        if (commonParent == null) {
            _LOG.warning("COMMON_PARENT_NOT_FOUND", this._commonParentScopedId);
            return null;
        }
        changeManager.addComponentChange(facesContext, commonParent, this);
        this._commonParent = null;
        return commonParent;
    }

    public void changeComponent(UIComponent changeTargetComponent) {
        UIComponent foundChild;
        if (changeTargetComponent == null) {
            throw new IllegalArgumentException(_LOG.getMessage("COMPONENT_REQUIRED"));
        }
        UIComponent destinationContainer = changeTargetComponent.findComponent(this._destinationContainerScopedId);
        if (destinationContainer == null) {
            _LOG.warning("DESTINATION_CONTAINER_NOT_FOUND", this._destinationContainerScopedId);
            return;
        }
        UIComponent sourceParent = changeTargetComponent.findComponent(this._sourceParentScopedId);
        UIComponent movableChild = foundChild = changeTargetComponent.findComponent(this._movableChildScopedId);
        int movableChildIndex = 0;
        while (foundChild != null) {
            if (foundChild.getParent().equals(sourceParent)) {
                movableChild = foundChild;
                movableChildIndex = sourceParent.getChildren().indexOf(movableChild);
            }
            foundChild.getParent().getChildren().remove(foundChild);
            foundChild = changeTargetComponent.findComponent(this._movableChildScopedId);
        }
        if (movableChild == null) {
            _LOG.warning("MOVABLE_CHILD_NOT_FOUND", this._movableChildScopedId);
            return;
        }
        sourceParent.getChildren().add(movableChildIndex, movableChild);
        String movableChildId = movableChild.getId();
        int indexOfChildWithSameIdAtDestination = 0;
        UIComponent childWithSameIdAtDestination = null;
        for (UIComponent childComponent : destinationContainer.getChildren()) {
            if (!movableChildId.equals(childComponent.getId())) continue;
            indexOfChildWithSameIdAtDestination = destinationContainer.getChildren().indexOf(childComponent);
            childWithSameIdAtDestination = childComponent;
            destinationContainer.getChildren().remove(childComponent);
        }
        int insertIndex = -1;
        if (this._insertBeforeId != null) {
            for (UIComponent childComponent : destinationContainer.getChildren()) {
                if (!this._insertBeforeId.equals(childComponent.getId())) continue;
                insertIndex = destinationContainer.getChildren().indexOf(childComponent);
                break;
            }
            if (insertIndex == -1) {
                if (childWithSameIdAtDestination != null) {
                    destinationContainer.getChildren().add(indexOfChildWithSameIdAtDestination, childWithSameIdAtDestination);
                }
                _LOG.warning("INSERT_BEFORE_NOT_FOUND", this._insertBeforeId);
                return;
            }
        }
        if (insertIndex == -1) {
            destinationContainer.getChildren().add(movableChild);
        } else {
            destinationContainer.getChildren().add(insertIndex, movableChild);
        }
    }

    public void changeDocument(Node changeTargetNode) {
        Node insertBeforeNode;
        if (changeTargetNode == null) {
            throw new IllegalArgumentException(_LOG.getMessage("NO_NODE_SPECIFIED"));
        }
        Node movableChildNode = ChangeUtils.__findNodeByScopedId(changeTargetNode, this._movableChildScopedId, Integer.MAX_VALUE);
        if (movableChildNode == null) {
            _LOG.warning("MOVABLE_CHILD_NOT_FOUND", this._movableChildScopedId);
            return;
        }
        Node destinationContainerNode = ChangeUtils.__findNodeByScopedId(changeTargetNode, this._destinationContainerScopedId, Integer.MAX_VALUE);
        if (destinationContainerNode == null) {
            _LOG.warning("DESTINATION_CONTAINER_NOT_FOUND", this._destinationContainerScopedId);
            return;
        }
        Node node = insertBeforeNode = this._insertBeforeId == null ? null : ChangeUtils.__findNodeByScopedId(destinationContainerNode, this._insertBeforeId, 1);
        if (this._insertBeforeId != null && insertBeforeNode == null) {
            _LOG.warning("INSERT_BEFORE_NOT_FOUND", this._insertBeforeId);
            return;
        }
        destinationContainerNode.insertBefore(movableChildNode, insertBeforeNode);
    }

    public boolean getForcesDocumentReload() {
        return true;
    }

    private static UIComponent _getClosestCommonParentUIXComponent(UIComponent firstComponent, UIComponent secondComponent) {
        UIComponent sharedRoot;
        if (firstComponent == null || secondComponent == null) {
            return null;
        }
        int firstDepth = MoveChildComponentChange._computeDepth(firstComponent);
        int secondDepth = MoveChildComponentChange._computeDepth(secondComponent);
        if (secondDepth > firstDepth) {
            secondComponent = MoveChildComponentChange._getAncestor(secondComponent, secondDepth - firstDepth);
        } else if (secondDepth < firstDepth) {
            firstComponent = MoveChildComponentChange._getAncestor(firstComponent, firstDepth - secondDepth);
        }
        while (firstComponent != null && firstComponent != secondComponent) {
            firstComponent = firstComponent.getParent();
            secondComponent = secondComponent.getParent();
        }
        for (sharedRoot = firstComponent; sharedRoot != null && !(sharedRoot instanceof UIXComponent); sharedRoot = sharedRoot.getParent()) {
        }
        return sharedRoot;
    }

    public String getSourceScopedId() {
        return this._sourceAbsoluteScopedId;
    }

    public String getDestinationScopedId() {
        return this._destinationAbsoluteScopedId;
    }

    public String getSourceLogicalScopedId() {
        return this._sourceAbsoluteLogicalScopedId == null ? this._sourceAbsoluteScopedId : this._sourceAbsoluteLogicalScopedId;
    }

    public String getDestinationLogicalScopedId() {
        return this._destinationAbsoluteLogicalScopedId == null ? this._destinationAbsoluteScopedId : this._destinationAbsoluteLogicalScopedId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MoveChildComponentChange)) {
            return false;
        }
        MoveChildComponentChange other = (MoveChildComponentChange)o;
        return this.getSourceLogicalScopedId().equals(other.getSourceLogicalScopedId()) && this.getDestinationLogicalScopedId().equals(other.getDestinationLogicalScopedId()) && this._equalsOrNull(this._insertBeforeId, other._insertBeforeId);
    }

    public int hashCode() {
        int hashCode = this.getSourceLogicalScopedId().hashCode() + 37 * this.getDestinationLogicalScopedId().hashCode();
        if (this._insertBeforeId != null) {
            hashCode += 1369 * this._insertBeforeId.hashCode();
        }
        return hashCode;
    }

    public String toString() {
        return super.toString() + "[logical_source=" + this.getSourceLogicalScopedId() + " logical_destination=" + this.getDestinationLogicalScopedId() + " absolute source=" + this.getSourceScopedId() + " absolute destination" + this.getDestinationScopedId() + " insert_before=" + this._insertBeforeId + "]";
    }

    private boolean _equalsOrNull(Object obj1, Object obj2) {
        return obj1 == null ? obj2 == null : obj1.equals(obj2);
    }

    private static int _computeDepth(UIComponent comp) {
        int i = 0;
        while ((comp = comp.getParent()) != null) {
            ++i;
        }
        return i;
    }

    private static UIComponent _getAncestor(UIComponent component, int level) {
        assert (level >= 0);
        while (level > 0) {
            component = component.getParent();
            --level;
        }
        return component;
    }
}

