import { IAsyncRunnable } from "./AsyncRunnable";
/**
 * A simple XHR queue controller
 * following the async op -> next pattern
 * Faces enforces for the XHR handling
 */
export declare class XhrQueueController<T extends IAsyncRunnable<any>> {
    queue: any[];
    taskRunning: boolean;
    constructor();
    /**
     * executes or enqueues an element
     * @param runnable the runnable (request) to be enqueued
     * @param timeOut timeout if > 0 which defers the execution
     * until the debounce window for the timeout is closed.
     */
    enqueue(runnable: T, timeOut?: number): void;
    /**
     * trigger the next element in the queue
     * to be started!
     */
    next(): void;
    /**
     * clears and resets the queue
     */
    clear(): void;
    /**
     * true if queue is empty
     */
    get isEmpty(): boolean;
    /**
     * Enriches the incoming async asyncRunnable
     * with the error and next handling
     * (aka: asyncRunnable is done -> next
     *                   error -> clear queue
     * @param asyncRunnable the async runnable which needs enrichment
     * @private
     */
    private enrichRunnable;
    /**
     * alerts the queue that a task is running
     *
     * @private
     */
    private signalTaskRunning;
    /**
     * updates the task running status according to the current queue
     * @private
     */
    private updateTaskRunning;
}
