/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.manifest;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.bundle.BundleDetails;
import org.apache.nifi.c2.protocol.component.api.BuildInfo;
import org.apache.nifi.c2.protocol.component.api.RuntimeManifest;
import org.apache.nifi.extension.manifest.ExtensionManifest;
import org.apache.nifi.extension.manifest.parser.ExtensionManifestParser;
import org.apache.nifi.manifest.RuntimeManifestService;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.NarClassLoadersHolder;
import org.apache.nifi.runtime.manifest.ExtensionManifestContainer;
import org.apache.nifi.runtime.manifest.RuntimeManifestBuilder;
import org.apache.nifi.runtime.manifest.impl.SchedulingDefaultsFactory;
import org.apache.nifi.runtime.manifest.impl.StandardRuntimeManifestBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardRuntimeManifestService
implements RuntimeManifestService {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardRuntimeManifestService.class);
    private static final String RUNTIME_MANIFEST_IDENTIFIER = "nifi";
    private static final String RUNTIME_TYPE = "nifi";
    private final ExtensionManager extensionManager;
    private final ExtensionManifestParser extensionManifestParser;
    private final String runtimeManifestIdentifier;
    private final String runtimeType;

    public StandardRuntimeManifestService(ExtensionManager extensionManager, ExtensionManifestParser extensionManifestParser, String runtimeManifestIdentifier, String runtimeType) {
        this.extensionManager = extensionManager;
        this.extensionManifestParser = extensionManifestParser;
        this.runtimeManifestIdentifier = runtimeManifestIdentifier;
        this.runtimeType = runtimeType;
    }

    public StandardRuntimeManifestService(ExtensionManager extensionManager, ExtensionManifestParser extensionManifestParser) {
        this(extensionManager, extensionManifestParser, "nifi", "nifi");
    }

    public RuntimeManifest getManifest() {
        Set allBundles = this.extensionManager.getAllBundles();
        Bundle frameworkBundle = this.getFrameworkBundle();
        BundleDetails frameworkDetails = frameworkBundle.getBundleDetails();
        Date frameworkBuildDate = frameworkDetails.getBuildTimestampDate();
        BuildInfo buildInfo = new BuildInfo();
        buildInfo.setVersion(frameworkDetails.getCoordinate().getVersion());
        buildInfo.setRevision(frameworkDetails.getBuildRevision());
        buildInfo.setCompiler(frameworkDetails.getBuildJdk());
        buildInfo.setTimestamp(frameworkBuildDate == null ? null : Long.valueOf(frameworkBuildDate.getTime()));
        RuntimeManifestBuilder manifestBuilder = new StandardRuntimeManifestBuilder().identifier(this.runtimeManifestIdentifier).runtimeType(this.runtimeType).version(buildInfo.getVersion()).schedulingDefaults(SchedulingDefaultsFactory.getNifiSchedulingDefaults()).buildInfo(buildInfo);
        for (Bundle bundle : allBundles) {
            this.getExtensionManifest(bundle).ifPresent(arg_0 -> ((RuntimeManifestBuilder)manifestBuilder).addBundle(arg_0));
        }
        return manifestBuilder.build();
    }

    private Optional<ExtensionManifestContainer> getExtensionManifest(Bundle bundle) {
        BundleDetails bundleDetails = bundle.getBundleDetails();
        try {
            ExtensionManifest extensionManifest = this.loadExtensionManifest(bundleDetails);
            Map<String, String> additionalDetails = this.loadAdditionalDetails(bundleDetails);
            ExtensionManifestContainer container = new ExtensionManifestContainer(extensionManifest, additionalDetails);
            return Optional.of(container);
        }
        catch (IOException e) {
            LOGGER.error("Unable to load extension manifest for bundle [{}]", (Object)bundleDetails.getCoordinate(), (Object)e);
            return Optional.empty();
        }
    }

    private ExtensionManifest loadExtensionManifest(BundleDetails bundleDetails) throws IOException {
        File manifestFile = new File(bundleDetails.getWorkingDirectory(), "META-INF/docs/extension-manifest.xml");
        if (!manifestFile.exists()) {
            throw new FileNotFoundException("Extension manifest files does not exist for " + bundleDetails.getCoordinate() + " at " + manifestFile.getAbsolutePath());
        }
        try (FileInputStream inputStream = new FileInputStream(manifestFile);){
            ExtensionManifest extensionManifest = this.extensionManifestParser.parse((InputStream)inputStream);
            extensionManifest.setGroupId(bundleDetails.getCoordinate().getGroup());
            extensionManifest.setArtifactId(bundleDetails.getCoordinate().getId());
            extensionManifest.setVersion(bundleDetails.getCoordinate().getVersion());
            ExtensionManifest extensionManifest2 = extensionManifest;
            return extensionManifest2;
        }
    }

    private Map<String, String> loadAdditionalDetails(BundleDetails bundleDetails) {
        LinkedHashMap<String, String> additionalDetailsMap = new LinkedHashMap<String, String>();
        File additionalDetailsDir = new File(bundleDetails.getWorkingDirectory(), "META-INF/docs/additional-details");
        if (!additionalDetailsDir.exists()) {
            LOGGER.debug("No additional-details directory found under [{}]", (Object)bundleDetails.getWorkingDirectory().getAbsolutePath());
            return additionalDetailsMap;
        }
        for (File additionalDetailsTypeDir : additionalDetailsDir.listFiles()) {
            if (!additionalDetailsTypeDir.isDirectory()) {
                LOGGER.debug("Skipping [{}], not a directory...", (Object)additionalDetailsTypeDir.getAbsolutePath());
                continue;
            }
            File additionalDetailsFile = new File(additionalDetailsTypeDir, "additionalDetails.html");
            if (!additionalDetailsFile.exists()) {
                LOGGER.debug("No additionalDetails.html found under [{}]", (Object)additionalDetailsTypeDir.getAbsolutePath());
                continue;
            }
            try (Stream<String> additionalDetailsLines = Files.lines(additionalDetailsFile.toPath());){
                String typeName = additionalDetailsTypeDir.getName();
                String additionalDetailsContent = additionalDetailsLines.collect(Collectors.joining());
                LOGGER.debug("Added additionalDetails for {} from {}", (Object)typeName, (Object)additionalDetailsFile.getAbsolutePath());
                additionalDetailsMap.put(typeName, additionalDetailsContent);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to load additional details content for " + additionalDetailsFile.getAbsolutePath() + " due to: " + e.getMessage(), e);
            }
        }
        return additionalDetailsMap;
    }

    Bundle getFrameworkBundle() {
        return NarClassLoadersHolder.getInstance().getFrameworkBundle();
    }
}

