/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.wal.seq;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.MemorySerializer;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.vm.MemoryFCRImpl;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryCMARW;
import io.questdb.cairo.wal.seq.TableMetadataChange;
import io.questdb.cairo.wal.seq.TableMetadataChangeLog;
import io.questdb.cairo.wal.seq.TransactionLogCursor;
import io.questdb.griffin.engine.ops.AlterOperation;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.Unsafe;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;

public class TableTransactionLog
implements Closeable {
    public static final int HEADER_RESERVED = 64;
    public static final long MAX_TXN_OFFSET = 4L;
    public static final long HEADER_SIZE = 76L;
    public static final int STRUCTURAL_CHANGE_WAL_ID = -1;
    private static final Log LOG = LogFactory.getLog(TableTransactionLog.class);
    private static final long TX_LOG_STRUCTURE_VERSION_OFFSET = 0L;
    private static final long TX_LOG_WAL_ID_OFFSET = 8L;
    private static final long TX_LOG_SEGMENT_OFFSET = 12L;
    private static final long TX_LOG_SEGMENT_TXN_OFFSET = 16L;
    private static final long TX_LOG_COMMIT_TIMESTAMP_OFFSET = 20L;
    public static final long RECORD_SIZE = 28L;
    private static final ThreadLocal<AlterOperation> tlAlterOperation = new ThreadLocal();
    private static final ThreadLocal<TableMetadataChangeLogImpl> tlStructChangeCursor = new ThreadLocal();
    private static final ThreadLocal<TransactionLogCursorImpl> tlTransactionLogCursor = new ThreadLocal();
    private final FilesFacade ff;
    private final AtomicLong maxTxn = new AtomicLong();
    private final StringSink rootPath = new StringSink();
    private final MemoryCMARW txnMem = Vm.getCMARWInstance();
    private final MemoryCMARW txnMetaMem = Vm.getCMARWInstance();
    private final MemoryCMARW txnMetaMemIndex = Vm.getCMARWInstance();

    TableTransactionLog(FilesFacade ff) {
        this.ff = ff;
    }

    @Override
    public void close() {
        if (this.txnMem.isOpen()) {
            long maxTxnInFile = this.txnMem.getLong(4L);
            assert (maxTxnInFile == this.maxTxn.get()) : "Max txn in the file " + maxTxnInFile + " but in memory is " + this.maxTxn.get();
            this.txnMem.close(false);
            this.txnMetaMem.close(false);
            this.txnMetaMemIndex.close(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int openFileRO(FilesFacade ff, Path path, String fileName) {
        int rootLen = path.length();
        path.concat(fileName).$();
        try {
            int n = TableUtils.openRO(ff, path, LOG);
            return n;
        }
        finally {
            path.trimTo(rootLen);
        }
    }

    private void syncDiskWrites() {
        this.txnMetaMemIndex.sync(false);
        this.txnMetaMem.sync(false);
        this.txnMem.sync(false);
    }

    @NotNull
    static TableMetadataChangeLog getTableMetadataChangeLog() {
        TableMetadataChangeLogImpl instance = tlStructChangeCursor.get();
        if (instance == null) {
            instance = new TableMetadataChangeLogImpl();
            tlStructChangeCursor.set(instance);
        }
        return instance;
    }

    long addEntry(long structureVersion, int walId, int segmentId, int segmentTxn, long timestamp) {
        this.txnMem.putLong(structureVersion);
        this.txnMem.putInt(walId);
        this.txnMem.putInt(segmentId);
        this.txnMem.putInt(segmentTxn);
        this.txnMem.putLong(timestamp);
        Unsafe.getUnsafe().storeFence();
        long maxTxn = this.maxTxn.incrementAndGet();
        this.txnMem.putLong(4L, maxTxn);
        return maxTxn;
    }

    void beginMetadataChangeEntry(long newStructureVersion, MemorySerializer serializer, Object instance, long timestamp) {
        assert (newStructureVersion == this.txnMetaMemIndex.getAppendOffset() / 8L);
        this.txnMem.putLong(newStructureVersion);
        this.txnMem.putInt(-1);
        this.txnMem.putInt(-1);
        this.txnMem.putInt(-1);
        this.txnMem.putLong(timestamp);
        this.txnMetaMem.putInt(0);
        long varMemBegin = this.txnMetaMem.getAppendOffset();
        serializer.toSink(instance, this.txnMetaMem);
        int len = (int)(this.txnMetaMem.getAppendOffset() - varMemBegin);
        this.txnMetaMem.putInt(varMemBegin - 4L, len);
        this.txnMetaMemIndex.putLong(varMemBegin + (long)len);
    }

    long endMetadataChangeEntry() {
        this.syncDiskWrites();
        Unsafe.getUnsafe().storeFence();
        long nextTxn = this.maxTxn.incrementAndGet();
        this.txnMem.putLong(4L, nextTxn);
        return nextTxn;
    }

    TransactionLogCursor getCursor(long txnLo) {
        Path path = Path.PATH.get().of(this.rootPath);
        TransactionLogCursorImpl cursor = tlTransactionLogCursor.get();
        if (cursor == null) {
            cursor = new TransactionLogCursorImpl(this.ff, txnLo, path);
            tlTransactionLogCursor.set(cursor);
            return cursor;
        }
        return cursor.of(this.ff, txnLo, path);
    }

    @NotNull
    TableMetadataChangeLog getTableMetadataChangeLog(TableToken tableToken, long structureVersionLo, MemorySerializer serializer) {
        TableMetadataChangeLogImpl cursor = (TableMetadataChangeLogImpl)TableTransactionLog.getTableMetadataChangeLog();
        cursor.of(this.ff, tableToken, structureVersionLo, serializer, Path.getThreadLocal(this.rootPath));
        return cursor;
    }

    long lastTxn() {
        return this.maxTxn.get();
    }

    void open(Path path) {
        this.rootPath.clear();
        path.toSink(this.rootPath);
        int pathLength = path.length();
        TableUtils.openSmallFile(this.ff, path, pathLength, this.txnMem, "_txnlog", 53);
        TableUtils.openSmallFile(this.ff, path, pathLength, this.txnMetaMem, "_txnlog.meta.d", 53);
        TableUtils.openSmallFile(this.ff, path, pathLength, this.txnMetaMemIndex, "_txnlog.meta.i", 53);
        long lastTxn = this.txnMem.getLong(4L);
        this.maxTxn.set(lastTxn);
        if (lastTxn == 0L) {
            this.txnMem.jumpTo(0L);
            this.txnMem.putInt(0);
            this.txnMem.putLong(0L);
            this.txnMem.putLong(0L);
            this.txnMem.jumpTo(76L);
            this.txnMetaMemIndex.jumpTo(0L);
            this.txnMetaMemIndex.putLong(0L);
            this.txnMetaMem.jumpTo(0L);
        } else {
            long maxStructureVersion = this.txnMem.getLong(76L + (lastTxn - 1L) * 28L + 0L);
            this.txnMem.jumpTo(76L + lastTxn * 28L);
            long structureAppendOffset = maxStructureVersion * 8L;
            long txnMetaMemSize = this.txnMetaMemIndex.getLong(structureAppendOffset);
            this.txnMetaMemIndex.jumpTo(structureAppendOffset + 8L);
            this.txnMetaMem.jumpTo(txnMetaMemSize);
        }
    }

    AlterOperation readTableMetadataChangeLog(long structureVersion, MemorySerializer serializer) {
        long txnMetaOffset = this.txnMetaMemIndex.getLong(structureVersion * 8L);
        int recordSize = this.txnMetaMem.getInt(txnMetaOffset);
        if (recordSize < 0 || (long)recordSize > Files.PAGE_SIZE) {
            throw CairoException.critical(0).put("invalid sequencer txn metadata [offset=").put(txnMetaOffset).put(", recordSize=").put(recordSize).put(']');
        }
        txnMetaOffset += 4L;
        AlterOperation alterToDeserializeTo = tlAlterOperation.get();
        if (alterToDeserializeTo == null) {
            alterToDeserializeTo = new AlterOperation();
            tlAlterOperation.set(alterToDeserializeTo);
        }
        serializer.fromSink(alterToDeserializeTo, this.txnMetaMem, txnMetaOffset, txnMetaOffset + (long)recordSize);
        this.txnMetaMem.jumpTo(txnMetaOffset + (long)recordSize);
        return alterToDeserializeTo;
    }

    private static class TransactionLogCursorImpl
    implements TransactionLogCursor {
        private long address;
        private int fd;
        private FilesFacade ff;
        private long txn;
        private long txnCount;
        private long txnOffset;

        public TransactionLogCursorImpl(FilesFacade ff, long txnLo, Path path) {
            this.of(ff, txnLo, path);
        }

        @Override
        public void close() {
            this.ff.close(this.fd);
            this.ff.munmap(this.address, this.getMappedLen(), 52);
        }

        @Override
        public long getCommitTimestamp() {
            return Unsafe.getUnsafe().getLong(this.address + this.txnOffset + 20L);
        }

        @Override
        public int getSegmentId() {
            return Unsafe.getUnsafe().getInt(this.address + this.txnOffset + 12L);
        }

        @Override
        public long getSegmentTxn() {
            return Unsafe.getUnsafe().getInt(this.address + this.txnOffset + 16L);
        }

        @Override
        public long getStructureVersion() {
            return Unsafe.getUnsafe().getLong(this.address + this.txnOffset + 0L);
        }

        @Override
        public long getTxn() {
            return this.txn;
        }

        @Override
        public int getWalId() {
            return Unsafe.getUnsafe().getInt(this.address + this.txnOffset + 8L);
        }

        @Override
        public boolean hasNext() {
            if (this.hasNext(this.getMappedLen())) {
                return true;
            }
            long newTxnCount = this.ff.readNonNegativeLong(this.fd, 4L);
            if (newTxnCount > this.txnCount) {
                long oldSize = this.getMappedLen();
                this.txnCount = newTxnCount;
                long newSize = this.getMappedLen();
                this.address = this.ff.mremap(this.fd, this.address, oldSize, newSize, 0L, 1, 52);
                return this.hasNext(newSize);
            }
            return false;
        }

        private long getMappedLen() {
            return this.txnCount * 28L + 76L;
        }

        private boolean hasNext(long mappedLen) {
            if (this.txnOffset + 56L <= mappedLen) {
                this.txnOffset += 28L;
                ++this.txn;
                return true;
            }
            return false;
        }

        @NotNull
        private TransactionLogCursorImpl of(FilesFacade ff, long txnLo, Path path) {
            this.ff = ff;
            this.fd = TableTransactionLog.openFileRO(ff, path, "_txnlog");
            this.txnCount = ff.readNonNegativeLong(this.fd, 4L);
            if (this.txnCount > -1L) {
                this.address = ff.mmap(this.fd, this.getMappedLen(), 0L, 1, 52);
                this.txnOffset = 76L + (txnLo - 1L) * 28L;
            }
            this.txn = txnLo;
            return this;
        }
    }

    private static class TableMetadataChangeLogImpl
    implements TableMetadataChangeLog {
        private final AlterOperation alterOp = new AlterOperation();
        private final MemoryFCRImpl txnMetaMem = new MemoryFCRImpl();
        private FilesFacade ff;
        private MemorySerializer serializer;
        private TableToken tableToken;
        private long txnMetaAddress;
        private long txnMetaOffset;
        private long txnMetaOffsetHi;

        private TableMetadataChangeLogImpl() {
        }

        @Override
        public void close() {
            if (this.txnMetaAddress > 0L) {
                this.ff.munmap(this.txnMetaAddress, this.txnMetaOffsetHi, 52);
                this.txnMetaAddress = 0L;
            }
            this.txnMetaOffset = 0L;
            this.txnMetaOffsetHi = 0L;
        }

        @Override
        public TableToken getTableToken() {
            return this.tableToken;
        }

        @Override
        public boolean hasNext() {
            return this.txnMetaOffset < this.txnMetaOffsetHi;
        }

        @Override
        public TableMetadataChange next() {
            int recordSize = this.txnMetaMem.getInt(this.txnMetaOffset);
            if (recordSize < 0 || (long)recordSize > Files.PAGE_SIZE) {
                throw CairoException.critical(0).put("invalid sequencer txn metadata [offset=").put(this.txnMetaOffset).put(", recordSize=").put(recordSize).put(']');
            }
            this.txnMetaOffset += 4L;
            this.serializer.fromSink(this.alterOp, this.txnMetaMem, this.txnMetaOffset, this.txnMetaOffset + (long)recordSize);
            this.txnMetaOffset += (long)recordSize;
            return this.alterOp;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void of(FilesFacade ff, TableToken tableToken, long structureVersionLo, MemorySerializer serializer, Path path) {
            this.tableToken = tableToken;
            this.close();
            this.ff = ff;
            this.serializer = serializer;
            int txnFd = -1;
            int txnMetaFd = -1;
            int txnMetaIndexFd = -1;
            try {
                txnFd = TableTransactionLog.openFileRO(ff, path, "_txnlog");
                txnMetaFd = TableTransactionLog.openFileRO(ff, path, "_txnlog.meta.d");
                txnMetaIndexFd = TableTransactionLog.openFileRO(ff, path, "_txnlog.meta.i");
                long txnCount = ff.readNonNegativeLong(txnFd, 4L);
                if (txnCount <= -1L) throw CairoException.critical(0).put("expected to read table structure changes but there is no saved in the sequencer [structureVersionLo=").put(structureVersionLo).put(']');
                long maxStructureVersion = ff.readNonNegativeLong(txnFd, 76L + (txnCount - 1L) * 28L + 0L);
                if (maxStructureVersion > structureVersionLo) {
                    this.txnMetaOffset = ff.readNonNegativeLong(txnMetaIndexFd, structureVersionLo * 8L);
                    if (this.txnMetaOffset <= -1L) throw CairoException.critical(0).put("expected to read table structure changes but there is no saved in the sequencer [structureVersionLo=").put(structureVersionLo).put(']');
                    this.txnMetaOffsetHi = ff.readNonNegativeLong(txnMetaIndexFd, maxStructureVersion * 8L);
                    if (this.txnMetaOffsetHi <= this.txnMetaOffset) throw CairoException.critical(0).put("expected to read table structure changes but there is no saved in the sequencer [structureVersionLo=").put(structureVersionLo).put(']');
                    this.txnMetaAddress = ff.mmap(txnMetaFd, this.txnMetaOffsetHi, 0L, 1, 52);
                    if (this.txnMetaAddress < 0L) {
                        this.txnMetaAddress = 0L;
                        this.close();
                        throw CairoException.critical(0).put("expected to read table structure changes but there is no saved in the sequencer [structureVersionLo=").put(structureVersionLo).put(']');
                    }
                    this.txnMetaMem.of(this.txnMetaAddress, this.txnMetaOffsetHi);
                    return;
                }
                this.txnMetaOffsetHi = 0L;
                this.txnMetaOffset = 0L;
                throw CairoException.critical(0).put("expected to read table structure changes but there is no saved in the sequencer [structureVersionLo=").put(structureVersionLo).put(']');
            }
            finally {
                ff.close(txnFd);
                ff.close(txnMetaFd);
                ff.close(txnMetaIndexFd);
            }
        }
    }
}

