/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.service.alias;

import java.io.File;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.nifi.flow.VersionedFlowCoordinates;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.apache.nifi.registry.properties.NiFiRegistryProperties;
import org.apache.nifi.registry.provider.ProviderFactoryException;
import org.apache.nifi.registry.provider.StandardProviderFactory;
import org.apache.nifi.registry.url.aliaser.generated.Alias;
import org.apache.nifi.registry.url.aliaser.generated.Aliases;
import org.apache.nifi.xml.processing.ProcessingException;
import org.apache.nifi.xml.processing.stream.StandardXMLStreamReaderProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.xml.sax.SAXException;

@Service
public class RegistryUrlAliasService {
    private static final String ALIASES_XSD = "/aliases.xsd";
    private static final String JAXB_GENERATED_PATH = "org.apache.nifi.registry.url.aliaser.generated";
    private static final JAXBContext JAXB_CONTEXT = RegistryUrlAliasService.initializeJaxbContext();
    private final Map<String, String> aliases;

    private static JAXBContext initializeJaxbContext() {
        try {
            return JAXBContext.newInstance((String)JAXB_GENERATED_PATH, (ClassLoader)RegistryUrlAliasService.class.getClassLoader());
        }
        catch (JAXBException e) {
            throw new RuntimeException("Unable to create JAXBContext.", e);
        }
    }

    @Autowired
    public RegistryUrlAliasService(NiFiRegistryProperties niFiRegistryProperties) {
        this(RegistryUrlAliasService.createAliases(niFiRegistryProperties));
    }

    private static List<Alias> createAliases(NiFiRegistryProperties niFiRegistryProperties) {
        File configurationFile = niFiRegistryProperties.getRegistryAliasConfigurationFile();
        if (configurationFile.exists()) {
            try {
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema schema = schemaFactory.newSchema(StandardProviderFactory.class.getResource(ALIASES_XSD));
                Unmarshaller unmarshaller = JAXB_CONTEXT.createUnmarshaller();
                unmarshaller.setSchema(schema);
                StandardXMLStreamReaderProvider provider = new StandardXMLStreamReaderProvider();
                XMLStreamReader reader = provider.getStreamReader(new StreamSource(configurationFile));
                JAXBElement element = unmarshaller.unmarshal(reader, Aliases.class);
                return ((Aliases)element.getValue()).getAlias();
            }
            catch (JAXBException | ProcessingException | SAXException e) {
                throw new ProviderFactoryException("Unable to load the registry alias configuration file at: " + configurationFile.getAbsolutePath(), e);
            }
        }
        return Collections.emptyList();
    }

    protected RegistryUrlAliasService(List<Alias> aliases) {
        Pattern urlStart = Pattern.compile("^https?://");
        this.aliases = new LinkedHashMap<String, String>();
        for (Alias alias : aliases) {
            String internal = alias.getInternal();
            String external = alias.getExternal();
            if (!urlStart.matcher(external).find()) {
                throw new IllegalArgumentException("Expected " + external + " to start with http:// or https://");
            }
            if (this.aliases.put(internal, external) == null) continue;
            throw new IllegalArgumentException("Duplicate internal token " + internal);
        }
    }

    public void setExternal(VersionedProcessGroup processGroup) {
        processGroup.getProcessGroups().forEach(this::setExternal);
        VersionedFlowCoordinates coordinates = processGroup.getVersionedFlowCoordinates();
        if (coordinates != null) {
            coordinates.setRegistryUrl(this.getExternal(coordinates.getRegistryUrl()));
        }
    }

    public void setInternal(VersionedProcessGroup processGroup) {
        processGroup.getProcessGroups().forEach(this::setInternal);
        VersionedFlowCoordinates coordinates = processGroup.getVersionedFlowCoordinates();
        if (coordinates != null) {
            coordinates.setRegistryUrl(this.getInternal(coordinates.getRegistryUrl()));
        }
    }

    protected String getExternal(String url) {
        for (Map.Entry<String, String> alias : this.aliases.entrySet()) {
            String internal = alias.getKey();
            String external = alias.getValue();
            if (!url.startsWith(internal)) continue;
            int internalLength = internal.length();
            if (url.length() == internalLength) {
                return external;
            }
            return external + url.substring(internalLength);
        }
        return url;
    }

    protected String getInternal(String url) {
        for (Map.Entry<String, String> alias : this.aliases.entrySet()) {
            String internal = alias.getKey();
            String external = alias.getValue();
            if (!url.startsWith(external)) continue;
            int externalLength = external.length();
            if (url.length() == externalLength) {
                return internal;
            }
            return internal + url.substring(externalLength);
        }
        return url;
    }
}

