/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap.userdetails;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.naming.AuthenticationException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.ExtendedResponse;
import javax.naming.ldap.LdapContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogMessage;
import org.springframework.ldap.NameNotFoundException;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.ldap.core.AttributesMapperCallbackHandler;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.NameClassPairCallbackHandler;
import org.springframework.ldap.core.SearchExecutor;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.ldap.DefaultLdapUsernameToDnMapper;
import org.springframework.security.ldap.LdapUsernameToDnMapper;
import org.springframework.security.ldap.LdapUtils;
import org.springframework.security.ldap.userdetails.InetOrgPersonContextMapper;
import org.springframework.security.ldap.userdetails.UserDetailsContextMapper;
import org.springframework.security.provisioning.UserDetailsManager;
import org.springframework.util.Assert;

public class LdapUserDetailsManager
implements UserDetailsManager {
    private final Log logger = LogFactory.getLog(LdapUserDetailsManager.class);
    private SecurityContextHolderStrategy securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();
    LdapUsernameToDnMapper usernameMapper = new DefaultLdapUsernameToDnMapper("cn=users", "uid");
    private DistinguishedName groupSearchBase = new DistinguishedName("cn=groups");
    private String passwordAttributeName = "userPassword";
    private String groupRoleAttributeName = "cn";
    private String groupMemberAttributeName = "uniquemember";
    private final String rolePrefix = "ROLE_";
    private String groupSearchFilter = "(uniquemember={0})";
    private UserDetailsContextMapper userDetailsMapper = new InetOrgPersonContextMapper();
    private final LdapTemplate template;
    private AttributesMapper roleMapper = attributes -> {
        Attribute roleAttr = attributes.get(this.groupRoleAttributeName);
        NamingEnumeration<?> ne = roleAttr.getAll();
        Object group = ne.next();
        String role = group.toString();
        return new SimpleGrantedAuthority(this.rolePrefix + role.toUpperCase());
    };
    private String[] attributesToRetrieve;
    private boolean usePasswordModifyExtensionOperation = false;

    public LdapUserDetailsManager(ContextSource contextSource) {
        this.template = new LdapTemplate(contextSource);
    }

    public UserDetails loadUserByUsername(String username) {
        DistinguishedName dn = this.usernameMapper.buildDn(username);
        List<GrantedAuthority> authorities = this.getUserAuthorities(dn, username);
        this.logger.debug((Object)LogMessage.format((String)"Loading user '%s' with DN '%s'", (Object)username, (Object)dn));
        DirContextAdapter userCtx = this.loadUserAsContext(dn, username);
        return this.userDetailsMapper.mapUserFromContext((DirContextOperations)userCtx, username, authorities);
    }

    private DirContextAdapter loadUserAsContext(DistinguishedName dn, String username) {
        return (DirContextAdapter)this.template.executeReadOnly(ctx -> {
            try {
                Attributes attrs = ctx.getAttributes((Name)dn, this.attributesToRetrieve);
                return new DirContextAdapter(attrs, (Name)LdapUtils.getFullDn(dn, ctx));
            }
            catch (javax.naming.NameNotFoundException ex) {
                throw new UsernameNotFoundException("User " + username + " not found", (Throwable)ex);
            }
        });
    }

    public void changePassword(String oldPassword, String newPassword) {
        Authentication authentication = this.securityContextHolderStrategy.getContext().getAuthentication();
        Assert.notNull((Object)authentication, (String)"No authentication object found in security context. Can't change current user's password!");
        String username = authentication.getName();
        this.logger.debug((Object)LogMessage.format((String)"Changing password for user '%s'", (Object)username));
        DistinguishedName userDn = this.usernameMapper.buildDn(username);
        if (this.usePasswordModifyExtensionOperation) {
            this.changePasswordUsingExtensionOperation(userDn, oldPassword, newPassword);
        } else {
            this.changePasswordUsingAttributeModification(userDn, oldPassword, newPassword);
        }
    }

    List<GrantedAuthority> getUserAuthorities(DistinguishedName dn, String username) {
        SearchExecutor se = ctx -> {
            DistinguishedName fullDn = LdapUtils.getFullDn(dn, ctx);
            SearchControls ctrls = new SearchControls();
            ctrls.setReturningAttributes(new String[]{this.groupRoleAttributeName});
            return ctx.search((Name)this.groupSearchBase, this.groupSearchFilter, (Object[])new String[]{fullDn.toUrl(), username}, ctrls);
        };
        AttributesMapperCallbackHandler roleCollector = new AttributesMapperCallbackHandler(this.roleMapper);
        this.template.search(se, (NameClassPairCallbackHandler)roleCollector);
        return roleCollector.getList();
    }

    public void createUser(UserDetails user) {
        DirContextAdapter ctx = new DirContextAdapter();
        this.copyToContext(user, ctx);
        DistinguishedName dn = this.usernameMapper.buildDn(user.getUsername());
        this.logger.debug((Object)LogMessage.format((String)"Creating new user '%s' with DN '%s'", (Object)user.getUsername(), (Object)dn));
        this.template.bind((Name)dn, (Object)ctx, null);
        List<GrantedAuthority> authorities = this.getUserAuthorities(dn, user.getUsername());
        if (authorities.size() > 0) {
            this.removeAuthorities(dn, authorities);
        }
        this.addAuthorities(dn, user.getAuthorities());
    }

    public void updateUser(UserDetails user) {
        DistinguishedName dn = this.usernameMapper.buildDn(user.getUsername());
        this.logger.debug((Object)LogMessage.format((String)"Updating new user '%s' with DN '%s'", (Object)user.getUsername(), (Object)dn));
        List<GrantedAuthority> authorities = this.getUserAuthorities(dn, user.getUsername());
        DirContextAdapter ctx = this.loadUserAsContext(dn, user.getUsername());
        ctx.setUpdateMode(true);
        this.copyToContext(user, ctx);
        LinkedList<ModificationItem> mods = new LinkedList<ModificationItem>(Arrays.asList(ctx.getModificationItems()));
        ListIterator modIt = mods.listIterator();
        while (modIt.hasNext()) {
            ModificationItem mod = (ModificationItem)modIt.next();
            Attribute a = mod.getAttribute();
            if (!"objectclass".equalsIgnoreCase(a.getID())) continue;
            modIt.remove();
        }
        this.template.modifyAttributes((Name)dn, mods.toArray(new ModificationItem[0]));
        this.removeAuthorities(dn, authorities);
        this.addAuthorities(dn, user.getAuthorities());
    }

    public void deleteUser(String username) {
        DistinguishedName dn = this.usernameMapper.buildDn(username);
        this.removeAuthorities(dn, this.getUserAuthorities(dn, username));
        this.template.unbind((Name)dn);
    }

    public boolean userExists(String username) {
        DistinguishedName dn = this.usernameMapper.buildDn(username);
        try {
            Object obj = this.template.lookup((Name)dn);
            if (obj instanceof Context) {
                LdapUtils.closeContext((Context)obj);
            }
            return true;
        }
        catch (NameNotFoundException ex) {
            return false;
        }
    }

    protected DistinguishedName buildGroupDn(String group) {
        DistinguishedName dn = new DistinguishedName((Name)this.groupSearchBase);
        dn.add(this.groupRoleAttributeName, group.toLowerCase());
        return dn;
    }

    protected void copyToContext(UserDetails user, DirContextAdapter ctx) {
        this.userDetailsMapper.mapUserToContext(user, ctx);
    }

    protected void addAuthorities(DistinguishedName userDn, Collection<? extends GrantedAuthority> authorities) {
        this.modifyAuthorities(userDn, authorities, 1);
    }

    protected void removeAuthorities(DistinguishedName userDn, Collection<? extends GrantedAuthority> authorities) {
        this.modifyAuthorities(userDn, authorities, 3);
    }

    private void modifyAuthorities(DistinguishedName userDn, Collection<? extends GrantedAuthority> authorities, int modType) {
        this.template.executeReadWrite(ctx -> {
            for (GrantedAuthority authority : authorities) {
                String group = this.convertAuthorityToGroup(authority);
                DistinguishedName fullDn = LdapUtils.getFullDn(userDn, ctx);
                ModificationItem addGroup = new ModificationItem(modType, new BasicAttribute(this.groupMemberAttributeName, fullDn.toUrl()));
                ctx.modifyAttributes((Name)this.buildGroupDn(group), new ModificationItem[]{addGroup});
            }
            return null;
        });
    }

    private String convertAuthorityToGroup(GrantedAuthority authority) {
        String group = authority.getAuthority();
        if (group.startsWith(this.rolePrefix)) {
            group = group.substring(this.rolePrefix.length());
        }
        return group;
    }

    public void setUsernameMapper(LdapUsernameToDnMapper usernameMapper) {
        this.usernameMapper = usernameMapper;
    }

    public void setPasswordAttributeName(String passwordAttributeName) {
        this.passwordAttributeName = passwordAttributeName;
    }

    public void setGroupSearchBase(String groupSearchBase) {
        this.groupSearchBase = new DistinguishedName(groupSearchBase);
    }

    public void setGroupRoleAttributeName(String groupRoleAttributeName) {
        this.groupRoleAttributeName = groupRoleAttributeName;
    }

    public void setAttributesToRetrieve(String[] attributesToRetrieve) {
        Assert.notNull((Object)attributesToRetrieve, (String)"attributesToRetrieve cannot be null");
        this.attributesToRetrieve = attributesToRetrieve;
    }

    public void setUserDetailsMapper(UserDetailsContextMapper userDetailsMapper) {
        this.userDetailsMapper = userDetailsMapper;
    }

    public void setGroupMemberAttributeName(String groupMemberAttributeName) {
        Assert.hasText((String)groupMemberAttributeName, (String)"groupMemberAttributeName should have text");
        this.groupMemberAttributeName = groupMemberAttributeName;
        this.groupSearchFilter = "(" + groupMemberAttributeName + "={0})";
    }

    public void setRoleMapper(AttributesMapper roleMapper) {
        this.roleMapper = roleMapper;
    }

    public void setUsePasswordModifyExtensionOperation(boolean usePasswordModifyExtensionOperation) {
        this.usePasswordModifyExtensionOperation = usePasswordModifyExtensionOperation;
    }

    public void setSecurityContextHolderStrategy(SecurityContextHolderStrategy securityContextHolderStrategy) {
        Assert.notNull((Object)securityContextHolderStrategy, (String)"securityContextHolderStrategy cannot be null");
        this.securityContextHolderStrategy = securityContextHolderStrategy;
    }

    private void changePasswordUsingAttributeModification(DistinguishedName userDn, String oldPassword, String newPassword) {
        ModificationItem[] passwordChange = new ModificationItem[]{new ModificationItem(2, new BasicAttribute(this.passwordAttributeName, newPassword))};
        if (oldPassword == null) {
            this.template.modifyAttributes((Name)userDn, passwordChange);
            return;
        }
        this.template.executeReadWrite(dirCtx -> {
            LdapContext ctx = (LdapContext)dirCtx;
            ctx.removeFromEnvironment("com.sun.jndi.ldap.connect.pool");
            ctx.addToEnvironment("java.naming.security.principal", LdapUtils.getFullDn(userDn, ctx).toString());
            ctx.addToEnvironment("java.naming.security.credentials", oldPassword);
            try {
                ctx.reconnect(null);
            }
            catch (AuthenticationException ex) {
                throw new BadCredentialsException("Authentication for password change failed.");
            }
            ctx.modifyAttributes((Name)userDn, passwordChange);
            return null;
        });
    }

    private void changePasswordUsingExtensionOperation(DistinguishedName userDn, String oldPassword, String newPassword) {
        this.template.executeReadWrite(dirCtx -> {
            LdapContext ctx = (LdapContext)dirCtx;
            String userIdentity = LdapUtils.getFullDn(userDn, ctx).encode();
            PasswordModifyRequest request = new PasswordModifyRequest(userIdentity, oldPassword, newPassword);
            try {
                return ctx.extendedOperation(request);
            }
            catch (AuthenticationException ex) {
                throw new BadCredentialsException("Authentication for password change failed.");
            }
        });
    }

    private static class PasswordModifyRequest
    implements ExtendedRequest {
        private static final byte SEQUENCE_TYPE = 48;
        private static final String PASSWORD_MODIFY_OID = "1.3.6.1.4.1.4203.1.11.1";
        private static final byte USER_IDENTITY_OCTET_TYPE = -128;
        private static final byte OLD_PASSWORD_OCTET_TYPE = -127;
        private static final byte NEW_PASSWORD_OCTET_TYPE = -126;
        private final ByteArrayOutputStream value = new ByteArrayOutputStream();

        PasswordModifyRequest(String userIdentity, String oldPassword, String newPassword) {
            ByteArrayOutputStream elements = new ByteArrayOutputStream();
            if (userIdentity != null) {
                this.berEncode((byte)-128, userIdentity.getBytes(), elements);
            }
            if (oldPassword != null) {
                this.berEncode((byte)-127, oldPassword.getBytes(), elements);
            }
            if (newPassword != null) {
                this.berEncode((byte)-126, newPassword.getBytes(), elements);
            }
            this.berEncode((byte)48, elements.toByteArray(), this.value);
        }

        @Override
        public String getID() {
            return PASSWORD_MODIFY_OID;
        }

        @Override
        public byte[] getEncodedValue() {
            return this.value.toByteArray();
        }

        @Override
        public ExtendedResponse createExtendedResponse(String id, byte[] berValue, int offset, int length) {
            return null;
        }

        private void berEncode(byte type, byte[] src, ByteArrayOutputStream dest) {
            int length = src.length;
            dest.write(type);
            if (length < 128) {
                dest.write(length);
            } else if ((length & 0xFF) == length) {
                dest.write(-127);
                dest.write((byte)(length & 0xFF));
            } else if ((length & 0xFFFF) == length) {
                dest.write(-126);
                dest.write((byte)(length >> 8 & 0xFF));
                dest.write((byte)(length & 0xFF));
            } else if ((length & 0xFFFFFF) == length) {
                dest.write(-125);
                dest.write((byte)(length >> 16 & 0xFF));
                dest.write((byte)(length >> 8 & 0xFF));
                dest.write((byte)(length & 0xFF));
            } else {
                dest.write(-124);
                dest.write((byte)(length >> 24 & 0xFF));
                dest.write((byte)(length >> 16 & 0xFF));
                dest.write((byte)(length >> 8 & 0xFF));
                dest.write((byte)(length & 0xFF));
            }
            try {
                dest.write(src);
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Failed to BER encode provided value of type: " + type);
            }
        }
    }
}

