/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.history.storage.questdb;

import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.nifi.controller.status.history.GarbageCollectionHistory;
import org.apache.nifi.controller.status.history.GarbageCollectionStatus;
import org.apache.nifi.controller.status.history.StandardGarbageCollectionHistory;
import org.apache.nifi.controller.status.history.StandardGarbageCollectionStatus;
import org.apache.nifi.controller.status.history.questdb.QuestDbContext;
import org.apache.nifi.controller.status.history.questdb.QuestDbEntityReadingTemplate;
import org.apache.nifi.controller.status.history.questdb.QuestDbEntityWritingTemplate;
import org.apache.nifi.controller.status.history.storage.GarbageCollectionStatusStorage;

public class QuestDbGarbageCollectionStatusStorage
implements GarbageCollectionStatusStorage {
    private static final String TABLE_NAME = "garbageCollectionStatus";
    private static final String QUERY = "SELECT * FROM garbageCollectionStatus WHERE capturedAt > to_timestamp('%s', 'yyyy-MM-dd:HH:mm:ss Z') AND capturedAt < to_timestamp('%s', 'yyyy-MM-dd:HH:mm:ss Z') ORDER BY capturedAt ASC";
    private static final QuestDbEntityWritingTemplate<GarbageCollectionStatus> WRITING_TEMPLATE = new QuestDbEntityWritingTemplate<GarbageCollectionStatus>("garbageCollectionStatus", (statusEntry, row) -> {
        row.putSym(1, (CharSequence)statusEntry.getMemoryManagerName());
        row.putLong(2, statusEntry.getCollectionCount());
        row.putLong(3, statusEntry.getCollectionMillis());
    });
    private static final QuestDbEntityReadingTemplate<GarbageCollectionStatus, GarbageCollectionHistory> READING_TEMPLATE = new QuestDbEntityReadingTemplate<GarbageCollectionStatus, GarbageCollectionHistory>("SELECT * FROM garbageCollectionStatus WHERE capturedAt > to_timestamp('%s', 'yyyy-MM-dd:HH:mm:ss Z') AND capturedAt < to_timestamp('%s', 'yyyy-MM-dd:HH:mm:ss Z') ORDER BY capturedAt ASC", record -> new StandardGarbageCollectionStatus(new StringBuilder(record.getSym(1)).toString(), new Date(record.getTimestamp(0)), record.getLong(2), record.getLong(3)), garbageCollectionStatuses -> {
        StandardGarbageCollectionHistory result = new StandardGarbageCollectionHistory();
        garbageCollectionStatuses.forEach(status -> result.addGarbageCollectionStatus((GarbageCollectionStatus)status));
        return result;
    }, e -> new StandardGarbageCollectionHistory());
    private final QuestDbContext context;

    public QuestDbGarbageCollectionStatusStorage(QuestDbContext context) {
        this.context = context;
    }

    @Override
    public GarbageCollectionHistory read(Instant start, Instant end) {
        return (GarbageCollectionHistory)READING_TEMPLATE.read(this.context.getEngine(), this.context.getSqlExecutionContext(), Arrays.asList(DATE_FORMATTER.format(start), DATE_FORMATTER.format(end)));
    }

    @Override
    public void store(List<Pair<Instant, GarbageCollectionStatus>> statusEntries) {
        WRITING_TEMPLATE.insert(this.context.getEngine(), this.context.getSqlExecutionContext(), statusEntries);
    }
}

