/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.params;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.parameter.ParameterSensitivity;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ParamProviderClient;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.nifi.ParamProviderResult;
import org.apache.nifi.toolkit.cli.impl.util.JacksonUtils;
import org.apache.nifi.web.api.entity.ParameterProviderApplyParametersRequestEntity;
import org.apache.nifi.web.api.entity.ParameterProviderEntity;
import org.apache.nifi.web.api.entity.ParameterProviderParameterApplicationEntity;
import org.apache.nifi.web.api.entity.ParameterProviderParameterFetchEntity;

public class FetchParams
extends AbstractNiFiCommand<ParamProviderResult> {
    public FetchParams() {
        super("fetch-params", ParamProviderResult.class);
    }

    @Override
    public String getDescription() {
        return "Fetches the parameters of a parameter provider.  If indicated, also applies the parameters to any referencing parameter contexts. When applying parameters, the --inputSource (-i) option specifies the location of a JSON file containing a parameterProviderParameterApplication entity, which allows detailed configuration of the applied groups and parameters.  For a simpler approach, this argument may be omitted, and all fetched groups will be mapped to parameter contexts of the same names, creating new parameter contexts if needed.  To select sensitive vs. non-sensitive parameters, the --sensitiveParamPattern (-spp) can be used.  If this is not supplied, all fetched parameters will default to sensitive.  Note that the --inputSource argument overrides any parameter sensitivity specified in the --sensitiveParamPattern argument.";
    }

    @Override
    protected void doInitialize(Context context) {
        super.doInitialize(context);
        this.addOption(CommandOption.PARAM_PROVIDER_ID.createOption());
        this.addOption(CommandOption.APPLY_PARAMETERS.createOption());
        this.addOption(CommandOption.INPUT_SOURCE.createOption());
        this.addOption(CommandOption.SENSITIVE_PARAM_PATTERN.createOption());
    }

    @Override
    public ParamProviderResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String paramProviderId = this.getRequiredArg(properties, CommandOption.PARAM_PROVIDER_ID);
        String sensitiveParamPattern = this.getArg(properties, CommandOption.SENSITIVE_PARAM_PATTERN);
        boolean apply = this.hasArg(properties, CommandOption.APPLY_PARAMETERS);
        String inputSource = this.getArg(properties, CommandOption.INPUT_SOURCE);
        ParameterProviderParameterApplicationEntity parameterApplicationEntity = null;
        if (inputSource != null) {
            String parameterApplicationJson = this.getInputSourceContent(inputSource);
            ObjectMapper objectMapper = JacksonUtils.getObjectMapper();
            parameterApplicationEntity = (ParameterProviderParameterApplicationEntity)objectMapper.readValue(parameterApplicationJson, ParameterProviderParameterApplicationEntity.class);
        }
        ParamProviderClient paramProviderClient = client.getParamProviderClient();
        ParameterProviderEntity existingParameterProvider = paramProviderClient.getParamProvider(paramProviderId);
        ParameterProviderParameterFetchEntity fetchEntity = new ParameterProviderParameterFetchEntity();
        fetchEntity.setRevision(existingParameterProvider.getRevision());
        fetchEntity.setId(existingParameterProvider.getId());
        ParameterProviderEntity fetchedParameterProvider = paramProviderClient.fetchParameters(fetchEntity);
        if (apply) {
            this.applyParametersAndWait(paramProviderClient, fetchedParameterProvider, parameterApplicationEntity, sensitiveParamPattern);
        }
        return new ParamProviderResult(this.getResultType(properties), fetchedParameterProvider);
    }

    private void applyParametersAndWait(ParamProviderClient paramProviderClient, ParameterProviderEntity fetchedParameterProvider, ParameterProviderParameterApplicationEntity inputApplicationEntity, String sensitiveParamPattern) throws NiFiClientException, IOException {
        ParameterProviderParameterApplicationEntity applicationEntity = inputApplicationEntity;
        if (applicationEntity == null) {
            applicationEntity = new ParameterProviderParameterApplicationEntity();
            applicationEntity.setRevision(fetchedParameterProvider.getRevision());
            applicationEntity.setParameterGroupConfigurations(fetchedParameterProvider.getComponent().getParameterGroupConfigurations());
            applicationEntity.getParameterGroupConfigurations().forEach(groupConfiguration -> {
                if (groupConfiguration.getParameterSensitivities() == null) {
                    groupConfiguration.setParameterSensitivities(new HashMap());
                }
                groupConfiguration.setSynchronized(Boolean.valueOf(true));
                Set paramNames = groupConfiguration.getParameterSensitivities().keySet();
                paramNames.forEach(paramName -> {
                    ParameterSensitivity sensitivity = ParameterSensitivity.SENSITIVE;
                    if (sensitiveParamPattern != null) {
                        sensitivity = paramName.matches(sensitiveParamPattern) ? ParameterSensitivity.SENSITIVE : ParameterSensitivity.NON_SENSITIVE;
                    }
                    groupConfiguration.getParameterSensitivities().put(paramName, sensitivity);
                });
            });
            applicationEntity.setId(fetchedParameterProvider.getId());
        }
        ParameterProviderApplyParametersRequestEntity request = paramProviderClient.applyParameters(applicationEntity);
        while (true) {
            String requestId;
            String providerId;
            ParameterProviderApplyParametersRequestEntity entity;
            if ((entity = paramProviderClient.getParamProviderApplyParametersRequest(providerId = fetchedParameterProvider.getId(), requestId = request.getRequest().getRequestId())).getRequest().isComplete()) {
                paramProviderClient.deleteParamProviderApplyParametersRequest(providerId, requestId);
                if (entity.getRequest().getFailureReason() == null) {
                    return;
                }
                throw new RuntimeException("Parameter Provider Application failed: " + entity.getRequest().getFailureReason());
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Parameter Application interrupted", e);
            }
        }
    }
}

