/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.properties;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.nifi.properties.AbstractHashiCorpVaultSensitivePropertyProvider;
import org.apache.nifi.properties.BootstrapProperties;
import org.apache.nifi.properties.ProtectedPropertyContext;
import org.apache.nifi.properties.SensitivePropertyProtectionException;

public class HashiCorpVaultTransitSensitivePropertyProvider
extends AbstractHashiCorpVaultSensitivePropertyProvider {
    private static final Charset PROPERTY_CHARSET = StandardCharsets.UTF_8;
    private static final String TRANSIT_PATH = "vault.transit.path";
    private static final String IDENTIFIER_KEY_FORMAT = "hashicorp/vault/transit/%s";

    HashiCorpVaultTransitSensitivePropertyProvider(BootstrapProperties bootstrapProperties) {
        super(bootstrapProperties);
    }

    @Override
    protected String getSecretsEnginePath(BootstrapProperties vaultBootstrapProperties) {
        if (vaultBootstrapProperties == null) {
            return null;
        }
        return vaultBootstrapProperties.getProperty(TRANSIT_PATH);
    }

    public String getIdentifierKey() {
        return String.format(IDENTIFIER_KEY_FORMAT, this.getPath());
    }

    public String protect(String unprotectedValue, ProtectedPropertyContext context) throws SensitivePropertyProtectionException {
        this.requireNotBlank(unprotectedValue);
        return this.getVaultCommunicationService().encrypt(this.getPath(), unprotectedValue.getBytes(PROPERTY_CHARSET));
    }

    public String unprotect(String protectedValue, ProtectedPropertyContext context) throws SensitivePropertyProtectionException {
        this.requireNotBlank(protectedValue);
        return new String(this.getVaultCommunicationService().decrypt(this.getPath(), protectedValue), PROPERTY_CHARSET);
    }
}

