/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.api.format;

import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.olingo.commons.api.format.TypeUtil;

public class AcceptCharset {
    private static final Pattern Q_PATTERN = Pattern.compile("\\A(?:0(?:\\.\\d{0,3})?)|(?:1(?:\\.0{0,3})?)\\Z");
    private static final Pattern CHARSET_PATTERN = Pattern.compile("([^,][\\w!#$%&'*+-._`|~;^]*)");
    private final String charset;
    private final Map<String, String> parameters = TypeUtil.createParameterMap();
    private final Float quality;
    private static final String UTF8_CHARSET = "utf8";
    private static final String UTF8_CHARSET1 = "utf-8";

    private AcceptCharset(String charset) {
        this.charset = this.parse(charset, this.parameters);
        if (!(UTF8_CHARSET.equalsIgnoreCase(this.charset) || UTF8_CHARSET1.equalsIgnoreCase(this.charset) || "*".equals(this.charset))) {
            if (CHARSET_PATTERN.matcher(this.charset).matches()) {
                throw new UnsupportedCharsetException("Unsupported charset in accept charset header:" + charset);
            }
            throw new IllegalArgumentException("Illegal charset in accept charset header:" + charset);
        }
        for (Map.Entry<String, String> param : this.parameters.entrySet()) {
            if (param.getKey().equals("q")) continue;
            throw new IllegalArgumentException("Illegal parameters in accept charset header:" + charset);
        }
        String q = this.parameters.get("q");
        if (q == null) {
            this.quality = Float.valueOf(1.0f);
        } else if (Q_PATTERN.matcher(q).matches()) {
            this.quality = Float.valueOf(q);
        } else {
            throw new IllegalArgumentException("Illegal quality parameter '" + q + "' in accept charset header:" + charset);
        }
    }

    private String parse(String acceptCharset, Map<String, String> parameters) {
        String[] charsetAndParameters = acceptCharset.split(";", 2);
        acceptCharset = charsetAndParameters[0];
        String params = charsetAndParameters.length > 1 ? charsetAndParameters[1] : null;
        TypeUtil.parseParameters(params, parameters);
        return acceptCharset;
    }

    public static List<AcceptCharset> create(String acceptCharsets) {
        if (acceptCharsets == null) {
            throw new IllegalArgumentException("Type parameter MUST NOT be null.");
        }
        ArrayList<AcceptCharset> result = new ArrayList<AcceptCharset>();
        ArrayList<IllegalArgumentException> exceptionList = new ArrayList<IllegalArgumentException>();
        String[] values = acceptCharsets.split(",");
        if (values.length == 0) {
            values = new String[]{acceptCharsets};
        }
        for (String value : values) {
            try {
                result.add(new AcceptCharset(value.trim()));
            }
            catch (UnsupportedCharsetException e) {
                exceptionList.add(e);
            }
            catch (IllegalArgumentException e) {
                exceptionList.add(e);
            }
        }
        if (result.isEmpty()) {
            if (exceptionList.get(0) instanceof UnsupportedCharsetException) {
                throw new UnsupportedCharsetException(((Exception)exceptionList.get(0)).getMessage());
            }
            if (exceptionList.get(0) instanceof IllegalArgumentException) {
                throw new IllegalArgumentException(((Exception)exceptionList.get(0)).getMessage());
            }
        }
        for (Exception exception : exceptionList) {
            if (exception instanceof UnsupportedCharsetException) continue;
            throw new IllegalArgumentException(exception.getMessage());
        }
        AcceptCharset.sort(result);
        return result;
    }

    public String getCharset() {
        return this.charset;
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public String getParameter(String name) {
        return this.parameters.get(name.toLowerCase(Locale.ROOT));
    }

    public Float getQuality() {
        return this.quality;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.charset);
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            result.append(';').append(entry.getKey()).append('=').append(entry.getValue());
        }
        return result.toString();
    }

    private static void sort(List<AcceptCharset> toSort) {
        Collections.sort(toSort, new Comparator<AcceptCharset>(){

            @Override
            public int compare(AcceptCharset a1, AcceptCharset a2) {
                int compare = a2.getQuality().compareTo(a1.getQuality());
                if (compare != 0) {
                    return compare;
                }
                return a2.getParameters().size() - a1.getParameters().size();
            }
        });
    }
}

