/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.internal;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.Random;
import java.util.function.Function;
import oracle.jdbc.logging.annotations.DisableTrace;

@DisableTrace
public final class OpaqueString
implements Serializable {
    private char[] c;

    public static OpaqueString newOpaqueString(char[] cArray) {
        if (cArray == null) {
            return new OpaqueString(null);
        }
        try {
            OpaqueString opaqueString = new OpaqueString(CharBuffer.wrap(cArray));
            return opaqueString;
        }
        finally {
            Arrays.fill(cArray, '\u0000');
        }
    }

    public static OpaqueString newOpaqueString(String string) {
        OpaqueString opaqueString = new OpaqueString(string);
        return opaqueString;
    }

    private OpaqueString(CharSequence charSequence) {
        if (charSequence == null) {
            this.c = null;
        } else {
            this.c = new char[charSequence.length()];
            for (int i2 = 0; i2 < charSequence.length(); ++i2) {
                this.c[i2] = charSequence.charAt(i2);
            }
            OpaqueString.xor(this.c, this.c, super.hashCode() + this.getClass().hashCode());
        }
    }

    public String get() {
        if (this.c == null) {
            return null;
        }
        return this.map(String::new);
    }

    public char[] getChars() {
        if (this.c == null) {
            return null;
        }
        char[] cArray = new char[this.c.length];
        OpaqueString.xor(this.c, cArray, super.hashCode() + this.getClass().hashCode());
        return cArray;
    }

    public boolean isNull() {
        return this.c == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T map(Function<char[], T> function) {
        if (this.c == null) {
            return function.apply(null);
        }
        char[] cArray = new char[this.c.length];
        try {
            OpaqueString.xor(this.c, cArray, super.hashCode() + this.getClass().hashCode());
            T t2 = function.apply(cArray);
            return t2;
        }
        finally {
            Arrays.fill(cArray, '\u0000');
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        short[] sArray;
        if (this.c == null) {
            sArray = null;
        } else {
            sArray = new short[this.c.length * 2];
            for (int i2 = 0; i2 < this.c.length; ++i2) {
                sArray[i2] = (short)this.c[i2];
            }
            Random random = new Random(super.hashCode() + this.getClass().hashCode());
            for (int i3 = this.c.length; i3 < sArray.length; ++i3) {
                sArray[i3] = (short)random.nextInt();
            }
        }
        objectOutputStream.writeObject(sArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        short[] sArray = (short[])objectInputStream.readObject();
        if (sArray == null) {
            this.c = null;
        } else {
            char[] cArray = new char[sArray.length / 2];
            try {
                for (int i2 = 0; i2 < cArray.length; ++i2) {
                    cArray[i2] = (char)(sArray[i2] ^ sArray[i2 + cArray.length]);
                }
                this.c = new char[cArray.length];
                OpaqueString.xor(cArray, this.c, super.hashCode() + this.getClass().hashCode());
            }
            finally {
                Arrays.fill(cArray, '\u0000');
            }
        }
    }

    private void readObjectNoData() throws InvalidObjectException {
        throw new InvalidObjectException("Stream data required");
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof OpaqueString)) {
            return false;
        }
        OpaqueString opaqueString = (OpaqueString)object;
        if (this.c == null || opaqueString.c == null) {
            return this.c == opaqueString.c;
        }
        if (this.c.length != opaqueString.c.length) {
            return false;
        }
        Random random = new Random(super.hashCode() + this.getClass().hashCode());
        Random random2 = new Random(System.identityHashCode(opaqueString) + opaqueString.getClass().hashCode());
        for (int i2 = 0; i2 < this.c.length; ++i2) {
            char c2;
            char c3 = (char)(this.c[i2] ^ random.nextInt());
            if (c3 == (c2 = (char)(opaqueString.c[i2] ^ random2.nextInt()))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.c == null || this.c.length == 0) {
            return 0;
        }
        return this.map(cArray -> {
            int n2 = 0;
            for (int i2 = 0; i2 < ((char[])cArray).length; ++i2) {
                n2 = 31 * n2 + cArray[i2];
            }
            return n2;
        });
    }

    private static void xor(char[] cArray, char[] cArray2, int n2) {
        assert (cArray.length == cArray2.length) : "Input and output are different lengths. input.length: " + cArray.length + " output.length: " + cArray2.length;
        Random random = new Random(n2);
        for (int i2 = 0; i2 < cArray2.length; ++i2) {
            cArray2[i2] = (char)(cArray[i2] ^ random.nextInt());
        }
    }
}

