/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.executorservice.durable;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.DurableExecutorSubmitToPartitionCodec;
import com.hazelcast.client.impl.protocol.task.AbstractPartitionMessageTask;
import com.hazelcast.config.DurableExecutorConfig;
import com.hazelcast.durableexecutor.impl.operations.TaskOperation;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.security.SecureCallable;
import com.hazelcast.security.SecurityContext;
import com.hazelcast.security.permission.DurableExecutorServicePermission;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.security.Permission;
import java.util.concurrent.Callable;
import javax.security.auth.Subject;

public class DurableExecutorSubmitToPartitionMessageTask
extends AbstractPartitionMessageTask<DurableExecutorSubmitToPartitionCodec.RequestParameters> {
    public DurableExecutorSubmitToPartitionMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
        this.setNamespaceAware();
    }

    @Override
    protected Operation prepareOperation() {
        SecurityContext securityContext = this.clientEngine.getSecurityContext();
        Data callableData = ((DurableExecutorSubmitToPartitionCodec.RequestParameters)this.parameters).callable;
        if (securityContext != null) {
            SecureCallable<Object> callable;
            Subject subject = this.endpoint.getSubject();
            Object taskObject = this.serializationService.toObject(((DurableExecutorSubmitToPartitionCodec.RequestParameters)this.parameters).callable);
            if (taskObject instanceof Runnable) {
                Runnable runnable = (Runnable)taskObject;
                callable = securityContext.createSecureCallable(subject, runnable);
            } else {
                callable = securityContext.createSecureCallable(subject, (Callable)taskObject);
            }
            callableData = this.serializationService.toData(callable);
        }
        return new TaskOperation(((DurableExecutorSubmitToPartitionCodec.RequestParameters)this.parameters).name, callableData);
    }

    @Override
    protected DurableExecutorSubmitToPartitionCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return DurableExecutorSubmitToPartitionCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return DurableExecutorSubmitToPartitionCodec.encodeResponse((Integer)response);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:durableExecutorService";
    }

    @Override
    public Permission getRequiredPermission() {
        return new DurableExecutorServicePermission(((DurableExecutorSubmitToPartitionCodec.RequestParameters)this.parameters).name, "modify");
    }

    @Override
    public String getDistributedObjectName() {
        return ((DurableExecutorSubmitToPartitionCodec.RequestParameters)this.parameters).name;
    }

    @Override
    public String getMethodName() {
        return "submitToPartition";
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    protected String getUserCodeNamespace() {
        DurableExecutorConfig config = this.nodeEngine.getConfig().findDurableExecutorConfig(((DurableExecutorSubmitToPartitionCodec.RequestParameters)this.parameters).name);
        return config == null ? null : config.getUserCodeNamespace();
    }
}

