/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.NamedConfig;
import com.hazelcast.config.UserCodeNamespaceAwareConfig;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.config.ConfigDataSerializerHook;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.nio.serialization.impl.Versioned;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

public class DurableExecutorConfig
implements IdentifiedDataSerializable,
NamedConfig,
Versioned,
UserCodeNamespaceAwareConfig<DurableExecutorConfig> {
    public static final int DEFAULT_POOL_SIZE = 16;
    public static final int DEFAULT_RING_BUFFER_CAPACITY = 100;
    public static final int DEFAULT_DURABILITY = 1;
    private String name = "default";
    private int poolSize = 16;
    private int durability = 1;
    private int capacity = 100;
    private String splitBrainProtectionName;
    private boolean statisticsEnabled = true;
    @Nullable
    private String userCodeNamespace = DEFAULT_NAMESPACE;

    public DurableExecutorConfig() {
    }

    public DurableExecutorConfig(String name) {
        this.name = name;
    }

    public DurableExecutorConfig(String name, int poolSize, int durability, int capacity, boolean statisticsEnabled, @Nullable String userCodeNamespace) {
        this(name, poolSize, durability, capacity, null, statisticsEnabled, userCodeNamespace);
    }

    public DurableExecutorConfig(String name, int poolSize, int durability, int capacity, String splitBrainProtectionName, boolean statisticsEnabled, @Nullable String userCodeNamespace) {
        this.name = name;
        this.poolSize = poolSize;
        this.durability = durability;
        this.capacity = capacity;
        this.splitBrainProtectionName = splitBrainProtectionName;
        this.statisticsEnabled = statisticsEnabled;
        this.userCodeNamespace = userCodeNamespace;
    }

    public DurableExecutorConfig(DurableExecutorConfig config) {
        this(config.getName(), config.getPoolSize(), config.getDurability(), config.getCapacity(), config.getSplitBrainProtectionName(), config.isStatisticsEnabled(), config.getUserCodeNamespace());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DurableExecutorConfig setName(String name) {
        this.name = name;
        return this;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public DurableExecutorConfig setPoolSize(int poolSize) {
        this.poolSize = Preconditions.checkPositive("poolSize", poolSize);
        return this;
    }

    public int getDurability() {
        return this.durability;
    }

    public DurableExecutorConfig setDurability(int durability) {
        this.durability = Preconditions.checkNotNegative(durability, "durability can't be smaller than 0");
        return this;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public DurableExecutorConfig setCapacity(int capacity) {
        this.capacity = Preconditions.checkPositive("capacity", capacity);
        return this;
    }

    public String getSplitBrainProtectionName() {
        return this.splitBrainProtectionName;
    }

    public DurableExecutorConfig setSplitBrainProtectionName(String splitBrainProtectionName) {
        this.splitBrainProtectionName = splitBrainProtectionName;
        return this;
    }

    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public DurableExecutorConfig setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
        return this;
    }

    @Override
    @Nullable
    public String getUserCodeNamespace() {
        return this.userCodeNamespace;
    }

    @Override
    public DurableExecutorConfig setUserCodeNamespace(@Nullable String userCodeNamespace) {
        this.userCodeNamespace = userCodeNamespace;
        return this;
    }

    public String toString() {
        return "ExecutorConfig{name='" + this.name + "', poolSize=" + this.poolSize + ", capacity=" + this.capacity + ", statisticsEnabled=" + this.statisticsEnabled + ", splitBrainProtectionName=" + this.splitBrainProtectionName + ", userCodeNamespace=" + this.userCodeNamespace + "}";
    }

    @Override
    public int getFactoryId() {
        return ConfigDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 31;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.name);
        out.writeInt(this.poolSize);
        out.writeInt(this.durability);
        out.writeInt(this.capacity);
        out.writeString(this.splitBrainProtectionName);
        out.writeBoolean(this.statisticsEnabled);
        if (out.getVersion().isGreaterOrEqual(Versions.V5_4)) {
            out.writeString(this.userCodeNamespace);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readString();
        this.poolSize = in.readInt();
        this.durability = in.readInt();
        this.capacity = in.readInt();
        this.splitBrainProtectionName = in.readString();
        this.statisticsEnabled = in.readBoolean();
        if (in.getVersion().isGreaterOrEqual(Versions.V5_4)) {
            this.userCodeNamespace = in.readString();
        }
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DurableExecutorConfig)) {
            return false;
        }
        DurableExecutorConfig that = (DurableExecutorConfig)o;
        if (this.poolSize != that.poolSize) {
            return false;
        }
        if (this.durability != that.durability) {
            return false;
        }
        if (this.capacity != that.capacity) {
            return false;
        }
        if (this.statisticsEnabled != that.statisticsEnabled) {
            return false;
        }
        if (!Objects.equals(this.splitBrainProtectionName, that.splitBrainProtectionName)) {
            return false;
        }
        if (!Objects.equals(this.userCodeNamespace, that.userCodeNamespace)) {
            return false;
        }
        return this.name.equals(that.name);
    }

    public final int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.poolSize;
        result = 31 * result + this.durability;
        result = 31 * result + this.capacity;
        result = 31 * result + (this.statisticsEnabled ? 1 : 0);
        result = 31 * result + (this.splitBrainProtectionName != null ? this.splitBrainProtectionName.hashCode() : 0);
        result = 31 * result + (this.userCodeNamespace != null ? this.userCodeNamespace.hashCode() : 0);
        return result;
    }
}

