/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core.metrics;

import com.hazelcast.jet.core.metrics.MetricsDataSerializerHook;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Measurement
implements IdentifiedDataSerializable {
    private Map<String, String> tags;
    private String metric;
    private long value;
    private long timestamp;

    Measurement() {
    }

    private Measurement(String metric, long value, long timestamp, @Nonnull Map<String, String> tags) {
        this.metric = metric;
        this.value = value;
        this.timestamp = timestamp;
        this.tags = new HashMap<String, String>(tags);
    }

    @Nonnull
    public static Measurement of(@Nonnull String metric, long value, long timestamp, @Nonnull Map<String, String> tags) {
        Objects.requireNonNull(tags, "metric");
        Objects.requireNonNull(tags, "tags");
        return new Measurement(metric, value, timestamp, tags);
    }

    public long value() {
        return this.value;
    }

    public long timestamp() {
        return this.timestamp;
    }

    @Nonnull
    public String metric() {
        return this.metric;
    }

    @Nullable
    public String tag(String name) {
        return this.tags.get(name);
    }

    @Override
    public int getFactoryId() {
        return MetricsDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 1;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.tags);
        out.writeLong(this.value);
        out.writeLong(this.timestamp);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.tags = (Map)in.readObject();
        this.value = in.readLong();
        this.timestamp = in.readLong();
    }

    public int hashCode() {
        return 31 * (int)(this.timestamp * 31L + this.value) + Objects.hashCode(this.tags);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Measurement)) {
            return false;
        }
        Measurement that = (Measurement)obj;
        return this.timestamp == that.timestamp && this.value == that.value && Objects.equals(this.tags, that.tags);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%s %,5d", this.metric, this.value)).append(" ").append(Util.toLocalTime(this.timestamp)).append(" [");
        String tags = this.tags.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(", "));
        sb.append(tags).append(']');
        return sb.toString();
    }
}

