/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.annotation;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationMarkup;

public class PDAnnotationPopup
extends PDAnnotation {
    private static final Log LOG = LogFactory.getLog(PDAnnotationPopup.class);
    public static final String SUB_TYPE = "Popup";

    public PDAnnotationPopup() {
        this.getCOSObject().setName(COSName.SUBTYPE, SUB_TYPE);
    }

    public PDAnnotationPopup(COSDictionary field) {
        super(field);
    }

    public void setOpen(boolean open) {
        this.getCOSObject().setBoolean("Open", open);
    }

    public boolean getOpen() {
        return this.getCOSObject().getBoolean("Open", false);
    }

    public void setParent(PDAnnotationMarkup annot) {
        this.getCOSObject().setItem(COSName.PARENT, (COSBase)annot.getCOSObject());
    }

    public PDAnnotationMarkup getParent() {
        try {
            PDAnnotation ann = PDAnnotation.createAnnotation(this.getCOSObject().getDictionaryObject(COSName.PARENT, COSName.P));
            if (!(ann instanceof PDAnnotationMarkup)) {
                LOG.error("parent annotation is of type " + ann.getClass().getSimpleName() + " but should be of type PDAnnotationMarkup");
                return null;
            }
            return (PDAnnotationMarkup)ann;
        }
        catch (IOException ioe) {
            LOG.debug("An exception while trying to get the parent markup - ignoring", ioe);
            return null;
        }
    }
}

