/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.log.BasicVersionedWriteLoggable;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.log.VersionedWriteLoggable;
import com.sleepycat.je.utilint.Timestamp;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;

public class Matchpoint
extends BasicVersionedWriteLoggable {
    private static final int LAST_FORMAT_CHANGE = 8;
    private Timestamp time;
    private int repMasterNodeId;

    public Matchpoint(int repMasterNodeId) {
        this.repMasterNodeId = repMasterNodeId;
        this.time = new Timestamp(System.currentTimeMillis());
    }

    public Matchpoint() {
    }

    public int getMasterNodeId() {
        return this.repMasterNodeId;
    }

    @Override
    public int getLastFormatChange() {
        return 8;
    }

    @Override
    public Collection<VersionedWriteLoggable> getEmbeddedLoggables() {
        return Collections.emptyList();
    }

    @Override
    public int getLogSize(int logVersion, boolean forReplication) {
        return LogUtils.getTimestampLogSize(this.time) + LogUtils.getPackedIntLogSize(this.repMasterNodeId);
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer, int logVersion, boolean forReplication) {
        LogUtils.writeTimestamp(logBuffer, this.time);
        LogUtils.writePackedInt(logBuffer, this.repMasterNodeId);
    }

    @Override
    public void readFromLog(ByteBuffer logBuffer, int entryVersion) {
        this.time = LogUtils.readTimestamp(logBuffer, false);
        this.repMasterNodeId = LogUtils.readInt(logBuffer, false);
    }

    @Override
    public void dumpLog(StringBuilder sb, boolean verbose) {
        sb.append("<Matchpoint");
        sb.append("\" time=\"").append(this.time);
        sb.append("\" master=\"").append(this.repMasterNodeId);
        sb.append("\">");
    }

    @Override
    public long getTransactionId() {
        return 0L;
    }

    @Override
    public boolean logicalEquals(Loggable other) {
        if (!(other instanceof Matchpoint)) {
            return false;
        }
        Matchpoint otherMatchpoint = (Matchpoint)other;
        return otherMatchpoint.time.equals(this.time) && otherMatchpoint.repMasterNodeId == this.repMasterNodeId;
    }
}

