/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.model;

import com.sleepycat.persist.model.ClassEnhancer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class ClassEnhancerTask
extends Task {
    private List<FileSet> fileSets = new ArrayList<FileSet>();
    private boolean verbose;

    public void execute() throws BuildException {
        if (this.fileSets.size() == 0) {
            throw new BuildException("At least one fileset must be specified");
        }
        try {
            int nFiles = 0;
            ClassEnhancer enhancer = new ClassEnhancer();
            enhancer.setVerbose(this.verbose);
            for (FileSet fileSet : this.fileSets) {
                String[] fileNames;
                DirectoryScanner scanner = fileSet.getDirectoryScanner(this.getProject());
                for (String fileName : fileNames = scanner.getIncludedFiles()) {
                    File file = new File(scanner.getBasedir(), fileName);
                    try {
                        nFiles += enhancer.enhanceFile(file);
                    }
                    catch (IOException e) {
                        throw new BuildException((Throwable)e);
                    }
                }
            }
            if (nFiles > 0) {
                System.out.println("Enhanced: " + nFiles + " files");
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void addConfiguredFileset(FileSet files) {
        this.fileSets.add(files);
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

