/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;

public class RewriteRequestForUncompressedJavascript
implements Filter {
    public static final String UNCOMPRESSED_JS_SUFFIX = ".uncompressed.js";
    public static final String JS_SUFFIX = ".js";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String requestURI = ((HttpServletRequest)request).getRequestURI();
        if (requestURI.endsWith(JS_SUFFIX) && !requestURI.endsWith(UNCOMPRESSED_JS_SUFFIX) && !requestURI.contains("../")) {
            String uncompressedJsUri = requestURI + UNCOMPRESSED_JS_SUFFIX;
            request.getRequestDispatcher(uncompressedJsUri).forward(request, response);
        } else {
            chain.doFilter(request, response);
        }
    }
}

