/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.service.route;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.base.Optional;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.client.ClientConfig;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.impl.mqclient.MQClientAPIFactory;
import org.apache.rocketmq.client.latency.MQFaultStrategy;
import org.apache.rocketmq.client.latency.Resolver;
import org.apache.rocketmq.client.latency.ServiceDetector;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.common.thread.ThreadPoolMonitor;
import org.apache.rocketmq.common.utils.AbstractStartAndShutdown;
import org.apache.rocketmq.common.utils.StartAndShutdown;
import org.apache.rocketmq.common.utils.ThreadUtils;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.proxy.common.Address;
import org.apache.rocketmq.proxy.common.ProxyContext;
import org.apache.rocketmq.proxy.config.ConfigurationManager;
import org.apache.rocketmq.proxy.config.ProxyConfig;
import org.apache.rocketmq.proxy.service.route.AddressableMessageQueue;
import org.apache.rocketmq.proxy.service.route.MessageQueueView;
import org.apache.rocketmq.proxy.service.route.ProxyTopicRouteData;
import org.apache.rocketmq.proxy.service.route.TopicRouteHelper;
import org.apache.rocketmq.remoting.protocol.header.GetMaxOffsetRequestHeader;
import org.apache.rocketmq.remoting.protocol.route.TopicRouteData;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class TopicRouteService
extends AbstractStartAndShutdown {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqProxy");
    private final MQClientAPIFactory mqClientAPIFactory;
    private MQFaultStrategy mqFaultStrategy;
    protected final LoadingCache<String, MessageQueueView> topicCache;
    protected final ScheduledExecutorService scheduledExecutorService;
    protected final ThreadPoolExecutor cacheRefreshExecutor;

    public TopicRouteService(final MQClientAPIFactory mqClientAPIFactory) {
        ProxyConfig config = ConfigurationManager.getProxyConfig();
        this.scheduledExecutorService = ThreadUtils.newSingleThreadScheduledExecutor((ThreadFactory)new ThreadFactoryImpl("TopicRouteService_"));
        this.cacheRefreshExecutor = ThreadPoolMonitor.createAndMonitor((int)config.getTopicRouteServiceThreadPoolNums(), (int)config.getTopicRouteServiceThreadPoolNums(), (long)60000L, (TimeUnit)TimeUnit.MILLISECONDS, (String)"TopicRouteCacheRefresh", (int)config.getTopicRouteServiceThreadPoolQueueCapacity());
        this.mqClientAPIFactory = mqClientAPIFactory;
        this.topicCache = Caffeine.newBuilder().maximumSize((long)config.getTopicRouteServiceCacheMaxNum()).expireAfterAccess((long)config.getTopicRouteServiceCacheExpiredSeconds(), TimeUnit.SECONDS).refreshAfterWrite((long)config.getTopicRouteServiceCacheRefreshSeconds(), TimeUnit.SECONDS).executor((Executor)this.cacheRefreshExecutor).build((CacheLoader)new CacheLoader<String, MessageQueueView>(){

            public @Nullable MessageQueueView load(String topic) throws Exception {
                try {
                    TopicRouteData topicRouteData = mqClientAPIFactory.getClient().getTopicRouteInfoFromNameServer(topic, Duration.ofSeconds(3L).toMillis());
                    return TopicRouteService.this.buildMessageQueueView(topic, topicRouteData);
                }
                catch (Exception e) {
                    if (TopicRouteHelper.isTopicNotExistError(e)) {
                        return MessageQueueView.WRAPPED_EMPTY_QUEUE;
                    }
                    throw e;
                }
            }

            public @Nullable MessageQueueView reload(@NonNull String key, @NonNull MessageQueueView oldValue) throws Exception {
                try {
                    return this.load(key);
                }
                catch (Exception e) {
                    log.warn(String.format("reload topic route from namesrv. topic: %s", key), (Throwable)e);
                    return oldValue;
                }
            }
        });
        ServiceDetector serviceDetector = new ServiceDetector(){

            public boolean detect(String endpoint, long timeoutMillis) {
                Optional candidateTopic = TopicRouteService.this.pickTopic();
                if (!candidateTopic.isPresent()) {
                    return false;
                }
                try {
                    GetMaxOffsetRequestHeader requestHeader = new GetMaxOffsetRequestHeader();
                    requestHeader.setTopic((String)candidateTopic.get());
                    requestHeader.setQueueId(Integer.valueOf(0));
                    Long maxOffset = (Long)mqClientAPIFactory.getClient().getMaxOffset(endpoint, requestHeader, timeoutMillis).get();
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
        };
        this.mqFaultStrategy = new MQFaultStrategy(this.extractClientConfigFromProxyConfig(config), new Resolver(){

            public String resolve(String name) {
                try {
                    String brokerAddr = TopicRouteService.this.getBrokerAddr(ProxyContext.createForInner("MQFaultStrategy"), name);
                    return brokerAddr;
                }
                catch (Exception e) {
                    return null;
                }
            }
        }, serviceDetector);
        this.init();
    }

    private Optional<String> pickTopic() {
        if (this.topicCache.asMap().isEmpty()) {
            return Optional.absent();
        }
        return Optional.of(this.topicCache.asMap().keySet().iterator().next());
    }

    protected void init() {
        this.appendShutdown(this.scheduledExecutorService::shutdown);
        this.appendStartAndShutdown((StartAndShutdown)this.mqClientAPIFactory);
    }

    public void shutdown() throws Exception {
        if (this.mqFaultStrategy.isStartDetectorEnable()) {
            this.mqFaultStrategy.shutdown();
        }
    }

    public void start() throws Exception {
        if (this.mqFaultStrategy.isStartDetectorEnable()) {
            this.mqFaultStrategy.startDetector();
        }
    }

    public ClientConfig extractClientConfigFromProxyConfig(ProxyConfig proxyConfig) {
        ClientConfig tempClientConfig = new ClientConfig();
        tempClientConfig.setSendLatencyEnable(proxyConfig.getSendLatencyEnable());
        tempClientConfig.setStartDetectorEnable(proxyConfig.getStartDetectorEnable());
        tempClientConfig.setDetectTimeout(proxyConfig.getDetectTimeout());
        tempClientConfig.setDetectInterval(proxyConfig.getDetectInterval());
        return tempClientConfig;
    }

    public void updateFaultItem(String brokerName, long currentLatency, boolean isolation, boolean reachable) {
        this.checkSendFaultToleranceEnable();
        this.mqFaultStrategy.updateFaultItem(brokerName, currentLatency, isolation, reachable);
    }

    public void checkSendFaultToleranceEnable() {
        boolean hotLatencySwitch = ConfigurationManager.getProxyConfig().isSendLatencyEnable();
        boolean hotDetectorSwitch = ConfigurationManager.getProxyConfig().isStartDetectorEnable();
        this.mqFaultStrategy.setSendLatencyFaultEnable(hotLatencySwitch);
        this.mqFaultStrategy.setStartDetectorEnable(hotDetectorSwitch);
    }

    public MQFaultStrategy getMqFaultStrategy() {
        return this.mqFaultStrategy;
    }

    public MessageQueueView getAllMessageQueueView(ProxyContext ctx, String topicName) throws Exception {
        return TopicRouteService.getCacheMessageQueueWrapper(this.topicCache, topicName);
    }

    public abstract MessageQueueView getCurrentMessageQueueView(ProxyContext var1, String var2) throws Exception;

    public abstract ProxyTopicRouteData getTopicRouteForProxy(ProxyContext var1, List<Address> var2, String var3) throws Exception;

    public abstract String getBrokerAddr(ProxyContext var1, String var2) throws Exception;

    public abstract AddressableMessageQueue buildAddressableMessageQueue(ProxyContext var1, MessageQueue var2) throws Exception;

    protected static MessageQueueView getCacheMessageQueueWrapper(LoadingCache<String, MessageQueueView> topicCache, String key) throws Exception {
        MessageQueueView res = (MessageQueueView)topicCache.get((Object)key);
        if (res != null && res.isEmptyCachedQueue()) {
            throw new MQClientException(17, "No topic route info in name server for the topic: " + key);
        }
        return res;
    }

    protected static boolean isTopicRouteValid(TopicRouteData routeData) {
        return routeData != null && routeData.getQueueDatas() != null && !routeData.getQueueDatas().isEmpty() && routeData.getBrokerDatas() != null && !routeData.getBrokerDatas().isEmpty();
    }

    protected MessageQueueView buildMessageQueueView(String topic, TopicRouteData topicRouteData) {
        if (TopicRouteService.isTopicRouteValid(topicRouteData)) {
            MessageQueueView tmp = new MessageQueueView(topic, topicRouteData, this.getMqFaultStrategy());
            log.debug("load topic route from namesrv. topic: {}, queue: {}", (Object)topic, (Object)tmp);
            return tmp;
        }
        return MessageQueueView.WRAPPED_EMPTY_QUEUE;
    }
}

