/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.controller.metrics;

import com.google.common.base.Splitter;
import io.openmessaging.storage.dledger.MemberState;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.LongHistogram;
import io.opentelemetry.api.metrics.LongUpDownCounter;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongGauge;
import io.opentelemetry.exporter.logging.otlp.OtlpJsonLoggingMetricExporter;
import io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporter;
import io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporterBuilder;
import io.opentelemetry.exporter.prometheus.PrometheusHttpServer;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.metrics.Aggregation;
import io.opentelemetry.sdk.metrics.InstrumentSelector;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import io.opentelemetry.sdk.metrics.View;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.metrics.export.PeriodicMetricReader;
import io.opentelemetry.sdk.resources.Resource;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.ControllerConfig;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.metrics.MetricsExporterType;
import org.apache.rocketmq.common.metrics.NopLongCounter;
import org.apache.rocketmq.common.metrics.NopLongHistogram;
import org.apache.rocketmq.common.metrics.NopLongUpDownCounter;
import org.apache.rocketmq.common.metrics.NopObservableLongGauge;
import org.apache.rocketmq.controller.ControllerManager;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class ControllerMetricsManager {
    private static final org.apache.rocketmq.logging.org.slf4j.Logger logger = LoggerFactory.getLogger((String)"RocketmqController");
    private static volatile ControllerMetricsManager instance;
    private static final Map<String, String> LABEL_MAP;
    public static LongUpDownCounter role;
    public static ObservableLongGauge dLedgerDiskUsage;
    public static ObservableLongGauge activeBrokerNum;
    public static LongCounter requestTotal;
    public static LongCounter dLedgerOpTotal;
    public static LongCounter electionTotal;
    public static LongHistogram requestLatency;
    public static LongHistogram dLedgerOpLatency;
    private static double us;
    private static double ms;
    private static double s;
    private final ControllerManager controllerManager;
    private final ControllerConfig config;
    private Meter controllerMeter;
    private OtlpGrpcMetricExporter metricExporter;
    private PeriodicMetricReader periodicMetricReader;
    private PrometheusHttpServer prometheusHttpServer;
    private MetricExporter loggingMetricExporter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ControllerMetricsManager getInstance(ControllerManager controllerManager) {
        if (instance != null) return instance;
        Class<ControllerMetricsManager> clazz = ControllerMetricsManager.class;
        synchronized (ControllerMetricsManager.class) {
            if (instance != null) return instance;
            instance = new ControllerMetricsManager(controllerManager);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public static AttributesBuilder newAttributesBuilder() {
        AttributesBuilder builder = Attributes.builder();
        LABEL_MAP.forEach((arg_0, arg_1) -> ((AttributesBuilder)builder).put(arg_0, arg_1));
        return builder;
    }

    public static void recordRole(MemberState.Role newRole, MemberState.Role oldRole) {
        role.add((long)(ControllerMetricsManager.getRoleValue(newRole) - ControllerMetricsManager.getRoleValue(oldRole)), ControllerMetricsManager.newAttributesBuilder().build());
    }

    private static int getRoleValue(MemberState.Role role) {
        switch (role) {
            case UNKNOWN: {
                return 0;
            }
            case CANDIDATE: {
                return 1;
            }
            case FOLLOWER: {
                return 2;
            }
            case LEADER: {
                return 3;
            }
        }
        logger.error("Unknown role {}", (Object)role);
        return 0;
    }

    private ControllerMetricsManager(ControllerManager controllerManager) {
        this.controllerManager = controllerManager;
        this.config = this.controllerManager.getControllerConfig();
        LABEL_MAP.put("address", this.config.getDLedgerAddress());
        LABEL_MAP.put("group", this.config.getControllerDLegerGroup());
        LABEL_MAP.put("peer_id", this.config.getControllerDLegerSelfId());
        this.init();
    }

    private boolean checkConfig() {
        if (this.config == null) {
            return false;
        }
        MetricsExporterType exporterType = this.config.getMetricsExporterType();
        if (!exporterType.isEnable()) {
            return false;
        }
        switch (exporterType) {
            case OTLP_GRPC: {
                return StringUtils.isNotBlank((CharSequence)this.config.getMetricsGrpcExporterTarget());
            }
            case PROM: {
                return true;
            }
            case LOG: {
                return true;
            }
        }
        return false;
    }

    private void registerMetricsView(SdkMeterProviderBuilder providerBuilder) {
        List<Double> latencyBuckets = Arrays.asList(1.0 * us, 3.0 * us, 5.0 * us, 10.0 * us, 30.0 * us, 50.0 * us, 100.0 * us, 300.0 * us, 500.0 * us, 1.0 * ms, 3.0 * ms, 5.0 * ms, 10.0 * ms, 30.0 * ms, 50.0 * ms, 100.0 * ms, 300.0 * ms, 500.0 * ms, 1.0 * s, 3.0 * s, 5.0 * s, 10.0 * s);
        View latencyView = View.builder().setAggregation(Aggregation.explicitBucketHistogram(latencyBuckets)).build();
        InstrumentSelector requestLatencySelector = InstrumentSelector.builder().setType(InstrumentType.HISTOGRAM).setName("request_latency").build();
        InstrumentSelector dLedgerOpLatencySelector = InstrumentSelector.builder().setType(InstrumentType.HISTOGRAM).setName("dledger_op_latency").build();
        providerBuilder.registerView(requestLatencySelector, latencyView);
        providerBuilder.registerView(dLedgerOpLatencySelector, latencyView);
    }

    private void initMetric(Meter meter) {
        role = meter.upDownCounterBuilder("role").setDescription("role of current node").build();
        dLedgerDiskUsage = meter.gaugeBuilder("dledger_disk_usage").setDescription("disk usage of dledger").setUnit("bytes").ofLongs().buildWithCallback(measurement -> {
            String path = this.config.getControllerStorePath();
            if (!UtilAll.isPathExists((String)path)) {
                return;
            }
            File file = new File(path);
            Long diskUsage = UtilAll.calculateFileSizeInPath((File)file);
            if (diskUsage == -1L) {
                logger.error("calculateFileSizeInPath error, path: {}", (Object)path);
                return;
            }
            measurement.record(diskUsage.longValue(), ControllerMetricsManager.newAttributesBuilder().build());
        });
        activeBrokerNum = meter.gaugeBuilder("active_broker_num").setDescription("now active brokers num").ofLongs().buildWithCallback(measurement -> {
            Map<String, Map<String, Integer>> activeBrokersNum = this.controllerManager.getHeartbeatManager().getActiveBrokersNum();
            activeBrokersNum.forEach((cluster, brokerSetAndNum) -> brokerSetAndNum.forEach((brokerSet, num) -> measurement.record((long)num.intValue(), ControllerMetricsManager.newAttributesBuilder().put("cluster", cluster).put("broker_set", brokerSet).build())));
        });
        requestTotal = meter.counterBuilder("request_total").setDescription("total request num").build();
        dLedgerOpTotal = meter.counterBuilder("dledger_op_total").setDescription("total dledger operation num").build();
        electionTotal = meter.counterBuilder("election_total").setDescription("total elect num").build();
        requestLatency = meter.histogramBuilder("request_latency").setDescription("request latency").setUnit("us").ofLongs().build();
        dLedgerOpLatency = meter.histogramBuilder("dledger_op_latency").setDescription("dledger operation latency").setUnit("us").ofLongs().build();
    }

    public void init() {
        MetricsExporterType type = this.config.getMetricsExporterType();
        if (type == MetricsExporterType.DISABLE) {
            return;
        }
        if (!this.checkConfig()) {
            logger.error("check metric config failed, will not export metrics");
            return;
        }
        String labels = this.config.getMetricsLabel();
        if (StringUtils.isNotBlank((CharSequence)labels)) {
            List labelList = Splitter.on((char)',').omitEmptyStrings().splitToList((CharSequence)labels);
            for (String label : labelList) {
                String[] pair = label.split(":");
                if (pair.length != 2) {
                    logger.warn("metrics label is not valid: {}", (Object)label);
                    continue;
                }
                LABEL_MAP.put(pair[0], pair[1]);
            }
        }
        if (this.config.isMetricsInDelta()) {
            LABEL_MAP.put("aggregation", "delta");
        }
        SdkMeterProviderBuilder providerBuilder = SdkMeterProvider.builder().setResource(Resource.empty());
        if (type == MetricsExporterType.OTLP_GRPC) {
            String endpoint = this.config.getMetricsGrpcExporterTarget();
            if (!endpoint.startsWith("http")) {
                endpoint = "https://" + endpoint;
            }
            OtlpGrpcMetricExporterBuilder metricExporterBuilder = OtlpGrpcMetricExporter.builder().setEndpoint(endpoint).setTimeout(this.config.getMetricGrpcExporterTimeOutInMills(), TimeUnit.MILLISECONDS).setAggregationTemporalitySelector(x -> {
                if (this.config.isMetricsInDelta() && (x == InstrumentType.COUNTER || x == InstrumentType.OBSERVABLE_COUNTER || x == InstrumentType.HISTOGRAM)) {
                    return AggregationTemporality.DELTA;
                }
                return AggregationTemporality.CUMULATIVE;
            });
            String headers = this.config.getMetricsGrpcExporterHeader();
            if (StringUtils.isNotBlank((CharSequence)headers)) {
                HashMap<String, String> headerMap = new HashMap<String, String>();
                List headerList = Splitter.on((char)',').omitEmptyStrings().splitToList((CharSequence)headers);
                for (String header : headerList) {
                    String[] pair = header.split(":");
                    if (pair.length != 2) {
                        logger.warn("metricsGrpcExporterHeader is not valid: {}", (Object)headers);
                        continue;
                    }
                    headerMap.put(pair[0], pair[1]);
                }
                headerMap.forEach((arg_0, arg_1) -> ((OtlpGrpcMetricExporterBuilder)metricExporterBuilder).addHeader(arg_0, arg_1));
            }
            this.metricExporter = metricExporterBuilder.build();
            this.periodicMetricReader = PeriodicMetricReader.builder((MetricExporter)this.metricExporter).setInterval(this.config.getMetricGrpcExporterIntervalInMills(), TimeUnit.MILLISECONDS).build();
            providerBuilder.registerMetricReader((MetricReader)this.periodicMetricReader);
        }
        if (type == MetricsExporterType.PROM) {
            String promExporterHost = this.config.getMetricsPromExporterHost();
            if (StringUtils.isBlank((CharSequence)promExporterHost)) {
                promExporterHost = "0.0.0.0";
            }
            this.prometheusHttpServer = PrometheusHttpServer.builder().setHost(promExporterHost).setPort(this.config.getMetricsPromExporterPort()).build();
            providerBuilder.registerMetricReader((MetricReader)this.prometheusHttpServer);
        }
        if (type == MetricsExporterType.LOG) {
            SLF4JBridgeHandler.removeHandlersForRootLogger();
            SLF4JBridgeHandler.install();
            this.loggingMetricExporter = OtlpJsonLoggingMetricExporter.create((AggregationTemporality)(this.config.isMetricsInDelta() ? AggregationTemporality.DELTA : AggregationTemporality.CUMULATIVE));
            Logger.getLogger(OtlpJsonLoggingMetricExporter.class.getName()).setLevel(Level.FINEST);
            this.periodicMetricReader = PeriodicMetricReader.builder((MetricExporter)this.loggingMetricExporter).setInterval(this.config.getMetricLoggingExporterIntervalInMills(), TimeUnit.MILLISECONDS).build();
            providerBuilder.registerMetricReader((MetricReader)this.periodicMetricReader);
        }
        this.registerMetricsView(providerBuilder);
        this.controllerMeter = OpenTelemetrySdk.builder().setMeterProvider(providerBuilder.build()).build().getMeter("controller");
        this.initMetric(this.controllerMeter);
    }

    static {
        LABEL_MAP = new HashMap<String, String>();
        role = new NopLongUpDownCounter();
        dLedgerDiskUsage = new NopObservableLongGauge();
        activeBrokerNum = new NopObservableLongGauge();
        requestTotal = new NopLongCounter();
        dLedgerOpTotal = new NopLongCounter();
        electionTotal = new NopLongCounter();
        requestLatency = new NopLongHistogram();
        dLedgerOpLatency = new NopLongHistogram();
        us = 1.0;
        ms = 1000.0 * us;
        s = 1000.0 * ms;
    }
}

