/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store;

import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.sdk.metrics.InstrumentSelector;
import io.opentelemetry.sdk.metrics.ViewBuilder;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.Inet6Address;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.apache.rocketmq.common.AbstractBrokerRunnable;
import org.apache.rocketmq.common.BoundaryType;
import org.apache.rocketmq.common.BrokerConfig;
import org.apache.rocketmq.common.BrokerIdentity;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.Pair;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.common.SystemClock;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.attribute.CQType;
import org.apache.rocketmq.common.attribute.CleanupPolicy;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageExtBatch;
import org.apache.rocketmq.common.message.MessageExtBrokerInner;
import org.apache.rocketmq.common.running.RunningStats;
import org.apache.rocketmq.common.sysflag.MessageSysFlag;
import org.apache.rocketmq.common.topic.TopicValidator;
import org.apache.rocketmq.common.utils.CleanupPolicyUtils;
import org.apache.rocketmq.common.utils.QueueTypeUtils;
import org.apache.rocketmq.common.utils.ServiceProvider;
import org.apache.rocketmq.common.utils.ThreadUtils;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.protocol.body.HARuntimeInfo;
import org.apache.rocketmq.store.AllocateMappedFileService;
import org.apache.rocketmq.store.AppendMessageResult;
import org.apache.rocketmq.store.CommitLog;
import org.apache.rocketmq.store.CommitLogDispatcher;
import org.apache.rocketmq.store.DispatchRequest;
import org.apache.rocketmq.store.GetMessageResult;
import org.apache.rocketmq.store.GetMessageStatus;
import org.apache.rocketmq.store.MessageArrivingListener;
import org.apache.rocketmq.store.MessageFilter;
import org.apache.rocketmq.store.MessageStore;
import org.apache.rocketmq.store.PutMessageResult;
import org.apache.rocketmq.store.PutMessageStatus;
import org.apache.rocketmq.store.QueryMessageResult;
import org.apache.rocketmq.store.RocksDBMessageStore;
import org.apache.rocketmq.store.RunningFlags;
import org.apache.rocketmq.store.SelectMappedBufferResult;
import org.apache.rocketmq.store.StoreCheckpoint;
import org.apache.rocketmq.store.StoreStatsService;
import org.apache.rocketmq.store.StoreUtil;
import org.apache.rocketmq.store.TransientStorePool;
import org.apache.rocketmq.store.config.BrokerRole;
import org.apache.rocketmq.store.config.FlushDiskType;
import org.apache.rocketmq.store.config.MessageStoreConfig;
import org.apache.rocketmq.store.config.StorePathConfigHelper;
import org.apache.rocketmq.store.dledger.DLedgerCommitLog;
import org.apache.rocketmq.store.exception.ConsumeQueueException;
import org.apache.rocketmq.store.ha.DefaultHAService;
import org.apache.rocketmq.store.ha.HAService;
import org.apache.rocketmq.store.ha.autoswitch.AutoSwitchHAService;
import org.apache.rocketmq.store.hook.PutMessageHook;
import org.apache.rocketmq.store.hook.SendMessageBackHook;
import org.apache.rocketmq.store.index.IndexService;
import org.apache.rocketmq.store.index.QueryOffsetResult;
import org.apache.rocketmq.store.kv.CommitLogDispatcherCompaction;
import org.apache.rocketmq.store.kv.CompactionService;
import org.apache.rocketmq.store.kv.CompactionStore;
import org.apache.rocketmq.store.logfile.MappedFile;
import org.apache.rocketmq.store.metrics.DefaultStoreMetricsManager;
import org.apache.rocketmq.store.queue.ConsumeQueueInterface;
import org.apache.rocketmq.store.queue.ConsumeQueueStore;
import org.apache.rocketmq.store.queue.ConsumeQueueStoreInterface;
import org.apache.rocketmq.store.queue.CqUnit;
import org.apache.rocketmq.store.queue.ReferredIterator;
import org.apache.rocketmq.store.stats.BrokerStatsManager;
import org.apache.rocketmq.store.timer.TimerMessageStore;
import org.apache.rocketmq.store.util.PerfCounter;
import org.rocksdb.RocksDBException;

public class DefaultMessageStore
implements MessageStore {
    protected static final Logger LOGGER = LoggerFactory.getLogger((String)"RocketmqStore");
    protected static final Logger ERROR_LOG = LoggerFactory.getLogger((String)"RocketmqStoreError");
    public final PerfCounter.Ticks perfs = new PerfCounter.Ticks(LOGGER);
    private final MessageStoreConfig messageStoreConfig;
    protected final CommitLog commitLog;
    protected final ConsumeQueueStoreInterface consumeQueueStore;
    private final FlushConsumeQueueService flushConsumeQueueService;
    protected final CleanCommitLogService cleanCommitLogService;
    private final CleanConsumeQueueService cleanConsumeQueueService;
    private final CorrectLogicOffsetService correctLogicOffsetService;
    protected final IndexService indexService;
    private final AllocateMappedFileService allocateMappedFileService;
    private ReputMessageService reputMessageService;
    private HAService haService;
    private CompactionStore compactionStore;
    private CompactionService compactionService;
    private final StoreStatsService storeStatsService;
    private final TransientStorePool transientStorePool;
    protected final RunningFlags runningFlags = new RunningFlags();
    private final SystemClock systemClock = new SystemClock();
    private final ScheduledExecutorService scheduledExecutorService;
    private final BrokerStatsManager brokerStatsManager;
    private final MessageArrivingListener messageArrivingListener;
    private final BrokerConfig brokerConfig;
    private volatile boolean shutdown = true;
    protected boolean notifyMessageArriveInBatch = false;
    protected StoreCheckpoint storeCheckpoint;
    private TimerMessageStore timerMessageStore;
    private final LinkedList<CommitLogDispatcher> dispatcherList;
    private RocksDBMessageStore rocksDBMessageStore;
    private final RandomAccessFile lockFile;
    private FileLock lock;
    boolean shutDownNormal = false;
    private static final int MAX_PULL_MSG_SIZE = 0x8000000;
    private volatile int aliveReplicasNum = 1;
    private MessageStore masterStoreInProcess = null;
    private volatile long masterFlushedOffset = -1L;
    private volatile long brokerInitMaxOffset = -1L;
    private final List<PutMessageHook> putMessageHookList = new ArrayList<PutMessageHook>();
    private SendMessageBackHook sendMessageBackHook;
    private final ConcurrentSkipListMap<Integer, Long> delayLevelTable = new ConcurrentSkipListMap();
    private int maxDelayLevel;
    private final AtomicInteger mappedPageHoldCount = new AtomicInteger(0);
    private final ConcurrentLinkedQueue<BatchDispatchRequest> batchDispatchRequestQueue = new ConcurrentLinkedQueue();
    private final int dispatchRequestOrderlyQueueSize = 16;
    private final DispatchRequestOrderlyQueue dispatchRequestOrderlyQueue = new DispatchRequestOrderlyQueue(16);
    private long stateMachineVersion = 0L;
    private final ConcurrentMap<String, TopicConfig> topicConfigTable;
    private final ScheduledExecutorService scheduledCleanQueueExecutorService = ThreadUtils.newSingleThreadScheduledExecutor((ThreadFactory)new ThreadFactoryImpl("StoreCleanQueueScheduledThread"));

    public DefaultMessageStore(MessageStoreConfig messageStoreConfig, BrokerStatsManager brokerStatsManager, MessageArrivingListener messageArrivingListener, BrokerConfig brokerConfig, ConcurrentMap<String, TopicConfig> topicConfigTable) throws IOException {
        this.messageArrivingListener = messageArrivingListener;
        this.brokerConfig = brokerConfig;
        this.messageStoreConfig = messageStoreConfig;
        this.aliveReplicasNum = messageStoreConfig.getTotalReplicas();
        this.brokerStatsManager = brokerStatsManager;
        this.topicConfigTable = topicConfigTable;
        this.allocateMappedFileService = new AllocateMappedFileService(this);
        this.commitLog = messageStoreConfig.isEnableDLegerCommitLog() ? new DLedgerCommitLog(this) : new CommitLog(this);
        this.consumeQueueStore = this.createConsumeQueueStore();
        this.flushConsumeQueueService = this.createFlushConsumeQueueService();
        this.cleanCommitLogService = new CleanCommitLogService();
        this.cleanConsumeQueueService = this.createCleanConsumeQueueService();
        this.correctLogicOffsetService = this.createCorrectLogicOffsetService();
        this.storeStatsService = new StoreStatsService(this.getBrokerIdentity());
        this.indexService = new IndexService(this);
        if (!messageStoreConfig.isEnableDLegerCommitLog() && !this.messageStoreConfig.isDuplicationEnable()) {
            if (brokerConfig.isEnableControllerMode()) {
                this.haService = new AutoSwitchHAService();
                LOGGER.warn("Load AutoSwitch HA Service: {}", (Object)AutoSwitchHAService.class.getSimpleName());
            } else {
                this.haService = (HAService)ServiceProvider.loadClass(HAService.class);
                if (null == this.haService) {
                    this.haService = new DefaultHAService();
                    LOGGER.warn("Load default HA Service: {}", (Object)DefaultHAService.class.getSimpleName());
                }
            }
        }
        this.reputMessageService = !messageStoreConfig.isEnableBuildConsumeQueueConcurrently() ? new ReputMessageService() : new ConcurrentReputMessageService();
        this.transientStorePool = new TransientStorePool(messageStoreConfig.getTransientStorePoolSize(), messageStoreConfig.getMappedFileSizeCommitLog());
        this.scheduledExecutorService = ThreadUtils.newSingleThreadScheduledExecutor((ThreadFactory)new ThreadFactoryImpl("StoreScheduledThread", this.getBrokerIdentity()));
        this.dispatcherList = new LinkedList();
        this.dispatcherList.addLast(new CommitLogDispatcherBuildConsumeQueue());
        this.dispatcherList.addLast(new CommitLogDispatcherBuildIndex());
        if (messageStoreConfig.isEnableCompaction()) {
            this.compactionStore = new CompactionStore(this);
            this.compactionService = new CompactionService(this.commitLog, this, this.compactionStore);
            this.dispatcherList.addLast(new CommitLogDispatcherCompaction(this.compactionService));
        }
        File file = new File(StorePathConfigHelper.getLockFile(messageStoreConfig.getStorePathRootDir()));
        UtilAll.ensureDirOK((String)file.getParent());
        UtilAll.ensureDirOK((String)this.getStorePathPhysic());
        UtilAll.ensureDirOK((String)this.getStorePathLogic());
        this.lockFile = new RandomAccessFile(file, "rw");
        this.parseDelayLevel();
    }

    public ConsumeQueueStoreInterface createConsumeQueueStore() {
        return new ConsumeQueueStore(this);
    }

    public CleanConsumeQueueService createCleanConsumeQueueService() {
        return new CleanConsumeQueueService();
    }

    public FlushConsumeQueueService createFlushConsumeQueueService() {
        return new FlushConsumeQueueService();
    }

    public CorrectLogicOffsetService createCorrectLogicOffsetService() {
        return new CorrectLogicOffsetService();
    }

    public boolean parseDelayLevel() {
        HashMap<String, Long> timeUnitTable = new HashMap<String, Long>();
        timeUnitTable.put("s", 1000L);
        timeUnitTable.put("m", 60000L);
        timeUnitTable.put("h", 3600000L);
        timeUnitTable.put("d", 86400000L);
        String levelString = this.messageStoreConfig.getMessageDelayLevel();
        try {
            String[] levelArray = levelString.split(" ");
            for (int i = 0; i < levelArray.length; ++i) {
                String value = levelArray[i];
                String ch = value.substring(value.length() - 1);
                Long tu = (Long)timeUnitTable.get(ch);
                int level = i + 1;
                if (level > this.maxDelayLevel) {
                    this.maxDelayLevel = level;
                }
                long num = Long.parseLong(value.substring(0, value.length() - 1));
                long delayTimeMillis = tu * num;
                this.delayLevelTable.put(level, delayTimeMillis);
            }
        }
        catch (Exception e) {
            LOGGER.error("parse message delay level failed. messageDelayLevel = {}", (Object)levelString, (Object)e);
            return false;
        }
        return true;
    }

    @Override
    public void truncateDirtyLogicFiles(long phyOffset) throws RocksDBException {
        this.consumeQueueStore.truncateDirty(phyOffset);
    }

    @Override
    public boolean load() {
        boolean result = true;
        try {
            boolean lastExitOK = !this.isTempFileExist();
            LOGGER.info("last shutdown {}, store path root dir: {}", (Object)(lastExitOK ? "normally" : "abnormally"), (Object)this.messageStoreConfig.getStorePathRootDir());
            result = this.commitLog.load();
            boolean bl = result = result && this.consumeQueueStore.load();
            if (this.messageStoreConfig.isEnableCompaction()) {
                boolean bl2 = result = result && this.compactionService.load(lastExitOK);
            }
            if (result) {
                this.loadCheckPoint();
                result = this.indexService.load(lastExitOK);
                this.recover(lastExitOK);
                LOGGER.info("message store recover end, and the max phy offset = {}", (Object)this.getMaxPhyOffset());
            }
            long maxOffset = this.getMaxPhyOffset();
            this.setBrokerInitMaxOffset(maxOffset);
            LOGGER.info("load over, and the max phy offset = {}", (Object)maxOffset);
        }
        catch (Exception e) {
            LOGGER.error("load exception", (Throwable)e);
            result = false;
        }
        if (!result) {
            this.allocateMappedFileService.shutdown();
        }
        return result;
    }

    public void loadCheckPoint() throws IOException {
        this.storeCheckpoint = new StoreCheckpoint(StorePathConfigHelper.getStoreCheckpoint(this.messageStoreConfig.getStorePathRootDir()));
        this.masterFlushedOffset = this.storeCheckpoint.getMasterFlushedOffset();
        this.setConfirmOffset(this.storeCheckpoint.getConfirmPhyOffset());
    }

    @Override
    public void start() throws Exception {
        if (!this.messageStoreConfig.isEnableDLegerCommitLog() && !this.messageStoreConfig.isDuplicationEnable()) {
            this.haService.init(this);
        }
        if (this.isTransientStorePoolEnable()) {
            this.transientStorePool.init();
        }
        this.allocateMappedFileService.start();
        this.indexService.start();
        this.lock = this.lockFile.getChannel().tryLock(0L, 1L, false);
        if (this.lock == null || this.lock.isShared() || !this.lock.isValid()) {
            throw new RuntimeException("Lock failed,MQ already started");
        }
        this.lockFile.getChannel().write(ByteBuffer.wrap("lock".getBytes(StandardCharsets.UTF_8)));
        this.lockFile.getChannel().force(true);
        this.reputMessageService.setReputFromOffset(this.commitLog.getConfirmOffset());
        this.reputMessageService.start();
        this.doRecheckReputOffsetFromCq();
        this.flushConsumeQueueService.start();
        this.commitLog.start();
        this.consumeQueueStore.start();
        this.storeStatsService.start();
        if (this.haService != null) {
            this.haService.start();
        }
        this.createTempFile();
        this.addScheduleTask();
        this.perfs.start();
        this.shutdown = false;
    }

    private void doRecheckReputOffsetFromCq() throws InterruptedException {
        if (!this.messageStoreConfig.isRecheckReputOffsetFromCq()) {
            return;
        }
        long maxPhysicalPosInLogicQueue = this.commitLog.getMinOffset();
        for (ConcurrentMap maps : this.getConsumeQueueTable().values()) {
            for (ConsumeQueueInterface logic : maps.values()) {
                if (logic.getMaxPhysicOffset() <= maxPhysicalPosInLogicQueue) continue;
                maxPhysicalPosInLogicQueue = logic.getMaxPhysicOffset();
            }
        }
        if (maxPhysicalPosInLogicQueue < 0L) {
            maxPhysicalPosInLogicQueue = 0L;
        }
        if (maxPhysicalPosInLogicQueue < this.commitLog.getMinOffset()) {
            maxPhysicalPosInLogicQueue = this.commitLog.getMinOffset();
            LOGGER.warn("[TooSmallCqOffset] maxPhysicalPosInLogicQueue={} clMinOffset={}", (Object)maxPhysicalPosInLogicQueue, (Object)this.commitLog.getMinOffset());
        }
        LOGGER.info("[SetReputOffset] maxPhysicalPosInLogicQueue={} clMinOffset={} clMaxOffset={} clConfirmedOffset={}", new Object[]{maxPhysicalPosInLogicQueue, this.commitLog.getMinOffset(), this.commitLog.getMaxOffset(), this.commitLog.getConfirmOffset()});
        this.reputMessageService.setReputFromOffset(maxPhysicalPosInLogicQueue);
        while (this.dispatchBehindBytes() > 0L) {
            Thread.sleep(1000L);
            LOGGER.info("Try to finish doing reput the messages fall behind during the starting, reputOffset={} maxOffset={} behind={}", new Object[]{this.reputMessageService.getReputFromOffset(), this.getMaxPhyOffset(), this.dispatchBehindBytes()});
        }
        this.recoverTopicQueueTable();
    }

    @Override
    public void shutdown() {
        if (!this.shutdown) {
            this.shutdown = true;
            this.scheduledExecutorService.shutdown();
            this.scheduledCleanQueueExecutorService.shutdown();
            try {
                this.scheduledExecutorService.awaitTermination(3L, TimeUnit.SECONDS);
                this.scheduledCleanQueueExecutorService.awaitTermination(3L, TimeUnit.SECONDS);
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                LOGGER.error("shutdown Exception, ", (Throwable)e);
            }
            if (this.haService != null) {
                this.haService.shutdown();
            }
            this.storeStatsService.shutdown();
            this.commitLog.shutdown();
            this.reputMessageService.shutdown();
            this.consumeQueueStore.shutdown();
            this.indexService.shutdown();
            if (this.compactionService != null) {
                this.compactionService.shutdown();
            }
            if (this.rocksDBMessageStore != null && this.rocksDBMessageStore.consumeQueueStore != null) {
                this.rocksDBMessageStore.consumeQueueStore.shutdown();
            }
            this.flushConsumeQueueService.shutdown();
            this.allocateMappedFileService.shutdown();
            this.storeCheckpoint.flush();
            this.storeCheckpoint.shutdown();
            this.perfs.shutdown();
            if (this.runningFlags.isWriteable() && this.dispatchBehindBytes() == 0L) {
                this.deleteFile(StorePathConfigHelper.getAbortFile(this.messageStoreConfig.getStorePathRootDir()));
                this.shutDownNormal = true;
            } else {
                LOGGER.warn("the store may be wrong, so shutdown abnormally, and keep abort file.");
            }
        }
        this.transientStorePool.destroy();
        if (this.lockFile != null && this.lock != null) {
            try {
                this.lock.release();
                this.lockFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void destroy() {
        this.consumeQueueStore.destroy();
        this.commitLog.destroy();
        this.indexService.destroy();
        this.deleteFile(StorePathConfigHelper.getAbortFile(this.messageStoreConfig.getStorePathRootDir()));
        this.deleteFile(StorePathConfigHelper.getStoreCheckpoint(this.messageStoreConfig.getStorePathRootDir()));
    }

    public long getMajorFileSize() {
        long commitLogSize = 0L;
        if (this.commitLog != null) {
            commitLogSize = this.commitLog.getTotalSize();
        }
        long consumeQueueSize = 0L;
        if (this.consumeQueueStore != null) {
            consumeQueueSize = this.consumeQueueStore.getTotalSize();
        }
        long indexFileSize = 0L;
        if (this.indexService != null) {
            indexFileSize = this.indexService.getTotalSize();
        }
        return commitLogSize + consumeQueueSize + indexFileSize;
    }

    @Override
    public CompletableFuture<PutMessageResult> asyncPutMessage(MessageExtBrokerInner msg) {
        Optional<TopicConfig> topicConfig;
        for (PutMessageHook putMessageHook : this.putMessageHookList) {
            PutMessageResult handleResult = putMessageHook.executeBeforePutMessage((MessageExt)msg);
            if (handleResult == null) continue;
            return CompletableFuture.completedFuture(handleResult);
        }
        if (msg.getProperties().containsKey("INNER_NUM") && !MessageSysFlag.check((int)msg.getSysFlag(), (int)128)) {
            LOGGER.warn("[BUG]The message had property {} but is not an inner batch", (Object)"INNER_NUM");
            return CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.MESSAGE_ILLEGAL, null));
        }
        if (MessageSysFlag.check((int)msg.getSysFlag(), (int)128) && !QueueTypeUtils.isBatchCq(topicConfig = this.getTopicConfig(msg.getTopic()))) {
            LOGGER.error("[BUG]The message is an inner batch but cq type is not batch cq");
            return CompletableFuture.completedFuture(new PutMessageResult(PutMessageStatus.MESSAGE_ILLEGAL, null));
        }
        long beginTime = this.getSystemClock().now();
        CompletableFuture<PutMessageResult> putResultFuture = this.commitLog.asyncPutMessage(msg);
        putResultFuture.thenAccept(result -> {
            long elapsedTime = this.getSystemClock().now() - beginTime;
            if (elapsedTime > 500L) {
                LOGGER.warn("DefaultMessageStore#putMessage: CommitLog#putMessage cost {}ms, topic={}, bodyLength={}", new Object[]{elapsedTime, msg.getTopic(), msg.getBody().length});
            }
            this.storeStatsService.setPutMessageEntireTimeMax(elapsedTime);
            if (null == result || !result.isOk()) {
                this.storeStatsService.getPutMessageFailedTimes().add(1L);
            }
        });
        return putResultFuture;
    }

    @Override
    public CompletableFuture<PutMessageResult> asyncPutMessages(MessageExtBatch messageExtBatch) {
        for (PutMessageHook putMessageHook : this.putMessageHookList) {
            PutMessageResult handleResult = putMessageHook.executeBeforePutMessage((MessageExt)messageExtBatch);
            if (handleResult == null) continue;
            return CompletableFuture.completedFuture(handleResult);
        }
        long beginTime = this.getSystemClock().now();
        CompletableFuture<PutMessageResult> putResultFuture = this.commitLog.asyncPutMessages(messageExtBatch);
        putResultFuture.thenAccept(result -> {
            long eclipseTime = this.getSystemClock().now() - beginTime;
            if (eclipseTime > 500L) {
                LOGGER.warn("not in lock eclipse time(ms)={}, bodyLength={}", (Object)eclipseTime, (Object)messageExtBatch.getBody().length);
            }
            this.storeStatsService.setPutMessageEntireTimeMax(eclipseTime);
            if (null == result || !result.isOk()) {
                this.storeStatsService.getPutMessageFailedTimes().add(1L);
            }
        });
        return putResultFuture;
    }

    @Override
    public PutMessageResult putMessage(MessageExtBrokerInner msg) {
        return this.waitForPutResult(this.asyncPutMessage(msg));
    }

    @Override
    public PutMessageResult putMessages(MessageExtBatch messageExtBatch) {
        return this.waitForPutResult(this.asyncPutMessages(messageExtBatch));
    }

    private PutMessageResult waitForPutResult(CompletableFuture<PutMessageResult> putMessageResultFuture) {
        try {
            int putMessageTimeout = Math.max(this.messageStoreConfig.getSyncFlushTimeout(), this.messageStoreConfig.getSlaveTimeout()) + 5000;
            return putMessageResultFuture.get(putMessageTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException e) {
            return new PutMessageResult(PutMessageStatus.UNKNOWN_ERROR, null);
        }
        catch (TimeoutException e) {
            LOGGER.error("usually it will never timeout, putMessageTimeout is much bigger than slaveTimeout and flushTimeout so the result can be got anyway, but in some situations timeout will happen like full gc process hangs or other unexpected situations.");
            return new PutMessageResult(PutMessageStatus.UNKNOWN_ERROR, null);
        }
    }

    @Override
    public boolean isOSPageCacheBusy() {
        long begin = this.getCommitLog().getBeginTimeInLock();
        long diff = this.systemClock.now() - begin;
        return diff < 10000000L && diff > this.messageStoreConfig.getOsPageCacheBusyTimeOutMills();
    }

    @Override
    public long lockTimeMills() {
        return this.commitLog.lockTimeMills();
    }

    @Override
    public long getMasterFlushedOffset() {
        return this.masterFlushedOffset;
    }

    @Override
    public void setMasterFlushedOffset(long masterFlushedOffset) {
        this.masterFlushedOffset = masterFlushedOffset;
        this.storeCheckpoint.setMasterFlushedOffset(masterFlushedOffset);
    }

    @Override
    public long getBrokerInitMaxOffset() {
        return this.brokerInitMaxOffset;
    }

    @Override
    public void setBrokerInitMaxOffset(long brokerInitMaxOffset) {
        this.brokerInitMaxOffset = brokerInitMaxOffset;
    }

    @Override
    public SystemClock getSystemClock() {
        return this.systemClock;
    }

    @Override
    public CommitLog getCommitLog() {
        return this.commitLog;
    }

    public void truncateDirtyFiles(long offsetToTruncate) throws RocksDBException {
        LOGGER.info("truncate dirty files to {}", (Object)offsetToTruncate);
        if (offsetToTruncate >= this.getMaxPhyOffset()) {
            LOGGER.info("no need to truncate files, truncate offset is {}, max physical offset is {}", (Object)offsetToTruncate, (Object)this.getMaxPhyOffset());
            return;
        }
        this.reputMessageService.shutdown();
        long oldReputFromOffset = this.reputMessageService.getReputFromOffset();
        this.truncateDirtyLogicFiles(offsetToTruncate);
        this.commitLog.truncateDirtyFiles(offsetToTruncate);
        this.recoverTopicQueueTable();
        this.reputMessageService = !this.messageStoreConfig.isEnableBuildConsumeQueueConcurrently() ? new ReputMessageService() : new ConcurrentReputMessageService();
        long resetReputOffset = Math.min(oldReputFromOffset, offsetToTruncate);
        LOGGER.info("oldReputFromOffset is {}, reset reput from offset to {}", (Object)oldReputFromOffset, (Object)resetReputOffset);
        this.reputMessageService.setReputFromOffset(resetReputOffset);
        this.reputMessageService.start();
    }

    @Override
    public boolean truncateFiles(long offsetToTruncate) throws RocksDBException {
        if (offsetToTruncate >= this.getMaxPhyOffset()) {
            LOGGER.info("no need to truncate files, truncate offset is {}, max physical offset is {}", (Object)offsetToTruncate, (Object)this.getMaxPhyOffset());
            return true;
        }
        if (!this.isOffsetAligned(offsetToTruncate)) {
            LOGGER.error("offset {} is not align, truncate failed, need manual fix", (Object)offsetToTruncate);
            return false;
        }
        this.truncateDirtyFiles(offsetToTruncate);
        return true;
    }

    @Override
    public boolean isOffsetAligned(long offset) {
        SelectMappedBufferResult mappedBufferResult = this.getCommitLogData(offset);
        if (mappedBufferResult == null) {
            return true;
        }
        DispatchRequest dispatchRequest = this.commitLog.checkMessageAndReturnSize(mappedBufferResult.getByteBuffer(), true, false);
        return dispatchRequest.isSuccess();
    }

    @Override
    public GetMessageResult getMessage(String group, String topic, int queueId, long offset, int maxMsgNums, MessageFilter messageFilter) {
        return this.getMessage(group, topic, queueId, offset, maxMsgNums, 0x8000000, messageFilter);
    }

    @Override
    public CompletableFuture<GetMessageResult> getMessageAsync(String group, String topic, int queueId, long offset, int maxMsgNums, MessageFilter messageFilter) {
        return CompletableFuture.completedFuture(this.getMessage(group, topic, queueId, offset, maxMsgNums, messageFilter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetMessageResult getMessage(String group, String topic, int queueId, long offset, int maxMsgNums, int maxTotalMsgSize, MessageFilter messageFilter) {
        if (this.shutdown) {
            LOGGER.warn("message store has shutdown, so getMessage is forbidden");
            return null;
        }
        if (!this.runningFlags.isReadable()) {
            LOGGER.warn("message store is not readable, so getMessage is forbidden " + this.runningFlags.getFlagBits());
            return null;
        }
        Optional<TopicConfig> topicConfig = this.getTopicConfig(topic);
        CleanupPolicy policy = CleanupPolicyUtils.getDeletePolicy(topicConfig);
        if (Objects.equals(policy, CleanupPolicy.COMPACTION) && this.messageStoreConfig.isEnableCompaction()) {
            return this.compactionStore.getMessage(group, topic, queueId, offset, maxMsgNums, maxTotalMsgSize);
        }
        long beginTime = this.getSystemClock().now();
        GetMessageStatus status = GetMessageStatus.NO_MESSAGE_IN_QUEUE;
        long nextBeginOffset = offset;
        long minOffset = 0L;
        long maxOffset = 0L;
        GetMessageResult getResult = new GetMessageResult();
        long maxOffsetPy = this.commitLog.getMaxOffset();
        ConsumeQueueInterface consumeQueue = this.findConsumeQueue(topic, queueId);
        if (consumeQueue != null) {
            minOffset = consumeQueue.getMinOffsetInQueue();
            maxOffset = consumeQueue.getMaxOffsetInQueue();
            if (maxOffset == 0L) {
                status = GetMessageStatus.NO_MESSAGE_IN_QUEUE;
                nextBeginOffset = this.nextOffsetCorrection(offset, 0L);
            } else if (offset < minOffset) {
                status = GetMessageStatus.OFFSET_TOO_SMALL;
                nextBeginOffset = this.nextOffsetCorrection(offset, minOffset);
            } else if (offset == maxOffset) {
                status = GetMessageStatus.OFFSET_OVERFLOW_ONE;
                nextBeginOffset = this.nextOffsetCorrection(offset, offset);
            } else if (offset > maxOffset) {
                status = GetMessageStatus.OFFSET_OVERFLOW_BADLY;
                nextBeginOffset = this.nextOffsetCorrection(offset, maxOffset);
            } else {
                long memory;
                long diff;
                int maxFilterMessageSize = Math.max(this.messageStoreConfig.getMaxFilterMessageSize(), maxMsgNums * consumeQueue.getUnitSize());
                boolean diskFallRecorded = this.messageStoreConfig.isDiskFallRecorded();
                long maxPullSize = Math.max(maxTotalMsgSize, 100);
                if (maxPullSize > 0x8000000L) {
                    LOGGER.warn("The max pull size is too large maxPullSize={} topic={} queueId={}", new Object[]{maxPullSize, topic, queueId});
                    maxPullSize = 0x8000000L;
                }
                status = GetMessageStatus.NO_MATCHED_MESSAGE;
                long maxPhyOffsetPulling = 0L;
                int cqFileNum = 0;
                block6: while (getResult.getBufferTotalSize() <= 0 && nextBeginOffset < maxOffset && cqFileNum++ < this.messageStoreConfig.getTravelCqFileNumWhenGetMessage()) {
                    ReferredIterator<CqUnit> bufferConsumeQueue = null;
                    try {
                        bufferConsumeQueue = consumeQueue.iterateFrom(nextBeginOffset, maxMsgNums);
                        if (bufferConsumeQueue == null) {
                            status = GetMessageStatus.OFFSET_FOUND_NULL;
                            nextBeginOffset = this.nextOffsetCorrection(nextBeginOffset, this.consumeQueueStore.rollNextFile(consumeQueue, nextBeginOffset));
                            LOGGER.warn("consumer request topic: " + topic + ", offset: " + offset + ", minOffset: " + minOffset + ", maxOffset: " + maxOffset + ", but access logic queue failed. Correct nextBeginOffset to " + nextBeginOffset);
                            break;
                        }
                        long nextPhyFileStartOffset = Long.MIN_VALUE;
                        while (bufferConsumeQueue.hasNext() && nextBeginOffset < maxOffset) {
                            CqUnit cqUnit = (CqUnit)bufferConsumeQueue.next();
                            long offsetPy = cqUnit.getPos();
                            int sizePy = cqUnit.getSize();
                            boolean isInMem = this.estimateInMemByCommitOffset(offsetPy, maxOffsetPy);
                            if ((cqUnit.getQueueOffset() - offset) * (long)consumeQueue.getUnitSize() > (long)maxFilterMessageSize || this.isTheBatchFull(sizePy, cqUnit.getBatchNum(), maxMsgNums, maxPullSize, getResult.getBufferTotalSize(), getResult.getMessageCount(), isInMem) || (long)getResult.getBufferTotalSize() >= maxPullSize) continue block6;
                            maxPhyOffsetPulling = offsetPy;
                            nextBeginOffset = cqUnit.getQueueOffset() + (long)cqUnit.getBatchNum();
                            if (nextPhyFileStartOffset != Long.MIN_VALUE && offsetPy < nextPhyFileStartOffset) continue;
                            if (messageFilter != null && !messageFilter.isMatchedByConsumeQueue(cqUnit.getValidTagsCodeAsLong(), cqUnit.getCqExtUnit())) {
                                if (getResult.getBufferTotalSize() != 0) continue;
                                status = GetMessageStatus.NO_MATCHED_MESSAGE;
                                continue;
                            }
                            SelectMappedBufferResult selectResult = this.commitLog.getMessage(offsetPy, sizePy);
                            if (null == selectResult) {
                                if (getResult.getBufferTotalSize() == 0) {
                                    status = GetMessageStatus.MESSAGE_WAS_REMOVING;
                                }
                                nextPhyFileStartOffset = this.commitLog.rollNextFile(offsetPy);
                                continue;
                            }
                            if (this.messageStoreConfig.isColdDataFlowControlEnable() && !MixAll.isSysConsumerGroupForNoColdReadLimit((String)group) && !selectResult.isInCache()) {
                                getResult.setColdDataSum(getResult.getColdDataSum() + (long)sizePy);
                            }
                            if (messageFilter != null && !messageFilter.isMatchedByCommitLog(selectResult.getByteBuffer().slice(), null)) {
                                if (getResult.getBufferTotalSize() == 0) {
                                    status = GetMessageStatus.NO_MATCHED_MESSAGE;
                                }
                                selectResult.release();
                                continue;
                            }
                            this.storeStatsService.getGetMessageTransferredMsgCount().add(cqUnit.getBatchNum());
                            getResult.addMessage(selectResult, cqUnit.getQueueOffset(), cqUnit.getBatchNum());
                            status = GetMessageStatus.FOUND;
                            nextPhyFileStartOffset = Long.MIN_VALUE;
                        }
                    }
                    catch (RocksDBException e) {
                        ERROR_LOG.error("getMessage Failed. cid: {}, topic: {}, queueId: {}, offset: {}, minOffset: {}, maxOffset: {}, {}", new Object[]{group, topic, queueId, offset, minOffset, maxOffset, e.getMessage()});
                    }
                    finally {
                        if (bufferConsumeQueue == null) continue;
                        bufferConsumeQueue.release();
                    }
                }
                if (diskFallRecorded) {
                    long fallBehind = maxOffsetPy - maxPhyOffsetPulling;
                    this.brokerStatsManager.recordDiskFallBehindSize(group, topic, queueId, fallBehind);
                }
                getResult.setSuggestPullingFromSlave((diff = maxOffsetPy - maxPhyOffsetPulling) > (memory = (long)((double)StoreUtil.TOTAL_PHYSICAL_MEMORY_SIZE * ((double)this.messageStoreConfig.getAccessMessageInMemoryMaxRatio() / 100.0))));
            }
        } else {
            status = GetMessageStatus.NO_MATCHED_LOGIC_QUEUE;
            nextBeginOffset = this.nextOffsetCorrection(offset, 0L);
        }
        if (GetMessageStatus.FOUND == status) {
            this.storeStatsService.getGetMessageTimesTotalFound().add(1L);
        } else {
            this.storeStatsService.getGetMessageTimesTotalMiss().add(1L);
        }
        long elapsedTime = this.getSystemClock().now() - beginTime;
        this.storeStatsService.setGetMessageEntireTimeMax(elapsedTime);
        if (getResult == null) {
            getResult = new GetMessageResult(0);
        }
        getResult.setStatus(status);
        getResult.setNextBeginOffset(nextBeginOffset);
        getResult.setMaxOffset(maxOffset);
        getResult.setMinOffset(minOffset);
        return getResult;
    }

    @Override
    public CompletableFuture<GetMessageResult> getMessageAsync(String group, String topic, int queueId, long offset, int maxMsgNums, int maxTotalMsgSize, MessageFilter messageFilter) {
        return CompletableFuture.completedFuture(this.getMessage(group, topic, queueId, offset, maxMsgNums, maxTotalMsgSize, messageFilter));
    }

    @Override
    public long getMaxOffsetInQueue(String topic, int queueId) throws ConsumeQueueException {
        return this.getMaxOffsetInQueue(topic, queueId, true);
    }

    @Override
    public long getMaxOffsetInQueue(String topic, int queueId, boolean committed) throws ConsumeQueueException {
        if (committed) {
            ConsumeQueueInterface logic = this.getConsumeQueue(topic, queueId);
            if (logic != null) {
                return logic.getMaxOffsetInQueue();
            }
        } else {
            Long offset = this.consumeQueueStore.getMaxOffset(topic, queueId);
            if (offset != null) {
                return offset;
            }
        }
        return 0L;
    }

    @Override
    public long getMinOffsetInQueue(String topic, int queueId) {
        try {
            return this.consumeQueueStore.getMinOffsetInQueue(topic, queueId);
        }
        catch (RocksDBException e) {
            ERROR_LOG.error("getMinOffsetInQueue Failed. topic: {}, queueId: {}", new Object[]{topic, queueId, e});
            return -1L;
        }
    }

    @Override
    public TimerMessageStore getTimerMessageStore() {
        return this.timerMessageStore;
    }

    @Override
    public void setTimerMessageStore(TimerMessageStore timerMessageStore) {
        this.timerMessageStore = timerMessageStore;
    }

    @Override
    public long getCommitLogOffsetInQueue(String topic, int queueId, long consumeQueueOffset) {
        CqUnit cqUnit;
        ConsumeQueueInterface consumeQueue = this.getConsumeQueue(topic, queueId);
        if (consumeQueue != null && (cqUnit = consumeQueue.get(consumeQueueOffset)) != null) {
            return cqUnit.getPos();
        }
        return 0L;
    }

    @Override
    public long getOffsetInQueueByTime(String topic, int queueId, long timestamp) {
        return this.getOffsetInQueueByTime(topic, queueId, timestamp, BoundaryType.LOWER);
    }

    @Override
    public long getOffsetInQueueByTime(String topic, int queueId, long timestamp, BoundaryType boundaryType) {
        try {
            return this.consumeQueueStore.getOffsetInQueueByTime(topic, queueId, timestamp, boundaryType);
        }
        catch (RocksDBException e) {
            ERROR_LOG.error("getOffsetInQueueByTime Failed. topic: {}, queueId: {}, timestamp: {} boundaryType: {}, {}", new Object[]{topic, queueId, timestamp, boundaryType, e.getMessage()});
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageExt lookMessageByOffset(long commitLogOffset) {
        SelectMappedBufferResult sbr = this.commitLog.getMessage(commitLogOffset, 4);
        if (null != sbr) {
            try {
                int size = sbr.getByteBuffer().getInt();
                MessageExt messageExt = this.lookMessageByOffset(commitLogOffset, size);
                return messageExt;
            }
            finally {
                sbr.release();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SelectMappedBufferResult selectOneMessageByOffset(long commitLogOffset) {
        SelectMappedBufferResult sbr = this.commitLog.getMessage(commitLogOffset, 4);
        if (null != sbr) {
            try {
                int size = sbr.getByteBuffer().getInt();
                SelectMappedBufferResult selectMappedBufferResult = this.commitLog.getMessage(commitLogOffset, size);
                return selectMappedBufferResult;
            }
            finally {
                sbr.release();
            }
        }
        return null;
    }

    @Override
    public SelectMappedBufferResult selectOneMessageByOffset(long commitLogOffset, int msgSize) {
        return this.commitLog.getMessage(commitLogOffset, msgSize);
    }

    @Override
    public String getRunningDataInfo() {
        return this.storeStatsService.toString();
    }

    public String getStorePathPhysic() {
        String storePathPhysic = this.getMessageStoreConfig().isEnableDLegerCommitLog() ? ((DLedgerCommitLog)this.getCommitLog()).getdLedgerServer().getdLedgerConfig().getDataStorePath() : this.getMessageStoreConfig().getStorePathCommitLog();
        return storePathPhysic;
    }

    public String getStorePathLogic() {
        return StorePathConfigHelper.getStorePathConsumeQueue(this.messageStoreConfig.getStorePathRootDir());
    }

    public MessageArrivingListener getMessageArrivingListener() {
        return this.messageArrivingListener;
    }

    @Override
    public HashMap<String, String> getRuntimeInfo() {
        String[] paths;
        HashMap<String, String> result = this.storeStatsService.getRuntimeInfo();
        double minPhysicsUsedRatio = Double.MAX_VALUE;
        String commitLogStorePath = this.getStorePathPhysic();
        for (String clPath : paths = commitLogStorePath.trim().split(MixAll.MULTI_PATH_SPLITTER)) {
            double physicRatio = UtilAll.isPathExists((String)clPath) ? UtilAll.getDiskPartitionSpaceUsedPercent((String)clPath) : -1.0;
            result.put(RunningStats.commitLogDiskRatio.name() + "_" + clPath, String.valueOf(physicRatio));
            minPhysicsUsedRatio = Math.min(minPhysicsUsedRatio, physicRatio);
        }
        result.put(RunningStats.commitLogDiskRatio.name(), String.valueOf(minPhysicsUsedRatio));
        double logicsRatio = UtilAll.getDiskPartitionSpaceUsedPercent((String)this.getStorePathLogic());
        result.put(RunningStats.consumeQueueDiskRatio.name(), String.valueOf(logicsRatio));
        result.put(RunningStats.commitLogMinOffset.name(), String.valueOf(this.getMinPhyOffset()));
        result.put(RunningStats.commitLogMaxOffset.name(), String.valueOf(this.getMaxPhyOffset()));
        return result;
    }

    @Override
    public long getMaxPhyOffset() {
        return this.commitLog.getMaxOffset();
    }

    @Override
    public long getMinPhyOffset() {
        return this.commitLog.getMinOffset();
    }

    @Override
    public long getLastFileFromOffset() {
        return this.commitLog.getLastFileFromOffset();
    }

    @Override
    public boolean getLastMappedFile(long startOffset) {
        return this.commitLog.getLastMappedFile(startOffset);
    }

    @Override
    public long getEarliestMessageTime(String topic, int queueId) {
        Pair<CqUnit, Long> pair;
        ConsumeQueueInterface logicQueue = this.getConsumeQueue(topic, queueId);
        if (logicQueue != null && (pair = logicQueue.getEarliestUnitAndStoreTime()) != null && pair.getObject2() != null) {
            return (Long)pair.getObject2();
        }
        return -1L;
    }

    @Override
    public CompletableFuture<Long> getEarliestMessageTimeAsync(String topic, int queueId) {
        return CompletableFuture.completedFuture(this.getEarliestMessageTime(topic, queueId));
    }

    @Override
    public long getEarliestMessageTime() {
        long minPhyOffset = this.getMinPhyOffset();
        if (this.getCommitLog() instanceof DLedgerCommitLog) {
            minPhyOffset += 48L;
        }
        int size = 64;
        InetAddressValidator validator = InetAddressValidator.getInstance();
        if (validator.isValidInet6Address(this.brokerConfig.getBrokerIP1())) {
            size = 76;
        }
        return this.getCommitLog().pickupStoreTimestamp(minPhyOffset, size);
    }

    @Override
    public long getMessageStoreTimeStamp(String topic, int queueId, long consumeQueueOffset) {
        Pair<CqUnit, Long> pair;
        ConsumeQueueInterface logicQueue = this.getConsumeQueue(topic, queueId);
        if (logicQueue != null && (pair = logicQueue.getCqUnitAndStoreTime(consumeQueueOffset)) != null && pair.getObject2() != null) {
            return (Long)pair.getObject2();
        }
        return -1L;
    }

    @Override
    public CompletableFuture<Long> getMessageStoreTimeStampAsync(String topic, int queueId, long consumeQueueOffset) {
        return CompletableFuture.completedFuture(this.getMessageStoreTimeStamp(topic, queueId, consumeQueueOffset));
    }

    @Override
    public long getMessageTotalInQueue(String topic, int queueId) {
        ConsumeQueueInterface logicQueue = this.getConsumeQueue(topic, queueId);
        if (logicQueue != null) {
            return logicQueue.getMessageTotalInQueue();
        }
        return 0L;
    }

    @Override
    public SelectMappedBufferResult getCommitLogData(long offset) {
        if (this.shutdown) {
            LOGGER.warn("message store has shutdown, so getPhyQueueData is forbidden");
            return null;
        }
        return this.commitLog.getData(offset);
    }

    @Override
    public List<SelectMappedBufferResult> getBulkCommitLogData(long offset, int size) {
        if (this.shutdown) {
            LOGGER.warn("message store has shutdown, so getBulkCommitLogData is forbidden");
            return null;
        }
        return this.commitLog.getBulkData(offset, size);
    }

    @Override
    public boolean appendToCommitLog(long startOffset, byte[] data, int dataStart, int dataLength) {
        if (this.shutdown) {
            LOGGER.warn("message store has shutdown, so appendToCommitLog is forbidden");
            return false;
        }
        boolean result = this.commitLog.appendData(startOffset, data, dataStart, dataLength);
        if (result) {
            this.reputMessageService.wakeup();
        } else {
            LOGGER.error("DefaultMessageStore#appendToCommitLog: failed to append data to commitLog, physical offset={}, data length={}", (Object)startOffset, (Object)data.length);
        }
        return result;
    }

    @Override
    public void executeDeleteFilesManually() {
        this.cleanCommitLogService.executeDeleteFilesManually();
    }

    @Override
    public QueryMessageResult queryMessage(String topic, String key, int maxNum, long begin, long end) {
        QueryOffsetResult queryOffsetResult;
        QueryMessageResult queryMessageResult = new QueryMessageResult();
        long lastQueryMsgTime = end;
        for (int i = 0; i < 3 && !(queryOffsetResult = this.indexService.queryOffset(topic, key, maxNum, begin, lastQueryMsgTime)).getPhyOffsets().isEmpty(); ++i) {
            Collections.sort(queryOffsetResult.getPhyOffsets());
            queryMessageResult.setIndexLastUpdatePhyoffset(queryOffsetResult.getIndexLastUpdatePhyoffset());
            queryMessageResult.setIndexLastUpdateTimestamp(queryOffsetResult.getIndexLastUpdateTimestamp());
            for (int m = 0; m < queryOffsetResult.getPhyOffsets().size(); ++m) {
                long offset = queryOffsetResult.getPhyOffsets().get(m);
                try {
                    SelectMappedBufferResult result;
                    MessageExt msg = this.lookMessageByOffset(offset);
                    if (0 == m) {
                        lastQueryMsgTime = msg.getStoreTimestamp();
                    }
                    if ((result = this.commitLog.getData(offset, false)) == null) continue;
                    int size = result.getByteBuffer().getInt(0);
                    result.getByteBuffer().limit(size);
                    result.setSize(size);
                    queryMessageResult.addMessage(result);
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error("queryMessage exception", (Throwable)e);
                }
            }
            if (queryMessageResult.getBufferTotalSize() > 0 || lastQueryMsgTime < begin) break;
        }
        return queryMessageResult;
    }

    @Override
    public CompletableFuture<QueryMessageResult> queryMessageAsync(String topic, String key, int maxNum, long begin, long end) {
        return CompletableFuture.completedFuture(this.queryMessage(topic, key, maxNum, begin, end));
    }

    @Override
    public void updateHaMasterAddress(String newAddr) {
        if (this.haService != null) {
            this.haService.updateHaMasterAddress(newAddr);
        }
    }

    @Override
    public void updateMasterAddress(String newAddr) {
        if (this.haService != null) {
            this.haService.updateMasterAddress(newAddr);
        }
        if (this.compactionService != null) {
            this.compactionService.updateMasterAddress(newAddr);
        }
    }

    @Override
    public void setAliveReplicaNumInGroup(int aliveReplicaNums) {
        this.aliveReplicasNum = aliveReplicaNums;
    }

    @Override
    public void wakeupHAClient() {
        if (this.haService != null) {
            this.haService.getHAClient().wakeup();
        }
    }

    @Override
    public int getAliveReplicaNumInGroup() {
        return this.aliveReplicasNum;
    }

    @Override
    public long slaveFallBehindMuch() {
        if (this.haService == null || this.messageStoreConfig.isDuplicationEnable() || this.messageStoreConfig.isEnableDLegerCommitLog()) {
            LOGGER.warn("haServer is null or duplication is enable or enableDLegerCommitLog is true");
            return -1L;
        }
        return this.commitLog.getMaxOffset() - this.haService.getPush2SlaveMaxOffset().get();
    }

    @Override
    public long now() {
        return this.systemClock.now();
    }

    @Override
    public int deleteTopics(Set<String> deleteTopics) {
        if (deleteTopics == null || deleteTopics.isEmpty()) {
            return 0;
        }
        int deleteCount = 0;
        for (String topic : deleteTopics) {
            ConcurrentMap<Integer, ConsumeQueueInterface> queueTable = this.consumeQueueStore.findConsumeQueueMap(topic);
            if (queueTable == null || queueTable.isEmpty()) continue;
            for (ConsumeQueueInterface cq : queueTable.values()) {
                try {
                    this.consumeQueueStore.destroy(cq);
                }
                catch (RocksDBException e) {
                    LOGGER.error("DeleteTopic: ConsumeQueue cleans error!, topic={}, queueId={}", new Object[]{cq.getTopic(), cq.getQueueId(), e});
                }
                LOGGER.info("DeleteTopic: ConsumeQueue has been cleaned, topic={}, queueId={}", (Object)cq.getTopic(), (Object)cq.getQueueId());
                this.consumeQueueStore.removeTopicQueueTable(cq.getTopic(), cq.getQueueId());
            }
            this.consumeQueueStore.getConsumeQueueTable().remove(topic);
            if (this.brokerConfig.isAutoDeleteUnusedStats()) {
                this.brokerStatsManager.onTopicDeleted(topic);
            }
            String consumeQueueDir = StorePathConfigHelper.getStorePathConsumeQueue(this.messageStoreConfig.getStorePathRootDir()) + File.separator + topic;
            String consumeQueueExtDir = StorePathConfigHelper.getStorePathConsumeQueueExt(this.messageStoreConfig.getStorePathRootDir()) + File.separator + topic;
            String batchConsumeQueueDir = StorePathConfigHelper.getStorePathBatchConsumeQueue(this.messageStoreConfig.getStorePathRootDir()) + File.separator + topic;
            UtilAll.deleteEmptyDirectory((File)new File(consumeQueueDir));
            UtilAll.deleteEmptyDirectory((File)new File(consumeQueueExtDir));
            UtilAll.deleteEmptyDirectory((File)new File(batchConsumeQueueDir));
            LOGGER.info("DeleteTopic: Topic has been destroyed, topic={}", (Object)topic);
            ++deleteCount;
        }
        return deleteCount;
    }

    @Override
    public int cleanUnusedTopic(Set<String> retainTopics) {
        Set consumeQueueTopicSet = this.getConsumeQueueTable().keySet();
        int deleteCount = 0;
        for (String topicName : Sets.difference(consumeQueueTopicSet, retainTopics)) {
            if (retainTopics.contains(topicName) || TopicValidator.isSystemTopic((String)topicName) || MixAll.isLmq((String)topicName)) continue;
            deleteCount += this.deleteTopics(Sets.newHashSet((Object[])new String[]{topicName}));
        }
        return deleteCount;
    }

    @Override
    public void cleanExpiredConsumerQueue() {
        long minCommitLogOffset = this.commitLog.getMinOffset();
        this.consumeQueueStore.cleanExpired(minCommitLogOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Long> getMessageIds(String topic, int queueId, long minOffset, long maxOffset, SocketAddress storeHost) {
        HashMap<String, Long> messageIds = new HashMap<String, Long>();
        if (this.shutdown) {
            return messageIds;
        }
        ConsumeQueueInterface consumeQueue = this.findConsumeQueue(topic, queueId);
        if (consumeQueue != null) {
            minOffset = Math.max(minOffset, consumeQueue.getMinOffsetInQueue());
            if ((maxOffset = Math.min(maxOffset, consumeQueue.getMaxOffsetInQueue())) == 0L) {
                return messageIds;
            }
            long nextOffset = minOffset;
            while (nextOffset < maxOffset) {
                ReferredIterator<CqUnit> bufferConsumeQueue = consumeQueue.iterateFrom(nextOffset);
                try {
                    if (bufferConsumeQueue != null && bufferConsumeQueue.hasNext()) {
                        while (bufferConsumeQueue.hasNext()) {
                            CqUnit cqUnit = (CqUnit)bufferConsumeQueue.next();
                            long offsetPy = cqUnit.getPos();
                            InetSocketAddress inetSocketAddress = (InetSocketAddress)storeHost;
                            int msgIdLength = inetSocketAddress.getAddress() instanceof Inet6Address ? 28 : 16;
                            ByteBuffer msgIdMemory = ByteBuffer.allocate(msgIdLength);
                            String msgId = MessageDecoder.createMessageId((ByteBuffer)msgIdMemory, (ByteBuffer)MessageExt.socketAddress2ByteBuffer((SocketAddress)storeHost), (long)offsetPy);
                            messageIds.put(msgId, cqUnit.getQueueOffset());
                            nextOffset = cqUnit.getQueueOffset() + (long)cqUnit.getBatchNum();
                            if (nextOffset < maxOffset) continue;
                            HashMap<String, Long> hashMap = messageIds;
                            return hashMap;
                        }
                        continue;
                    }
                    HashMap<String, Long> hashMap = messageIds;
                    return hashMap;
                }
                finally {
                    if (bufferConsumeQueue == null) continue;
                    bufferConsumeQueue.release();
                }
            }
        }
        return messageIds;
    }

    @Override
    @Deprecated
    public boolean checkInDiskByConsumeOffset(String topic, int queueId, long consumeOffset) {
        long maxOffsetPy = this.commitLog.getMaxOffset();
        ConsumeQueueInterface consumeQueue = this.getConsumeQueue(topic, queueId);
        if (consumeQueue != null) {
            CqUnit cqUnit = consumeQueue.get(consumeOffset);
            if (cqUnit != null) {
                long offsetPy = cqUnit.getPos();
                return !this.estimateInMemByCommitOffset(offsetPy, maxOffsetPy);
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean checkInMemByConsumeOffset(String topic, int queueId, long consumeOffset, int batchSize) {
        ConsumeQueueInterface consumeQueue = this.getConsumeQueue(topic, queueId);
        if (consumeQueue != null) {
            CqUnit firstCQItem = consumeQueue.get(consumeOffset);
            if (firstCQItem == null) {
                return false;
            }
            long startOffsetPy = firstCQItem.getPos();
            if (batchSize <= 1) {
                int size = firstCQItem.getSize();
                return this.checkInMemByCommitOffset(startOffsetPy, size);
            }
            CqUnit lastCQItem = consumeQueue.get(consumeOffset + (long)batchSize);
            if (lastCQItem == null) {
                int size = firstCQItem.getSize();
                return this.checkInMemByCommitOffset(startOffsetPy, size);
            }
            long endOffsetPy = lastCQItem.getPos();
            int size = (int)(endOffsetPy - startOffsetPy) + lastCQItem.getSize();
            return this.checkInMemByCommitOffset(startOffsetPy, size);
        }
        return false;
    }

    @Override
    public boolean checkInStoreByConsumeOffset(String topic, int queueId, long consumeOffset) {
        long commitLogOffset = this.getCommitLogOffsetInQueue(topic, queueId, consumeOffset);
        return this.checkInDiskByCommitOffset(commitLogOffset);
    }

    @Override
    public long dispatchBehindBytes() {
        return this.reputMessageService.behind();
    }

    @Override
    public long dispatchBehindMilliseconds() {
        return this.reputMessageService.behindMs();
    }

    public long flushBehindBytes() {
        if (this.messageStoreConfig.isTransientStorePoolEnable()) {
            return this.commitLog.remainHowManyDataToCommit() + this.commitLog.remainHowManyDataToFlush();
        }
        return this.commitLog.remainHowManyDataToFlush();
    }

    @Override
    public long flush() {
        return this.commitLog.flush();
    }

    @Override
    public long getFlushedWhere() {
        return this.commitLog.getFlushedWhere();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean resetWriteOffset(long phyOffset) {
        long startReadOffset;
        ConcurrentHashMap<String, Long> newMap = new ConcurrentHashMap<String, Long>(this.consumeQueueStore.getTopicQueueTable());
        SelectMappedBufferResult lastBuffer = null;
        long l = startReadOffset = phyOffset == -1L ? 0L : phyOffset;
        while ((lastBuffer = this.selectOneMessageByOffset(startReadOffset)) != null) {
            try {
                if (lastBuffer.getStartOffset() > startReadOffset) {
                    startReadOffset = lastBuffer.getStartOffset();
                    continue;
                }
                ByteBuffer bb = lastBuffer.getByteBuffer();
                int magicCode = bb.getInt(bb.position() + 4);
                if (magicCode == -875286124) {
                    startReadOffset += (long)bb.getInt(bb.position());
                    continue;
                }
                if (magicCode != -626843481) {
                    throw new RuntimeException("Unknown magicCode: " + magicCode);
                }
                lastBuffer.getByteBuffer().mark();
                DispatchRequest dispatchRequest = this.checkMessageAndReturnSize(lastBuffer.getByteBuffer(), true, this.messageStoreConfig.isDuplicationEnable(), true);
                if (!dispatchRequest.isSuccess()) break;
                lastBuffer.getByteBuffer().reset();
                MessageExt msg = MessageDecoder.decode((ByteBuffer)lastBuffer.getByteBuffer(), (boolean)true, (boolean)false, (boolean)false, (boolean)false, (boolean)true);
                if (msg == null) break;
                String key = msg.getTopic() + "-" + msg.getQueueId();
                Long cur = newMap.get(key);
                if (cur != null && cur > msg.getQueueOffset()) {
                    newMap.put(key, msg.getQueueOffset());
                }
                startReadOffset += (long)msg.getStoreSize();
            }
            catch (Throwable e) {
                LOGGER.error("resetWriteOffset error.", e);
            }
            finally {
                if (lastBuffer == null) continue;
                lastBuffer.release();
            }
        }
        if (this.commitLog.resetOffset(phyOffset)) {
            this.consumeQueueStore.setTopicQueueTable(newMap);
            return true;
        }
        return false;
    }

    @Override
    public long getConfirmOffset() {
        return this.commitLog.getConfirmOffset();
    }

    public long getConfirmOffsetDirectly() {
        return this.commitLog.getConfirmOffsetDirectly();
    }

    @Override
    public void setConfirmOffset(long phyOffset) {
        this.commitLog.setConfirmOffset(phyOffset);
    }

    @Override
    public byte[] calcDeltaChecksum(long from, long to) {
        if (from < 0L || to <= from) {
            return new byte[0];
        }
        int size = (int)(to - from);
        if ((long)size > this.messageStoreConfig.getMaxChecksumRange()) {
            LOGGER.error("Checksum range from {}, size {} exceeds threshold {}", new Object[]{from, size, this.messageStoreConfig.getMaxChecksumRange()});
            return null;
        }
        ArrayList msgList = new ArrayList();
        List<SelectMappedBufferResult> bufferResultList = this.getBulkCommitLogData(from, size);
        if (bufferResultList.isEmpty()) {
            return new byte[0];
        }
        for (SelectMappedBufferResult bufferResult : bufferResultList) {
            msgList.addAll(MessageDecoder.decodesBatch((ByteBuffer)bufferResult.getByteBuffer(), (boolean)true, (boolean)false, (boolean)false));
            bufferResult.release();
        }
        if (msgList.isEmpty()) {
            return new byte[0];
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(size);
        for (MessageExt msg : msgList) {
            try {
                byteBuffer.put(MessageDecoder.encodeUniquely((MessageExt)msg, (boolean)false));
            }
            catch (IOException iOException) {}
        }
        return Hashing.murmur3_128().hashBytes(byteBuffer.array()).asBytes();
    }

    @Override
    public void setPhysicalOffset(long phyOffset) {
        this.commitLog.setMappedFileQueueOffset(phyOffset);
    }

    @Override
    public boolean isMappedFilesEmpty() {
        return this.commitLog.isMappedFilesEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageExt lookMessageByOffset(long commitLogOffset, int size) {
        SelectMappedBufferResult sbr = this.commitLog.getMessage(commitLogOffset, size);
        if (null != sbr) {
            try {
                MessageExt messageExt = MessageDecoder.decode((ByteBuffer)sbr.getByteBuffer(), (boolean)true, (boolean)false);
                return messageExt;
            }
            finally {
                sbr.release();
            }
        }
        return null;
    }

    @Override
    public ConsumeQueueInterface findConsumeQueue(String topic, int queueId) {
        return this.consumeQueueStore.findOrCreateConsumeQueue(topic, queueId);
    }

    private long nextOffsetCorrection(long oldOffset, long newOffset) {
        long nextOffset = oldOffset;
        if (this.getMessageStoreConfig().getBrokerRole() != BrokerRole.SLAVE || this.getMessageStoreConfig().isOffsetCheckInSlave()) {
            nextOffset = newOffset;
        }
        return nextOffset;
    }

    private boolean estimateInMemByCommitOffset(long offsetPy, long maxOffsetPy) {
        long memory = (long)((double)StoreUtil.TOTAL_PHYSICAL_MEMORY_SIZE * ((double)this.messageStoreConfig.getAccessMessageInMemoryMaxRatio() / 100.0));
        return maxOffsetPy - offsetPy <= memory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkInMemByCommitOffset(long offsetPy, int size) {
        SelectMappedBufferResult message = this.commitLog.getMessage(offsetPy, size);
        if (message != null) {
            try {
                boolean bl = message.isInMem();
                return bl;
            }
            finally {
                message.release();
            }
        }
        return false;
    }

    public boolean checkInDiskByCommitOffset(long offsetPy) {
        return offsetPy >= this.commitLog.getMinOffset();
    }

    public boolean checkInColdAreaByCommitOffset(long offsetPy, long maxOffsetPy) {
        long memory = (long)((double)StoreUtil.TOTAL_PHYSICAL_MEMORY_SIZE * ((double)this.messageStoreConfig.getAccessMessageInMemoryHotRatio() / 100.0));
        return maxOffsetPy - offsetPy > memory;
    }

    private boolean isTheBatchFull(int sizePy, int unitBatchNum, int maxMsgNums, long maxMsgSize, int bufferTotal, int messageTotal, boolean isInMem) {
        if (0 == bufferTotal || 0 == messageTotal) {
            return false;
        }
        if (messageTotal + unitBatchNum > maxMsgNums) {
            return true;
        }
        if ((long)(bufferTotal + sizePy) > maxMsgSize) {
            return true;
        }
        if (isInMem) {
            if (bufferTotal + sizePy > this.messageStoreConfig.getMaxTransferBytesOnMessageInMemory()) {
                return true;
            }
            return messageTotal > this.messageStoreConfig.getMaxTransferCountOnMessageInMemory() - 1;
        }
        if (bufferTotal + sizePy > this.messageStoreConfig.getMaxTransferBytesOnMessageInDisk()) {
            return true;
        }
        return messageTotal > this.messageStoreConfig.getMaxTransferCountOnMessageInDisk() - 1;
    }

    private void deleteFile(String fileName) {
        File file = new File(fileName);
        boolean result = file.delete();
        LOGGER.info(fileName + (result ? " delete OK" : " delete Failed"));
    }

    private void createTempFile() throws IOException {
        String fileName = StorePathConfigHelper.getAbortFile(this.messageStoreConfig.getStorePathRootDir());
        File file = new File(fileName);
        UtilAll.ensureDirOK((String)file.getParent());
        boolean result = file.createNewFile();
        LOGGER.info(fileName + (result ? " create OK" : " already exists"));
        MixAll.string2File((String)Long.toString(MixAll.getPID()), (String)file.getAbsolutePath());
    }

    private void addScheduleTask() {
        this.scheduledExecutorService.scheduleAtFixedRate((Runnable)new AbstractBrokerRunnable(this.getBrokerIdentity()){

            public void run0() {
                DefaultMessageStore.this.cleanFilesPeriodically();
            }
        }, 60000L, this.messageStoreConfig.getCleanResourceInterval(), TimeUnit.MILLISECONDS);
        this.scheduledExecutorService.scheduleAtFixedRate((Runnable)new AbstractBrokerRunnable(this.getBrokerIdentity()){

            public void run0() {
                DefaultMessageStore.this.checkSelf();
            }
        }, 1L, 10L, TimeUnit.MINUTES);
        this.scheduledExecutorService.scheduleAtFixedRate((Runnable)new AbstractBrokerRunnable(this.getBrokerIdentity()){

            public void run0() {
                if (DefaultMessageStore.this.getMessageStoreConfig().isDebugLockEnable()) {
                    try {
                        long lockTime;
                        if (DefaultMessageStore.this.commitLog.getBeginTimeInLock() != 0L && (lockTime = System.currentTimeMillis() - DefaultMessageStore.this.commitLog.getBeginTimeInLock()) > 1000L && lockTime < 10000000L) {
                            String stack = UtilAll.jstack();
                            String fileName = System.getProperty("user.home") + File.separator + "debug/lock/stack-" + DefaultMessageStore.this.commitLog.getBeginTimeInLock() + "-" + lockTime;
                            MixAll.string2FileNotSafe((String)stack, (String)fileName);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }, 1L, 1L, TimeUnit.SECONDS);
        this.scheduledExecutorService.scheduleAtFixedRate((Runnable)new AbstractBrokerRunnable(this.getBrokerIdentity()){

            public void run0() {
                DefaultMessageStore.this.storeCheckpoint.flush();
            }
        }, 1L, 1L, TimeUnit.SECONDS);
        this.scheduledCleanQueueExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                DefaultMessageStore.this.cleanQueueFilesPeriodically();
            }
        }, 60000L, this.messageStoreConfig.getCleanResourceInterval(), TimeUnit.MILLISECONDS);
    }

    private void cleanFilesPeriodically() {
        this.cleanCommitLogService.run();
    }

    private void cleanQueueFilesPeriodically() {
        this.correctLogicOffsetService.run();
        this.cleanConsumeQueueService.run();
    }

    private void checkSelf() {
        this.commitLog.checkSelf();
        this.consumeQueueStore.checkSelf();
    }

    private boolean isTempFileExist() {
        String fileName = StorePathConfigHelper.getAbortFile(this.messageStoreConfig.getStorePathRootDir());
        File file = new File(fileName);
        return file.exists();
    }

    private boolean isRecoverConcurrently() {
        return this.brokerConfig.isRecoverConcurrently() && !this.messageStoreConfig.isEnableRocksDBStore();
    }

    private void recover(boolean lastExitOK) throws RocksDBException {
        boolean recoverConcurrently = this.isRecoverConcurrently();
        LOGGER.info("message store recover mode: {}", (Object)(recoverConcurrently ? "concurrent" : "normal"));
        long recoverConsumeQueueStart = System.currentTimeMillis();
        this.recoverConsumeQueue();
        long maxPhyOffsetOfConsumeQueue = this.consumeQueueStore.getMaxPhyOffsetInConsumeQueue();
        long recoverConsumeQueueEnd = System.currentTimeMillis();
        if (lastExitOK) {
            this.commitLog.recoverNormally(maxPhyOffsetOfConsumeQueue);
        } else {
            this.commitLog.recoverAbnormally(maxPhyOffsetOfConsumeQueue);
        }
        long recoverCommitLogEnd = System.currentTimeMillis();
        this.recoverTopicQueueTable();
        long recoverConsumeOffsetEnd = System.currentTimeMillis();
        LOGGER.info("message store recover total cost: {} ms, recoverConsumeQueue: {} ms, recoverCommitLog: {} ms, recoverOffsetTable: {} ms", new Object[]{recoverConsumeOffsetEnd - recoverConsumeQueueStart, recoverConsumeQueueEnd - recoverConsumeQueueStart, recoverCommitLogEnd - recoverConsumeQueueEnd, recoverConsumeOffsetEnd - recoverCommitLogEnd});
    }

    @Override
    public long getTimingMessageCount(String topic) {
        if (null == this.timerMessageStore) {
            return 0L;
        }
        return this.timerMessageStore.getTimerMetrics().getTimingCount(topic);
    }

    @Override
    public MessageStoreConfig getMessageStoreConfig() {
        return this.messageStoreConfig;
    }

    @Override
    public TransientStorePool getTransientStorePool() {
        return this.transientStorePool;
    }

    private void recoverConsumeQueue() {
        if (!this.isRecoverConcurrently()) {
            this.consumeQueueStore.recover();
        } else {
            this.consumeQueueStore.recoverConcurrently();
        }
    }

    @Override
    public void recoverTopicQueueTable() {
        long minPhyOffset = this.commitLog.getMinOffset();
        this.consumeQueueStore.recoverOffsetTable(minPhyOffset);
    }

    @Override
    public AllocateMappedFileService getAllocateMappedFileService() {
        return this.allocateMappedFileService;
    }

    @Override
    public StoreStatsService getStoreStatsService() {
        return this.storeStatsService;
    }

    public RunningFlags getAccessRights() {
        return this.runningFlags;
    }

    public ConcurrentMap<String, ConcurrentMap<Integer, ConsumeQueueInterface>> getConsumeQueueTable() {
        return this.consumeQueueStore.getConsumeQueueTable();
    }

    @Override
    public StoreCheckpoint getStoreCheckpoint() {
        return this.storeCheckpoint;
    }

    @Override
    public HAService getHaService() {
        return this.haService;
    }

    @Override
    public RunningFlags getRunningFlags() {
        return this.runningFlags;
    }

    public void doDispatch(DispatchRequest req) throws RocksDBException {
        for (CommitLogDispatcher dispatcher : this.dispatcherList) {
            dispatcher.dispatch(req);
        }
    }

    protected void putMessagePositionInfo(DispatchRequest dispatchRequest) throws RocksDBException {
        this.consumeQueueStore.putMessagePositionInfoWrapper(dispatchRequest);
    }

    @Override
    public DispatchRequest checkMessageAndReturnSize(ByteBuffer byteBuffer, boolean checkCRC, boolean checkDupInfo, boolean readBody) {
        return this.commitLog.checkMessageAndReturnSize(byteBuffer, checkCRC, checkDupInfo, readBody);
    }

    @Override
    public long getStateMachineVersion() {
        return this.stateMachineVersion;
    }

    public void setStateMachineVersion(long stateMachineVersion) {
        this.stateMachineVersion = stateMachineVersion;
    }

    @Override
    public BrokerStatsManager getBrokerStatsManager() {
        return this.brokerStatsManager;
    }

    public BrokerConfig getBrokerConfig() {
        return this.brokerConfig;
    }

    @Override
    public int remainTransientStoreBufferNumbs() {
        if (this.isTransientStorePoolEnable()) {
            return this.transientStorePool.availableBufferNums();
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isTransientStorePoolDeficient() {
        return this.remainTransientStoreBufferNumbs() == 0;
    }

    @Override
    public long remainHowManyDataToCommit() {
        return this.commitLog.remainHowManyDataToCommit();
    }

    @Override
    public long remainHowManyDataToFlush() {
        return this.commitLog.remainHowManyDataToFlush();
    }

    @Override
    public LinkedList<CommitLogDispatcher> getDispatcherList() {
        return this.dispatcherList;
    }

    @Override
    public void addDispatcher(CommitLogDispatcher dispatcher) {
        this.dispatcherList.add(dispatcher);
    }

    @Override
    public void setMasterStoreInProcess(MessageStore masterStoreInProcess) {
        this.masterStoreInProcess = masterStoreInProcess;
    }

    @Override
    public MessageStore getMasterStoreInProcess() {
        return this.masterStoreInProcess;
    }

    @Override
    public boolean getData(long offset, int size, ByteBuffer byteBuffer) {
        return this.commitLog.getData(offset, size, byteBuffer);
    }

    @Override
    public ConsumeQueueInterface getConsumeQueue(String topic, int queueId) {
        ConcurrentMap map = (ConcurrentMap)this.getConsumeQueueTable().get(topic);
        if (map == null) {
            return null;
        }
        return (ConsumeQueueInterface)map.get(queueId);
    }

    @Override
    public void unlockMappedFile(final MappedFile mappedFile) {
        this.scheduledExecutorService.schedule(new Runnable(){

            @Override
            public void run() {
                mappedFile.munlock();
            }
        }, 6L, TimeUnit.SECONDS);
    }

    @Override
    public PerfCounter.Ticks getPerfCounter() {
        return this.perfs;
    }

    @Override
    public ConsumeQueueStoreInterface getQueueStore() {
        return this.consumeQueueStore;
    }

    @Override
    public void onCommitLogAppend(MessageExtBrokerInner msg, AppendMessageResult result, MappedFile commitLogFile) {
    }

    @Override
    public void onCommitLogDispatch(DispatchRequest dispatchRequest, boolean doDispatch, MappedFile commitLogFile, boolean isRecover, boolean isFileEnd) throws RocksDBException {
        if (doDispatch && !isFileEnd) {
            this.doDispatch(dispatchRequest);
        }
    }

    @Override
    public boolean isSyncDiskFlush() {
        return FlushDiskType.SYNC_FLUSH == this.getMessageStoreConfig().getFlushDiskType();
    }

    @Override
    public boolean isSyncMaster() {
        return BrokerRole.SYNC_MASTER == this.getMessageStoreConfig().getBrokerRole();
    }

    @Override
    public void assignOffset(MessageExtBrokerInner msg) throws RocksDBException {
        int tranType = MessageSysFlag.getTransactionValue((int)msg.getSysFlag());
        if (tranType == 0 || tranType == 8) {
            this.consumeQueueStore.assignQueueOffset(msg);
        }
    }

    @Override
    public void increaseOffset(MessageExtBrokerInner msg, short messageNum) {
        int tranType = MessageSysFlag.getTransactionValue((int)msg.getSysFlag());
        if (tranType == 0 || tranType == 8) {
            this.consumeQueueStore.increaseQueueOffset(msg, messageNum);
        }
    }

    public ConcurrentMap<String, TopicConfig> getTopicConfigs() {
        return this.topicConfigTable;
    }

    public Optional<TopicConfig> getTopicConfig(String topic) {
        if (this.topicConfigTable == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.topicConfigTable.get(topic));
    }

    public BrokerIdentity getBrokerIdentity() {
        if (this.messageStoreConfig.isEnableDLegerCommitLog()) {
            return new BrokerIdentity(this.brokerConfig.getBrokerClusterName(), this.brokerConfig.getBrokerName(), (long)Integer.parseInt(this.messageStoreConfig.getdLegerSelfId().substring(1)), this.brokerConfig.isInBrokerContainer());
        }
        return new BrokerIdentity(this.brokerConfig.getBrokerClusterName(), this.brokerConfig.getBrokerName(), this.brokerConfig.getBrokerId(), this.brokerConfig.isInBrokerContainer());
    }

    @Override
    public void notifyMessageArriveIfNecessary(DispatchRequest dispatchRequest) {
        if (this.brokerConfig.isLongPollingEnable() && this.messageArrivingListener != null) {
            this.messageArrivingListener.arriving(dispatchRequest.getTopic(), dispatchRequest.getQueueId(), dispatchRequest.getConsumeQueueOffset() + 1L, dispatchRequest.getTagsCode(), dispatchRequest.getStoreTimestamp(), dispatchRequest.getBitMap(), dispatchRequest.getPropertiesMap());
            this.reputMessageService.notifyMessageArrive4MultiQueue(dispatchRequest);
        }
    }

    @Override
    public HARuntimeInfo getHARuntimeInfo() {
        if (this.haService != null) {
            return this.haService.getRuntimeInfo(this.commitLog.getMaxOffset());
        }
        return null;
    }

    public void enableRocksdbCQWrite() {
        try {
            RocksDBMessageStore store;
            this.rocksDBMessageStore = store = new RocksDBMessageStore(this.messageStoreConfig, this.brokerStatsManager, this.messageArrivingListener, this.brokerConfig, this.topicConfigTable);
            store.loadAndStartConsumerServiceOnly();
            this.addDispatcher(store.getDispatcherBuildRocksdbConsumeQueue());
        }
        catch (Exception e) {
            LOGGER.error("enableRocksdbCqWrite error", (Throwable)e);
        }
    }

    public int getMaxDelayLevel() {
        return this.maxDelayLevel;
    }

    public long computeDeliverTimestamp(int delayLevel, long storeTimestamp) {
        Long time = this.delayLevelTable.get(delayLevel);
        if (time != null) {
            return time + storeTimestamp;
        }
        return storeTimestamp + 1000L;
    }

    @Override
    public List<PutMessageHook> getPutMessageHookList() {
        return this.putMessageHookList;
    }

    @Override
    public void setSendMessageBackHook(SendMessageBackHook sendMessageBackHook) {
        this.sendMessageBackHook = sendMessageBackHook;
    }

    @Override
    public SendMessageBackHook getSendMessageBackHook() {
        return this.sendMessageBackHook;
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public long estimateMessageCount(String topic, int queueId, long from, long to, MessageFilter filter) {
        long msgCount;
        if (from < 0L) {
            from = 0L;
        }
        if (from >= to) {
            return 0L;
        }
        if (null == filter) {
            return to - from;
        }
        ConsumeQueueInterface consumeQueue = this.findConsumeQueue(topic, queueId);
        if (null == consumeQueue) {
            return 0L;
        }
        long minOffset = consumeQueue.getMinOffsetInQueue();
        if (from < minOffset) {
            long diff = to - from;
            from = minOffset;
            to = from + diff;
        }
        return (msgCount = consumeQueue.estimateMessageCount(from, to, filter)) == -1L ? to - from : msgCount;
    }

    @Override
    public List<Pair<InstrumentSelector, ViewBuilder>> getMetricsView() {
        return DefaultStoreMetricsManager.getMetricsView();
    }

    @Override
    public void initMetrics(Meter meter, Supplier<AttributesBuilder> attributesBuilderSupplier) {
        DefaultStoreMetricsManager.init(meter, attributesBuilderSupplier, this);
    }

    public boolean isTransientStorePoolEnable() {
        return this.messageStoreConfig.isTransientStorePoolEnable() && (this.brokerConfig.isEnableControllerMode() || this.messageStoreConfig.getBrokerRole() != BrokerRole.SLAVE);
    }

    public long getReputFromOffset() {
        return this.reputMessageService.getReputFromOffset();
    }

    public RocksDBMessageStore getRocksDBMessageStore() {
        return this.rocksDBMessageStore;
    }

    public ConsumeQueueStoreInterface getConsumeQueueStore() {
        return this.consumeQueueStore;
    }

    class ConcurrentReputMessageService
    extends ReputMessageService {
        private static final int BATCH_SIZE = 0x400000;
        private long batchId;
        private MainBatchDispatchRequestService mainBatchDispatchRequestService;
        private DispatchService dispatchService;

        public ConcurrentReputMessageService() {
            this.batchId = 0L;
            this.mainBatchDispatchRequestService = new MainBatchDispatchRequestService();
            this.dispatchService = new DispatchService();
        }

        public void createBatchDispatchRequest(ByteBuffer byteBuffer, int position, int size) {
            if (position < 0) {
                return;
            }
            DefaultMessageStore.this.mappedPageHoldCount.getAndIncrement();
            BatchDispatchRequest task = new BatchDispatchRequest(byteBuffer.duplicate(), position, size, this.batchId++);
            DefaultMessageStore.this.batchDispatchRequestQueue.offer(task);
        }

        public void start() {
            super.start();
            this.mainBatchDispatchRequestService.start();
            this.dispatchService.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doReput() {
            SelectMappedBufferResult result;
            if (this.reputFromOffset < DefaultMessageStore.this.commitLog.getMinOffset()) {
                LOGGER.warn("The reputFromOffset={} is smaller than minPyOffset={}, this usually indicate that the dispatch behind too much and the commitlog has expired.", (Object)this.reputFromOffset, (Object)DefaultMessageStore.this.commitLog.getMinOffset());
                this.reputFromOffset = DefaultMessageStore.this.commitLog.getMinOffset();
            }
            boolean doNext = true;
            while (this.isCommitLogAvailable() && doNext && (result = DefaultMessageStore.this.commitLog.getData(this.reputFromOffset)) != null) {
                boolean over;
                int batchDispatchRequestStart = -1;
                int batchDispatchRequestSize = -1;
                try {
                    this.reputFromOffset = result.getStartOffset();
                    int readSize = 0;
                    while (readSize < result.getSize() && this.reputFromOffset < this.getReputEndOffset() && doNext) {
                        ByteBuffer byteBuffer = result.getByteBuffer();
                        int totalSize = this.preCheckMessageAndReturnSize(byteBuffer);
                        if (totalSize > 0) {
                            if (batchDispatchRequestStart == -1) {
                                batchDispatchRequestStart = byteBuffer.position();
                                batchDispatchRequestSize = 0;
                            }
                            if ((batchDispatchRequestSize += totalSize) > 0x400000) {
                                this.createBatchDispatchRequest(byteBuffer, batchDispatchRequestStart, batchDispatchRequestSize);
                                batchDispatchRequestStart = -1;
                                batchDispatchRequestSize = -1;
                            }
                            byteBuffer.position(byteBuffer.position() + totalSize);
                            this.reputFromOffset += (long)totalSize;
                            readSize += totalSize;
                            continue;
                        }
                        doNext = false;
                        if (totalSize == 0) {
                            this.reputFromOffset = DefaultMessageStore.this.commitLog.rollNextFile(this.reputFromOffset);
                        }
                        this.createBatchDispatchRequest(byteBuffer, batchDispatchRequestStart, batchDispatchRequestSize);
                        batchDispatchRequestStart = -1;
                        batchDispatchRequestSize = -1;
                    }
                    this.createBatchDispatchRequest(result.getByteBuffer(), batchDispatchRequestStart, batchDispatchRequestSize);
                    boolean bl = over = DefaultMessageStore.this.mappedPageHoldCount.get() == 0;
                }
                catch (Throwable throwable) {
                    boolean over2;
                    this.createBatchDispatchRequest(result.getByteBuffer(), batchDispatchRequestStart, batchDispatchRequestSize);
                    boolean bl = over2 = DefaultMessageStore.this.mappedPageHoldCount.get() == 0;
                    while (!over2) {
                        try {
                            TimeUnit.MILLISECONDS.sleep(1L);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        over2 = DefaultMessageStore.this.mappedPageHoldCount.get() == 0;
                    }
                    result.release();
                    throw throwable;
                }
                while (!over) {
                    try {
                        TimeUnit.MILLISECONDS.sleep(1L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    over = DefaultMessageStore.this.mappedPageHoldCount.get() == 0;
                }
                result.release();
            }
        }

        public int preCheckMessageAndReturnSize(ByteBuffer byteBuffer) {
            byteBuffer.mark();
            int totalSize = byteBuffer.getInt();
            if (this.reputFromOffset + (long)totalSize > DefaultMessageStore.this.getConfirmOffset()) {
                return -1;
            }
            int magicCode = byteBuffer.getInt();
            switch (magicCode) {
                case -626843481: 
                case -626843477: {
                    break;
                }
                case -875286124: {
                    return 0;
                }
                default: {
                    return -1;
                }
            }
            byteBuffer.reset();
            return totalSize;
        }

        @Override
        public void shutdown() {
            for (int i = 0; i < 50 && this.isCommitLogAvailable(); ++i) {
                try {
                    TimeUnit.MILLISECONDS.sleep(100L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.isCommitLogAvailable()) {
                LOGGER.warn("shutdown concurrentReputMessageService, but CommitLog have not finish to be dispatched, CommitLog max offset={}, reputFromOffset={}", (Object)DefaultMessageStore.this.commitLog.getMaxOffset(), (Object)this.reputFromOffset);
            }
            this.mainBatchDispatchRequestService.shutdown();
            this.dispatchService.shutdown();
            super.shutdown();
        }

        @Override
        public String getServiceName() {
            if (DefaultMessageStore.this.getBrokerConfig().isInBrokerContainer()) {
                return DefaultMessageStore.this.getBrokerIdentity().getIdentifier() + ConcurrentReputMessageService.class.getSimpleName();
            }
            return ConcurrentReputMessageService.class.getSimpleName();
        }
    }

    class DispatchService
    extends ServiceThread {
        private final List<DispatchRequest[]> dispatchRequestsList = new ArrayList<DispatchRequest[]>();

        DispatchService() {
        }

        private void dispatch() throws Exception {
            this.dispatchRequestsList.clear();
            DefaultMessageStore.this.dispatchRequestOrderlyQueue.get(this.dispatchRequestsList);
            if (!this.dispatchRequestsList.isEmpty()) {
                for (DispatchRequest[] dispatchRequests : this.dispatchRequestsList) {
                    for (DispatchRequest dispatchRequest : dispatchRequests) {
                        DefaultMessageStore.this.doDispatch(dispatchRequest);
                        DefaultMessageStore.this.notifyMessageArriveIfNecessary(dispatchRequest);
                        if (DefaultMessageStore.this.getMessageStoreConfig().isDuplicationEnable() || DefaultMessageStore.this.getMessageStoreConfig().getBrokerRole() != BrokerRole.SLAVE) continue;
                        DefaultMessageStore.this.storeStatsService.getSinglePutMessageTopicTimesTotal(dispatchRequest.getTopic()).add(1L);
                        DefaultMessageStore.this.storeStatsService.getSinglePutMessageTopicSizeTotal(dispatchRequest.getTopic()).add(dispatchRequest.getMsgSize());
                    }
                }
            }
        }

        public void run() {
            LOGGER.info(this.getServiceName() + " service started");
            while (!this.isStopped()) {
                try {
                    TimeUnit.MILLISECONDS.sleep(1L);
                    this.dispatch();
                }
                catch (Exception e) {
                    LOGGER.warn(this.getServiceName() + " service has exception. ", (Throwable)e);
                }
            }
            LOGGER.info(this.getServiceName() + " service end");
        }

        public String getServiceName() {
            if (DefaultMessageStore.this.getBrokerConfig().isInBrokerContainer()) {
                return DefaultMessageStore.this.getBrokerIdentity().getIdentifier() + DispatchService.class.getSimpleName();
            }
            return DispatchService.class.getSimpleName();
        }
    }

    class MainBatchDispatchRequestService
    extends ServiceThread {
        private final ExecutorService batchDispatchRequestExecutor;

        public MainBatchDispatchRequestService() {
            this.batchDispatchRequestExecutor = ThreadUtils.newThreadPoolExecutor((int)DefaultMessageStore.this.getMessageStoreConfig().getBatchDispatchRequestThreadPoolNums(), (int)DefaultMessageStore.this.getMessageStoreConfig().getBatchDispatchRequestThreadPoolNums(), (long)60000L, (TimeUnit)TimeUnit.MICROSECONDS, new LinkedBlockingQueue(4096), (ThreadFactory)new ThreadFactoryImpl("BatchDispatchRequestServiceThread_"), (RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
        }

        private void pollBatchDispatchRequest() {
            try {
                if (!DefaultMessageStore.this.batchDispatchRequestQueue.isEmpty()) {
                    BatchDispatchRequest task = (BatchDispatchRequest)DefaultMessageStore.this.batchDispatchRequestQueue.peek();
                    this.batchDispatchRequestExecutor.execute(() -> {
                        try {
                            ByteBuffer tmpByteBuffer = task.byteBuffer;
                            tmpByteBuffer.position(task.position);
                            tmpByteBuffer.limit(task.position + task.size);
                            ArrayList<DispatchRequest> dispatchRequestList = new ArrayList<DispatchRequest>();
                            while (tmpByteBuffer.hasRemaining()) {
                                DispatchRequest dispatchRequest = DefaultMessageStore.this.commitLog.checkMessageAndReturnSize(tmpByteBuffer, false, false, false);
                                if (dispatchRequest.isSuccess()) {
                                    dispatchRequestList.add(dispatchRequest);
                                    continue;
                                }
                                LOGGER.error("[BUG]read total count not equals msg total size.");
                            }
                            DefaultMessageStore.this.dispatchRequestOrderlyQueue.put(task.id, dispatchRequestList.toArray(new DispatchRequest[dispatchRequestList.size()]));
                            DefaultMessageStore.this.mappedPageHoldCount.getAndDecrement();
                        }
                        catch (Exception e) {
                            LOGGER.error("There is an exception in task execution.", (Throwable)e);
                        }
                    });
                    DefaultMessageStore.this.batchDispatchRequestQueue.poll();
                }
            }
            catch (Exception e) {
                LOGGER.warn(this.getServiceName() + " service has exception. ", (Throwable)e);
            }
        }

        public void run() {
            LOGGER.info(this.getServiceName() + " service started");
            while (!this.isStopped()) {
                try {
                    TimeUnit.MILLISECONDS.sleep(1L);
                    this.pollBatchDispatchRequest();
                }
                catch (Exception e) {
                    LOGGER.warn(this.getServiceName() + " service has exception. ", (Throwable)e);
                }
            }
            LOGGER.info(this.getServiceName() + " service end");
        }

        public String getServiceName() {
            if (DefaultMessageStore.this.getBrokerConfig().isInBrokerContainer()) {
                return DefaultMessageStore.this.getBrokerIdentity().getIdentifier() + MainBatchDispatchRequestService.class.getSimpleName();
            }
            return MainBatchDispatchRequestService.class.getSimpleName();
        }
    }

    class ReputMessageService
    extends ServiceThread {
        protected volatile long reputFromOffset = 0L;
        protected volatile long currentReputTimestamp = System.currentTimeMillis();

        ReputMessageService() {
        }

        public long getReputFromOffset() {
            return this.reputFromOffset;
        }

        public void setReputFromOffset(long reputFromOffset) {
            this.reputFromOffset = reputFromOffset;
        }

        public long getCurrentReputTimestamp() {
            return this.currentReputTimestamp;
        }

        public void shutdown() {
            for (int i = 0; i < 50 && this.isCommitLogAvailable(); ++i) {
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.isCommitLogAvailable()) {
                LOGGER.warn("shutdown ReputMessageService, but CommitLog have not finish to be dispatched, CommitLog max offset={}, reputFromOffset={}", (Object)DefaultMessageStore.this.commitLog.getMaxOffset(), (Object)this.reputFromOffset);
            }
            super.shutdown();
        }

        public long behind() {
            return DefaultMessageStore.this.getConfirmOffset() - this.reputFromOffset;
        }

        public long behindMs() {
            long lastCommitLogFileTimeStamp = System.currentTimeMillis();
            MappedFile lastMappedFile = DefaultMessageStore.this.commitLog.getMappedFileQueue().getLastMappedFile();
            if (lastMappedFile != null) {
                lastCommitLogFileTimeStamp = lastMappedFile.getStoreTimestamp();
            }
            return Math.max(0L, lastCommitLogFileTimeStamp - this.currentReputTimestamp);
        }

        public boolean isCommitLogAvailable() {
            return this.reputFromOffset < this.getReputEndOffset();
        }

        protected long getReputEndOffset() {
            return DefaultMessageStore.this.getMessageStoreConfig().isReadUnCommitted() ? DefaultMessageStore.this.commitLog.getMaxOffset() : DefaultMessageStore.this.commitLog.getConfirmOffset();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doReput() {
            SelectMappedBufferResult result;
            boolean isCommitLogAvailable;
            if (this.reputFromOffset < DefaultMessageStore.this.commitLog.getMinOffset()) {
                LOGGER.warn("The reputFromOffset={} is smaller than minPyOffset={}, this usually indicate that the dispatch behind too much and the commitlog has expired.", (Object)this.reputFromOffset, (Object)DefaultMessageStore.this.commitLog.getMinOffset());
                this.reputFromOffset = DefaultMessageStore.this.commitLog.getMinOffset();
            }
            if (!(isCommitLogAvailable = this.isCommitLogAvailable())) {
                this.currentReputTimestamp = System.currentTimeMillis();
            }
            boolean doNext = true;
            block5: while (isCommitLogAvailable && doNext && (result = DefaultMessageStore.this.commitLog.getData(this.reputFromOffset)) != null) {
                try {
                    this.reputFromOffset = result.getStartOffset();
                    int readSize = 0;
                    while (readSize < result.getSize() && this.reputFromOffset < this.getReputEndOffset() && doNext) {
                        int size;
                        DispatchRequest dispatchRequest = DefaultMessageStore.this.commitLog.checkMessageAndReturnSize(result.getByteBuffer(), false, false, false);
                        int n = size = dispatchRequest.getBufferSize() == -1 ? dispatchRequest.getMsgSize() : dispatchRequest.getBufferSize();
                        if (this.reputFromOffset + (long)size > this.getReputEndOffset()) {
                            doNext = false;
                            continue block5;
                        }
                        if (dispatchRequest.isSuccess()) {
                            if (size > 0) {
                                this.currentReputTimestamp = dispatchRequest.getStoreTimestamp();
                                DefaultMessageStore.this.doDispatch(dispatchRequest);
                                if (!DefaultMessageStore.this.notifyMessageArriveInBatch) {
                                    DefaultMessageStore.this.notifyMessageArriveIfNecessary(dispatchRequest);
                                }
                                this.reputFromOffset += (long)size;
                                readSize += size;
                                if (DefaultMessageStore.this.getMessageStoreConfig().isDuplicationEnable() || DefaultMessageStore.this.getMessageStoreConfig().getBrokerRole() != BrokerRole.SLAVE) continue;
                                DefaultMessageStore.this.storeStatsService.getSinglePutMessageTopicTimesTotal(dispatchRequest.getTopic()).add(dispatchRequest.getBatchSize());
                                DefaultMessageStore.this.storeStatsService.getSinglePutMessageTopicSizeTotal(dispatchRequest.getTopic()).add(dispatchRequest.getMsgSize());
                                continue;
                            }
                            if (size != 0) continue;
                            this.reputFromOffset = DefaultMessageStore.this.commitLog.rollNextFile(this.reputFromOffset);
                            readSize = result.getSize();
                            continue;
                        }
                        if (size > 0) {
                            LOGGER.error("[BUG]read total count not equals msg total size. reputFromOffset={}", (Object)this.reputFromOffset);
                            this.reputFromOffset += (long)size;
                            continue;
                        }
                        doNext = false;
                        if (!DefaultMessageStore.this.getMessageStoreConfig().isEnableDLegerCommitLog() && DefaultMessageStore.this.brokerConfig.getBrokerId() != 0L) continue;
                        LOGGER.error("[BUG]dispatch message to consume queue error, COMMITLOG OFFSET: {}", (Object)this.reputFromOffset);
                        this.reputFromOffset += (long)(result.getSize() - readSize);
                    }
                }
                catch (RocksDBException e) {
                    ERROR_LOG.info("dispatch message to cq exception. reputFromOffset: {}", (Object)this.reputFromOffset, (Object)e);
                    return;
                }
                finally {
                    result.release();
                }
            }
        }

        private void notifyMessageArrive4MultiQueue(DispatchRequest dispatchRequest) {
            String[] queueOffsets;
            Map<String, String> prop = dispatchRequest.getPropertiesMap();
            if (prop == null || dispatchRequest.getTopic().startsWith("%RETRY%")) {
                return;
            }
            String multiDispatchQueue = prop.get("INNER_MULTI_DISPATCH");
            String multiQueueOffset = prop.get("INNER_MULTI_QUEUE_OFFSET");
            if (StringUtils.isBlank((CharSequence)multiDispatchQueue) || StringUtils.isBlank((CharSequence)multiQueueOffset)) {
                return;
            }
            String[] queues = multiDispatchQueue.split(",");
            if (queues.length != (queueOffsets = multiQueueOffset.split(",")).length) {
                return;
            }
            for (int i = 0; i < queues.length; ++i) {
                String queueName = queues[i];
                long queueOffset = Long.parseLong(queueOffsets[i]);
                int queueId = dispatchRequest.getQueueId();
                if (DefaultMessageStore.this.getMessageStoreConfig().isEnableLmq() && MixAll.isLmq((String)queueName)) {
                    queueId = 0;
                }
                DefaultMessageStore.this.messageArrivingListener.arriving(queueName, queueId, queueOffset + 1L, dispatchRequest.getTagsCode(), dispatchRequest.getStoreTimestamp(), dispatchRequest.getBitMap(), dispatchRequest.getPropertiesMap());
            }
        }

        public void run() {
            LOGGER.info(this.getServiceName() + " service started");
            while (!this.isStopped()) {
                try {
                    TimeUnit.MILLISECONDS.sleep(1L);
                    this.doReput();
                }
                catch (Throwable e) {
                    LOGGER.warn(this.getServiceName() + " service has exception. ", e);
                }
            }
            LOGGER.info(this.getServiceName() + " service end");
        }

        public String getServiceName() {
            if (DefaultMessageStore.this.getBrokerConfig().isInBrokerContainer()) {
                return DefaultMessageStore.this.getBrokerIdentity().getIdentifier() + ReputMessageService.class.getSimpleName();
            }
            return ReputMessageService.class.getSimpleName();
        }
    }

    static class DispatchRequestOrderlyQueue {
        DispatchRequest[][] buffer;
        long ptr = 0L;
        AtomicLong maxPtr = new AtomicLong();

        public DispatchRequestOrderlyQueue(int bufferNum) {
            this.buffer = new DispatchRequest[bufferNum][];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(long index, DispatchRequest[] dispatchRequests) {
            while (this.ptr + (long)this.buffer.length <= index) {
                DispatchRequestOrderlyQueue dispatchRequestOrderlyQueue = this;
                synchronized (dispatchRequestOrderlyQueue) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            int mod = (int)(index % (long)this.buffer.length);
            this.buffer[mod] = dispatchRequests;
            this.maxPtr.incrementAndGet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DispatchRequest[] get(List<DispatchRequest[]> dispatchRequestsList) {
            DispatchRequestOrderlyQueue dispatchRequestOrderlyQueue = this;
            synchronized (dispatchRequestOrderlyQueue) {
                for (int i = 0; i < this.buffer.length; ++i) {
                    int mod = (int)(this.ptr % (long)this.buffer.length);
                    DispatchRequest[] ret = this.buffer[mod];
                    if (ret == null) {
                        this.notifyAll();
                        return null;
                    }
                    dispatchRequestsList.add(ret);
                    this.buffer[mod] = null;
                    ++this.ptr;
                }
            }
            return null;
        }

        public synchronized boolean isEmpty() {
            return this.maxPtr.get() == this.ptr;
        }
    }

    static class BatchDispatchRequest {
        private final ByteBuffer byteBuffer;
        private final int position;
        private final int size;
        private final long id;

        public BatchDispatchRequest(ByteBuffer byteBuffer, int position, int size, long id) {
            this.byteBuffer = byteBuffer;
            this.position = position;
            this.size = size;
            this.id = id;
        }
    }

    class FlushConsumeQueueService
    extends ServiceThread {
        private static final int RETRY_TIMES_OVER = 3;
        private long lastFlushTimestamp = 0L;

        FlushConsumeQueueService() {
        }

        private void doFlush(int retryTimes) {
            int flushConsumeQueueLeastPages = DefaultMessageStore.this.getMessageStoreConfig().getFlushConsumeQueueLeastPages();
            if (retryTimes == 3) {
                flushConsumeQueueLeastPages = 0;
            }
            long logicsMsgTimestamp = 0L;
            int flushConsumeQueueThoroughInterval = DefaultMessageStore.this.getMessageStoreConfig().getFlushConsumeQueueThoroughInterval();
            long currentTimeMillis = System.currentTimeMillis();
            if (currentTimeMillis >= this.lastFlushTimestamp + (long)flushConsumeQueueThoroughInterval) {
                this.lastFlushTimestamp = currentTimeMillis;
                flushConsumeQueueLeastPages = 0;
                logicsMsgTimestamp = DefaultMessageStore.this.getStoreCheckpoint().getLogicsMsgTimestamp();
            }
            ConcurrentMap<String, ConcurrentMap<Integer, ConsumeQueueInterface>> tables = DefaultMessageStore.this.getConsumeQueueTable();
            for (ConcurrentMap maps : tables.values()) {
                for (ConsumeQueueInterface cq : maps.values()) {
                    boolean result = false;
                    for (int i = 0; i < retryTimes && !result; ++i) {
                        result = DefaultMessageStore.this.consumeQueueStore.flush(cq, flushConsumeQueueLeastPages);
                    }
                }
            }
            if (DefaultMessageStore.this.messageStoreConfig.isEnableCompaction()) {
                DefaultMessageStore.this.compactionStore.flush(flushConsumeQueueLeastPages);
            }
            if (0 == flushConsumeQueueLeastPages) {
                if (logicsMsgTimestamp > 0L) {
                    DefaultMessageStore.this.getStoreCheckpoint().setLogicsMsgTimestamp(logicsMsgTimestamp);
                }
                DefaultMessageStore.this.getStoreCheckpoint().flush();
            }
        }

        public void run() {
            LOGGER.info(this.getServiceName() + " service started");
            while (!this.isStopped()) {
                try {
                    int interval = DefaultMessageStore.this.getMessageStoreConfig().getFlushIntervalConsumeQueue();
                    this.waitForRunning(interval);
                    this.doFlush(1);
                }
                catch (Exception e) {
                    LOGGER.warn(this.getServiceName() + " service has exception. ", (Throwable)e);
                }
            }
            this.doFlush(3);
            LOGGER.info(this.getServiceName() + " service end");
        }

        public String getServiceName() {
            if (DefaultMessageStore.this.brokerConfig.isInBrokerContainer()) {
                return DefaultMessageStore.this.getBrokerIdentity().getIdentifier() + FlushConsumeQueueService.class.getSimpleName();
            }
            return FlushConsumeQueueService.class.getSimpleName();
        }

        public long getJoinTime() {
            return 60000L;
        }
    }

    class CorrectLogicOffsetService {
        private long lastForceCorrectTime = -1L;

        CorrectLogicOffsetService() {
        }

        public void run() {
            try {
                this.correctLogicMinOffset();
            }
            catch (Throwable e) {
                LOGGER.warn(this.getServiceName() + " service has exception. ", e);
            }
        }

        private boolean needCorrect(ConsumeQueueInterface logic, long minPhyOffset, long lastForeCorrectTimeCurRun) {
            if (logic == null) {
                return false;
            }
            if (DefaultMessageStore.this.consumeQueueStore.isFirstFileExist(logic) && !DefaultMessageStore.this.consumeQueueStore.isFirstFileAvailable(logic)) {
                LOGGER.error("CorrectLogicOffsetService.needCorrect. first file not available, trigger correct. topic:{}, queue:{}, maxPhyOffset in queue:{}, minPhyOffset in commit log:{}, minOffset in queue:{}, maxOffset in queue:{}, cqType:{}", new Object[]{logic.getTopic(), logic.getQueueId(), logic.getMaxPhysicOffset(), minPhyOffset, logic.getMinOffsetInQueue(), logic.getMaxOffsetInQueue(), logic.getCQType()});
                return true;
            }
            if (logic.getMaxPhysicOffset() == -1L || minPhyOffset == -1L) {
                return false;
            }
            if (logic.getMaxPhysicOffset() < minPhyOffset) {
                if (logic.getMinOffsetInQueue() < logic.getMaxOffsetInQueue()) {
                    LOGGER.error("CorrectLogicOffsetService.needCorrect. logic max phy offset: {} is less than min phy offset: {}, but min offset: {} is less than max offset: {}. topic:{}, queue:{}, cqType:{}.", new Object[]{logic.getMaxPhysicOffset(), minPhyOffset, logic.getMinOffsetInQueue(), logic.getMaxOffsetInQueue(), logic.getTopic(), logic.getQueueId(), logic.getCQType()});
                    return true;
                }
                if (logic.getMinOffsetInQueue() == logic.getMaxOffsetInQueue()) {
                    return false;
                }
                LOGGER.error("CorrectLogicOffsetService.needCorrect. It should not happen, logic max phy offset: {} is less than min phy offset: {}, but min offset: {} is larger than max offset: {}. topic:{}, queue:{}, cqType:{}", new Object[]{logic.getMaxPhysicOffset(), minPhyOffset, logic.getMinOffsetInQueue(), logic.getMaxOffsetInQueue(), logic.getTopic(), logic.getQueueId(), logic.getCQType()});
                return false;
            }
            int forceCorrectInterval = DefaultMessageStore.this.getMessageStoreConfig().getCorrectLogicMinOffsetForceInterval();
            if (System.currentTimeMillis() - lastForeCorrectTimeCurRun > (long)forceCorrectInterval) {
                this.lastForceCorrectTime = System.currentTimeMillis();
                CqUnit cqUnit = logic.getEarliestUnit();
                if (cqUnit == null) {
                    if (logic.getMinOffsetInQueue() == logic.getMaxOffsetInQueue()) {
                        return false;
                    }
                    LOGGER.error("CorrectLogicOffsetService.needCorrect. cqUnit is null, logic max phy offset: {} is greater than min phy offset: {}, but min offset: {} is not equal to max offset: {}. topic:{}, queue:{}, cqType:{}.", new Object[]{logic.getMaxPhysicOffset(), minPhyOffset, logic.getMinOffsetInQueue(), logic.getMaxOffsetInQueue(), logic.getTopic(), logic.getQueueId(), logic.getCQType()});
                    return true;
                }
                if (cqUnit.getPos() < minPhyOffset) {
                    LOGGER.error("CorrectLogicOffsetService.needCorrect. logic max phy offset: {} is greater than min phy offset: {}, but minPhyPos in cq is: {}. min offset in queue: {}, max offset in queue: {}, topic:{}, queue:{}, cqType:{}.", new Object[]{logic.getMaxPhysicOffset(), minPhyOffset, cqUnit.getPos(), logic.getMinOffsetInQueue(), logic.getMaxOffsetInQueue(), logic.getTopic(), logic.getQueueId(), logic.getCQType()});
                    return true;
                }
                if (cqUnit.getPos() >= minPhyOffset) {
                    return false;
                }
            }
            return false;
        }

        private void correctLogicMinOffset() {
            long lastForeCorrectTimeCurRun = this.lastForceCorrectTime;
            long minPhyOffset = DefaultMessageStore.this.getMinPhyOffset();
            ConcurrentMap<String, ConcurrentMap<Integer, ConsumeQueueInterface>> tables = DefaultMessageStore.this.getConsumeQueueTable();
            for (ConcurrentMap maps : tables.values()) {
                for (ConsumeQueueInterface logic : maps.values()) {
                    if (Objects.equals(CQType.SimpleCQ, logic.getCQType()) || !this.needCorrect(logic, minPhyOffset, lastForeCorrectTimeCurRun)) continue;
                    this.doCorrect(logic, minPhyOffset);
                }
            }
        }

        private void doCorrect(ConsumeQueueInterface logic, long minPhyOffset) {
            DefaultMessageStore.this.consumeQueueStore.deleteExpiredFile(logic, minPhyOffset);
            int sleepIntervalWhenCorrectMinOffset = DefaultMessageStore.this.getMessageStoreConfig().getCorrectLogicMinOffsetSleepInterval();
            if (sleepIntervalWhenCorrectMinOffset > 0) {
                try {
                    Thread.sleep(sleepIntervalWhenCorrectMinOffset);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public String getServiceName() {
            if (DefaultMessageStore.this.brokerConfig.isInBrokerContainer()) {
                return DefaultMessageStore.this.brokerConfig.getIdentifier() + CorrectLogicOffsetService.class.getSimpleName();
            }
            return CorrectLogicOffsetService.class.getSimpleName();
        }
    }

    class CleanConsumeQueueService {
        protected long lastPhysicalMinOffset = 0L;

        CleanConsumeQueueService() {
        }

        public void run() {
            try {
                this.deleteExpiredFiles();
            }
            catch (Throwable e) {
                LOGGER.warn(this.getServiceName() + " service has exception. ", e);
            }
        }

        protected void deleteExpiredFiles() {
            int deleteLogicsFilesInterval = DefaultMessageStore.this.getMessageStoreConfig().getDeleteConsumeQueueFilesInterval();
            long minOffset = DefaultMessageStore.this.commitLog.getMinOffset();
            if (minOffset > this.lastPhysicalMinOffset) {
                this.lastPhysicalMinOffset = minOffset;
                ConcurrentMap<String, ConcurrentMap<Integer, ConsumeQueueInterface>> tables = DefaultMessageStore.this.getConsumeQueueTable();
                for (ConcurrentMap maps : tables.values()) {
                    for (ConsumeQueueInterface logic : maps.values()) {
                        int deleteCount = DefaultMessageStore.this.consumeQueueStore.deleteExpiredFile(logic, minOffset);
                        if (deleteCount <= 0 || deleteLogicsFilesInterval <= 0) continue;
                        try {
                            Thread.sleep(deleteLogicsFilesInterval);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                DefaultMessageStore.this.indexService.deleteExpiredFile(minOffset);
            }
        }

        public String getServiceName() {
            return DefaultMessageStore.this.brokerConfig.getIdentifier() + CleanConsumeQueueService.class.getSimpleName();
        }
    }

    class CleanCommitLogService {
        private static final int MAX_MANUAL_DELETE_FILE_TIMES = 20;
        private final String diskSpaceWarningLevelRatio = System.getProperty("rocketmq.broker.diskSpaceWarningLevelRatio", "");
        private final String diskSpaceCleanForciblyRatio = System.getProperty("rocketmq.broker.diskSpaceCleanForciblyRatio", "");
        private long lastRedeleteTimestamp = 0L;
        private final AtomicInteger manualDeleteFileSeveralTimes = new AtomicInteger();
        private volatile boolean cleanImmediately = false;
        private int forceCleanFailedTimes = 0;

        CleanCommitLogService() {
        }

        double getDiskSpaceWarningLevelRatio() {
            double finalDiskSpaceWarningLevelRatio = "".equals(this.diskSpaceWarningLevelRatio) ? (double)DefaultMessageStore.this.getMessageStoreConfig().getDiskSpaceWarningLevelRatio() / 100.0 : Double.parseDouble(this.diskSpaceWarningLevelRatio);
            if (finalDiskSpaceWarningLevelRatio > 0.9) {
                finalDiskSpaceWarningLevelRatio = 0.9;
            }
            if (finalDiskSpaceWarningLevelRatio < 0.35) {
                finalDiskSpaceWarningLevelRatio = 0.35;
            }
            return finalDiskSpaceWarningLevelRatio;
        }

        double getDiskSpaceCleanForciblyRatio() {
            double finalDiskSpaceCleanForciblyRatio = "".equals(this.diskSpaceCleanForciblyRatio) ? (double)DefaultMessageStore.this.getMessageStoreConfig().getDiskSpaceCleanForciblyRatio() / 100.0 : Double.parseDouble(this.diskSpaceCleanForciblyRatio);
            if (finalDiskSpaceCleanForciblyRatio > 0.85) {
                finalDiskSpaceCleanForciblyRatio = 0.85;
            }
            if (finalDiskSpaceCleanForciblyRatio < 0.3) {
                finalDiskSpaceCleanForciblyRatio = 0.3;
            }
            return finalDiskSpaceCleanForciblyRatio;
        }

        public void executeDeleteFilesManually() {
            this.manualDeleteFileSeveralTimes.set(20);
            LOGGER.info("executeDeleteFilesManually was invoked");
        }

        public void run() {
            try {
                this.deleteExpiredFiles();
                this.reDeleteHangedFile();
            }
            catch (Throwable e) {
                LOGGER.warn(this.getServiceName() + " service has exception. ", e);
            }
        }

        private void deleteExpiredFiles() {
            boolean isManualDelete;
            int deleteCount = 0;
            long fileReservedTime = DefaultMessageStore.this.getMessageStoreConfig().getFileReservedTime();
            int deletePhysicFilesInterval = DefaultMessageStore.this.getMessageStoreConfig().getDeleteCommitLogFilesInterval();
            int destroyMappedFileIntervalForcibly = DefaultMessageStore.this.getMessageStoreConfig().getDestroyMapedFileIntervalForcibly();
            int deleteFileBatchMax = DefaultMessageStore.this.getMessageStoreConfig().getDeleteFileBatchMax();
            boolean isTimeUp = this.isTimeToDelete();
            boolean isUsageExceedsThreshold = this.isSpaceToDelete();
            boolean bl = isManualDelete = this.manualDeleteFileSeveralTimes.get() > 0;
            if (isTimeUp || isUsageExceedsThreshold || isManualDelete) {
                if (isManualDelete) {
                    this.manualDeleteFileSeveralTimes.decrementAndGet();
                }
                boolean cleanAtOnce = DefaultMessageStore.this.getMessageStoreConfig().isCleanFileForciblyEnable() && this.cleanImmediately;
                LOGGER.info("begin to delete before {} hours file. isTimeUp: {} isUsageExceedsThreshold: {} manualDeleteFileSeveralTimes: {} cleanAtOnce: {} deleteFileBatchMax: {}", new Object[]{fileReservedTime, isTimeUp, isUsageExceedsThreshold, this.manualDeleteFileSeveralTimes.get(), cleanAtOnce, deleteFileBatchMax});
                deleteCount = DefaultMessageStore.this.commitLog.deleteExpiredFile(fileReservedTime *= 3600000L, deletePhysicFilesInterval, destroyMappedFileIntervalForcibly, cleanAtOnce, deleteFileBatchMax);
                if (deleteCount > 0) {
                    if (DefaultMessageStore.this.brokerConfig.isEnableControllerMode() && DefaultMessageStore.this.haService instanceof AutoSwitchHAService) {
                        long minPhyOffset = DefaultMessageStore.this.getMinPhyOffset();
                        ((AutoSwitchHAService)DefaultMessageStore.this.haService).truncateEpochFilePrefix(minPhyOffset - 1L);
                    }
                } else if (isUsageExceedsThreshold) {
                    LOGGER.warn("disk space will be full soon, but delete file failed.");
                }
            }
        }

        private void reDeleteHangedFile() {
            int interval = DefaultMessageStore.this.getMessageStoreConfig().getRedeleteHangedFileInterval();
            long currentTimestamp = System.currentTimeMillis();
            if (currentTimestamp - this.lastRedeleteTimestamp > (long)interval) {
                this.lastRedeleteTimestamp = currentTimestamp;
                int destroyMappedFileIntervalForcibly = DefaultMessageStore.this.getMessageStoreConfig().getDestroyMapedFileIntervalForcibly();
                if (DefaultMessageStore.this.commitLog.retryDeleteFirstFile(destroyMappedFileIntervalForcibly)) {
                    // empty if block
                }
            }
        }

        public String getServiceName() {
            return DefaultMessageStore.this.brokerConfig.getIdentifier() + CleanCommitLogService.class.getSimpleName();
        }

        protected boolean isTimeToDelete() {
            String when = DefaultMessageStore.this.getMessageStoreConfig().getDeleteWhen();
            if (UtilAll.isItTimeToDo((String)when)) {
                LOGGER.info("it's time to reclaim disk space, " + when);
                return true;
            }
            return false;
        }

        private boolean isSpaceToDelete() {
            boolean isUsageExceedsThreshold;
            long partitionLogicalSize;
            String storePathLogics;
            double logicsRatio;
            this.cleanImmediately = false;
            String commitLogStorePath = DefaultMessageStore.this.getMessageStoreConfig().getStorePathCommitLog();
            String[] storePaths = commitLogStorePath.trim().split(MixAll.MULTI_PATH_SPLITTER);
            HashSet<String> fullStorePath = new HashSet<String>();
            double minPhysicRatio = 100.0;
            String minStorePath = null;
            for (String storePathPhysic : storePaths) {
                double physicRatio = UtilAll.getDiskPartitionSpaceUsedPercent((String)storePathPhysic);
                if (minPhysicRatio > physicRatio) {
                    minPhysicRatio = physicRatio;
                    minStorePath = storePathPhysic;
                }
                if (!(physicRatio > this.getDiskSpaceCleanForciblyRatio())) continue;
                fullStorePath.add(storePathPhysic);
            }
            DefaultMessageStore.this.commitLog.setFullStorePaths(fullStorePath);
            if (minPhysicRatio > this.getDiskSpaceWarningLevelRatio()) {
                boolean diskFull = DefaultMessageStore.this.runningFlags.getAndMakeDiskFull();
                if (diskFull) {
                    LOGGER.error("physic disk maybe full soon " + minPhysicRatio + ", so mark disk full, storePathPhysic=" + minStorePath);
                }
                this.cleanImmediately = true;
                return true;
            }
            if (minPhysicRatio > this.getDiskSpaceCleanForciblyRatio()) {
                this.cleanImmediately = true;
                return true;
            }
            boolean diskOK = DefaultMessageStore.this.runningFlags.getAndMakeDiskOK();
            if (!diskOK) {
                LOGGER.info("physic disk space OK " + minPhysicRatio + ", so mark disk ok, storePathPhysic=" + minStorePath);
            }
            if ((logicsRatio = UtilAll.getDiskPartitionSpaceUsedPercent((String)(storePathLogics = StorePathConfigHelper.getStorePathConsumeQueue(DefaultMessageStore.this.getMessageStoreConfig().getStorePathRootDir())))) > this.getDiskSpaceWarningLevelRatio()) {
                boolean diskOK2 = DefaultMessageStore.this.runningFlags.getAndMakeDiskFull();
                if (diskOK2) {
                    LOGGER.error("logics disk maybe full soon " + logicsRatio + ", so mark disk full");
                }
                this.cleanImmediately = true;
                return true;
            }
            if (logicsRatio > this.getDiskSpaceCleanForciblyRatio()) {
                this.cleanImmediately = true;
                return true;
            }
            boolean diskOK3 = DefaultMessageStore.this.runningFlags.getAndMakeDiskOK();
            if (!diskOK3) {
                LOGGER.info("logics disk space OK " + logicsRatio + ", so mark disk ok");
            }
            double ratio = (double)DefaultMessageStore.this.getMessageStoreConfig().getDiskMaxUsedSpaceRatio() / 100.0;
            int replicasPerPartition = DefaultMessageStore.this.getMessageStoreConfig().getReplicasPerDiskPartition();
            if (replicasPerPartition <= 1) {
                if (minPhysicRatio < 0.0 || minPhysicRatio > ratio) {
                    LOGGER.info("commitLog disk maybe full soon, so reclaim space, " + minPhysicRatio);
                    return true;
                }
                if (logicsRatio < 0.0 || logicsRatio > ratio) {
                    LOGGER.info("consumeQueue disk maybe full soon, so reclaim space, " + logicsRatio);
                    return true;
                }
                return false;
            }
            long majorFileSize = DefaultMessageStore.this.getMajorFileSize();
            double logicalRatio = 1.0 * (double)majorFileSize / (double)(partitionLogicalSize = UtilAll.getDiskPartitionTotalSpace((String)minStorePath) / (long)replicasPerPartition);
            if (logicalRatio > DefaultMessageStore.this.getMessageStoreConfig().getLogicalDiskSpaceCleanForciblyThreshold()) {
                LOGGER.info("Logical disk usage {} exceeds logical disk space clean forcibly threshold {}, forcibly: {}", new Object[]{logicalRatio, minPhysicRatio, this.cleanImmediately});
                this.cleanImmediately = true;
                return true;
            }
            boolean bl = isUsageExceedsThreshold = logicalRatio > ratio;
            if (isUsageExceedsThreshold) {
                LOGGER.info("Logical disk usage {} exceeds clean threshold {}, forcibly: {}", new Object[]{logicalRatio, ratio, this.cleanImmediately});
            }
            return isUsageExceedsThreshold;
        }

        public int getManualDeleteFileSeveralTimes() {
            return this.manualDeleteFileSeveralTimes.get();
        }

        public void setManualDeleteFileSeveralTimes(int manualDeleteFileSeveralTimes) {
            this.manualDeleteFileSeveralTimes.set(manualDeleteFileSeveralTimes);
        }

        public double calcStorePathPhysicRatio() {
            HashSet<String> fullStorePath = new HashSet<String>();
            String storePath = DefaultMessageStore.this.getStorePathPhysic();
            String[] paths = storePath.trim().split(MixAll.MULTI_PATH_SPLITTER);
            double minPhysicRatio = 100.0;
            for (String path : paths) {
                double physicRatio = UtilAll.isPathExists((String)path) ? UtilAll.getDiskPartitionSpaceUsedPercent((String)path) : -1.0;
                minPhysicRatio = Math.min(minPhysicRatio, physicRatio);
                if (!(physicRatio > this.getDiskSpaceCleanForciblyRatio())) continue;
                fullStorePath.add(path);
            }
            DefaultMessageStore.this.commitLog.setFullStorePaths(fullStorePath);
            return minPhysicRatio;
        }

        public boolean isSpaceFull() {
            double ratio;
            double physicRatio = this.calcStorePathPhysicRatio();
            if (physicRatio > (ratio = (double)DefaultMessageStore.this.getMessageStoreConfig().getDiskMaxUsedSpaceRatio() / 100.0)) {
                LOGGER.info("physic disk of commitLog used: " + physicRatio);
            }
            if (physicRatio > this.getDiskSpaceWarningLevelRatio()) {
                boolean diskok = DefaultMessageStore.this.runningFlags.getAndMakeDiskFull();
                if (diskok) {
                    LOGGER.error("physic disk of commitLog maybe full soon, used " + physicRatio + ", so mark disk full");
                }
                return true;
            }
            boolean diskok = DefaultMessageStore.this.runningFlags.getAndMakeDiskOK();
            if (!diskok) {
                LOGGER.info("physic disk space of commitLog OK " + physicRatio + ", so mark disk ok");
            }
            return false;
        }
    }

    class CommitLogDispatcherBuildIndex
    implements CommitLogDispatcher {
        CommitLogDispatcherBuildIndex() {
        }

        @Override
        public void dispatch(DispatchRequest request) {
            if (DefaultMessageStore.this.messageStoreConfig.isMessageIndexEnable()) {
                DefaultMessageStore.this.indexService.buildIndex(request);
            }
        }
    }

    class CommitLogDispatcherBuildConsumeQueue
    implements CommitLogDispatcher {
        CommitLogDispatcherBuildConsumeQueue() {
        }

        @Override
        public void dispatch(DispatchRequest request) throws RocksDBException {
            int tranType = MessageSysFlag.getTransactionValue((int)request.getSysFlag());
            switch (tranType) {
                case 0: 
                case 8: {
                    DefaultMessageStore.this.putMessagePositionInfo(request);
                    break;
                }
            }
        }
    }
}

