/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.metrics;

import com.google.common.collect.Lists;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableDoubleGauge;
import io.opentelemetry.api.metrics.ObservableLongGauge;
import io.opentelemetry.sdk.metrics.InstrumentSelector;
import io.opentelemetry.sdk.metrics.ViewBuilder;
import java.util.List;
import java.util.function.Supplier;
import org.apache.rocketmq.common.Pair;
import org.apache.rocketmq.common.metrics.NopObservableDoubleGauge;
import org.apache.rocketmq.common.metrics.NopObservableLongGauge;
import org.apache.rocketmq.store.config.MessageStoreConfig;
import org.apache.rocketmq.store.queue.CombineConsumeQueueStore;
import org.apache.rocketmq.store.queue.ConsumeQueueStoreInterface;
import org.apache.rocketmq.store.queue.RocksDBConsumeQueueStore;
import org.rocksdb.TickerType;

public class RocksDBStoreMetricsManager {
    private Supplier<AttributesBuilder> attributesBuilderSupplier;
    private MessageStoreConfig messageStoreConfig;
    private ObservableLongGauge bytesRocksdbRead = new NopObservableLongGauge();
    private ObservableLongGauge bytesRocksdbWritten = new NopObservableLongGauge();
    private ObservableLongGauge timesRocksdbRead = new NopObservableLongGauge();
    private ObservableLongGauge timesRocksdbWrittenSelf = new NopObservableLongGauge();
    private ObservableLongGauge timesRocksdbWrittenOther = new NopObservableLongGauge();
    private ObservableLongGauge timesRocksdbCompressed = new NopObservableLongGauge();
    private ObservableDoubleGauge bytesRocksdbAmplificationRead = new NopObservableDoubleGauge();
    private ObservableDoubleGauge rocksdbCacheHitRate = new NopObservableDoubleGauge();
    private volatile long blockCacheHitTimes = 0L;
    private volatile long blockCacheMissTimes = 0L;

    public List<Pair<InstrumentSelector, ViewBuilder>> getMetricsView() {
        return Lists.newArrayList();
    }

    public void init(Meter meter, Supplier<AttributesBuilder> attributesBuilderSupplier, ConsumeQueueStoreInterface consumeQueueStore) {
        RocksDBConsumeQueueStore rocksDBMessageStore = consumeQueueStore instanceof RocksDBConsumeQueueStore ? (RocksDBConsumeQueueStore)consumeQueueStore : (consumeQueueStore instanceof CombineConsumeQueueStore ? ((CombineConsumeQueueStore)consumeQueueStore).getRocksDBConsumeQueueStore() : null);
        if (rocksDBMessageStore == null) {
            return;
        }
        this.attributesBuilderSupplier = attributesBuilderSupplier;
        this.bytesRocksdbWritten = meter.gaugeBuilder("rocketmq_rocksdb_bytes_written").setDescription("The cumulative number of bytes written to the database.").ofLongs().buildWithCallback(measurement -> measurement.record(rocksDBMessageStore.getStatistics().getTickerCount(TickerType.BYTES_WRITTEN), this.newAttributesBuilder().put("type", "consume_queue").build()));
        this.bytesRocksdbRead = meter.gaugeBuilder("rocketmq_rocksdb_bytes_read").setDescription("The cumulative number of bytes read from the database.").ofLongs().buildWithCallback(measurement -> measurement.record(rocksDBMessageStore.getStatistics().getTickerCount(TickerType.BYTES_READ), this.newAttributesBuilder().put("type", "consume_queue").build()));
        this.timesRocksdbWrittenSelf = meter.gaugeBuilder("rocketmq_rocksdb_times_written_self").setDescription("The cumulative number of write operations performed by self.").ofLongs().buildWithCallback(measurement -> measurement.record(rocksDBMessageStore.getStatistics().getTickerCount(TickerType.WRITE_DONE_BY_SELF), this.newAttributesBuilder().put("type", "consume_queue").build()));
        this.timesRocksdbWrittenOther = meter.gaugeBuilder("rocketmq_rocksdb_times_written_other").setDescription("The cumulative number of write operations performed by other.").ofLongs().buildWithCallback(measurement -> measurement.record(rocksDBMessageStore.getStatistics().getTickerCount(TickerType.WRITE_DONE_BY_OTHER), this.newAttributesBuilder().put("type", "consume_queue").build()));
        this.timesRocksdbRead = meter.gaugeBuilder("rocketmq_rocksdb_times_read").setDescription("The cumulative number of write operations performed by other.").ofLongs().buildWithCallback(measurement -> measurement.record(rocksDBMessageStore.getStatistics().getTickerCount(TickerType.NUMBER_KEYS_READ), this.newAttributesBuilder().put("type", "consume_queue").build()));
        this.rocksdbCacheHitRate = meter.gaugeBuilder("rocketmq_rocksdb_rate_cache_hit").setDescription("The rate at which cache lookups were served from the cache rather than needing to be fetched from disk.").buildWithCallback(measurement -> {
            long newMissTimes;
            long newHitTimes = rocksDBMessageStore.getStatistics().getTickerCount(TickerType.BLOCK_CACHE_HIT);
            long totalPeriod = newHitTimes - this.blockCacheHitTimes + (newMissTimes = rocksDBMessageStore.getStatistics().getTickerCount(TickerType.BLOCK_CACHE_MISS)) - this.blockCacheMissTimes;
            double hitRate = totalPeriod == 0L ? 0.0 : (double)(newHitTimes - this.blockCacheHitTimes) / (double)totalPeriod;
            this.blockCacheHitTimes = newHitTimes;
            this.blockCacheMissTimes = newMissTimes;
            measurement.record(hitRate, this.newAttributesBuilder().put("type", "consume_queue").build());
        });
        this.timesRocksdbCompressed = meter.gaugeBuilder("rocketmq_rocksdb_times_compressed").setDescription("The cumulative number of compressions that have occurred.").ofLongs().buildWithCallback(measurement -> measurement.record(rocksDBMessageStore.getStatistics().getTickerCount(TickerType.NUMBER_BLOCK_COMPRESSED), this.newAttributesBuilder().put("type", "consume_queue").build()));
        this.bytesRocksdbAmplificationRead = meter.gaugeBuilder("rocketmq_rocksdb_read_amplification_bytes").setDescription("The rate at which cache lookups were served from the cache rather than needing to be fetched from disk.").buildWithCallback(measurement -> measurement.record((double)rocksDBMessageStore.getStatistics().getTickerCount(TickerType.READ_AMP_TOTAL_READ_BYTES), this.newAttributesBuilder().put("type", "consume_queue").build()));
    }

    public AttributesBuilder newAttributesBuilder() {
        if (this.attributesBuilderSupplier == null) {
            return Attributes.builder();
        }
        return this.attributesBuilderSupplier.get().put("storage_type", "local").put("storage_medium", "disk");
    }

    public Supplier<AttributesBuilder> getAttributesBuilderSupplier() {
        return this.attributesBuilderSupplier;
    }

    public MessageStoreConfig getMessageStoreConfig() {
        return this.messageStoreConfig;
    }

    public ObservableLongGauge getBytesRocksdbRead() {
        return this.bytesRocksdbRead;
    }

    public ObservableLongGauge getBytesRocksdbWritten() {
        return this.bytesRocksdbWritten;
    }

    public ObservableLongGauge getTimesRocksdbRead() {
        return this.timesRocksdbRead;
    }

    public ObservableLongGauge getTimesRocksdbWrittenSelf() {
        return this.timesRocksdbWrittenSelf;
    }

    public ObservableLongGauge getTimesRocksdbWrittenOther() {
        return this.timesRocksdbWrittenOther;
    }

    public ObservableLongGauge getTimesRocksdbCompressed() {
        return this.timesRocksdbCompressed;
    }

    public ObservableDoubleGauge getBytesRocksdbAmplificationRead() {
        return this.bytesRocksdbAmplificationRead;
    }

    public ObservableDoubleGauge getRocksdbCacheHitRate() {
        return this.rocksdbCacheHitRate;
    }

    public long getBlockCacheHitTimes() {
        return this.blockCacheHitTimes;
    }

    public long getBlockCacheMissTimes() {
        return this.blockCacheMissTimes;
    }

    public void setAttributesBuilderSupplier(Supplier<AttributesBuilder> attributesBuilderSupplier) {
        this.attributesBuilderSupplier = attributesBuilderSupplier;
    }

    public void setMessageStoreConfig(MessageStoreConfig messageStoreConfig) {
        this.messageStoreConfig = messageStoreConfig;
    }
}

