/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.client;

import io.netty.channel.Channel;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.client.ConsumerGroupEvent;
import org.apache.rocketmq.broker.client.ConsumerIdsChangeListener;
import org.apache.rocketmq.common.utils.ThreadUtils;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;

public class DefaultConsumerIdsChangeListener
implements ConsumerIdsChangeListener {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqBroker");
    private final BrokerController brokerController;
    private final int cacheSize = 8096;
    private final ScheduledExecutorService scheduledExecutorService = ThreadUtils.newScheduledThreadPool((int)1, (ThreadFactory)ThreadUtils.newGenericThreadFactory((String)"DefaultConsumerIdsChangeListener", (boolean)true));
    private ConcurrentHashMap<String, List<Channel>> consumerChannelMap = new ConcurrentHashMap(8096);
    private final ConcurrentHashMap<String, NotifyTaskControl> activeGroupNotifyMap = new ConcurrentHashMap();

    public DefaultConsumerIdsChangeListener(BrokerController brokerController) {
        this.brokerController = brokerController;
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    DefaultConsumerIdsChangeListener.this.notifyConsumerChange();
                }
                catch (Exception e) {
                    log.error("DefaultConsumerIdsChangeListen#notifyConsumerChange: unexpected error occurs", (Throwable)e);
                }
            }
        }, 30L, 15L, TimeUnit.SECONDS);
    }

    @Override
    public void handle(ConsumerGroupEvent event, String group, Object ... args) {
        if (event == null) {
            return;
        }
        switch (event) {
            case CHANGE: {
                if (args == null || args.length < 1) {
                    return;
                }
                List channels = (List)args[0];
                if (channels == null || !this.brokerController.getBrokerConfig().isNotifyConsumerIdsChangedEnable()) break;
                if (this.brokerController.getBrokerConfig().isRealTimeNotifyConsumerChange()) {
                    NotifyTaskControl currentNotifyTaskControl = new NotifyTaskControl(channels);
                    this.activeGroupNotifyMap.compute(group, (k, oldVal) -> {
                        if (null != oldVal) {
                            oldVal.interrupt();
                        }
                        return currentNotifyTaskControl;
                    });
                    boolean isNormalCompletion = true;
                    for (Channel chl : currentNotifyTaskControl.getChannels()) {
                        if (currentNotifyTaskControl.isInterrupted()) {
                            isNormalCompletion = false;
                            break;
                        }
                        this.brokerController.getBroker2Client().notifyConsumerIdsChanged(chl, group);
                    }
                    if (!isNormalCompletion) break;
                    this.activeGroupNotifyMap.computeIfPresent(group, (k, val) -> val == currentNotifyTaskControl ? null : val);
                    break;
                }
                this.consumerChannelMap.put(group, channels);
                break;
            }
            case UNREGISTER: {
                this.brokerController.getConsumerFilterManager().unRegister(group);
                break;
            }
            case REGISTER: {
                if (args == null || args.length < 1) {
                    return;
                }
                Collection subscriptionDataList = (Collection)args[0];
                this.brokerController.getConsumerFilterManager().register(group, subscriptionDataList);
                break;
            }
            case CLIENT_REGISTER: 
            case CLIENT_UNREGISTER: {
                break;
            }
            default: {
                throw new RuntimeException("Unknown event " + (Object)((Object)event));
            }
        }
    }

    private void notifyConsumerChange() {
        if (this.consumerChannelMap.isEmpty()) {
            return;
        }
        ConcurrentHashMap<String, List<Channel>> processMap = new ConcurrentHashMap<String, List<Channel>>(this.consumerChannelMap);
        this.consumerChannelMap = new ConcurrentHashMap(8096);
        for (Map.Entry<String, List<Channel>> entry : processMap.entrySet()) {
            String consumerId = entry.getKey();
            List<Channel> channelList = entry.getValue();
            try {
                if (channelList == null || !this.brokerController.getBrokerConfig().isNotifyConsumerIdsChangedEnable()) continue;
                for (Channel chl : channelList) {
                    this.brokerController.getBroker2Client().notifyConsumerIdsChanged(chl, consumerId);
                }
            }
            catch (Exception e) {
                log.error("Failed to notify consumer when some consumers changed, consumerId to notify: {}", (Object)consumerId, (Object)e);
            }
        }
    }

    @Override
    public void shutdown() {
        this.scheduledExecutorService.shutdown();
    }

    private static class NotifyTaskControl {
        private final AtomicBoolean interrupted = new AtomicBoolean(false);
        private final List<Channel> channels;

        public NotifyTaskControl(List<Channel> channels) {
            this.channels = channels;
        }

        public boolean isInterrupted() {
            return this.interrupted.get();
        }

        public void interrupt() {
            this.interrupted.set(true);
        }

        public List<Channel> getChannels() {
            return this.channels;
        }
    }
}

