/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.shaded.io.opentelemetry.sdk;

import javax.annotation.concurrent.ThreadSafe;
import org.apache.rocketmq.shaded.io.opentelemetry.api.OpenTelemetry;
import org.apache.rocketmq.shaded.io.opentelemetry.api.metrics.MeterBuilder;
import org.apache.rocketmq.shaded.io.opentelemetry.api.metrics.MeterProvider;
import org.apache.rocketmq.shaded.io.opentelemetry.api.trace.Tracer;
import org.apache.rocketmq.shaded.io.opentelemetry.api.trace.TracerBuilder;
import org.apache.rocketmq.shaded.io.opentelemetry.api.trace.TracerProvider;
import org.apache.rocketmq.shaded.io.opentelemetry.context.propagation.ContextPropagators;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.OpenTelemetrySdkBuilder;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.logs.SdkLogEmitterProvider;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.SdkMeterProvider;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.trace.SdkTracerProvider;

@ThreadSafe
public final class OpenTelemetrySdk
implements OpenTelemetry {
    private final ObfuscatedTracerProvider tracerProvider;
    private final ObfuscatedMeterProvider meterProvider;
    private final SdkLogEmitterProvider logEmitterProvider;
    private final ContextPropagators propagators;

    OpenTelemetrySdk(SdkTracerProvider tracerProvider, SdkMeterProvider meterProvider, SdkLogEmitterProvider logEmitterProvider, ContextPropagators propagators) {
        this.tracerProvider = new ObfuscatedTracerProvider(tracerProvider);
        this.meterProvider = new ObfuscatedMeterProvider(meterProvider);
        this.logEmitterProvider = logEmitterProvider;
        this.propagators = propagators;
    }

    public static OpenTelemetrySdkBuilder builder() {
        return new OpenTelemetrySdkBuilder();
    }

    @Override
    public TracerProvider getTracerProvider() {
        return this.tracerProvider;
    }

    public SdkTracerProvider getSdkTracerProvider() {
        return this.tracerProvider.unobfuscate();
    }

    @Override
    public MeterProvider getMeterProvider() {
        return this.meterProvider;
    }

    public SdkMeterProvider getSdkMeterProvider() {
        return this.meterProvider.unobfuscate();
    }

    public SdkLogEmitterProvider getSdkLogEmitterProvider() {
        return this.logEmitterProvider;
    }

    @Override
    public ContextPropagators getPropagators() {
        return this.propagators;
    }

    public String toString() {
        return "OpenTelemetrySdk{tracerProvider=" + this.tracerProvider.unobfuscate() + '}';
    }

    @ThreadSafe
    static class ObfuscatedTracerProvider
    implements TracerProvider {
        private final SdkTracerProvider delegate;

        ObfuscatedTracerProvider(SdkTracerProvider delegate) {
            this.delegate = delegate;
        }

        @Override
        public Tracer get(String instrumentationScopeName) {
            return this.delegate.get(instrumentationScopeName);
        }

        @Override
        public Tracer get(String instrumentationScopeName, String instrumentationScopeVersion) {
            return this.delegate.get(instrumentationScopeName, instrumentationScopeVersion);
        }

        @Override
        public TracerBuilder tracerBuilder(String instrumentationScopeName) {
            return this.delegate.tracerBuilder(instrumentationScopeName);
        }

        public SdkTracerProvider unobfuscate() {
            return this.delegate;
        }
    }

    @ThreadSafe
    static class ObfuscatedMeterProvider
    implements MeterProvider {
        private final SdkMeterProvider delegate;

        ObfuscatedMeterProvider(SdkMeterProvider delegate) {
            this.delegate = delegate;
        }

        @Override
        public MeterBuilder meterBuilder(String instrumentationScopeName) {
            return this.delegate.meterBuilder(instrumentationScopeName);
        }

        public SdkMeterProvider unobfuscate() {
            return this.delegate;
        }
    }
}

