/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.meta.rocksdb;

import com.alipay.sofa.jraft.util.StorageOptionsFactory;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.rocketmq.mqtt.meta.rocksdb.RocksDBSnapshot;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.Env;
import org.rocksdb.MergeOperator;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.StringAppendOperator;
import org.rocksdb.TableFormatConfig;
import org.rocksdb.WriteOptions;

public class RocksDBEngine {
    private RocksDB rdb;
    private String rdbPath;
    private DBOptions dbOptions;
    private ColumnFamilyHandle defaultHandle;
    private final List<ColumnFamilyOptions> cfOptionsList = Lists.newArrayList();
    private final List<ColumnFamilyDescriptor> cfDescriptors = Lists.newArrayList();
    private WriteOptions writeOptions;
    private RocksDBSnapshot rocksDBSnapshot;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    public RocksDB getRdb() {
        return this.rdb;
    }

    public String getRdbPath() {
        return this.rdbPath;
    }

    public ReadWriteLock getReadWriteLock() {
        return this.readWriteLock;
    }

    public WriteOptions getWriteOptions() {
        return this.writeOptions;
    }

    public RocksDBEngine(String dbPath) {
        this.rdbPath = dbPath;
        this.rocksDBSnapshot = new RocksDBSnapshot(this);
    }

    public RocksDBSnapshot getRocksDBSnapshot() {
        return this.rocksDBSnapshot;
    }

    public void init() throws RocksDBException {
        this.dbOptions = this.createDBOptions();
        ColumnFamilyOptions cfOptions = this.createColumnFamilyOptions();
        this.cfOptionsList.add(cfOptions);
        this.cfDescriptors.add(new ColumnFamilyDescriptor(RocksDB.DEFAULT_COLUMN_FAMILY, cfOptions));
        this.writeOptions = new WriteOptions();
        this.writeOptions.setSync(false);
        this.writeOptions.setDisableWAL(true);
        this.destroyRocksDB();
        this.openRocksDB();
    }

    public DBOptions createDBOptions() {
        return StorageOptionsFactory.getRocksDBOptions(RocksDBEngine.class).setEnv(Env.getDefault());
    }

    public ColumnFamilyOptions createColumnFamilyOptions() {
        BlockBasedTableConfig tConfig = StorageOptionsFactory.getRocksDBTableFormatConfig(RocksDBEngine.class);
        return StorageOptionsFactory.getRocksDBColumnFamilyOptions(RocksDBEngine.class).setTableFormatConfig((TableFormatConfig)tConfig).setMergeOperator((MergeOperator)new StringAppendOperator());
    }

    protected void destroyRocksDB() throws RocksDBException {
        try (Options opt = new Options();){
            RocksDB.destroyDB((String)this.rdbPath, (Options)opt);
        }
    }

    protected void openRocksDB() throws RocksDBException {
        ArrayList cfHandles = Lists.newArrayList();
        this.rdb = RocksDB.open((DBOptions)this.dbOptions, (String)this.rdbPath, this.cfDescriptors, (List)cfHandles);
        this.defaultHandle = (ColumnFamilyHandle)cfHandles.get(0);
    }

    protected void closeRocksDB() {
        if (this.rdb != null) {
            this.rdb.close();
            this.rdb = null;
        }
    }

    static {
        RocksDB.loadLibrary();
    }
}

