/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.util;

import com.alipay.sofa.jraft.rhea.util.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public class Partitions {
    public static <IN, OUT> List<OUT> manyToOne(List<IN> inputList, int unitSize, Function<List<IN>, OUT> func) {
        if (inputList == null || inputList.isEmpty()) {
            return Collections.emptyList();
        }
        int inputSize = inputList.size();
        ArrayList outputList = Lists.newArrayListWithCapacity((int)Math.ceil((double)inputSize / (double)unitSize));
        if (inputSize <= unitSize) {
            Partitions.add(outputList, func.apply(inputList));
            return outputList;
        }
        ArrayList<IN> segment = Lists.newArrayListWithCapacity(unitSize);
        for (IN input : inputList) {
            segment.add(input);
            if (segment.size() < unitSize) continue;
            Partitions.add(outputList, func.apply(segment));
            segment = Lists.newArrayListWithCapacity(unitSize);
        }
        if (!segment.isEmpty()) {
            Partitions.add(outputList, func.apply(segment));
        }
        return outputList;
    }

    public static <IN, OUT> List<OUT> oneToOne(List<IN> inputList, int unitSize, Function<List<IN>, List<OUT>> func) {
        if (inputList == null || inputList.isEmpty()) {
            return Collections.emptyList();
        }
        int inputSize = inputList.size();
        if (inputSize <= unitSize) {
            return func.apply(inputList);
        }
        ArrayList outputList = Lists.newArrayListWithCapacity(inputSize);
        ArrayList<IN> segment = Lists.newArrayListWithCapacity(unitSize);
        for (IN input : inputList) {
            segment.add(input);
            if (segment.size() < unitSize) continue;
            Partitions.addAll(outputList, func.apply(segment));
            segment = Lists.newArrayListWithCapacity(unitSize);
        }
        if (!segment.isEmpty()) {
            Partitions.addAll(outputList, func.apply(segment));
        }
        return outputList;
    }

    private static <T> void add(List<T> list, T element) {
        if (list != null && element != null) {
            list.add(element);
        }
    }

    private static <T> void addAll(List<T> list, List<T> elements) {
        if (list != null && elements != null && !elements.isEmpty()) {
            list.addAll(elements);
        }
    }
}

