/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.codegen.js.jx;

import org.apache.royale.compiler.asdoc.royale.ASDocComment;
import org.apache.royale.compiler.codegen.js.IJSEmitter;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.definitions.IAppliedVectorDefinition;
import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.internal.codegen.as.ASEmitterTokens;
import org.apache.royale.compiler.internal.codegen.js.JSSubEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitter;
import org.apache.royale.compiler.internal.codegen.js.royale.JSRoyaleEmitterTokens;
import org.apache.royale.compiler.internal.projects.RoyaleJSProject;
import org.apache.royale.compiler.projects.ICompilerProject;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IASNode;
import org.apache.royale.compiler.tree.as.IBinaryOperatorNode;
import org.apache.royale.compiler.tree.as.IExpressionNode;
import org.apache.royale.compiler.tree.as.IFunctionNode;
import org.apache.royale.compiler.utils.NativeUtils;

public class AsIsEmitter
extends JSSubEmitter {
    public AsIsEmitter(IJSEmitter emitter) {
        super(emitter);
    }

    public void emitIsAs(IExpressionNode node, IExpressionNode left, IExpressionNode right, ASTNodeID id, boolean coercion) {
        IBinaryOperatorNode binaryOperatorNode;
        ICompilerProject project;
        IDefinition dnode;
        IDefinition iDefinition = dnode = this.getProject() != null ? right.resolve(this.getProject()) : null;
        if (id != ASTNodeID.Op_IsID && dnode != null) {
            boolean emit = coercion ? !((RoyaleJSProject)this.getProject()).config.getJSOutputOptimizations().contains(JSRoyaleEmitterTokens.SKIP_FUNCTION_COERCIONS.getToken()) : !((RoyaleJSProject)this.getProject()).config.getJSOutputOptimizations().contains(JSRoyaleEmitterTokens.SKIP_AS_COERCIONS.getToken());
            IFunctionNode functionNode = (IFunctionNode)left.getAncestorOfType(IFunctionNode.class);
            if (functionNode != null) {
                ASDocComment asDoc;
                if (coercion) {
                    for (IASNode child = left.getParent(); child != functionNode; child = child.getParent()) {
                        if (child.getNodeID() != ASTNodeID.TryID) continue;
                        emit = true;
                        break;
                    }
                }
                if ((asDoc = (ASDocComment)functionNode.getASDocComment()) != null) {
                    String asDocString = asDoc.commentNoEnd();
                    String coercionToken = JSRoyaleEmitterTokens.EMIT_COERCION.getToken();
                    int emitIndex = asDocString.indexOf(coercionToken);
                    while (emitIndex != -1) {
                        String rightSide;
                        String emitable = asDocString.substring(emitIndex + coercionToken.length());
                        int endIndex = emitable.indexOf("\n");
                        emitable = emitable.substring(0, endIndex);
                        if ((emitable = emitable.trim()).equals(rightSide = dnode.getQualifiedName())) {
                            emit = true;
                            break;
                        }
                        emitIndex = asDocString.indexOf(coercionToken, emitIndex + coercionToken.length());
                    }
                    String ignoreToken = JSRoyaleEmitterTokens.IGNORE_COERCION.getToken();
                    int ignoreIndex = asDocString.indexOf(ignoreToken);
                    while (ignoreIndex != -1) {
                        String rightSide;
                        String ignorable = asDocString.substring(ignoreIndex + ignoreToken.length());
                        int endIndex = ignorable.indexOf("\n");
                        ignorable = ignorable.substring(0, endIndex);
                        if ((ignorable = ignorable.trim()).equals(rightSide = dnode.getQualifiedName())) {
                            emit = false;
                            break;
                        }
                        ignoreIndex = asDocString.indexOf(ignoreToken, ignoreIndex + ignoreToken.length());
                    }
                }
            }
            if (!emit) {
                if (dnode.getQualifiedName().equals("Function")) {
                    this.write(" /** @type {Function} */ (");
                } else if (dnode.getQualifiedName().equals("Class")) {
                    this.write(" /** @type {Object|null} */ (");
                }
                this.getWalker().walk((IASNode)left);
                if (dnode.getQualifiedName().equals("Function") || dnode.getQualifiedName().equals("Class")) {
                    this.write(")");
                }
                return;
            }
        }
        if ((project = this.getProject()) instanceof RoyaleJSProject) {
            ((RoyaleJSProject)project).needLanguage = true;
        }
        this.getEmitter().getModel().needLanguage = true;
        if (node instanceof IBinaryOperatorNode) {
            binaryOperatorNode = (IBinaryOperatorNode)node;
            this.startMapping((ISourceLocation)node, (ISourceLocation)binaryOperatorNode.getLeftOperandNode());
        } else {
            this.startMapping((ISourceLocation)node);
        }
        this.write(JSRoyaleEmitterTokens.LANGUAGE_QNAME);
        this.write(ASEmitterTokens.MEMBER_ACCESS);
        if (id == ASTNodeID.Op_IsID) {
            this.write(ASEmitterTokens.IS);
        } else {
            this.write(ASEmitterTokens.AS);
        }
        this.write(ASEmitterTokens.PAREN_OPEN);
        this.endMapping((ISourceLocation)node);
        this.getWalker().walk((IASNode)left);
        if (node instanceof IBinaryOperatorNode) {
            binaryOperatorNode = (IBinaryOperatorNode)node;
            this.startMapping((ISourceLocation)node, (ISourceLocation)binaryOperatorNode.getLeftOperandNode());
        } else {
            this.startMapping((ISourceLocation)node);
        }
        this.writeToken(ASEmitterTokens.COMMA);
        this.endMapping((ISourceLocation)node);
        if (dnode instanceof IClassDefinition) {
            this.startMapping((ISourceLocation)right);
            if (NativeUtils.isSyntheticJSType(dnode.getQualifiedName())) {
                String synthName;
                JSRoyaleEmitterTokens langMethod;
                if (NativeUtils.isVector(dnode.getQualifiedName()) && dnode instanceof IAppliedVectorDefinition) {
                    langMethod = JSRoyaleEmitterTokens.SYNTH_VECTOR;
                    synthName = this.getEmitter().formatQualifiedName(((IAppliedVectorDefinition)dnode).resolveElementType(project).getQualifiedName());
                } else {
                    langMethod = JSRoyaleEmitterTokens.SYNTH_TYPE;
                    synthName = this.getEmitter().formatQualifiedName(dnode.getQualifiedName());
                }
                this.write(langMethod);
                this.write(ASEmitterTokens.PAREN_OPEN);
                this.write(ASEmitterTokens.SINGLE_QUOTE);
                this.write(synthName);
                this.write(ASEmitterTokens.SINGLE_QUOTE);
                this.write(ASEmitterTokens.PAREN_CLOSE);
                if (project instanceof RoyaleJSProject) {
                    ((RoyaleJSProject)project).needLanguage = true;
                }
                this.getEmitter().getModel().needLanguage = true;
            } else {
                this.write(this.getEmitter().formatQualifiedName(((JSRoyaleEmitter)this.getEmitter()).convertASTypeToJS(dnode.getQualifiedName())));
            }
            this.endMapping((ISourceLocation)right);
        } else {
            this.getWalker().walk((IASNode)right);
        }
        if (node instanceof IBinaryOperatorNode) {
            binaryOperatorNode = (IBinaryOperatorNode)node;
            this.startMapping((ISourceLocation)node, (ISourceLocation)binaryOperatorNode.getLeftOperandNode());
        } else {
            this.startMapping((ISourceLocation)node);
        }
        if (coercion) {
            this.writeToken(ASEmitterTokens.COMMA);
            this.write(ASEmitterTokens.TRUE);
        }
        this.write(ASEmitterTokens.PAREN_CLOSE);
        this.endMapping((ISourceLocation)node);
    }
}

