/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.utils;

public class NativeUtils {
    public static boolean isNative(String type) {
        for (NativeASType test : NativeASType.values()) {
            if (!test.getValue().equals(type)) continue;
            return true;
        }
        return type.startsWith("Vector.<");
    }

    public static boolean isJSNative(String type) {
        for (NativeJSType test : NativeJSType.values()) {
            if (!test.getValue().equals(type)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSyntheticJSType(String type) {
        for (SyntheticJSType test : SyntheticJSType.values()) {
            if (!test.getValue().equals(type)) continue;
            return true;
        }
        return type.startsWith("Vector.<");
    }

    public static boolean isVector(String type) {
        return type != null && type.startsWith("Vector.<");
    }

    public static enum NativeASType {
        Any("*"),
        Argument("Argument"),
        Array("Array"),
        Boolean("Boolean"),
        Class("Class"),
        Date("Date"),
        Error("Error"),
        EvalError("EvalError"),
        Function("Function"),
        Infinity("Infinity"),
        Math("Math"),
        JSON("JSON"),
        NaN("NaN"),
        Namespace("Namespace"),
        Number("Number"),
        Object("Object"),
        QName("QName"),
        RangeError("RangeError"),
        ReferenceError("ReferenceError"),
        RegExp("RegExp"),
        String("String"),
        SyntaxError("SyntaxError"),
        TypeError("TypeError"),
        URIError("URIError"),
        Vector("Vector"),
        XML("XML"),
        XMLList("XMLList"),
        _assert("assert"),
        decodeURI("decodeURI"),
        decodeURIComponent("decodeURIComponent"),
        encodeURI("encodeURI"),
        encodeURIComponent("encodeURIComponent"),
        escape("escape"),
        _int("int"),
        isFinite("isFinite"),
        isNaN("isNaN"),
        isXMLName("isXMLName"),
        parseFloat("parseFloat"),
        parseInt("parseInt"),
        trace("trace"),
        uint("uint"),
        undefined("undefined"),
        unescape("unescape");

        private final String value;

        private NativeASType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum NativeJSType {
        NaN("NaN"),
        Event("Event"),
        Array("Array"),
        RegExp("RegExp"),
        Float32Array("Float32Array"),
        Float64Array("Float64Array"),
        Int8Array("Int8Array"),
        Int16Array("Int16Array"),
        Int32Array("Int32Array"),
        Uint8Array("Uint8Array"),
        Uint8ClampedArray("Uint8ClampedArray"),
        Uint16Array("Uint16Array"),
        Uint32Array("Uint32Array"),
        Date("Date"),
        Math("Math"),
        Error("Error"),
        RangeError("RangeError"),
        Boolean("Boolean"),
        decodeURI("decodeURI"),
        decodeURIComponent("decodeURIComponent"),
        encodeURI("encodeURI"),
        encodeURIComponent("encodeURIComponent"),
        escape("escape"),
        isFinite("isFinite"),
        isNaN("isNaN"),
        Map("Map"),
        Number("Number"),
        Object("Object"),
        parseFloat("parseFloat"),
        parseInt("parseInt"),
        String("String"),
        undefined("undefined"),
        unescape("unescape"),
        window("window"),
        _int("int"),
        trace("trace"),
        uint("uint"),
        _byte("byte");

        private final String value;

        private NativeJSType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum SyntheticJSType {
        _int("int"),
        uint("uint"),
        Vector("Vector"),
        Class("Class");

        private final String value;

        private SyntheticJSType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

