/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.utils;

import com.google.debugging.sourcemap.FilePosition;
import com.google.debugging.sourcemap.SourceMapConsumerV3;
import com.google.debugging.sourcemap.SourceMapGeneratorV3;
import com.google.debugging.sourcemap.SourceMapParseException;
import java.io.IOException;

public class SourceMapUtils {
    public static String sourceMapConsumerToString(SourceMapConsumerV3 consumer, String file) {
        SourceMapGeneratorV3 generator = SourceMapUtils.sourceMapConsumerToGenerator(consumer);
        StringBuilder builder = new StringBuilder();
        try {
            generator.appendTo((Appendable)builder, file);
        }
        catch (IOException e) {
            return "";
        }
        return builder.toString();
    }

    public static SourceMapGeneratorV3 sourceMapConsumerToGenerator(SourceMapConsumerV3 consumer) {
        final SourceMapGeneratorV3 generator = new SourceMapGeneratorV3();
        final SourceMapEntryCounter counter = new SourceMapEntryCounter();
        generator.setSourceRoot(consumer.getSourceRoot());
        consumer.visitMappings((SourceMapConsumerV3.EntryVisitor)counter);
        consumer.visitMappings(new SourceMapConsumerV3.EntryVisitor(){
            private int index = 0;

            public void visit(String sourceName, String symbolName, FilePosition sourceStartPosition, FilePosition startPosition, FilePosition endPosition) {
                generator.addMapping(sourceName, symbolName, sourceStartPosition, startPosition, endPosition);
                ++this.index;
                if (this.index == counter.count) {
                    SourceMapUtils.appendExtraMappingToGenerator(generator, sourceName, symbolName, sourceStartPosition, startPosition, endPosition);
                }
            }
        });
        return generator;
    }

    public static SourceMapGeneratorV3 sourceMapConsumerToGeneratorWithRemappedSourceRoot(SourceMapConsumerV3 consumer, String sourceRoot, String className) {
        final SourceMapGeneratorV3 generator = new SourceMapGeneratorV3();
        final SourceMapEntryCounter counter = new SourceMapEntryCounter();
        final String startPath = "/" + className.replace(".", "/") + ".";
        generator.setSourceRoot(sourceRoot);
        consumer.visitMappings((SourceMapConsumerV3.EntryVisitor)counter);
        consumer.visitMappings(new SourceMapConsumerV3.EntryVisitor(){
            private int index = 0;

            public void visit(String sourceName, String symbolName, FilePosition sourceStartPosition, FilePosition startPosition, FilePosition endPosition) {
                String newSourceName = sourceName;
                int startPathIndex = newSourceName.indexOf(startPath);
                if (startPathIndex != -1) {
                    newSourceName = newSourceName.substring(startPathIndex + 1);
                }
                generator.addMapping(newSourceName, symbolName, sourceStartPosition, startPosition, endPosition);
                ++this.index;
                if (this.index == counter.count) {
                    SourceMapUtils.appendExtraMappingToGenerator(generator, newSourceName, symbolName, sourceStartPosition, startPosition, endPosition);
                }
            }
        });
        return generator;
    }

    public static SourceMapConsumerV3 addLineToSourceMap(SourceMapConsumerV3 consumer, String sourceFileName, final int lineToAdd) {
        if (consumer == null) {
            return null;
        }
        final SourceMapGeneratorV3 generator = new SourceMapGeneratorV3();
        final SourceMapEntryCounter counter = new SourceMapEntryCounter();
        generator.setSourceRoot(consumer.getSourceRoot());
        consumer.visitMappings((SourceMapConsumerV3.EntryVisitor)counter);
        consumer.visitMappings(new SourceMapConsumerV3.EntryVisitor(){
            private int index = 0;

            public void visit(String sourceName, String symbolName, FilePosition sourceStartPosition, FilePosition startPosition, FilePosition endPosition) {
                if (startPosition.getLine() >= lineToAdd) {
                    startPosition = new FilePosition(startPosition.getLine() + 1, startPosition.getColumn());
                    endPosition = new FilePosition(endPosition.getLine() + 1, endPosition.getColumn());
                }
                generator.addMapping(sourceName, symbolName, sourceStartPosition, startPosition, endPosition);
                ++this.index;
                if (this.index == counter.count) {
                    SourceMapUtils.appendExtraMappingToGenerator(generator, sourceName, symbolName, sourceStartPosition, startPosition, endPosition);
                }
            }
        });
        return SourceMapUtils.sourceMapGeneratorToConsumer(generator, sourceFileName);
    }

    public static SourceMapConsumerV3 removeLineFromSourceMap(SourceMapConsumerV3 consumer, String sourceFileName, final int lineToRemove) {
        if (consumer == null) {
            return null;
        }
        final SourceMapGeneratorV3 generator = new SourceMapGeneratorV3();
        final SourceMapEntryCounter counter = new SourceMapEntryCounter();
        generator.setSourceRoot(consumer.getSourceRoot());
        consumer.visitMappings((SourceMapConsumerV3.EntryVisitor)counter);
        consumer.visitMappings(new SourceMapConsumerV3.EntryVisitor(){
            private int index = 0;

            public void visit(String sourceName, String symbolName, FilePosition sourceStartPosition, FilePosition startPosition, FilePosition endPosition) {
                if (startPosition.getLine() == lineToRemove) {
                    return;
                }
                if (startPosition.getLine() > lineToRemove) {
                    startPosition = new FilePosition(startPosition.getLine() - 1, startPosition.getColumn());
                }
                if (endPosition.getLine() > lineToRemove) {
                    endPosition = new FilePosition(endPosition.getLine() - 1, endPosition.getColumn());
                }
                generator.addMapping(sourceName, symbolName, sourceStartPosition, startPosition, endPosition);
                ++this.index;
                if (this.index == counter.count) {
                    SourceMapUtils.appendExtraMappingToGenerator(generator, sourceName, symbolName, sourceStartPosition, startPosition, endPosition);
                }
            }
        });
        return SourceMapUtils.sourceMapGeneratorToConsumer(generator, sourceFileName);
    }

    private static void appendExtraMappingToGenerator(SourceMapGeneratorV3 generator, String sourceName, String symbolName, FilePosition sourceStartPosition, FilePosition startPosition, FilePosition endPosition) {
        FilePosition newEndPosition = new FilePosition(endPosition.getLine(), endPosition.getColumn() + 1);
        generator.addMapping(sourceName, symbolName, sourceStartPosition, endPosition, newEndPosition);
    }

    public static String sourceMapGeneratorToString(SourceMapGeneratorV3 generator, String fileName) {
        StringBuilder builder = new StringBuilder();
        try {
            generator.appendTo((Appendable)builder, fileName);
        }
        catch (IOException e) {
            return null;
        }
        return builder.toString();
    }

    public static SourceMapConsumerV3 sourceMapGeneratorToConsumer(SourceMapGeneratorV3 generator, String fileName) {
        String generatorString = SourceMapUtils.sourceMapGeneratorToString(generator, fileName);
        if (generatorString == null) {
            return null;
        }
        SourceMapConsumerV3 consumer = new SourceMapConsumerV3();
        try {
            consumer.parse(generatorString);
        }
        catch (SourceMapParseException e) {
            return null;
        }
        return consumer;
    }

    private static class SourceMapEntryCounter
    implements SourceMapConsumerV3.EntryVisitor {
        private int count = 0;

        private SourceMapEntryCounter() {
        }

        public void visit(String sourceName, String symbolName, FilePosition sourceStartPosition, FilePosition startPosition, FilePosition endPosition) {
            ++this.count;
        }
    }
}

