/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter;

import java.io.Closeable;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.royale.compiler.internal.parsing.mxml.MXMLToken;
import org.apache.royale.compiler.internal.parsing.mxml.MXMLTokenizer;
import org.apache.royale.compiler.parsing.IMXMLToken;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.UnexpectedExceptionProblem;
import org.apache.royale.formatter.ASTokenFormatter;
import org.apache.royale.formatter.FormatterSettings;
import org.apache.royale.formatter.internal.BaseTokenFormatter;

public class MXMLTokenFormatter
extends BaseTokenFormatter {
    private static final int TOKEN_TYPE_EXTRA = 999999;
    private static final Pattern SCRIPT_START_PATTERN = Pattern.compile("<((?:mx|fx):(Script|Metadata))");
    private static final Pattern TAG_START_WITH_OPTIONAL_CDATA_PATTERN = Pattern.compile("^<((?:mx|fx):(\\w+))>\\s*(<!\\[CDATA\\[)?");
    private static final Pattern TAG_END_WITH_OPTIONAL_CDATA_PATTERN = Pattern.compile("(?:\\]\\]>)?\\s*<\\/(?:mx|fx):(?:\\w+)>$");
    private static final String FORMATTER_TAG_OFF = "@formatter:off";
    private static final String FORMATTER_TAG_ON = "@formatter:on";
    private int indent;
    private int numRequiredNewLines;
    private boolean requiredSpace;
    private boolean inOpenTag;
    private boolean inCloseTag;
    private boolean skipFormatting;
    private String attributeIndent;
    private IMXMLToken prevToken;
    private IMXMLToken prevTokenOrExtra;
    private IMXMLToken token;
    private IMXMLToken nextToken;
    private List<ElementStackItem> elementStack;

    public MXMLTokenFormatter(FormatterSettings settings) {
        super(settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(String filePath, String text, Collection<ICompilerProblem> problems) {
        if (problems == null) {
            problems = new ArrayList<ICompilerProblem>();
        }
        StringReader textReader = new StringReader(text);
        MXMLTokenizer mxmlTokenizer = new MXMLTokenizer();
        IMXMLToken[] originalTokens = null;
        try {
            originalTokens = mxmlTokenizer.getTokens(textReader);
        }
        finally {
            IOUtils.closeQuietly((Reader)textReader);
            IOUtils.closeQuietly((Closeable)mxmlTokenizer);
        }
        if (mxmlTokenizer.hasTokenizationProblems()) {
            problems.addAll(mxmlTokenizer.getTokenizationProblems());
        }
        if (!this.settings.ignoreProblems && this.hasErrors(problems)) {
            return text;
        }
        List<IMXMLToken> tokens = this.insertExtraMXMLTokens(originalTokens, text);
        try {
            return this.parseTokens(filePath, text, tokens, problems);
        }
        catch (Exception e) {
            if (problems != null) {
                System.err.println(e);
                e.printStackTrace(System.err);
                problems.add((ICompilerProblem)new UnexpectedExceptionProblem((Throwable)e));
            }
            return text;
        }
    }

    private String parseTokens(String filePath, String text, List<IMXMLToken> tokens, Collection<ICompilerProblem> problems) throws Exception {
        this.indent = 0;
        this.numRequiredNewLines = 0;
        this.requiredSpace = false;
        this.inOpenTag = false;
        this.inCloseTag = false;
        this.skipFormatting = false;
        this.attributeIndent = "";
        this.prevToken = null;
        this.prevTokenOrExtra = null;
        this.token = null;
        this.nextToken = null;
        this.elementStack = new ArrayList<ElementStackItem>();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < tokens.size(); ++i) {
            this.token = tokens.get(i);
            this.nextToken = null;
            if (i < tokens.size() - 1) {
                this.nextToken = tokens.get(i + 1);
            }
            if (this.token.getType() == 999999) {
                if (this.skipFormatting) {
                    builder.append(this.token.getText());
                } else {
                    if (i == tokens.size() - 1) {
                        this.numRequiredNewLines = Math.min(1, Math.max(0, this.countNewLinesInExtra(this.token)));
                        this.appendNewLines(builder, this.numRequiredNewLines);
                        break;
                    }
                    this.numRequiredNewLines = Math.max(this.numRequiredNewLines, this.countNewLinesInExtra(this.token));
                }
                this.prevTokenOrExtra = this.token;
                continue;
            }
            if (this.token.getType() == 13) {
                if (this.skipFormatting) {
                    builder.append(this.token.getText());
                    continue;
                }
                if (this.elementStack.isEmpty() || !this.elementStack.get((int)(this.elementStack.size() - 1)).containsText) {
                    this.numRequiredNewLines = Math.max(this.numRequiredNewLines, this.countNewLinesInExtra(this.token));
                } else {
                    builder.append(this.token.getText());
                }
                if (i != tokens.size() - 1) continue;
                this.numRequiredNewLines = Math.min(1, this.numRequiredNewLines);
                this.appendNewLines(builder, this.numRequiredNewLines);
                continue;
            }
            if (this.token.getType() == 8 && SCRIPT_START_PATTERN.matcher(this.token.getText()).matches()) {
                if (this.prevToken != null && this.numRequiredNewLines > 0) {
                    this.appendNewLines(builder, this.numRequiredNewLines);
                }
                StringBuilder scriptBuilder = new StringBuilder();
                scriptBuilder.append(this.token.getText());
                boolean inScriptCloseTag = false;
                while (i < tokens.size() - 1) {
                    this.token = tokens.get(++i);
                    scriptBuilder.append(this.token.getText());
                    if (this.token.getType() == 3) {
                        inScriptCloseTag = true;
                        continue;
                    }
                    if (!inScriptCloseTag || this.token.getType() != 11) continue;
                }
                if (problems == null) {
                    problems = new ArrayList<ICompilerProblem>();
                }
                builder.append(this.formatMXMLScriptElement(filePath, this.token.getLine(), scriptBuilder.toString(), problems));
                if (this.hasErrors(problems)) {
                    return text;
                }
                this.prevToken = this.token;
                this.prevTokenOrExtra = this.token;
                this.requiredSpace = false;
                this.numRequiredNewLines = 1;
                continue;
            }
            switch (this.token.getType()) {
                case 8: {
                    this.inOpenTag = true;
                    boolean containsText = !this.elementStack.isEmpty() && this.elementStack.get((int)(this.elementStack.size() - 1)).containsText;
                    this.elementStack.add(new ElementStackItem(this.token, this.token.getText().substring(1), containsText));
                    break;
                }
                case 3: {
                    if (this.elementStack.isEmpty() || !this.elementStack.get((int)(this.elementStack.size() - 1)).containsText) {
                        this.indent = this.decreaseIndent(this.indent);
                    }
                    this.inCloseTag = true;
                    break;
                }
                case 7: {
                    this.requiredSpace = true;
                }
            }
            if (!this.skipFormatting && this.prevToken != null) {
                if (this.numRequiredNewLines > 0) {
                    this.appendNewLines(builder, this.numRequiredNewLines);
                    this.appendIndent(builder, this.indent);
                    if (this.attributeIndent.length() > 0) {
                        builder.append(this.attributeIndent);
                    }
                } else if (this.requiredSpace) {
                    builder.append(' ');
                }
            }
            builder.append(this.token.getText());
            this.requiredSpace = false;
            this.numRequiredNewLines = 0;
            switch (this.token.getType()) {
                case 9: {
                    this.numRequiredNewLines = Math.max(this.numRequiredNewLines, 1);
                    break;
                }
                case 3: {
                    if (this.nextToken != null && this.nextToken.getType() != 11 && this.nextToken.getType() != 5 && this.nextToken.getType() != 999999) {
                        this.requiredSpace = true;
                    }
                    if (this.elementStack.isEmpty()) {
                        return text;
                    }
                    String elementName = this.token.getText().substring(2);
                    ElementStackItem elementItem = this.elementStack.remove(this.elementStack.size() - 1);
                    if (elementName.equals(elementItem.elementName)) break;
                    return text;
                }
                case 8: {
                    if (this.nextToken == null || this.nextToken.getType() == 11 || this.nextToken.getType() == 5) break;
                    this.attributeIndent = this.getAttributeIndent(this.token);
                    if (this.nextToken.getType() == 999999) break;
                    this.requiredSpace = true;
                    break;
                }
                case 11: {
                    if (this.inOpenTag) {
                        ElementStackItem element = this.elementStack.get(this.elementStack.size() - 1);
                        if (!element.containsText) {
                            element.containsText = this.elementContainsText(tokens, i + 1, element.token);
                        }
                        if (this.elementStack.isEmpty() || !this.elementStack.get((int)(this.elementStack.size() - 1)).containsText) {
                            this.indent = this.increaseIndent(this.indent);
                        }
                    } else if (this.elementStack.isEmpty() || !this.elementStack.get((int)(this.elementStack.size() - 1)).containsText) {
                        this.numRequiredNewLines = Math.max(this.numRequiredNewLines, 1);
                    }
                    this.inOpenTag = false;
                    this.attributeIndent = "";
                    this.inCloseTag = false;
                    break;
                }
                case 5: {
                    if (this.inOpenTag) {
                        this.elementStack.remove(this.elementStack.size() - 1);
                    } else if (this.elementStack.isEmpty() || !this.elementStack.get((int)(this.elementStack.size() - 1)).containsText) {
                        this.numRequiredNewLines = Math.max(this.numRequiredNewLines, 1);
                    }
                    this.inOpenTag = false;
                    this.attributeIndent = "";
                    this.inCloseTag = false;
                    break;
                }
                case 10: {
                    if (!this.inOpenTag || !this.settings.mxmlInsertNewLineBetweenAttributes || this.nextToken == null || this.nextToken.getType() == 11 || this.nextToken.getType() == 5) break;
                    this.numRequiredNewLines = Math.max(this.numRequiredNewLines, 1);
                    break;
                }
                case 4: {
                    String tokenText = this.token.getText();
                    String trimmed = tokenText.substring(4, tokenText.length() - 3).trim();
                    if (!this.skipFormatting && FORMATTER_TAG_OFF.equals(trimmed)) {
                        this.skipFormatting = true;
                        break;
                    }
                    if (!this.skipFormatting || !FORMATTER_TAG_ON.equals(trimmed)) break;
                    this.skipFormatting = false;
                    break;
                }
            }
            this.prevToken = this.token;
            this.prevTokenOrExtra = this.token;
        }
        return builder.toString();
    }

    private String formatMXMLScriptElement(String filePath, int line, String text, Collection<ICompilerProblem> problems) {
        boolean requireCdata;
        Object indent = "\t";
        if (this.settings.insertSpaces) {
            indent = "";
            for (int i = 0; i < this.settings.tabSize; ++i) {
                indent = (String)indent + " ";
            }
        }
        StringBuilder builder = new StringBuilder();
        Matcher scriptStartMatcher = TAG_START_WITH_OPTIONAL_CDATA_PATTERN.matcher(text);
        if (!scriptStartMatcher.find() || scriptStartMatcher.end() > text.length()) {
            return text;
        }
        int startEndSearch = scriptStartMatcher.end();
        Matcher scriptEndMatcher = TAG_END_WITH_OPTIONAL_CDATA_PATTERN.matcher(text.substring(startEndSearch));
        if (!scriptEndMatcher.find()) {
            return text;
        }
        String scriptTagText = scriptStartMatcher.group(1);
        String scriptTagName = scriptStartMatcher.group(2);
        String cdataText = scriptStartMatcher.group(3);
        String scriptText = text.substring(startEndSearch, startEndSearch + scriptEndMatcher.start());
        boolean bl = requireCdata = cdataText != null || "Script".equals(scriptTagName);
        if (problems == null) {
            problems = new ArrayList<ICompilerProblem>();
        }
        ASTokenFormatter asFormatter = new ASTokenFormatter(this.settings);
        String formattedScriptText = asFormatter.format(filePath + "@Script[" + line + "]", scriptText, problems);
        if (!this.settings.ignoreProblems && this.hasErrors(problems)) {
            return text;
        }
        if (formattedScriptText.length() > 0) {
            CharSequence[] formattedLines = formattedScriptText.split("\n");
            String lineIndent = requireCdata ? (String)indent + (String)indent + (String)indent : (String)indent + (String)indent;
            for (int i = 0; i < formattedLines.length; ++i) {
                formattedLines[i] = lineIndent + (String)formattedLines[i];
            }
            formattedScriptText = String.join((CharSequence)"\n", formattedLines);
        }
        builder.append((String)indent);
        builder.append("<");
        builder.append(scriptTagText);
        builder.append(">\n");
        if (requireCdata) {
            builder.append((String)indent);
            builder.append((String)indent);
            builder.append("<![CDATA[\n");
        }
        if (formattedScriptText.length() > 0) {
            builder.append(formattedScriptText);
            builder.append("\n");
        }
        if (requireCdata) {
            builder.append((String)indent);
            builder.append((String)indent);
            builder.append("]]>\n");
        }
        builder.append((String)indent);
        builder.append("</");
        builder.append(scriptTagText);
        builder.append(">");
        return builder.toString();
    }

    private boolean elementContainsText(List<IMXMLToken> tokens, int startIndex, IMXMLToken openTagToken) {
        ArrayList<IMXMLToken> elementStack = new ArrayList<IMXMLToken>();
        elementStack.add(openTagToken);
        block6: for (int i = startIndex; i < tokens.size(); ++i) {
            IMXMLToken token = tokens.get(i);
            switch (token.getType()) {
                case 12: {
                    if (elementStack.size() != 1) continue block6;
                    return true;
                }
                case 8: {
                    elementStack.add(token);
                    continue block6;
                }
                case 5: {
                    elementStack.remove(elementStack.size() - 1);
                    if (elementStack.size() != 0) continue block6;
                    return false;
                }
                case 3: {
                    elementStack.remove(elementStack.size() - 1);
                    if (elementStack.size() != 0) continue block6;
                    return false;
                }
            }
        }
        return false;
    }

    private int countNewLinesInExtra(IMXMLToken token) {
        if (token == null || token.getType() != 13 && token.getType() != 999999) {
            return 0;
        }
        int numNewLinesInWhitespace = 0;
        String whitespace = token.getText();
        int index = -1;
        while ((index = whitespace.indexOf(10, index + 1)) != -1) {
            ++numNewLinesInWhitespace;
        }
        return numNewLinesInWhitespace;
    }

    private String getAttributeIndent(IMXMLToken openTagToken) {
        int indentSize;
        if (!this.settings.mxmlAlignAttributes) {
            return this.getIndent();
        }
        Object result = "";
        for (indentSize = openTagToken.getText().length() + 1; indentSize >= this.settings.tabSize; indentSize -= this.settings.tabSize) {
            result = (String)result + this.getIndent();
        }
        for (int i = 0; i < indentSize; ++i) {
            result = (String)result + " ";
        }
        return result;
    }

    private List<IMXMLToken> insertExtraMXMLTokens(IMXMLToken[] originalTokens, String text) {
        ArrayList<IMXMLToken> tokens = new ArrayList<IMXMLToken>();
        IMXMLToken prevToken = null;
        for (IMXMLToken token : originalTokens) {
            if (prevToken != null) {
                int start = prevToken.getEnd();
                int end = token.getStart();
                if (end > start) {
                    String tokenText = text.substring(start, end);
                    MXMLToken extraToken = new MXMLToken(999999, start, end, prevToken.getLine(), prevToken.getColumn() + end - start, tokenText);
                    extraToken.setEndLine(token.getLine());
                    extraToken.setEndLine(token.getColumn());
                    tokens.add(extraToken);
                }
            }
            tokens.add(token);
            prevToken = token;
        }
        if (prevToken != null) {
            int start = prevToken.getEnd();
            int end = text.length();
            if (end > start) {
                String tokenText = text.substring(start, end);
                MXMLToken extraToken = new MXMLToken(999999, start, end, prevToken.getLine(), prevToken.getColumn() + end - start, tokenText);
                extraToken.setEndLine(prevToken.getLine());
                extraToken.setEndLine(prevToken.getColumn());
                tokens.add(extraToken);
            }
        }
        return tokens;
    }

    private static class ElementStackItem {
        public IMXMLToken token;
        public String elementName;
        public boolean containsText = false;

        public ElementStackItem(IMXMLToken token, String elementName, boolean containsText) {
            this.token = token;
            this.elementName = elementName;
            this.containsText = containsText;
        }
    }
}

