////////////////////////////////////////////////////////////////////////////////
//
//  Licensed to the Apache Software Foundation (ASF) under one or more
//  contributor license agreements.  See the NOTICE file distributed with
//  this work for additional information regarding copyright ownership.
//  The ASF licenses this file to You under the Apache License, Version 2.0
//  (the "License"); you may not use this file except in compliance with
//  the License.  You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
////////////////////////////////////////////////////////////////////////////////
package
{
    /**
     *  The FontAwesome6ProIconType class list all possible icons
	 *  for Font Awesome Pro version 6.x, excluding the Free version icons (FontAwesome6IconType class),
     *  found in https://fontawesome.com/ to use with the 
     *  FontAwesomeIcon class.
	 * 
     *
     *  @langversion 3.0
     *  @playerversion Flash 10.2
     *  @playerversion AIR 2.6
     *  @productversion Royale 0.9.11
     */
    public class FontAwesome6ProIconType
    {
        /**
		 *  constructor.
         * 
		 *  @langversion 3.0
		 *  @playerversion Flash 10.2
		 *  @playerversion AIR 2.6
		 *  @productversion Royale 0.9.11
		 */
		public function FontAwesome6ProIconType()
		{
			super();
		}

		public static const _360_DEGREES:String = '360-degrees';
		public static const ABACUS:String = 'abacus';
		public static const ACCENT_GRAVE:String = 'accent-grave';
		public static const ACORN:String = 'acorn';
		public static const AIR_CONDITIONER:String = 'air-conditioner';
		public static const AIRPLAY:String = 'airplay';
		public static const ALARM_CLOCK:String = 'alarm-clock';
		public static const ALARM_EXCLAMATION:String = 'alarm-exclamation';
		public static const ALARM_PLUS:String = 'alarm-plus';
		public static const ALARM_SNOOZE:String = 'alarm-snooze';
		public static const ALBUM:String = 'album';
		public static const ALBUM_CIRCLE_PLUS:String = 'album-circle-plus';
		public static const ALBUM_CIRCLE_USER:String = 'album-circle-user';
		public static const ALBUM_COLLECTION:String = 'album-collection';
		public static const ALBUM_COLLECTION_CIRCLE_PLUS:String = 'album-collection-circle-plus';
		public static const ALBUM_COLLECTION_CIRCLE_USER:String = 'album-collection-circle-user';
		public static const ALICORN:String = 'alicorn';
		public static const ALIEN:String = 'alien';
		public static const ALIEN_8BIT:String = 'alien-8bit';
		public static const ALIEN_MONSTER:String = 'alien-monster';
		public static const ALIGN_SLASH:String = 'align-slash';
		public static const ALT:String = 'alt';
		public static const AMPERSAND:String = 'ampersand';
		public static const AMP_GUITAR:String = 'amp-guitar';
		public static const ANALYTICS:String = 'analytics';
		public static const ANGEL:String = 'angel';
		public static const ANGLE:String = 'angle';
		public static const ANGLE_90:String = 'angle-90';
		public static const ANGLES_UP_DOWN:String = 'angles-up-down';
		public static const ANT:String = 'ant';
		public static const APARTMENT:String = 'apartment';
		public static const APERTURE:String = 'aperture';
		public static const APOSTROPHE:String = 'apostrophe';
		public static const APPLE_CORE:String = 'apple-core';
		public static const APPLE_CRATE:String = 'apple-crate';
		public static const ARROW_ALT_DOWN:String = 'arrow-alt-down';
		public static const ARROW_ALT_FROM_BOTTOM:String = 'arrow-alt-from-bottom';
		public static const ARROW_ALT_FROM_LEFT:String = 'arrow-alt-from-left';
		public static const ARROW_ALT_FROM_RIGHT:String = 'arrow-alt-from-right';
		public static const ARROW_ALT_FROM_TOP:String = 'arrow-alt-from-top';
		public static const ARROW_ALT_LEFT:String = 'arrow-alt-left';
		public static const ARROW_ALT_RIGHT:String = 'arrow-alt-right';
		public static const ARROW_ALT_SQUARE_DOWN:String = 'arrow-alt-square-down';
		public static const ARROW_ALT_SQUARE_LEFT:String = 'arrow-alt-square-left';
		public static const ARROW_ALT_SQUARE_RIGHT:String = 'arrow-alt-square-right';
		public static const ARROW_ALT_SQUARE_UP:String = 'arrow-alt-square-up';
		public static const ARROW_ALT_TO_BOTTOM:String = 'arrow-alt-to-bottom';
		public static const ARROW_ALT_TO_LEFT:String = 'arrow-alt-to-left';
		public static const ARROW_ALT_TO_RIGHT:String = 'arrow-alt-to-right';
		public static const ARROW_ALT_TO_TOP:String = 'arrow-alt-to-top';
		public static const ARROW_ALT_UP:String = 'arrow-alt-up';
		public static const ARROW_DOWN_ARROW_UP:String = 'arrow-down-arrow-up';
		public static const ARROW_DOWN_BIG_SMALL:String = 'arrow-down-big-small';
		public static const ARROW_DOWN_FROM_ARC:String = 'arrow-down-from-arc';
		public static const ARROW_DOWN_FROM_BRACKET:String = 'arrow-down-from-bracket';
		public static const ARROW_DOWN_FROM_DOTTED_LINE:String = 'arrow-down-from-dotted-line';
		public static const ARROW_DOWN_FROM_LINE:String = 'arrow-down-from-line';
		public static const ARROW_DOWN_LEFT:String = 'arrow-down-left';
		public static const ARROW_DOWN_LEFT_AND_ARROW_UP_RIGHT_TO_CENTER:String = 'arrow-down-left-and-arrow-up-right-to-center';
		public static const ARROW_DOWN_RIGHT:String = 'arrow-down-right';
		public static const ARROW_DOWN_SMALL_BIG:String = 'arrow-down-small-big';
		public static const ARROW_DOWN_SQUARE_TRIANGLE:String = 'arrow-down-square-triangle';
		public static const ARROW_DOWN_TO_ARC:String = 'arrow-down-to-arc';
		public static const ARROW_DOWN_TO_BRACKET:String = 'arrow-down-to-bracket';
		public static const ARROW_DOWN_TO_DOTTED_LINE:String = 'arrow-down-to-dotted-line';
		public static const ARROW_DOWN_TO_LINE:String = 'arrow-down-to-line';
		public static const ARROW_DOWN_TO_SQUARE:String = 'arrow-down-to-square';
		public static const ARROW_DOWN_TRIANGLE_SQUARE:String = 'arrow-down-triangle-square';
		public static const ARROW_FROM_BOTTOM:String = 'arrow-from-bottom';
		public static const ARROW_FROM_LEFT:String = 'arrow-from-left';
		public static const ARROW_FROM_RIGHT:String = 'arrow-from-right';
		public static const ARROW_FROM_TOP:String = 'arrow-from-top';
		public static const ARROW_LEFT_FROM_ARC:String = 'arrow-left-from-arc';
		public static const ARROW_LEFT_FROM_BRACKET:String = 'arrow-left-from-bracket';
		public static const ARROW_LEFT_FROM_LINE:String = 'arrow-left-from-line';
		public static const ARROW_LEFT_LONG_TO_LINE:String = 'arrow-left-long-to-line';
		public static const ARROW_LEFT_TO_ARC:String = 'arrow-left-to-arc';
		public static const ARROW_LEFT_TO_BRACKET:String = 'arrow-left-to-bracket';
		public static const ARROW_LEFT_TO_LINE:String = 'arrow-left-to-line';
		public static const ARROW_PROGRESS:String = 'arrow-progress';
		public static const ARROW_RIGHT_FROM_ARC:String = 'arrow-right-from-arc';
		public static const ARROW_RIGHT_FROM_LINE:String = 'arrow-right-from-line';
		public static const ARROW_RIGHT_LONG_TO_LINE:String = 'arrow-right-long-to-line';
		public static const ARROW_RIGHT_TO_ARC:String = 'arrow-right-to-arc';
		public static const ARROW_RIGHT_TO_LINE:String = 'arrow-right-to-line';
		public static const ARROWS_CROSS:String = 'arrows-cross';
		public static const ARROWS_FROM_DOTTED_LINE:String = 'arrows-from-dotted-line';
		public static const ARROWS_FROM_LINE:String = 'arrows-from-line';
		public static const ARROWS_MAXIMIZE:String = 'arrows-maximize';
		public static const ARROWS_MINIMIZE:String = 'arrows-minimize';
		public static const ARROW_SQUARE_DOWN:String = 'arrow-square-down';
		public static const ARROW_SQUARE_LEFT:String = 'arrow-square-left';
		public static const ARROW_SQUARE_RIGHT:String = 'arrow-square-right';
		public static const ARROW_SQUARE_UP:String = 'arrow-square-up';
		public static const ARROWS_REPEAT:String = 'arrows-repeat';
		public static const ARROWS_REPEAT_1:String = 'arrows-repeat-1';
		public static const ARROWS_RETWEET:String = 'arrows-retweet';
		public static const ARROWS_ROTATE_REVERSE:String = 'arrows-rotate-reverse';
		public static const ARROWS_TO_DOTTED_LINE:String = 'arrows-to-dotted-line';
		public static const ARROWS_TO_LINE:String = 'arrows-to-line';
		public static const ARROW_TO_BOTTOM:String = 'arrow-to-bottom';
		public static const ARROW_TO_LEFT:String = 'arrow-to-left';
		public static const ARROW_TO_RIGHT:String = 'arrow-to-right';
		public static const ARROW_TO_TOP:String = 'arrow-to-top';
		public static const ARROW_TURN_DOWN_LEFT:String = 'arrow-turn-down-left';
		public static const ARROW_TURN_DOWN_RIGHT:String = 'arrow-turn-down-right';
		public static const ARROW_TURN_LEFT:String = 'arrow-turn-left';
		public static const ARROW_TURN_LEFT_DOWN:String = 'arrow-turn-left-down';
		public static const ARROW_TURN_LEFT_UP:String = 'arrow-turn-left-up';
		public static const ARROW_TURN_RIGHT:String = 'arrow-turn-right';
		public static const ARROW_UP_ARROW_DOWN:String = 'arrow-up-arrow-down';
		public static const ARROW_UP_BIG_SMALL:String = 'arrow-up-big-small';
		public static const ARROW_UP_FROM_ARC:String = 'arrow-up-from-arc';
		public static const ARROW_UP_FROM_DOTTED_LINE:String = 'arrow-up-from-dotted-line';
		public static const ARROW_UP_FROM_LINE:String = 'arrow-up-from-line';
		public static const ARROW_UP_FROM_SQUARE:String = 'arrow-up-from-square';
		public static const ARROW_UP_LEFT:String = 'arrow-up-left';
		public static const ARROW_UP_LEFT_FROM_CIRCLE:String = 'arrow-up-left-from-circle';
		public static const ARROW_UP_RIGHT:String = 'arrow-up-right';
		public static const ARROW_UP_RIGHT_AND_ARROW_DOWN_LEFT_FROM_CENTER:String = 'arrow-up-right-and-arrow-down-left-from-center';
		public static const ARROW_UP_SMALL_BIG:String = 'arrow-up-small-big';
		public static const ARROW_UP_SQUARE_TRIANGLE:String = 'arrow-up-square-triangle';
		public static const ARROW_UP_TO_ARC:String = 'arrow-up-to-arc';
		public static const ARROW_UP_TO_BRACKET:String = 'arrow-up-to-bracket';
		public static const ARROW_UP_TO_DOTTED_LINE:String = 'arrow-up-to-dotted-line';
		public static const ARROW_UP_TO_LINE:String = 'arrow-up-to-line';
		public static const ARROW_UP_TRIANGLE_SQUARE:String = 'arrow-up-triangle-square';
		public static const ATOM_ALT:String = 'atom-alt';
		public static const ATOM_SIMPLE:String = 'atom-simple';
		public static const AUDIO_DESCRIPTION_SLASH:String = 'audio-description-slash';
		public static const AVOCADO:String = 'avocado';
		public static const AWARD_SIMPLE:String = 'award-simple';
		public static const AXE:String = 'axe';
		public static const AXE_BATTLE:String = 'axe-battle';
		public static const BACKPACK:String = 'backpack';
		public static const BADGE:String = 'badge';
		public static const BADGE_CHECK:String = 'badge-check';
		public static const BADGE_DOLLAR:String = 'badge-dollar';
		public static const BADGE_PERCENT:String = 'badge-percent';
		public static const BADGER_HONEY:String = 'badger-honey';
		public static const BADGE_SHERIFF:String = 'badge-sheriff';
		public static const BADMINTON:String = 'badminton';
		public static const BAGEL:String = 'bagel';
		public static const BAG_SEEDLING:String = 'bag-seedling';
		public static const BAG_SHOPPING_MINUS:String = 'bag-shopping-minus';
		public static const BAG_SHOPPING_PLUS:String = 'bag-shopping-plus';
		public static const BAGS_SHOPPING:String = 'bags-shopping';
		public static const BAGUETTE:String = 'baguette';
		public static const BALLOON:String = 'balloon';
		public static const BALLOONS:String = 'balloons';
		public static const BALLOT:String = 'ballot';
		public static const BALLOT_CHECK:String = 'ballot-check';
		public static const BALL_PILE:String = 'ball-pile';
		public static const BANANA:String = 'banana';
		public static const BAN_BUG:String = 'ban-bug';
		public static const BANJO:String = 'banjo';
		public static const BAN_PARKING:String = 'ban-parking';
		public static const BARCODE_ALT:String = 'barcode-alt';
		public static const BARCODE_READ:String = 'barcode-read';
		public static const BARCODE_SCAN:String = 'barcode-scan';
		public static const BARN_SILO:String = 'barn-silo';
		public static const BARS_FILTER:String = 'bars-filter';
		public static const BARS_SORT:String = 'bars-sort';
		public static const BASKETBALL_HOOP:String = 'basketball-hoop';
		public static const BASKET_SHOPPING_MINUS:String = 'basket-shopping-minus';
		public static const BASKET_SHOPPING_PLUS:String = 'basket-shopping-plus';
		public static const BASKET_SHOPPING_SIMPLE:String = 'basket-shopping-simple';
		public static const BAT:String = 'bat';
		public static const BATTERY_1:String = 'battery-1';
		public static const BATTERY_BOLT:String = 'battery-bolt';
		public static const BATTERY_EXCLAMATION:String = 'battery-exclamation';
		public static const BATTERY_LOW:String = 'battery-low';
		public static const BATTERY_SLASH:String = 'battery-slash';
		public static const BED_ALT:String = 'bed-alt';
		public static const BED_BUNK:String = 'bed-bunk';
		public static const BED_EMPTY:String = 'bed-empty';
		public static const BED_FRONT:String = 'bed-front';
		public static const BEE:String = 'bee';
		public static const BEER_FOAM:String = 'beer-foam';
		public static const BEER_MUG:String = 'beer-mug';
		public static const BELL_EXCLAMATION:String = 'bell-exclamation';
		public static const BELL_ON:String = 'bell-on';
		public static const BELL_PLUS:String = 'bell-plus';
		public static const BELL_RING:String = 'bell-ring';
		public static const BELLS:String = 'bells';
		public static const BELL_SCHOOL:String = 'bell-school';
		public static const BELL_SCHOOL_SLASH:String = 'bell-school-slash';
		public static const BENCH_TREE:String = 'bench-tree';
		public static const BETAMAX:String = 'betamax';
		public static const BIKING_MOUNTAIN:String = 'biking-mountain';
		public static const BILLBOARD:String = 'billboard';
		public static const BINARY:String = 'binary';
		public static const BINARY_CIRCLE_CHECK:String = 'binary-circle-check';
		public static const BINARY_LOCK:String = 'binary-lock';
		public static const BINARY_SLASH:String = 'binary-slash';
		public static const BIN_BOTTLES:String = 'bin-bottles';
		public static const BIN_BOTTLES_RECYCLE:String = 'bin-bottles-recycle';
		public static const BIN_RECYCLE:String = 'bin-recycle';
		public static const BIRD:String = 'bird';
		public static const BLANKET:String = 'blanket';
		public static const BLANKET_FIRE:String = 'blanket-fire';
		public static const BLINDS:String = 'blinds';
		public static const BLINDS_OPEN:String = 'blinds-open';
		public static const BLINDS_RAISED:String = 'blinds-raised';
		public static const BLOCK:String = 'block';
		public static const BLOCK_BRICK:String = 'block-brick';
		public static const BLOCK_BRICK_FIRE:String = 'block-brick-fire';
		public static const BLOCK_QUESTION:String = 'block-question';
		public static const BLOCK_QUOTE:String = 'block-quote';
		public static const BLUEBERRIES:String = 'blueberries';
		public static const BOLT_AUTO:String = 'bolt-auto';
		public static const BOLT_SLASH:String = 'bolt-slash';
		public static const BONE_BREAK:String = 'bone-break';
		public static const BOOK_ALT:String = 'book-alt';
		public static const BOOK_ARROW_RIGHT:String = 'book-arrow-right';
		public static const BOOK_ARROW_UP:String = 'book-arrow-up';
		public static const BOOK_BLANK:String = 'book-blank';
		public static const BOOK_CIRCLE:String = 'book-circle';
		public static const BOOK_CIRCLE_ARROW_RIGHT:String = 'book-circle-arrow-right';
		public static const BOOK_CIRCLE_ARROW_UP:String = 'book-circle-arrow-up';
		public static const BOOK_COPY:String = 'book-copy';
		public static const BOOK_FONT:String = 'book-font';
		public static const BOOK_HEART:String = 'book-heart';
		public static const BOOK_LAW:String = 'book-law';
		public static const BOOKMARK_CIRCLE:String = 'bookmark-circle';
		public static const BOOKMARK_SLASH:String = 'bookmark-slash';
		public static const BOOK_OPEN_ALT:String = 'book-open-alt';
		public static const BOOK_OPEN_COVER:String = 'book-open-cover';
		public static const BOOKS:String = 'books';
		public static const BOOK_SECTION:String = 'book-section';
		public static const BOOKS_MEDICAL:String = 'books-medical';
		public static const BOOK_SPARKLES:String = 'book-sparkles';
		public static const BOOK_SPELLS:String = 'book-spells';
		public static const BOOK_USER:String = 'book-user';
		public static const BOOMBOX:String = 'boombox';
		public static const BOOT:String = 'boot';
		public static const BOOTH_CURTAIN:String = 'booth-curtain';
		public static const BOOT_HEELED:String = 'boot-heeled';
		public static const BORDER_BOTTOM:String = 'border-bottom';
		public static const BORDER_BOTTOM_RIGHT:String = 'border-bottom-right';
		public static const BORDER_CENTER_H:String = 'border-center-h';
		public static const BORDER_CENTER_V:String = 'border-center-v';
		public static const BORDER_INNER:String = 'border-inner';
		public static const BORDER_LEFT:String = 'border-left';
		public static const BORDER_OUTER:String = 'border-outer';
		public static const BORDER_RIGHT:String = 'border-right';
		public static const BORDER_STYLE_ALT:String = 'border-style-alt';
		public static const BORDER_TOP:String = 'border-top';
		public static const BOTTLE_BABY:String = 'bottle-baby';
		public static const BOW_ARROW:String = 'bow-arrow';
		public static const BOWL_CHOPSTICKS:String = 'bowl-chopsticks';
		public static const BOWL_CHOPSTICKS_NOODLES:String = 'bowl-chopsticks-noodles';
		public static const BOWL_HOT:String = 'bowl-hot';
		public static const BOWLING_BALL_PIN:String = 'bowling-ball-pin';
		public static const BOWLING_PINS:String = 'bowling-pins';
		public static const BOWL_SALAD:String = 'bowl-salad';
		public static const BOWL_SCOOP:String = 'bowl-scoop';
		public static const BOWL_SCOOPS:String = 'bowl-scoops';
		public static const BOWL_SHAVED_ICE:String = 'bowl-shaved-ice';
		public static const BOWL_SOFT_SERVE:String = 'bowl-soft-serve';
		public static const BOWL_SPOON:String = 'bowl-spoon';
		public static const BOX_ALT:String = 'box-alt';
		public static const BOX_BALLOT:String = 'box-ballot';
		public static const BOX_CHECK:String = 'box-check';
		public static const BOX_CIRCLE_CHECK:String = 'box-circle-check';
		public static const BOX_DOLLAR:String = 'box-dollar';
		public static const BOX_FRAGILE:String = 'box-fragile';
		public static const BOX_FULL:String = 'box-full';
		public static const BOX_HEART:String = 'box-heart';
		public static const BOXING_GLOVE:String = 'boxing-glove';
		public static const BOX_OPEN_FULL:String = 'box-open-full';
		public static const BOX_TAPED:String = 'box-taped';
		public static const BOX_UP:String = 'box-up';
		public static const BOX_USD:String = 'box-usd';
		public static const BRACKET:String = 'bracket';
		public static const BRACKET_CURLY:String = 'bracket-curly';
		public static const BRACKET_CURLY_LEFT:String = 'bracket-curly-left';
		public static const BRACKET_CURLY_RIGHT:String = 'bracket-curly-right';
		public static const BRACKET_LEFT:String = 'bracket-left';
		public static const BRACKET_ROUND:String = 'bracket-round';
		public static const BRACKET_ROUND_RIGHT:String = 'bracket-round-right';
		public static const BRACKETS:String = 'brackets';
		public static const BRACKETS_CURLY:String = 'brackets-curly';
		public static const BRACKET_SQUARE:String = 'bracket-square';
		public static const BRACKET_SQUARE_RIGHT:String = 'bracket-square-right';
		public static const BRACKETS_ROUND:String = 'brackets-round';
		public static const BRACKETS_SQUARE:String = 'brackets-square';
		public static const BRAIN_ARROW_CURVED_RIGHT:String = 'brain-arrow-curved-right';
		public static const BRAIN_CIRCUIT:String = 'brain-circuit';
		public static const BRAKE_WARNING:String = 'brake-warning';
		public static const BREAD_LOAF:String = 'bread-loaf';
		public static const BREAD_SLICE_BUTTER:String = 'bread-slice-butter';
		public static const BRIDGE_SUSPENSION:String = 'bridge-suspension';
		public static const BRIEFCASE_ARROW_RIGHT:String = 'briefcase-arrow-right';
		public static const BRIEFCASE_BLANK:String = 'briefcase-blank';
		public static const BRIGHTNESS:String = 'brightness';
		public static const BRIGHTNESS_LOW:String = 'brightness-low';
		public static const BRING_FORWARD:String = 'bring-forward';
		public static const BRING_FRONT:String = 'bring-front';
		public static const BROCCOLI:String = 'broccoli';
		public static const BROOM_WIDE:String = 'broom-wide';
		public static const BROWSER:String = 'browser';
		public static const BROWSERS:String = 'browsers';
		public static const BUILDING_MAGNIFYING_GLASS:String = 'building-magnifying-glass';
		public static const BUILDING_MEMO:String = 'building-memo';
		public static const BUILDINGS:String = 'buildings';
		public static const BULLDOZER:String = 'bulldozer';
		public static const BULLSEYE_ARROW:String = 'bullseye-arrow';
		public static const BULLSEYE_POINTER:String = 'bullseye-pointer';
		public static const BUOY:String = 'buoy';
		public static const BUOY_MOORING:String = 'buoy-mooring';
		public static const BURGER_CHEESE:String = 'burger-cheese';
		public static const BURGER_FRIES:String = 'burger-fries';
		public static const BURGER_GLASS:String = 'burger-glass';
		public static const BURGER_LETTUCE:String = 'burger-lettuce';
		public static const BURGER_SODA:String = 'burger-soda';
		public static const BURRITO:String = 'burrito';
		public static const BUSINESS_FRONT:String = 'business-front';
		public static const BUS_SCHOOL:String = 'bus-school';
		public static const BUTTER:String = 'butter';
		public static const CABIN:String = 'cabin';
		public static const CABINET_FILING:String = 'cabinet-filing';
		public static const CACTUS:String = 'cactus';
		public static const CADUCEUS:String = 'caduceus';
		public static const CAKE_SLICE:String = 'cake-slice';
		public static const CALCULATOR_ALT:String = 'calculator-alt';
		public static const CALCULATOR_SIMPLE:String = 'calculator-simple';
		public static const CALENDAR_ARROW_DOWN:String = 'calendar-arrow-down';
		public static const CALENDAR_ARROW_UP:String = 'calendar-arrow-up';
		public static const CALENDAR_CIRCLE:String = 'calendar-circle';
		public static const CALENDAR_CIRCLE_EXCLAMATION:String = 'calendar-circle-exclamation';
		public static const CALENDAR_CIRCLE_MINUS:String = 'calendar-circle-minus';
		public static const CALENDAR_CIRCLE_PLUS:String = 'calendar-circle-plus';
		public static const CALENDAR_CIRCLE_USER:String = 'calendar-circle-user';
		public static const CALENDAR_CLOCK:String = 'calendar-clock';
		public static const CALENDAR_DOWNLOAD:String = 'calendar-download';
		public static const CALENDAR_EDIT:String = 'calendar-edit';
		public static const CALENDAR_EXCLAMATION:String = 'calendar-exclamation';
		public static const CALENDAR_HEART:String = 'calendar-heart';
		public static const CALENDAR_IMAGE:String = 'calendar-image';
		public static const CALENDAR_LINES:String = 'calendar-lines';
		public static const CALENDAR_LINES_PEN:String = 'calendar-lines-pen';
		public static const CALENDAR_NOTE:String = 'calendar-note';
		public static const CALENDAR_PEN:String = 'calendar-pen';
		public static const CALENDAR_RANGE:String = 'calendar-range';
		public static const CALENDARS:String = 'calendars';
		public static const CALENDAR_STAR:String = 'calendar-star';
		public static const CALENDAR_TIME:String = 'calendar-time';
		public static const CALENDAR_UPLOAD:String = 'calendar-upload';
		public static const CALENDAR_USERS:String = 'calendar-users';
		public static const CAMCORDER:String = 'camcorder';
		public static const CAMERA_CCTV:String = 'camera-cctv';
		public static const CAMERA_CIRCLE:String = 'camera-circle';
		public static const CAMERA_HOME:String = 'camera-home';
		public static const CAMERA_MOVIE:String = 'camera-movie';
		public static const CAMERA_POLAROID:String = 'camera-polaroid';
		public static const CAMERA_SECURITY:String = 'camera-security';
		public static const CAMERA_SLASH:String = 'camera-slash';
		public static const CAMERA_VIEWFINDER:String = 'camera-viewfinder';
		public static const CAMERA_WEB:String = 'camera-web';
		public static const CAMERA_WEB_SLASH:String = 'camera-web-slash';
		public static const CAMPFIRE:String = 'campfire';
		public static const CANDLE_HOLDER:String = 'candle-holder';
		public static const CANDY:String = 'candy';
		public static const CANDY_BAR:String = 'candy-bar';
		public static const CANDY_CORN:String = 'candy-corn';
		public static const CAN_FOOD:String = 'can-food';
		public static const CANNON:String = 'cannon';
		public static const CARAVAN_ALT:String = 'caravan-alt';
		public static const CARAVAN_SIMPLE:String = 'caravan-simple';
		public static const CAR_BOLT:String = 'car-bolt';
		public static const CAR_BUILDING:String = 'car-building';
		public static const CAR_BUMP:String = 'car-bump';
		public static const CAR_BUS:String = 'car-bus';
		public static const CAR_CIRCLE_BOLT:String = 'car-circle-bolt';
		public static const CARD_CLUB:String = 'card-club';
		public static const CARD_DIAMOND:String = 'card-diamond';
		public static const CARD_HEART:String = 'card-heart';
		public static const CARDS:String = 'cards';
		public static const CARDS_BLANK:String = 'cards-blank';
		public static const CARD_SPADE:String = 'card-spade';
		public static const CARET_CIRCLE_DOWN:String = 'caret-circle-down';
		public static const CARET_CIRCLE_LEFT:String = 'caret-circle-left';
		public static const CARET_CIRCLE_RIGHT:String = 'caret-circle-right';
		public static const CARET_CIRCLE_UP:String = 'caret-circle-up';
		public static const CAR_GARAGE:String = 'car-garage';
		public static const CAR_MECHANIC:String = 'car-mechanic';
		public static const CAR_MIRRORS:String = 'car-mirrors';
		public static const CARS:String = 'cars';
		public static const CAR_SIDE_BOLT:String = 'car-side-bolt';
		public static const CART_ARROW_UP:String = 'cart-arrow-up';
		public static const CART_CIRCLE_ARROW_DOWN:String = 'cart-circle-arrow-down';
		public static const CART_CIRCLE_ARROW_UP:String = 'cart-circle-arrow-up';
		public static const CART_CIRCLE_CHECK:String = 'cart-circle-check';
		public static const CART_CIRCLE_EXCLAMATION:String = 'cart-circle-exclamation';
		public static const CART_CIRCLE_PLUS:String = 'cart-circle-plus';
		public static const CART_CIRCLE_XMARK:String = 'cart-circle-xmark';
		public static const CART_FLATBED_BOXES:String = 'cart-flatbed-boxes';
		public static const CART_FLATBED_EMPTY:String = 'cart-flatbed-empty';
		public static const CAR_TILT:String = 'car-tilt';
		public static const CART_MINUS:String = 'cart-minus';
		public static const CART_SHOPPING_FAST:String = 'cart-shopping-fast';
		public static const CART_XMARK:String = 'cart-xmark';
		public static const CAR_WASH:String = 'car-wash';
		public static const CAR_WRENCH:String = 'car-wrench';
		public static const CASSETTE_BETAMAX:String = 'cassette-betamax';
		public static const CASSETTE_TAPE:String = 'cassette-tape';
		public static const CASSETTE_VHS:String = 'cassette-vhs';
		public static const CASTLE:String = 'castle';
		public static const CAT_SPACE:String = 'cat-space';
		public static const CAULDRON:String = 'cauldron';
		public static const CCTV:String = 'cctv';
		public static const CHAIN_HORIZONTAL:String = 'chain-horizontal';
		public static const CHAIN_HORIZONTAL_SLASH:String = 'chain-horizontal-slash';
		public static const CHAIR_OFFICE:String = 'chair-office';
		public static const CHAMPAGNE_GLASS:String = 'champagne-glass';
		public static const CHART_BULLET:String = 'chart-bullet';
		public static const CHART_CANDLESTICK:String = 'chart-candlestick';
		public static const CHART_KANBAN:String = 'chart-kanban';
		public static const CHART_LINE_DOWN:String = 'chart-line-down';
		public static const CHART_LINE_UP:String = 'chart-line-up';
		public static const CHART_LINE_UP_DOWN:String = 'chart-line-up-down';
		public static const CHART_MIXED:String = 'chart-mixed';
		public static const CHART_MIXED_UP_CIRCLE_CURRENCY:String = 'chart-mixed-up-circle-currency';
		public static const CHART_MIXED_UP_CIRCLE_DOLLAR:String = 'chart-mixed-up-circle-dollar';
		public static const CHART_NETWORK:String = 'chart-network';
		public static const CHART_PIE_ALT:String = 'chart-pie-alt';
		public static const CHART_PIE_SIMPLE:String = 'chart-pie-simple';
		public static const CHART_PIE_SIMPLE_CIRCLE_CURRENCY:String = 'chart-pie-simple-circle-currency';
		public static const CHART_PIE_SIMPLE_CIRCLE_DOLLAR:String = 'chart-pie-simple-circle-dollar';
		public static const CHART_PYRAMID:String = 'chart-pyramid';
		public static const CHART_RADAR:String = 'chart-radar';
		public static const CHART_SCATTER:String = 'chart-scatter';
		public static const CHART_SCATTER_3D:String = 'chart-scatter-3d';
		public static const CHART_SCATTER_BUBBLE:String = 'chart-scatter-bubble';
		public static const CHART_SIMPLE_HORIZONTAL:String = 'chart-simple-horizontal';
		public static const CHART_TREE_MAP:String = 'chart-tree-map';
		public static const CHART_USER:String = 'chart-user';
		public static const CHART_WATERFALL:String = 'chart-waterfall';
		public static const CHEESEBURGER:String = 'cheeseburger';
		public static const CHEESE_SWISS:String = 'cheese-swiss';
		public static const CHERRIES:String = 'cherries';
		public static const CHESS_BISHOP_ALT:String = 'chess-bishop-alt';
		public static const CHESS_BISHOP_PIECE:String = 'chess-bishop-piece';
		public static const CHESS_CLOCK:String = 'chess-clock';
		public static const CHESS_CLOCK_ALT:String = 'chess-clock-alt';
		public static const CHESS_CLOCK_FLIP:String = 'chess-clock-flip';
		public static const CHESS_KING_ALT:String = 'chess-king-alt';
		public static const CHESS_KING_PIECE:String = 'chess-king-piece';
		public static const CHESS_KNIGHT_ALT:String = 'chess-knight-alt';
		public static const CHESS_KNIGHT_PIECE:String = 'chess-knight-piece';
		public static const CHESS_PAWN_ALT:String = 'chess-pawn-alt';
		public static const CHESS_PAWN_PIECE:String = 'chess-pawn-piece';
		public static const CHESS_QUEEN_ALT:String = 'chess-queen-alt';
		public static const CHESS_QUEEN_PIECE:String = 'chess-queen-piece';
		public static const CHESS_ROOK_ALT:String = 'chess-rook-alt';
		public static const CHESS_ROOK_PIECE:String = 'chess-rook-piece';
		public static const CHESTNUT:String = 'chestnut';
		public static const CHEVRON_DOUBLE_DOWN:String = 'chevron-double-down';
		public static const CHEVRON_DOUBLE_LEFT:String = 'chevron-double-left';
		public static const CHEVRON_DOUBLE_RIGHT:String = 'chevron-double-right';
		public static const CHEVRON_DOUBLE_UP:String = 'chevron-double-up';
		public static const CHEVRONS_DOWN:String = 'chevrons-down';
		public static const CHEVRONS_LEFT:String = 'chevrons-left';
		public static const CHEVRON_SQUARE_DOWN:String = 'chevron-square-down';
		public static const CHEVRON_SQUARE_LEFT:String = 'chevron-square-left';
		public static const CHEVRON_SQUARE_RIGHT:String = 'chevron-square-right';
		public static const CHEVRON_SQUARE_UP:String = 'chevron-square-up';
		public static const CHEVRONS_RIGHT:String = 'chevrons-right';
		public static const CHEVRONS_UP:String = 'chevrons-up';
		public static const CHF_SIGN:String = 'chf-sign';
		public static const CHIMNEY:String = 'chimney';
		public static const CHOCOLATE_BAR:String = 'chocolate-bar';
		public static const CHOPSTICKS:String = 'chopsticks';
		public static const CIRCLE_0:String = 'circle-0';
		public static const CIRCLE_1:String = 'circle-1';
		public static const CIRCLE_2:String = 'circle-2';
		public static const CIRCLE_3:String = 'circle-3';
		public static const CIRCLE_4:String = 'circle-4';
		public static const CIRCLE_5:String = 'circle-5';
		public static const CIRCLE_6:String = 'circle-6';
		public static const CIRCLE_7:String = 'circle-7';
		public static const CIRCLE_8:String = 'circle-8';
		public static const CIRCLE_9:String = 'circle-9';
		public static const CIRCLE_A:String = 'circle-a';
		public static const CIRCLE_AMPERSAND:String = 'circle-ampersand';
		public static const CIRCLE_ARROW_DOWN_LEFT:String = 'circle-arrow-down-left';
		public static const CIRCLE_ARROW_DOWN_RIGHT:String = 'circle-arrow-down-right';
		public static const CIRCLE_ARROW_UP_LEFT:String = 'circle-arrow-up-left';
		public static const CIRCLE_ARROW_UP_RIGHT:String = 'circle-arrow-up-right';
		public static const CIRCLE_B:String = 'circle-b';
		public static const CIRCLE_BOLT:String = 'circle-bolt';
		public static const CIRCLE_BOOKMARK:String = 'circle-bookmark';
		public static const CIRCLE_BOOK_OPEN:String = 'circle-book-open';
		public static const CIRCLE_C:String = 'circle-c';
		public static const CIRCLE_CALENDAR:String = 'circle-calendar';
		public static const CIRCLE_CAMERA:String = 'circle-camera';
		public static const CIRCLE_CARET_DOWN:String = 'circle-caret-down';
		public static const CIRCLE_CARET_LEFT:String = 'circle-caret-left';
		public static const CIRCLE_CARET_RIGHT:String = 'circle-caret-right';
		public static const CIRCLE_CARET_UP:String = 'circle-caret-up';
		public static const CIRCLE_D:String = 'circle-d';
		public static const CIRCLE_DASHED:String = 'circle-dashed';
		public static const CIRCLE_DIVIDE:String = 'circle-divide';
		public static const CIRCLE_DOLLAR:String = 'circle-dollar';
		public static const CIRCLE_DOWN_LEFT:String = 'circle-down-left';
		public static const CIRCLE_DOWN_RIGHT:String = 'circle-down-right';
		public static const CIRCLE_E:String = 'circle-e';
		public static const CIRCLE_ELLIPSIS:String = 'circle-ellipsis';
		public static const CIRCLE_ELLIPSIS_VERTICAL:String = 'circle-ellipsis-vertical';
		public static const CIRCLE_ENVELOPE:String = 'circle-envelope';
		public static const CIRCLE_EURO:String = 'circle-euro';
		public static const CIRCLE_EXCLAMATION_CHECK:String = 'circle-exclamation-check';
		public static const CIRCLE_F:String = 'circle-f';
		public static const CIRCLE_G:String = 'circle-g';
		public static const CIRCLE_GF:String = 'circle-gf';
		public static const CIRCLE_HALF:String = 'circle-half';
		public static const CIRCLE_HEART:String = 'circle-heart';
		public static const CIRCLE_I:String = 'circle-i';
		public static const CIRCLE_J:String = 'circle-j';
		public static const CIRCLE_K:String = 'circle-k';
		public static const CIRCLE_L:String = 'circle-l';
		public static const CIRCLE_LOCATION_ARROW:String = 'circle-location-arrow';
		public static const CIRCLE_M:String = 'circle-m';
		public static const CIRCLE_MICROPHONE:String = 'circle-microphone';
		public static const CIRCLE_MICROPHONE_LINES:String = 'circle-microphone-lines';
		public static const CIRCLE_N:String = 'circle-n';
		public static const CIRCLE_O:String = 'circle-o';
		public static const CIRCLE_P:String = 'circle-p';
		public static const CIRCLE_PARKING:String = 'circle-parking';
		public static const CIRCLE_PHONE:String = 'circle-phone';
		public static const CIRCLE_PHONE_FLIP:String = 'circle-phone-flip';
		public static const CIRCLE_PHONE_HANGUP:String = 'circle-phone-hangup';
		public static const CIRCLE_Q:String = 'circle-q';
		public static const CIRCLE_QUARTER:String = 'circle-quarter';
		public static const CIRCLE_QUARTERS:String = 'circle-quarters';
		public static const CIRCLE_QUARTER_STROKE:String = 'circle-quarter-stroke';
		public static const CIRCLE_R:String = 'circle-r';
		public static const CIRCLE_S:String = 'circle-s';
		public static const CIRCLE_SMALL:String = 'circle-small';
		public static const CIRCLE_SORT:String = 'circle-sort';
		public static const CIRCLE_SORT_DOWN:String = 'circle-sort-down';
		public static const CIRCLE_SORT_UP:String = 'circle-sort-up';
		public static const CIRCLES_OVERLAP:String = 'circles-overlap';
		public static const CIRCLE_STAR:String = 'circle-star';
		public static const CIRCLE_STERLING:String = 'circle-sterling';
		public static const CIRCLE_T:String = 'circle-t';
		public static const CIRCLE_THREE_QUARTERS:String = 'circle-three-quarters';
		public static const CIRCLE_THREE_QUARTERS_STROKE:String = 'circle-three-quarters-stroke';
		public static const CIRCLE_TRASH:String = 'circle-trash';
		public static const CIRCLE_U:String = 'circle-u';
		public static const CIRCLE_UP_LEFT:String = 'circle-up-left';
		public static const CIRCLE_UP_RIGHT:String = 'circle-up-right';
		public static const CIRCLE_V:String = 'circle-v';
		public static const CIRCLE_VIDEO:String = 'circle-video';
		public static const CIRCLE_W:String = 'circle-w';
		public static const CIRCLE_WAVEFORM_LINES:String = 'circle-waveform-lines';
		public static const CIRCLE_WIFI:String = 'circle-wifi';
		public static const CIRCLE_WIFI_CIRCLE_WIFI:String = 'circle-wifi-circle-wifi';
		public static const CIRCLE_WIFI_GROUP:String = 'circle-wifi-group';
		public static const CIRCLE_X:String = 'circle-x';
		public static const CIRCLE_Y:String = 'circle-y';
		public static const CIRCLE_YEN:String = 'circle-yen';
		public static const CIRCLE_Z:String = 'circle-z';
		public static const CITRUS:String = 'citrus';
		public static const CITRUS_SLICE:String = 'citrus-slice';
		public static const CLAPPERBOARD_PLAY:String = 'clapperboard-play';
		public static const CLARINET:String = 'clarinet';
		public static const CLAW_MARKS:String = 'claw-marks';
		public static const CLIPBOARD_LIST_CHECK:String = 'clipboard-list-check';
		public static const CLIPBOARD_MEDICAL:String = 'clipboard-medical';
		public static const CLIPBOARD_PRESCRIPTION:String = 'clipboard-prescription';
		public static const CLOCK_DESK:String = 'clock-desk';
		public static const CLOCK_EIGHT:String = 'clock-eight';
		public static const CLOCK_EIGHT_THIRTY:String = 'clock-eight-thirty';
		public static const CLOCK_ELEVEN:String = 'clock-eleven';
		public static const CLOCK_ELEVEN_THIRTY:String = 'clock-eleven-thirty';
		public static const CLOCK_FIVE:String = 'clock-five';
		public static const CLOCK_FIVE_THIRTY:String = 'clock-five-thirty';
		public static const CLOCK_FOUR_THIRTY:String = 'clock-four-thirty';
		public static const CLOCK_NINE:String = 'clock-nine';
		public static const CLOCK_NINE_THIRTY:String = 'clock-nine-thirty';
		public static const CLOCK_ONE:String = 'clock-one';
		public static const CLOCK_ONE_THIRTY:String = 'clock-one-thirty';
		public static const CLOCK_SEVEN:String = 'clock-seven';
		public static const CLOCK_SEVEN_THIRTY:String = 'clock-seven-thirty';
		public static const CLOCK_SIX:String = 'clock-six';
		public static const CLOCK_SIX_THIRTY:String = 'clock-six-thirty';
		public static const CLOCK_TEN:String = 'clock-ten';
		public static const CLOCK_TEN_THIRTY:String = 'clock-ten-thirty';
		public static const CLOCK_THREE:String = 'clock-three';
		public static const CLOCK_THREE_THIRTY:String = 'clock-three-thirty';
		public static const CLOCK_TWELVE:String = 'clock-twelve';
		public static const CLOCK_TWELVE_THIRTY:String = 'clock-twelve-thirty';
		public static const CLOCK_TWO:String = 'clock-two';
		public static const CLOCK_TWO_THIRTY:String = 'clock-two-thirty';
		public static const CLOSED_CAPTIONING_SLASH:String = 'closed-captioning-slash';
		public static const CLOTHES_HANGER:String = 'clothes-hanger';
		public static const CLOUD_BINARY:String = 'cloud-binary';
		public static const CLOUD_BOLT_MOON:String = 'cloud-bolt-moon';
		public static const CLOUD_BOLT_SUN:String = 'cloud-bolt-sun';
		public static const CLOUD_CHECK:String = 'cloud-check';
		public static const CLOUD_DRIZZLE:String = 'cloud-drizzle';
		public static const CLOUD_EXCLAMATION:String = 'cloud-exclamation';
		public static const CLOUD_FOG:String = 'cloud-fog';
		public static const CLOUD_HAIL:String = 'cloud-hail';
		public static const CLOUD_HAIL_MIXED:String = 'cloud-hail-mixed';
		public static const CLOUD_MINUS:String = 'cloud-minus';
		public static const CLOUD_MUSIC:String = 'cloud-music';
		public static const CLOUD_PLUS:String = 'cloud-plus';
		public static const CLOUD_QUESTION:String = 'cloud-question';
		public static const CLOUD_RAINBOW:String = 'cloud-rainbow';
		public static const CLOUDS:String = 'clouds';
		public static const CLOUD_SHOWERS:String = 'cloud-showers';
		public static const CLOUD_SLASH:String = 'cloud-slash';
		public static const CLOUD_SLEET:String = 'cloud-sleet';
		public static const CLOUDS_MOON:String = 'clouds-moon';
		public static const CLOUD_SNOW:String = 'cloud-snow';
		public static const CLOUDS_SUN:String = 'clouds-sun';
		public static const CLOUD_WORD:String = 'cloud-word';
		public static const CLOUD_XMARK:String = 'cloud-xmark';
		public static const CLUB:String = 'club';
		public static const COCONUT:String = 'coconut';
		public static const CODE_PULL_REQUEST_CLOSED:String = 'code-pull-request-closed';
		public static const CODE_PULL_REQUEST_DRAFT:String = 'code-pull-request-draft';
		public static const CODE_SIMPLE:String = 'code-simple';
		public static const COFFEE_BEAN:String = 'coffee-bean';
		public static const COFFEE_BEANS:String = 'coffee-beans';
		public static const COFFEE_POT:String = 'coffee-pot';
		public static const COFFEE_TOGO:String = 'coffee-togo';
		public static const COFFIN:String = 'coffin';
		public static const COFFIN_CROSS:String = 'coffin-cross';
		public static const COIN:String = 'coin';
		public static const COIN_BLANK:String = 'coin-blank';
		public static const COIN_FRONT:String = 'coin-front';
		public static const COIN_VERTICAL:String = 'coin-vertical';
		public static const COLON:String = 'colon';
		public static const COLUMNS_3:String = 'columns-3';
		public static const COMET:String = 'comet';
		public static const COMMA:String = 'comma';
		public static const COMMAND:String = 'command';
		public static const COMMENT_ALT_ARROW_DOWN:String = 'comment-alt-arrow-down';
		public static const COMMENT_ALT_ARROW_UP:String = 'comment-alt-arrow-up';
		public static const COMMENT_ALT_CAPTIONS:String = 'comment-alt-captions';
		public static const COMMENT_ALT_CHECK:String = 'comment-alt-check';
		public static const COMMENT_ALT_DOLLAR:String = 'comment-alt-dollar';
		public static const COMMENT_ALT_DOTS:String = 'comment-alt-dots';
		public static const COMMENT_ALT_EDIT:String = 'comment-alt-edit';
		public static const COMMENT_ALT_EXCLAMATION:String = 'comment-alt-exclamation';
		public static const COMMENT_ALT_IMAGE:String = 'comment-alt-image';
		public static const COMMENT_ALT_LINES:String = 'comment-alt-lines';
		public static const COMMENT_ALT_MEDICAL:String = 'comment-alt-medical';
		public static const COMMENT_ALT_MINUS:String = 'comment-alt-minus';
		public static const COMMENT_ALT_MUSIC:String = 'comment-alt-music';
		public static const COMMENT_ALT_PLUS:String = 'comment-alt-plus';
		public static const COMMENT_ALT_QUOTE:String = 'comment-alt-quote';
		public static const COMMENT_ALT_SLASH:String = 'comment-alt-slash';
		public static const COMMENT_ALT_SMILE:String = 'comment-alt-smile';
		public static const COMMENT_ALT_TEXT:String = 'comment-alt-text';
		public static const COMMENT_ALT_TIMES:String = 'comment-alt-times';
		public static const COMMENT_ARROW_DOWN:String = 'comment-arrow-down';
		public static const COMMENT_ARROW_UP:String = 'comment-arrow-up';
		public static const COMMENT_ARROW_UP_RIGHT:String = 'comment-arrow-up-right';
		public static const COMMENT_CAPTIONS:String = 'comment-captions';
		public static const COMMENT_CHECK:String = 'comment-check';
		public static const COMMENT_CODE:String = 'comment-code';
		public static const COMMENT_EDIT:String = 'comment-edit';
		public static const COMMENT_EXCLAMATION:String = 'comment-exclamation';
		public static const COMMENT_HEART:String = 'comment-heart';
		public static const COMMENT_IMAGE:String = 'comment-image';
		public static const COMMENT_LINES:String = 'comment-lines';
		public static const COMMENT_MIDDLE:String = 'comment-middle';
		public static const COMMENT_MIDDLE_ALT:String = 'comment-middle-alt';
		public static const COMMENT_MIDDLE_TOP:String = 'comment-middle-top';
		public static const COMMENT_MIDDLE_TOP_ALT:String = 'comment-middle-top-alt';
		public static const COMMENT_MINUS:String = 'comment-minus';
		public static const COMMENT_MUSIC:String = 'comment-music';
		public static const COMMENT_PEN:String = 'comment-pen';
		public static const COMMENT_PLUS:String = 'comment-plus';
		public static const COMMENT_QUESTION:String = 'comment-question';
		public static const COMMENT_QUOTE:String = 'comment-quote';
		public static const COMMENTS_ALT:String = 'comments-alt';
		public static const COMMENTS_ALT_DOLLAR:String = 'comments-alt-dollar';
		public static const COMMENT_SMILE:String = 'comment-smile';
		public static const COMMENTS_QUESTION:String = 'comments-question';
		public static const COMMENTS_QUESTION_CHECK:String = 'comments-question-check';
		public static const COMMENT_TEXT:String = 'comment-text';
		public static const COMMENT_TIMES:String = 'comment-times';
		public static const COMMENT_XMARK:String = 'comment-xmark';
		public static const COMPASS_SLASH:String = 'compass-slash';
		public static const COMPRESS_ARROWS:String = 'compress-arrows';
		public static const COMPRESS_WIDE:String = 'compress-wide';
		public static const COMPUTER_CLASSIC:String = 'computer-classic';
		public static const COMPUTER_MOUSE_SCROLLWHEEL:String = 'computer-mouse-scrollwheel';
		public static const COMPUTER_SPEAKER:String = 'computer-speaker';
		public static const CONSTRUCTION:String = 'construction';
		public static const CONTAINER_STORAGE:String = 'container-storage';
		public static const CONVEYOR_BELT:String = 'conveyor-belt';
		public static const CONVEYOR_BELT_ALT:String = 'conveyor-belt-alt';
		public static const CONVEYOR_BELT_ARM:String = 'conveyor-belt-arm';
		public static const CONVEYOR_BELT_BOXES:String = 'conveyor-belt-boxes';
		public static const CONVEYOR_BELT_EMPTY:String = 'conveyor-belt-empty';
		public static const CORN:String = 'corn';
		public static const CORNER:String = 'corner';
		public static const COUCH_SMALL:String = 'couch-small';
		public static const COURT_SPORT:String = 'court-sport';
		public static const COWBELL:String = 'cowbell';
		public static const COWBELL_CIRCLE_PLUS:String = 'cowbell-circle-plus';
		public static const COWBELL_MORE:String = 'cowbell-more';
		public static const CRAB:String = 'crab';
		public static const CRATE_APPLE:String = 'crate-apple';
		public static const CRATE_EMPTY:String = 'crate-empty';
		public static const CREDIT_CARD_BLANK:String = 'credit-card-blank';
		public static const CREDIT_CARD_FRONT:String = 'credit-card-front';
		public static const CREEMEE:String = 'creemee';
		public static const CRICKET:String = 'cricket';
		public static const CRICKET_BAT_BALL:String = 'cricket-bat-ball';
		public static const CROISSANT:String = 'croissant';
		public static const CROSSHAIRS_SIMPLE:String = 'crosshairs-simple';
		public static const CRUTCHES:String = 'crutches';
		public static const CRYSTAL_BALL:String = 'crystal-ball';
		public static const CUCUMBER:String = 'cucumber';
		public static const CUPCAKE:String = 'cupcake';
		public static const CUP_STRAW:String = 'cup-straw';
		public static const CUP_STRAW_SWOOSH:String = 'cup-straw-swoosh';
		public static const CUP_TOGO:String = 'cup-togo';
		public static const CURLING:String = 'curling';
		public static const CURLING_STONE:String = 'curling-stone';
		public static const CUSTARD:String = 'custard';
		public static const DAGGER:String = 'dagger';
		public static const DASH:String = 'dash';
		public static const DEBUG:String = 'debug';
		public static const DEER:String = 'deer';
		public static const DEER_RUDOLPH:String = 'deer-rudolph';
		public static const DELETE_RIGHT:String = 'delete-right';
		public static const DESKTOP_ARROW_DOWN:String = 'desktop-arrow-down';
		public static const DESKTOP_CODE:String = 'desktop-code';
		public static const DESKTOP_MEDICAL:String = 'desktop-medical';
		public static const DESKTOP_SLASH:String = 'desktop-slash';
		public static const DEWPOINT:String = 'dewpoint';
		public static const DIAGRAM_CELLS:String = 'diagram-cells';
		public static const DIAGRAM_LEAN_CANVAS:String = 'diagram-lean-canvas';
		public static const DIAGRAM_NESTED:String = 'diagram-nested';
		public static const DIAGRAM_PREVIOUS:String = 'diagram-previous';
		public static const DIAGRAM_SANKEY:String = 'diagram-sankey';
		public static const DIAGRAM_SUBTASK:String = 'diagram-subtask';
		public static const DIAGRAM_VENN:String = 'diagram-venn';
		public static const DIAL:String = 'dial';
		public static const DIAL_HIGH:String = 'dial-high';
		public static const DIAL_LOW:String = 'dial-low';
		public static const DIAL_MAX:String = 'dial-max';
		public static const DIAL_MED:String = 'dial-med';
		public static const DIAL_MED_HIGH:String = 'dial-med-high';
		public static const DIAL_MED_LOW:String = 'dial-med-low';
		public static const DIAL_MIN:String = 'dial-min';
		public static const DIAL_OFF:String = 'dial-off';
		public static const DIAMOND_EXCLAMATION:String = 'diamond-exclamation';
		public static const DIAMOND_HALF:String = 'diamond-half';
		public static const DIAMOND_HALF_STROKE:String = 'diamond-half-stroke';
		public static const DICE_D10:String = 'dice-d10';
		public static const DICE_D12:String = 'dice-d12';
		public static const DICE_D4:String = 'dice-d4';
		public static const DICE_D8:String = 'dice-d8';
		public static const DINOSAUR:String = 'dinosaur';
		public static const DIPLOMA:String = 'diploma';
		public static const DISC_DRIVE:String = 'disc-drive';
		public static const DISPLAY_ARROW_DOWN:String = 'display-arrow-down';
		public static const DISPLAY_CHART_UP:String = 'display-chart-up';
		public static const DISPLAY_CHART_UP_CIRCLE_CURRENCY:String = 'display-chart-up-circle-currency';
		public static const DISPLAY_CHART_UP_CIRCLE_DOLLAR:String = 'display-chart-up-circle-dollar';
		public static const DISPLAY_CODE:String = 'display-code';
		public static const DISPLAY_MEDICAL:String = 'display-medical';
		public static const DISPLAY_SLASH:String = 'display-slash';
		public static const DISTRIBUTE_SPACING_HORIZONTAL:String = 'distribute-spacing-horizontal';
		public static const DISTRIBUTE_SPACING_VERTICAL:String = 'distribute-spacing-vertical';
		public static const DITTO:String = 'ditto';
		public static const DOG_LEASHED:String = 'dog-leashed';
		public static const DOLLAR_CIRCLE:String = 'dollar-circle';
		public static const DOLLAR_SQUARE:String = 'dollar-square';
		public static const DOLLY_EMPTY:String = 'dolly-empty';
		public static const DOLLY_FLATBED_ALT:String = 'dolly-flatbed-alt';
		public static const DOLLY_FLATBED_EMPTY:String = 'dolly-flatbed-empty';
		public static const DOLPHIN:String = 'dolphin';
		public static const DO_NOT_ENTER:String = 'do-not-enter';
		public static const DONUT:String = 'donut';
		public static const DOUGHNUT:String = 'doughnut';
		public static const DOWN:String = 'down';
		public static const DOWN_FROM_BRACKET:String = 'down-from-bracket';
		public static const DOWN_FROM_DOTTED_LINE:String = 'down-from-dotted-line';
		public static const DOWN_FROM_LINE:String = 'down-from-line';
		public static const DOWN_LEFT:String = 'down-left';
		public static const DOWN_RIGHT:String = 'down-right';
		public static const DOWN_TO_BRACKET:String = 'down-to-bracket';
		public static const DOWN_TO_DOTTED_LINE:String = 'down-to-dotted-line';
		public static const DOWN_TO_LINE:String = 'down-to-line';
		public static const DRAW_CIRCLE:String = 'draw-circle';
		public static const DRAW_SQUARE:String = 'draw-square';
		public static const DREIDEL:String = 'dreidel';
		public static const DRONE:String = 'drone';
		public static const DRONE_ALT:String = 'drone-alt';
		public static const DRONE_FRONT:String = 'drone-front';
		public static const DROPLET_DEGREE:String = 'droplet-degree';
		public static const DROPLET_PERCENT:String = 'droplet-percent';
		public static const DRUMSTICK:String = 'drumstick';
		public static const DRYER:String = 'dryer';
		public static const DRYER_ALT:String = 'dryer-alt';
		public static const DRYER_HEAT:String = 'dryer-heat';
		public static const DUCK:String = 'duck';
		public static const EAR:String = 'ear';
		public static const EAR_MUFFS:String = 'ear-muffs';
		public static const ECLIPSE:String = 'eclipse';
		public static const ECLIPSE_ALT:String = 'eclipse-alt';
		public static const EGG_FRIED:String = 'egg-fried';
		public static const EGGPLANT:String = 'eggplant';
		public static const ELEPHANT:String = 'elephant';
		public static const ELLIPSIS_H_ALT:String = 'ellipsis-h-alt';
		public static const ELLIPSIS_STROKE:String = 'ellipsis-stroke';
		public static const ELLIPSIS_STROKE_VERTICAL:String = 'ellipsis-stroke-vertical';
		public static const ELLIPSIS_V_ALT:String = 'ellipsis-v-alt';
		public static const EMPTY_SET:String = 'empty-set';
		public static const ENGINE:String = 'engine';
		public static const ENGINE_EXCLAMATION:String = 'engine-exclamation';
		public static const ENGINE_WARNING:String = 'engine-warning';
		public static const ENVELOPE_BADGE:String = 'envelope-badge';
		public static const ENVELOPE_CIRCLE:String = 'envelope-circle';
		public static const ENVELOPE_DOT:String = 'envelope-dot';
		public static const ENVELOPE_OPEN_DOLLAR:String = 'envelope-open-dollar';
		public static const ENVELOPES:String = 'envelopes';
		public static const ESCALATOR:String = 'escalator';
		public static const EXCAVATOR:String = 'excavator';
		public static const EXCLAMATION_SQUARE:String = 'exclamation-square';
		public static const EXPAND_ARROWS:String = 'expand-arrows';
		public static const EXPAND_WIDE:String = 'expand-wide';
		public static const EXPLODING_HEAD:String = 'exploding-head';
		public static const EYE_DROPPER_FULL:String = 'eye-dropper-full';
		public static const EYE_DROPPER_HALF:String = 'eye-dropper-half';
		public static const EYE_EVIL:String = 'eye-evil';
		public static const EYES:String = 'eyes';
		public static const FACE_ANGRY_HORNS:String = 'face-angry-horns';
		public static const FACE_ANGUISHED:String = 'face-anguished';
		public static const FACE_ANXIOUS_SWEAT:String = 'face-anxious-sweat';
		public static const FACE_ASTONISHED:String = 'face-astonished';
		public static const FACE_AWESOME:String = 'face-awesome';
		public static const FACE_BEAM_HAND_OVER_MOUTH:String = 'face-beam-hand-over-mouth';
		public static const FACE_CLOUDS:String = 'face-clouds';
		public static const FACE_CONFOUNDED:String = 'face-confounded';
		public static const FACE_CONFUSED:String = 'face-confused';
		public static const FACE_COWBOY_HAT:String = 'face-cowboy-hat';
		public static const FACE_DIAGONAL_MOUTH:String = 'face-diagonal-mouth';
		public static const FACE_DISAPPOINTED:String = 'face-disappointed';
		public static const FACE_DISGUISE:String = 'face-disguise';
		public static const FACE_DOTTED:String = 'face-dotted';
		public static const FACE_DOWNCAST_SWEAT:String = 'face-downcast-sweat';
		public static const FACE_DROOLING:String = 'face-drooling';
		public static const FACE_EXHALING:String = 'face-exhaling';
		public static const FACE_EXPLODE:String = 'face-explode';
		public static const FACE_EXPRESSIONLESS:String = 'face-expressionless';
		public static const FACE_EYES_XMARKS:String = 'face-eyes-xmarks';
		public static const FACE_FEARFUL:String = 'face-fearful';
		public static const FACE_FROWN_SLIGHT:String = 'face-frown-slight';
		public static const FACE_GLASSES:String = 'face-glasses';
		public static const FACE_HAND_OVER_MOUTH:String = 'face-hand-over-mouth';
		public static const FACE_HAND_PEEKING:String = 'face-hand-peeking';
		public static const FACE_HAND_YAWN:String = 'face-hand-yawn';
		public static const FACE_HEAD_BANDAGE:String = 'face-head-bandage';
		public static const FACE_HOLDING_BACK_TEARS:String = 'face-holding-back-tears';
		public static const FACE_HUSHED:String = 'face-hushed';
		public static const FACE_ICICLES:String = 'face-icicles';
		public static const FACE_KISS_CLOSED_EYES:String = 'face-kiss-closed-eyes';
		public static const FACE_LYING:String = 'face-lying';
		public static const FACE_MASK:String = 'face-mask';
		public static const FACE_MELTING:String = 'face-melting';
		public static const FACE_MONOCLE:String = 'face-monocle';
		public static const FACE_NAUSEATED:String = 'face-nauseated';
		public static const FACE_NOSE_STEAM:String = 'face-nose-steam';
		public static const FACE_PARTY:String = 'face-party';
		public static const FACE_PENSIVE:String = 'face-pensive';
		public static const FACE_PERSEVERING:String = 'face-persevering';
		public static const FACE_PLEADING:String = 'face-pleading';
		public static const FACE_POUTING:String = 'face-pouting';
		public static const FACE_RAISED_EYEBROW:String = 'face-raised-eyebrow';
		public static const FACE_RELIEVED:String = 'face-relieved';
		public static const FACE_SAD_SWEAT:String = 'face-sad-sweat';
		public static const FACE_SALUTING:String = 'face-saluting';
		public static const FACE_SCREAM:String = 'face-scream';
		public static const FACE_SHUSH:String = 'face-shush';
		public static const FACE_SLEEPING:String = 'face-sleeping';
		public static const FACE_SLEEPY:String = 'face-sleepy';
		public static const FACE_SMILE_HALO:String = 'face-smile-halo';
		public static const FACE_SMILE_HEARTS:String = 'face-smile-hearts';
		public static const FACE_SMILE_HORNS:String = 'face-smile-horns';
		public static const FACE_SMILE_PLUS:String = 'face-smile-plus';
		public static const FACE_SMILE_RELAXED:String = 'face-smile-relaxed';
		public static const FACE_SMILE_TEAR:String = 'face-smile-tear';
		public static const FACE_SMILE_TONGUE:String = 'face-smile-tongue';
		public static const FACE_SMILE_UPSIDE_DOWN:String = 'face-smile-upside-down';
		public static const FACE_SMILING_HANDS:String = 'face-smiling-hands';
		public static const FACE_SMIRKING:String = 'face-smirking';
		public static const FACE_SPIRAL_EYES:String = 'face-spiral-eyes';
		public static const FACE_SUNGLASSES:String = 'face-sunglasses';
		public static const FACE_SWEAR:String = 'face-swear';
		public static const FACE_THERMOMETER:String = 'face-thermometer';
		public static const FACE_THINKING:String = 'face-thinking';
		public static const FACE_TISSUE:String = 'face-tissue';
		public static const FACE_TONGUE_MONEY:String = 'face-tongue-money';
		public static const FACE_TONGUE_SWEAT:String = 'face-tongue-sweat';
		public static const FACE_UNAMUSED:String = 'face-unamused';
		public static const FACE_VIEWFINDER:String = 'face-viewfinder';
		public static const FACE_VOMIT:String = 'face-vomit';
		public static const FACE_WEARY:String = 'face-weary';
		public static const FACE_WOOZY:String = 'face-woozy';
		public static const FACE_WORRIED:String = 'face-worried';
		public static const FACE_ZANY:String = 'face-zany';
		public static const FACE_ZIPPER:String = 'face-zipper';
		public static const FALAFEL:String = 'falafel';
		public static const FAMILY:String = 'family';
		public static const FAMILY_DRESS:String = 'family-dress';
		public static const FAMILY_PANTS:String = 'family-pants';
		public static const FAN_TABLE:String = 'fan-table';
		public static const FARM:String = 'farm';
		public static const FENCE:String = 'fence';
		public static const FERRIS_WHEEL:String = 'ferris-wheel';
		public static const FIELD_HOCKEY:String = 'field-hockey';
		public static const FIELD_HOCKEY_STICK_BALL:String = 'field-hockey-stick-ball';
		public static const FILE_AWARD:String = 'file-award';
		public static const FILE_BINARY:String = 'file-binary';
		public static const FILE_CAD:String = 'file-cad';
		public static const FILE_CARET_DOWN:String = 'file-caret-down';
		public static const FILE_CARET_UP:String = 'file-caret-up';
		public static const FILE_CERTIFICATE:String = 'file-certificate';
		public static const FILE_CHART_COLUMN:String = 'file-chart-column';
		public static const FILE_CHART_LINE:String = 'file-chart-line';
		public static const FILE_CHART_PIE:String = 'file-chart-pie';
		public static const FILE_CHECK:String = 'file-check';
		public static const FILE_CIRCLE_INFO:String = 'file-circle-info';
		public static const FILE_DASHED_LINE:String = 'file-dashed-line';
		public static const FILE_DOC:String = 'file-doc';
		public static const FILE_EPS:String = 'file-eps';
		public static const FILE_EXCLAMATION:String = 'file-exclamation';
		public static const FILE_GIF:String = 'file-gif';
		public static const FILE_HEART:String = 'file-heart';
		public static const FILE_JPG:String = 'file-jpg';
		public static const FILE_LOCK:String = 'file-lock';
		public static const FILE_MAGNIFYING_GLASS:String = 'file-magnifying-glass';
		public static const FILE_MINUS:String = 'file-minus';
		public static const FILE_MOV:String = 'file-mov';
		public static const FILE_MP3:String = 'file-mp3';
		public static const FILE_MP4:String = 'file-mp4';
		public static const FILE_MUSIC:String = 'file-music';
		public static const FILE_PLUS:String = 'file-plus';
		public static const FILE_PLUS_MINUS:String = 'file-plus-minus';
		public static const FILE_PNG:String = 'file-png';
		public static const FILE_PPT:String = 'file-ppt';
		public static const FILES:String = 'files';
		public static const FILE_SEARCH:String = 'file-search';
		public static const FILE_SLASH:String = 'file-slash';
		public static const FILES_MEDICAL:String = 'files-medical';
		public static const FILE_SPREADSHEET:String = 'file-spreadsheet';
		public static const FILE_SVG:String = 'file-svg';
		public static const FILE_TIMES:String = 'file-times';
		public static const FILE_USER:String = 'file-user';
		public static const FILE_VECTOR:String = 'file-vector';
		public static const FILE_XLS:String = 'file-xls';
		public static const FILE_XMARK:String = 'file-xmark';
		public static const FILE_XML:String = 'file-xml';
		public static const FILE_ZIP:String = 'file-zip';
		public static const FILM_ALT:String = 'film-alt';
		public static const FILM_CANISTER:String = 'film-canister';
		public static const FILM_CANNISTER:String = 'film-cannister';
		public static const FILMS:String = 'films';
		public static const FILM_SIMPLE:String = 'film-simple';
		public static const FILM_SLASH:String = 'film-slash';
		public static const FILTER_LIST:String = 'filter-list';
		public static const FILTERS:String = 'filters';
		public static const FILTER_SLASH:String = 'filter-slash';
		public static const FIRE_FLAME:String = 'fire-flame';
		public static const FIRE_HYDRANT:String = 'fire-hydrant';
		public static const FIREPLACE:String = 'fireplace';
		public static const FIRE_SMOKE:String = 'fire-smoke';
		public static const FIREWALL:String = 'firewall';
		public static const FISH_BONES:String = 'fish-bones';
		public static const FISH_COOKED:String = 'fish-cooked';
		public static const FISHING_ROD:String = 'fishing-rod';
		public static const FLAG_ALT:String = 'flag-alt';
		public static const FLAG_PENNANT:String = 'flag-pennant';
		public static const FLAG_SWALLOWTAIL:String = 'flag-swallowtail';
		public static const FLAME:String = 'flame';
		public static const FLASHLIGHT:String = 'flashlight';
		public static const FLASK_GEAR:String = 'flask-gear';
		public static const FLASK_POISON:String = 'flask-poison';
		public static const FLASK_POTION:String = 'flask-potion';
		public static const FLASK_ROUND_POISON:String = 'flask-round-poison';
		public static const FLASK_ROUND_POTION:String = 'flask-round-potion';
		public static const FLATBREAD:String = 'flatbread';
		public static const FLATBREAD_STUFFED:String = 'flatbread-stuffed';
		public static const FLOPPY_DISK_CIRCLE_ARROW_RIGHT:String = 'floppy-disk-circle-arrow-right';
		public static const FLOPPY_DISK_CIRCLE_XMARK:String = 'floppy-disk-circle-xmark';
		public static const FLOPPY_DISK_PEN:String = 'floppy-disk-pen';
		public static const FLOPPY_DISKS:String = 'floppy-disks';
		public static const FLOPPY_DISK_TIMES:String = 'floppy-disk-times';
		public static const FLOWER:String = 'flower';
		public static const FLOWER_DAFFODIL:String = 'flower-daffodil';
		public static const FLOWER_TULIP:String = 'flower-tulip';
		public static const FLUTE:String = 'flute';
		public static const FLUX_CAPACITOR:String = 'flux-capacitor';
		public static const FLYING_DISC:String = 'flying-disc';
		public static const FOG:String = 'fog';
		public static const FOLDER_ARROW_DOWN:String = 'folder-arrow-down';
		public static const FOLDER_ARROW_UP:String = 'folder-arrow-up';
		public static const FOLDER_BOOKMARK:String = 'folder-bookmark';
		public static const FOLDER_CHECK:String = 'folder-check';
		public static const FOLDER_COG:String = 'folder-cog';
		public static const FOLDER_DOWNLOAD:String = 'folder-download';
		public static const FOLDER_GEAR:String = 'folder-gear';
		public static const FOLDER_GRID:String = 'folder-grid';
		public static const FOLDER_HEART:String = 'folder-heart';
		public static const FOLDER_IMAGE:String = 'folder-image';
		public static const FOLDER_MAGNIFYING_GLASS:String = 'folder-magnifying-glass';
		public static const FOLDER_MEDICAL:String = 'folder-medical';
		public static const FOLDER_MUSIC:String = 'folder-music';
		public static const FOLDERS:String = 'folders';
		public static const FOLDER_SEARCH:String = 'folder-search';
		public static const FOLDER_TIMES:String = 'folder-times';
		public static const FOLDER_UPLOAD:String = 'folder-upload';
		public static const FOLDER_USER:String = 'folder-user';
		public static const FOLDER_XMARK:String = 'folder-xmark';
		public static const FONDUE_POT:String = 'fondue-pot';
		public static const FONT_CASE:String = 'font-case';
		public static const FOOTBALL_HELMET:String = 'football-helmet';
		public static const FORK:String = 'fork';
		public static const FORK_KNIFE:String = 'fork-knife';
		public static const FORKLIFT:String = 'forklift';
		public static const FORT:String = 'fort';
		public static const FRAGILE:String = 'fragile';
		public static const FRAME:String = 'frame';
		public static const FRENCH_FRIES:String = 'french-fries';
		public static const FROSTY_HEAD:String = 'frosty-head';
		public static const FUNCTION:String = 'function';
		public static const GALAXY:String = 'galaxy';
		public static const GALLERY_THUMBNAILS:String = 'gallery-thumbnails';
		public static const GAME_BOARD:String = 'game-board';
		public static const GAME_BOARD_ALT:String = 'game-board-alt';
		public static const GAME_BOARD_SIMPLE:String = 'game-board-simple';
		public static const GAME_CONSOLE_HANDHELD:String = 'game-console-handheld';
		public static const GAME_CONSOLE_HANDHELD_CRANK:String = 'game-console-handheld-crank';
		public static const GAMEPAD_ALT:String = 'gamepad-alt';
		public static const GAMEPAD_MODERN:String = 'gamepad-modern';
		public static const GARAGE:String = 'garage';
		public static const GARAGE_CAR:String = 'garage-car';
		public static const GARAGE_OPEN:String = 'garage-open';
		public static const GARLIC:String = 'garlic';
		public static const GAS_PUMP_SLASH:String = 'gas-pump-slash';
		public static const GAUGE_CIRCLE_BOLT:String = 'gauge-circle-bolt';
		public static const GAUGE_CIRCLE_MINUS:String = 'gauge-circle-minus';
		public static const GAUGE_CIRCLE_PLUS:String = 'gauge-circle-plus';
		public static const GAUGE_LOW:String = 'gauge-low';
		public static const GAUGE_MAX:String = 'gauge-max';
		public static const GAUGE_MIN:String = 'gauge-min';
		public static const GAUGE_SIMPLE_LOW:String = 'gauge-simple-low';
		public static const GAUGE_SIMPLE_MAX:String = 'gauge-simple-max';
		public static const GAUGE_SIMPLE_MIN:String = 'gauge-simple-min';
		public static const GAVE_DANDY:String = 'gave-dandy';
		public static const GEAR_CODE:String = 'gear-code';
		public static const GEAR_COMPLEX:String = 'gear-complex';
		public static const GEAR_COMPLEX_CODE:String = 'gear-complex-code';
		public static const GIF:String = 'gif';
		public static const GIFT_CARD:String = 'gift-card';
		public static const GINGERBREAD_MAN:String = 'gingerbread-man';
		public static const GLASS:String = 'glass';
		public static const GLASS_CHAMPAGNE:String = 'glass-champagne';
		public static const GLASS_CITRUS:String = 'glass-citrus';
		public static const GLASS_EMPTY:String = 'glass-empty';
		public static const GLASSES_ALT:String = 'glasses-alt';
		public static const GLASSES_ROUND:String = 'glasses-round';
		public static const GLASS_HALF:String = 'glass-half';
		public static const GLASS_HALF_EMPTY:String = 'glass-half-empty';
		public static const GLASS_HALF_FULL:String = 'glass-half-full';
		public static const GLASS_WHISKEY_ROCKS:String = 'glass-whiskey-rocks';
		public static const GLOBE_POINTER:String = 'globe-pointer';
		public static const GLOBE_SNOW:String = 'globe-snow';
		public static const GLOBE_STAND:String = 'globe-stand';
		public static const GLOVE_BOXING:String = 'glove-boxing';
		public static const GOAL_NET:String = 'goal-net';
		public static const GOLF_CLUB:String = 'golf-club';
		public static const GOLF_FLAG_HOLE:String = 'golf-flag-hole';
		public static const GRAMOPHONE:String = 'gramophone';
		public static const GRAPES:String = 'grapes';
		public static const GRATE:String = 'grate';
		public static const GRATE_DROPLET:String = 'grate-droplet';
		public static const GRID:String = 'grid';
		public static const GRID_2:String = 'grid-2';
		public static const GRID_2_PLUS:String = 'grid-2-plus';
		public static const GRID_3:String = 'grid-3';
		public static const GRID_4:String = 'grid-4';
		public static const GRID_5:String = 'grid-5';
		public static const GRID_DIVIDERS:String = 'grid-dividers';
		public static const GRID_HORIZONTAL:String = 'grid-horizontal';
		public static const GRID_ROUND:String = 'grid-round';
		public static const GRID_ROUND_2:String = 'grid-round-2';
		public static const GRID_ROUND_2_PLUS:String = 'grid-round-2-plus';
		public static const GRID_ROUND_4:String = 'grid-round-4';
		public static const GRID_ROUND_5:String = 'grid-round-5';
		public static const GRILL:String = 'grill';
		public static const GRILL_FIRE:String = 'grill-fire';
		public static const GRILL_HOT:String = 'grill-hot';
		public static const GRIP_DOTS:String = 'grip-dots';
		public static const GRIP_DOTS_VERTICAL:String = 'grip-dots-vertical';
		public static const GUITAR_ELECTRIC:String = 'guitar-electric';
		public static const GUITARS:String = 'guitars';
		public static const GUN_SLASH:String = 'gun-slash';
		public static const GUN_SQUIRT:String = 'gun-squirt';
		public static const H1:String = 'h1';
		public static const H2:String = 'h2';
		public static const H3:String = 'h3';
		public static const H4:String = 'h4';
		public static const H5:String = 'h5';
		public static const H6:String = 'h6';
		public static const HAMMER_BRUSH:String = 'hammer-brush';
		public static const HAMMER_CRASH:String = 'hammer-crash';
		public static const HAMMER_WAR:String = 'hammer-war';
		public static const HAND_BACK_POINT_DOWN:String = 'hand-back-point-down';
		public static const HAND_BACK_POINT_LEFT:String = 'hand-back-point-left';
		public static const HAND_BACK_POINT_RIBBON:String = 'hand-back-point-ribbon';
		public static const HAND_BACK_POINT_RIGHT:String = 'hand-back-point-right';
		public static const HAND_BACK_POINT_UP:String = 'hand-back-point-up';
		public static const HAND_FINGERS_CROSSED:String = 'hand-fingers-crossed';
		public static const HAND_HEART:String = 'hand-heart';
		public static const HAND_HOLDING_BOX:String = 'hand-holding-box';
		public static const HAND_HOLDING_CIRCLE_DOLLAR:String = 'hand-holding-circle-dollar';
		public static const HAND_HOLDING_MAGIC:String = 'hand-holding-magic';
		public static const HAND_HOLDING_SEEDLING:String = 'hand-holding-seedling';
		public static const HAND_HOLDING_SKULL:String = 'hand-holding-skull';
		public static const HAND_HORNS:String = 'hand-horns';
		public static const HAND_LOVE:String = 'hand-love';
		public static const HAND_POINT_RIBBON:String = 'hand-point-ribbon';
		public static const HAND_RECEIVING:String = 'hand-receiving';
		public static const HANDS_HEART:String = 'hands-heart';
		public static const HANDS_HOLDING_DIAMOND:String = 'hands-holding-diamond';
		public static const HANDS_HOLDING_DOLLAR:String = 'hands-holding-dollar';
		public static const HANDS_HOLDING_HEART:String = 'hands-holding-heart';
		public static const HANDS_USD:String = 'hands-usd';
		public static const HAND_WAVE:String = 'hand-wave';
		public static const HASHTAG_LOCK:String = 'hashtag-lock';
		public static const HAT_BEACH:String = 'hat-beach';
		public static const HAT_CHEF:String = 'hat-chef';
		public static const HAT_SANTA:String = 'hat-santa';
		public static const HAT_WINTER:String = 'hat-winter';
		public static const HAT_WITCH:String = 'hat-witch';
		public static const HEAD_SIDE:String = 'head-side';
		public static const HEAD_SIDE_BRAIN:String = 'head-side-brain';
		public static const HEAD_SIDE_GEAR:String = 'head-side-gear';
		public static const HEAD_SIDE_GOGGLES:String = 'head-side-goggles';
		public static const HEAD_SIDE_HEADPHONES:String = 'head-side-headphones';
		public static const HEAD_SIDE_HEART:String = 'head-side-heart';
		public static const HEAD_SIDE_MEDICAL:String = 'head-side-medical';
		public static const HEAD_VR:String = 'head-vr';
		public static const HEART_CIRCLE:String = 'heart-circle';
		public static const HEART_HALF:String = 'heart-half';
		public static const HEART_HALF_ALT:String = 'heart-half-alt';
		public static const HEART_HALF_STROKE:String = 'heart-half-stroke';
		public static const HEART_RATE:String = 'heart-rate';
		public static const HEART_SQUARE:String = 'heart-square';
		public static const HEAT:String = 'heat';
		public static const HELMET_BATTLE:String = 'helmet-battle';
		public static const HEXAGON:String = 'hexagon';
		public static const HEXAGON_CHECK:String = 'hexagon-check';
		public static const HEXAGON_DIVIDE:String = 'hexagon-divide';
		public static const HEXAGON_EXCLAMATION:String = 'hexagon-exclamation';
		public static const HEXAGON_IMAGE:String = 'hexagon-image';
		public static const HEXAGON_MINUS:String = 'hexagon-minus';
		public static const HEXAGON_PLUS:String = 'hexagon-plus';
		public static const HEXAGON_VERTICAL_NFT:String = 'hexagon-vertical-nft';
		public static const HEXAGON_VERTICAL_NFT_SLANTED:String = 'hexagon-vertical-nft-slanted';
		public static const HEXAGON_XMARK:String = 'hexagon-xmark';
		public static const HIGH_DEFINITION:String = 'high-definition';
		public static const HIGHLIGHTER_LINE:String = 'highlighter-line';
		public static const HOCKEY_MASK:String = 'hockey-mask';
		public static const HOCKEY_STICK_PUCK:String = 'hockey-stick-puck';
		public static const HOCKEY_STICKS:String = 'hockey-sticks';
		public static const HOME_BLANK:String = 'home-blank';
		public static const HOME_HEART:String = 'home-heart';
		public static const HONEY_POT:String = 'honey-pot';
		public static const HOOD_CLOAK:String = 'hood-cloak';
		public static const HORIZONTAL_RULE:String = 'horizontal-rule';
		public static const HORSE_SADDLE:String = 'horse-saddle';
		public static const HOSE:String = 'hose';
		public static const HOSE_REEL:String = 'hose-reel';
		public static const HOSPITALS:String = 'hospitals';
		public static const HOURGLASS_CLOCK:String = 'hourglass-clock';
		public static const HOUSE_BLANK:String = 'house-blank';
		public static const HOUSE_BUILDING:String = 'house-building';
		public static const HOUSE_CHIMNEY_BLANK:String = 'house-chimney-blank';
		public static const HOUSE_CHIMNEY_HEART:String = 'house-chimney-heart';
		public static const HOUSE_DAY:String = 'house-day';
		public static const HOUSE_FLOOD:String = 'house-flood';
		public static const HOUSE_HEART:String = 'house-heart';
		public static const HOUSE_LEAVE:String = 'house-leave';
		public static const HOUSE_NIGHT:String = 'house-night';
		public static const HOUSE_PERSON_ARRIVE:String = 'house-person-arrive';
		public static const HOUSE_PERSON_DEPART:String = 'house-person-depart';
		public static const HOUSE_PERSON_LEAVE:String = 'house-person-leave';
		public static const HOUSE_PERSON_RETURN:String = 'house-person-return';
		public static const HOUSE_RETURN:String = 'house-return';
		public static const HOUSE_TREE:String = 'house-tree';
		public static const HOUSE_TURRET:String = 'house-turret';
		public static const HOUSE_WATER:String = 'house-water';
		public static const HOUSE_WINDOW:String = 'house-window';
		public static const HUMIDITY:String = 'humidity';
		public static const HUNDRED_POINTS:String = 'hundred-points';
		public static const HYPHEN:String = 'hyphen';
		public static const ICE_SKATE:String = 'ice-skate';
		public static const ICONS_ALT:String = 'icons-alt';
		public static const IMAGE_LANDSCAPE:String = 'image-landscape';
		public static const IMAGE_POLAROID:String = 'image-polaroid';
		public static const IMAGE_POLAROID_USER:String = 'image-polaroid-user';
		public static const IMAGE_SLASH:String = 'image-slash';
		public static const IMAGES_USER:String = 'images-user';
		public static const IMAGE_USER:String = 'image-user';
		public static const INBOX_ARROW_DOWN:String = 'inbox-arrow-down';
		public static const INBOX_ARROW_UP:String = 'inbox-arrow-up';
		public static const INBOXES:String = 'inboxes';
		public static const INBOX_FULL:String = 'inbox-full';
		public static const INBOX_IN:String = 'inbox-in';
		public static const INBOX_OUT:String = 'inbox-out';
		public static const INDUSTRY_ALT:String = 'industry-alt';
		public static const INDUSTRY_WINDOWS:String = 'industry-windows';
		public static const INFO_SQUARE:String = 'info-square';
		public static const INHALER:String = 'inhaler';
		public static const INPUT_NUMERIC:String = 'input-numeric';
		public static const INPUT_PIPE:String = 'input-pipe';
		public static const INPUT_TEXT:String = 'input-text';
		public static const INTEGRAL:String = 'integral';
		public static const INTERROBANG:String = 'interrobang';
		public static const INTERSECTION:String = 'intersection';
		public static const INVENTORY:String = 'inventory';
		public static const ISLAND_TREE_PALM:String = 'island-tree-palm';
		public static const ISLAND_TROPICAL:String = 'island-tropical';
		public static const JACK_O_LANTERN:String = 'jack-o-lantern';
		public static const JOYSTICK:String = 'joystick';
		public static const JUG:String = 'jug';
		public static const JUG_BOTTLE:String = 'jug-bottle';
		public static const KAZOO:String = 'kazoo';
		public static const KERNING:String = 'kerning';
		public static const KEYBOARD_BRIGHTNESS:String = 'keyboard-brightness';
		public static const KEYBOARD_BRIGHTNESS_LOW:String = 'keyboard-brightness-low';
		public static const KEYBOARD_DOWN:String = 'keyboard-down';
		public static const KEYBOARD_LEFT:String = 'keyboard-left';
		public static const KEYNOTE:String = 'keynote';
		public static const KEY_SKELETON:String = 'key-skeleton';
		public static const KEY_SKELETON_LEFT_RIGHT:String = 'key-skeleton-left-right';
		public static const KIDNEYS:String = 'kidneys';
		public static const KITE:String = 'kite';
		public static const KIWI_FRUIT:String = 'kiwi-fruit';
		public static const KNIFE:String = 'knife';
		public static const KNIFE_KITCHEN:String = 'knife-kitchen';
		public static const LACROSSE_STICK:String = 'lacrosse-stick';
		public static const LACROSSE_STICK_BALL:String = 'lacrosse-stick-ball';
		public static const LAMBDA:String = 'lambda';
		public static const LAMP:String = 'lamp';
		public static const LAMP_DESK:String = 'lamp-desk';
		public static const LAMP_FLOOR:String = 'lamp-floor';
		public static const LAMP_STREET:String = 'lamp-street';
		public static const LANDMARK_MAGNIFYING_GLASS:String = 'landmark-magnifying-glass';
		public static const LANDSCAPE:String = 'landscape';
		public static const LAPTOP_ARROW_DOWN:String = 'laptop-arrow-down';
		public static const LAPTOP_BINARY:String = 'laptop-binary';
		public static const LAPTOP_MOBILE:String = 'laptop-mobile';
		public static const LAPTOP_SLASH:String = 'laptop-slash';
		public static const LASSO:String = 'lasso';
		public static const LASSO_SPARKLES:String = 'lasso-sparkles';
		public static const LAYER_GROUP_MINUS:String = 'layer-group-minus';
		public static const LAYER_GROUP_PLUS:String = 'layer-group-plus';
		public static const LAYER_MINUS:String = 'layer-minus';
		public static const LAYER_PLUS:String = 'layer-plus';
		public static const LEAF_HEART:String = 'leaf-heart';
		public static const LEAF_MAPLE:String = 'leaf-maple';
		public static const LEAF_OAK:String = 'leaf-oak';
		public static const LEAFY_GREEN:String = 'leafy-green';
		public static const LEFT:String = 'left';
		public static const LEFT_FROM_BRACKET:String = 'left-from-bracket';
		public static const LEFT_FROM_LINE:String = 'left-from-line';
		public static const LEFT_LONG_TO_LINE:String = 'left-long-to-line';
		public static const LEFT_TO_BRACKET:String = 'left-to-bracket';
		public static const LEFT_TO_LINE:String = 'left-to-line';
		public static const LIGHTBULB_CFL:String = 'lightbulb-cfl';
		public static const LIGHTBULB_CFL_ON:String = 'lightbulb-cfl-on';
		public static const LIGHTBULB_DOLLAR:String = 'lightbulb-dollar';
		public static const LIGHTBULB_EXCLAMATION:String = 'lightbulb-exclamation';
		public static const LIGHTBULB_EXCLAMATION_ON:String = 'lightbulb-exclamation-on';
		public static const LIGHTBULB_GEAR:String = 'lightbulb-gear';
		public static const LIGHTBULB_ON:String = 'lightbulb-on';
		public static const LIGHTBULB_SLASH:String = 'lightbulb-slash';
		public static const LIGHT_CEILING:String = 'light-ceiling';
		public static const LIGHT_EMERGENCY:String = 'light-emergency';
		public static const LIGHT_EMERGENCY_ON:String = 'light-emergency-on';
		public static const LIGHTHOUSE:String = 'lighthouse';
		public static const LIGHTS_HOLIDAY:String = 'lights-holiday';
		public static const LIGHT_SWITCH:String = 'light-switch';
		public static const LIGHT_SWITCH_OFF:String = 'light-switch-off';
		public static const LIGHT_SWITCH_ON:String = 'light-switch-on';
		public static const LINE_COLUMNS:String = 'line-columns';
		public static const LINE_HEIGHT:String = 'line-height';
		public static const LINK_HORIZONTAL:String = 'link-horizontal';
		public static const LINK_HORIZONTAL_SLASH:String = 'link-horizontal-slash';
		public static const LINK_SIMPLE:String = 'link-simple';
		public static const LINK_SIMPLE_SLASH:String = 'link-simple-slash';
		public static const LIPS:String = 'lips';
		public static const LIST_DROPDOWN:String = 'list-dropdown';
		public static const LIST_MUSIC:String = 'list-music';
		public static const LIST_RADIO:String = 'list-radio';
		public static const LIST_TIMELINE:String = 'list-timeline';
		public static const LIST_TREE:String = 'list-tree';
		public static const LOADER:String = 'loader';
		public static const LOBSTER:String = 'lobster';
		public static const LOCATION_ARROW_UP:String = 'location-arrow-up';
		public static const LOCATION_CHECK:String = 'location-check';
		public static const LOCATION_CIRCLE:String = 'location-circle';
		public static const LOCATION_CROSSHAIRS_SLASH:String = 'location-crosshairs-slash';
		public static const LOCATION_DOT_SLASH:String = 'location-dot-slash';
		public static const LOCATION_EXCLAMATION:String = 'location-exclamation';
		public static const LOCATION_MINUS:String = 'location-minus';
		public static const LOCATION_PEN:String = 'location-pen';
		public static const LOCATION_PIN_SLASH:String = 'location-pin-slash';
		public static const LOCATION_PLUS:String = 'location-plus';
		public static const LOCATION_QUESTION:String = 'location-question';
		public static const LOCATION_SLASH:String = 'location-slash';
		public static const LOCATION_SMILE:String = 'location-smile';
		public static const LOCATION_XMARK:String = 'location-xmark';
		public static const LOCK_A:String = 'lock-a';
		public static const LOCK_ALT:String = 'lock-alt';
		public static const LOCK_HASHTAG:String = 'lock-hashtag';
		public static const LOCK_KEYHOLE:String = 'lock-keyhole';
		public static const LOCK_KEYHOLE_OPEN:String = 'lock-keyhole-open';
		public static const LOCK_OPEN_ALT:String = 'lock-open-alt';
		public static const LOLLIPOP:String = 'lollipop';
		public static const LOLLYPOP:String = 'lollypop';
		public static const LOVESEAT:String = 'loveseat';
		public static const LUCHADOR:String = 'luchador';
		public static const LUCHADOR_MASK:String = 'luchador-mask';
		public static const MACE:String = 'mace';
		public static const MAGNIFYING_GLASS_ARROWS_ROTATE:String = 'magnifying-glass-arrows-rotate';
		public static const MAGNIFYING_GLASS_MUSIC:String = 'magnifying-glass-music';
		public static const MAGNIFYING_GLASS_PLAY:String = 'magnifying-glass-play';
		public static const MAGNIFYING_GLASS_WAVEFORM:String = 'magnifying-glass-waveform';
		public static const MAILBOX:String = 'mailbox';
		public static const MAILBOX_FLAG_UP:String = 'mailbox-flag-up';
		public static const MAKI_ROLL:String = 'maki-roll';
		public static const MAKIZUSHI:String = 'makizushi';
		public static const MANDOLIN:String = 'mandolin';
		public static const MANGO:String = 'mango';
		public static const MANHOLE:String = 'manhole';
		public static const MAP_MARKER_ALT_SLASH:String = 'map-marker-alt-slash';
		public static const MAP_MARKER_CHECK:String = 'map-marker-check';
		public static const MAP_MARKER_EDIT:String = 'map-marker-edit';
		public static const MAP_MARKER_EXCLAMATION:String = 'map-marker-exclamation';
		public static const MAP_MARKER_MINUS:String = 'map-marker-minus';
		public static const MAP_MARKER_PLUS:String = 'map-marker-plus';
		public static const MAP_MARKER_QUESTION:String = 'map-marker-question';
		public static const MAP_MARKER_SLASH:String = 'map-marker-slash';
		public static const MAP_MARKER_SMILE:String = 'map-marker-smile';
		public static const MAP_MARKER_TIMES:String = 'map-marker-times';
		public static const MAP_MARKER_XMARK:String = 'map-marker-xmark';
		public static const MASK_LUCHADOR:String = 'mask-luchador';
		public static const MASK_SNORKEL:String = 'mask-snorkel';
		public static const MEAT:String = 'meat';
		public static const MEGAPHONE:String = 'megaphone';
		public static const MELON:String = 'melon';
		public static const MELON_SLICE:String = 'melon-slice';
		public static const MEMO:String = 'memo';
		public static const MEMO_CIRCLE_CHECK:String = 'memo-circle-check';
		public static const MEMO_CIRCLE_INFO:String = 'memo-circle-info';
		public static const MEMO_PAD:String = 'memo-pad';
		public static const MERGE:String = 'merge';
		public static const MESSAGE_ARROW_DOWN:String = 'message-arrow-down';
		public static const MESSAGE_ARROW_UP:String = 'message-arrow-up';
		public static const MESSAGE_ARROW_UP_RIGHT:String = 'message-arrow-up-right';
		public static const MESSAGE_BOT:String = 'message-bot';
		public static const MESSAGE_CAPTIONS:String = 'message-captions';
		public static const MESSAGE_CHECK:String = 'message-check';
		public static const MESSAGE_CODE:String = 'message-code';
		public static const MESSAGE_DOLLAR:String = 'message-dollar';
		public static const MESSAGE_DOTS:String = 'message-dots';
		public static const MESSAGE_EDIT:String = 'message-edit';
		public static const MESSAGE_EXCLAMATION:String = 'message-exclamation';
		public static const MESSAGE_HEART:String = 'message-heart';
		public static const MESSAGE_IMAGE:String = 'message-image';
		public static const MESSAGE_LINES:String = 'message-lines';
		public static const MESSAGE_MEDICAL:String = 'message-medical';
		public static const MESSAGE_MIDDLE:String = 'message-middle';
		public static const MESSAGE_MIDDLE_TOP:String = 'message-middle-top';
		public static const MESSAGE_MINUS:String = 'message-minus';
		public static const MESSAGE_MUSIC:String = 'message-music';
		public static const MESSAGE_PEN:String = 'message-pen';
		public static const MESSAGE_PLUS:String = 'message-plus';
		public static const MESSAGE_QUESTION:String = 'message-question';
		public static const MESSAGE_QUOTE:String = 'message-quote';
		public static const MESSAGES:String = 'messages';
		public static const MESSAGES_DOLLAR:String = 'messages-dollar';
		public static const MESSAGE_SLASH:String = 'message-slash';
		public static const MESSAGE_SMILE:String = 'message-smile';
		public static const MESSAGE_SMS:String = 'message-sms';
		public static const MESSAGES_QUESTION:String = 'messages-question';
		public static const MESSAGE_TEXT:String = 'message-text';
		public static const MESSAGE_TIMES:String = 'message-times';
		public static const MESSAGE_XMARK:String = 'message-xmark';
		public static const MESSAGING:String = 'messaging';
		public static const METER:String = 'meter';
		public static const METER_BOLT:String = 'meter-bolt';
		public static const METER_DROPLET:String = 'meter-droplet';
		public static const METER_FIRE:String = 'meter-fire';
		public static const MICROCHIP_AI:String = 'microchip-ai';
		public static const MICROPHONE_CIRCLE:String = 'microphone-circle';
		public static const MICROPHONE_CIRCLE_ALT:String = 'microphone-circle-alt';
		public static const MICROPHONE_STAND:String = 'microphone-stand';
		public static const MICROWAVE:String = 'microwave';
		public static const MIND_SHARE:String = 'mind-share';
		public static const MINUS_HEXAGON:String = 'minus-hexagon';
		public static const MINUS_LARGE:String = 'minus-large';
		public static const MINUS_OCTAGON:String = 'minus-octagon';
		public static const MISTLETOE:String = 'mistletoe';
		public static const MOBILE_IPHONE:String = 'mobile-iphone';
		public static const MOBILE_NOTCH:String = 'mobile-notch';
		public static const MOBILE_SIGNAL:String = 'mobile-signal';
		public static const MOBILE_SIGNAL_OUT:String = 'mobile-signal-out';
		public static const MONEY_BILLS_ALT:String = 'money-bills-alt';
		public static const MONEY_BILL_SIMPLE:String = 'money-bill-simple';
		public static const MONEY_BILL_SIMPLE_WAVE:String = 'money-bill-simple-wave';
		public static const MONEY_BILLS_SIMPLE:String = 'money-bills-simple';
		public static const MONEY_CHECK_DOLLAR_PEN:String = 'money-check-dollar-pen';
		public static const MONEY_CHECK_EDIT:String = 'money-check-edit';
		public static const MONEY_CHECK_EDIT_ALT:String = 'money-check-edit-alt';
		public static const MONEY_CHECK_PEN:String = 'money-check-pen';
		public static const MONEY_FROM_BRACKET:String = 'money-from-bracket';
		public static const MONEY_SIMPLE_FROM_BRACKET:String = 'money-simple-from-bracket';
		public static const MONITOR_HEART_RATE:String = 'monitor-heart-rate';
		public static const MONITOR_WAVEFORM:String = 'monitor-waveform';
		public static const MONKEY:String = 'monkey';
		public static const MOON_CLOUD:String = 'moon-cloud';
		public static const MOON_OVER_SUN:String = 'moon-over-sun';
		public static const MOON_STARS:String = 'moon-stars';
		public static const MOPED:String = 'moped';
		public static const MOUNTAINS:String = 'mountains';
		public static const MOUSE_ALT:String = 'mouse-alt';
		public static const MOUSE_FIELD:String = 'mouse-field';
		public static const MP3_PLAYER:String = 'mp3-player';
		public static const MUG:String = 'mug';
		public static const MUG_MARSHMALLOWS:String = 'mug-marshmallows';
		public static const MUG_TEA:String = 'mug-tea';
		public static const MUG_TEA_SAUCER:String = 'mug-tea-saucer';
		public static const MUSHROOM:String = 'mushroom';
		public static const MUSIC_ALT:String = 'music-alt';
		public static const MUSIC_ALT_SLASH:String = 'music-alt-slash';
		public static const MUSIC_MAGNIFYING_GLASS:String = 'music-magnifying-glass';
		public static const MUSIC_NOTE:String = 'music-note';
		public static const MUSIC_NOTE_SLASH:String = 'music-note-slash';
		public static const MUSIC_SLASH:String = 'music-slash';
		public static const MUSTACHE:String = 'mustache';
		public static const NARWHAL:String = 'narwhal';
		public static const NESTING_DOLLS:String = 'nesting-dolls';
		public static const NFC:String = 'nfc';
		public static const NFC_LOCK:String = 'nfc-lock';
		public static const NFC_MAGNIFYING_GLASS:String = 'nfc-magnifying-glass';
		public static const NFC_PEN:String = 'nfc-pen';
		public static const NFC_SIGNAL:String = 'nfc-signal';
		public static const NFC_SLASH:String = 'nfc-slash';
		public static const NFC_TRASH:String = 'nfc-trash';
		public static const NIGIRI:String = 'nigiri';
		public static const NOSE:String = 'nose';
		public static const NOTE:String = 'note';
		public static const NOTEBOOK:String = 'notebook';
		public static const NOTE_MEDICAL:String = 'note-medical';
		public static const NOTES:String = 'notes';
		public static const OBJECT_EXCLUDE:String = 'object-exclude';
		public static const OBJECT_INTERSECT:String = 'object-intersect';
		public static const OBJECTS_ALIGN_BOTTOM:String = 'objects-align-bottom';
		public static const OBJECTS_ALIGN_CENTER_HORIZONTAL:String = 'objects-align-center-horizontal';
		public static const OBJECTS_ALIGN_CENTER_VERTICAL:String = 'objects-align-center-vertical';
		public static const OBJECTS_ALIGN_LEFT:String = 'objects-align-left';
		public static const OBJECTS_ALIGN_RIGHT:String = 'objects-align-right';
		public static const OBJECTS_ALIGN_TOP:String = 'objects-align-top';
		public static const OBJECTS_COLUMN:String = 'objects-column';
		public static const OBJECT_SUBTRACT:String = 'object-subtract';
		public static const OBJECT_UNION:String = 'object-union';
		public static const OCTAGON:String = 'octagon';
		public static const OCTAGON_CHECK:String = 'octagon-check';
		public static const OCTAGON_DIVIDE:String = 'octagon-divide';
		public static const OCTAGON_EXCLAMATION:String = 'octagon-exclamation';
		public static const OCTAGON_MINUS:String = 'octagon-minus';
		public static const OCTAGON_PLUS:String = 'octagon-plus';
		public static const OCTAGON_XMARK:String = 'octagon-xmark';
		public static const OIL_CAN_DRIP:String = 'oil-can-drip';
		public static const OIL_TEMP:String = 'oil-temp';
		public static const OIL_TEMPERATURE:String = 'oil-temperature';
		public static const OLIVE:String = 'olive';
		public static const OLIVE_BRANCH:String = 'olive-branch';
		public static const OMEGA:String = 'omega';
		public static const ONION:String = 'onion';
		public static const OPTION:String = 'option';
		public static const ORNAMENT:String = 'ornament';
		public static const OUTLET:String = 'outlet';
		public static const OVEN:String = 'oven';
		public static const OVERLINE:String = 'overline';
		public static const PAGE:String = 'page';
		public static const PAGE_BREAK:String = 'page-break';
		public static const PAGE_CARET_DOWN:String = 'page-caret-down';
		public static const PAGE_CARET_UP:String = 'page-caret-up';
		public static const PAINTBRUSH_ALT:String = 'paintbrush-alt';
		public static const PAINT_BRUSH_ALT:String = 'paint-brush-alt';
		public static const PAINTBRUSH_FINE:String = 'paintbrush-fine';
		public static const PAINT_BRUSH_FINE:String = 'paint-brush-fine';
		public static const PAINTBRUSH_PENCIL:String = 'paintbrush-pencil';
		public static const PALETTE_BOXES:String = 'palette-boxes';
		public static const PALLET_ALT:String = 'pallet-alt';
		public static const PALLET_BOX:String = 'pallet-box';
		public static const PALLET_BOXES:String = 'pallet-boxes';
		public static const PANCAKES:String = 'pancakes';
		public static const PANEL_EWS:String = 'panel-ews';
		public static const PANEL_FIRE:String = 'panel-fire';
		public static const PAN_FOOD:String = 'pan-food';
		public static const PAN_FRYING:String = 'pan-frying';
		public static const PAPERCLIP_VERTICAL:String = 'paperclip-vertical';
		public static const PAPER_PLANE_ALT:String = 'paper-plane-alt';
		public static const PAPER_PLANE_TOP:String = 'paper-plane-top';
		public static const PARAGRAPH_LEFT:String = 'paragraph-left';
		public static const PARAGRAPH_RTL:String = 'paragraph-rtl';
		public static const PARENTHESES:String = 'parentheses';
		public static const PARENTHESIS:String = 'parenthesis';
		public static const PARKING_CIRCLE:String = 'parking-circle';
		public static const PARKING_CIRCLE_SLASH:String = 'parking-circle-slash';
		public static const PARKING_SLASH:String = 'parking-slash';
		public static const PARTY_BACK:String = 'party-back';
		public static const PARTY_BELL:String = 'party-bell';
		public static const PARTY_HORN:String = 'party-horn';
		public static const PAW_ALT:String = 'paw-alt';
		public static const PAW_CLAWS:String = 'paw-claws';
		public static const PAW_SIMPLE:String = 'paw-simple';
		public static const PEACH:String = 'peach';
		public static const PEANUT:String = 'peanut';
		public static const PEANUTS:String = 'peanuts';
		public static const PEAPOD:String = 'peapod';
		public static const PEAR:String = 'pear';
		public static const PEDESTAL:String = 'pedestal';
		public static const PEGASUS:String = 'pegasus';
		public static const PEN_ALT_SLASH:String = 'pen-alt-slash';
		public static const PENCIL_MECHANICAL:String = 'pencil-mechanical';
		public static const PENCIL_PAINTBRUSH:String = 'pencil-paintbrush';
		public static const PENCIL_SLASH:String = 'pencil-slash';
		public static const PEN_CIRCLE:String = 'pen-circle';
		public static const PEN_CLIP_SLASH:String = 'pen-clip-slash';
		public static const PEN_FANCY_SLASH:String = 'pen-fancy-slash';
		public static const PEN_FIELD:String = 'pen-field';
		public static const PEN_LINE:String = 'pen-line';
		public static const PENNANT:String = 'pennant';
		public static const PEN_NIB_SLASH:String = 'pen-nib-slash';
		public static const PEN_PAINTBRUSH:String = 'pen-paintbrush';
		public static const PEN_SLASH:String = 'pen-slash';
		public static const PEN_SWIRL:String = 'pen-swirl';
		public static const PEOPLE:String = 'people';
		public static const PEOPLE_DRESS:String = 'people-dress';
		public static const PEOPLE_DRESS_SIMPLE:String = 'people-dress-simple';
		public static const PEOPLE_PANTS:String = 'people-pants';
		public static const PEOPLE_PANTS_SIMPLE:String = 'people-pants-simple';
		public static const PEOPLE_SIMPLE:String = 'people-simple';
		public static const PEPPER:String = 'pepper';
		public static const PERIOD:String = 'period';
		public static const PERSON_BIKING_MOUNTAIN:String = 'person-biking-mountain';
		public static const PERSON_CARRY:String = 'person-carry';
		public static const PERSON_CARRY_BOX:String = 'person-carry-box';
		public static const PERSON_DOLLY:String = 'person-dolly';
		public static const PERSON_DOLLY_EMPTY:String = 'person-dolly-empty';
		public static const PERSON_DRESS_FAIRY:String = 'person-dress-fairy';
		public static const PERSON_DRESS_SIMPLE:String = 'person-dress-simple';
		public static const PERSON_FAIRY:String = 'person-fairy';
		public static const PERSON_FROM_PORTAL:String = 'person-from-portal';
		public static const PERSON_PINBALL:String = 'person-pinball';
		public static const PERSON_RUNNING_FAST:String = 'person-running-fast';
		public static const PERSON_SEAT:String = 'person-seat';
		public static const PERSON_SEAT_RECLINED:String = 'person-seat-reclined';
		public static const PERSON_SIGN:String = 'person-sign';
		public static const PERSON_SIMPLE:String = 'person-simple';
		public static const PERSON_SKI_JUMPING:String = 'person-ski-jumping';
		public static const PERSON_SKI_LIFT:String = 'person-ski-lift';
		public static const PERSON_SLEDDING:String = 'person-sledding';
		public static const PERSON_SNOWMOBILING:String = 'person-snowmobiling';
		public static const PERSON_TO_DOOR:String = 'person-to-door';
		public static const PERSON_TO_PORTAL:String = 'person-to-portal';
		public static const PHONE_ARROW_DOWN:String = 'phone-arrow-down';
		public static const PHONE_ARROW_DOWN_LEFT:String = 'phone-arrow-down-left';
		public static const PHONE_ARROW_RIGHT:String = 'phone-arrow-right';
		public static const PHONE_ARROW_UP:String = 'phone-arrow-up';
		public static const PHONE_ARROW_UP_RIGHT:String = 'phone-arrow-up-right';
		public static const PHONE_CIRCLE:String = 'phone-circle';
		public static const PHONE_CIRCLE_ALT:String = 'phone-circle-alt';
		public static const PHONE_CIRCLE_DOWN:String = 'phone-circle-down';
		public static const PHONE_HANGUP:String = 'phone-hangup';
		public static const PHONE_INCOMING:String = 'phone-incoming';
		public static const PHONE_INTERCOM:String = 'phone-intercom';
		public static const PHONE_LAPTOP:String = 'phone-laptop';
		public static const PHONE_MISSED:String = 'phone-missed';
		public static const PHONE_OFFICE:String = 'phone-office';
		public static const PHONE_OUTGOING:String = 'phone-outgoing';
		public static const PHONE_PLUS:String = 'phone-plus';
		public static const PHONE_ROTARY:String = 'phone-rotary';
		public static const PHONE_SQUARE_DOWN:String = 'phone-square-down';
		public static const PHONE_XMARK:String = 'phone-xmark';
		public static const PHOTO_FILM_MUSIC:String = 'photo-film-music';
		public static const PI:String = 'pi';
		public static const PIANO:String = 'piano';
		public static const PIANO_KEYBOARD:String = 'piano-keyboard';
		public static const PICKAXE:String = 'pickaxe';
		public static const PICKLEBALL:String = 'pickleball';
		public static const PIE:String = 'pie';
		public static const PIG:String = 'pig';
		public static const PINATA:String = 'pinata';
		public static const PINBALL:String = 'pinball';
		public static const PINEAPPLE:String = 'pineapple';
		public static const PIPE:String = 'pipe';
		public static const PIPE_CIRCLE_CHECK:String = 'pipe-circle-check';
		public static const PIPE_COLLAR:String = 'pipe-collar';
		public static const PIPE_SECTION:String = 'pipe-section';
		public static const PIPE_SMOKING:String = 'pipe-smoking';
		public static const PIPE_VALVE:String = 'pipe-valve';
		public static const PIZZA:String = 'pizza';
		public static const PLANE_ALT:String = 'plane-alt';
		public static const PLANE_ENGINES:String = 'plane-engines';
		public static const PLANE_PROP:String = 'plane-prop';
		public static const PLANE_TAIL:String = 'plane-tail';
		public static const PLANET_MOON:String = 'planet-moon';
		public static const PLANET_RINGED:String = 'planet-ringed';
		public static const PLANE_UP_SLASH:String = 'plane-up-slash';
		public static const PLATE_UTENSILS:String = 'plate-utensils';
		public static const PLAY_PAUSE:String = 'play-pause';
		public static const PLUS_HEXAGON:String = 'plus-hexagon';
		public static const PLUS_LARGE:String = 'plus-large';
		public static const PLUS_OCTAGON:String = 'plus-octagon';
		public static const PODIUM:String = 'podium';
		public static const PODIUM_STAR:String = 'podium-star';
		public static const POLICE_BOX:String = 'police-box';
		public static const POLL_PEOPLE:String = 'poll-people';
		public static const POMPEBLED:String = 'pompebled';
		public static const POOL_8_BALL:String = 'pool-8-ball';
		public static const POPCORN:String = 'popcorn';
		public static const POPSICLE:String = 'popsicle';
		public static const PORTAL_ENTER:String = 'portal-enter';
		public static const PORTAL_EXIT:String = 'portal-exit';
		public static const POTATO:String = 'potato';
		public static const POT_FOOD:String = 'pot-food';
		public static const PRESCRIPTION_BOTTLE_PILL:String = 'prescription-bottle-pill';
		public static const PRESENTATION:String = 'presentation';
		public static const PRESENTATION_SCREEN:String = 'presentation-screen';
		public static const PRETZEL:String = 'pretzel';
		public static const PRINT_MAGNIFYING_GLASS:String = 'print-magnifying-glass';
		public static const PRINT_SEARCH:String = 'print-search';
		public static const PRINT_SLASH:String = 'print-slash';
		public static const PRO:String = 'pro';
		public static const PROJECTOR:String = 'projector';
		public static const PUMP:String = 'pump';
		public static const PUMPKIN:String = 'pumpkin';
		public static const PUZZLE:String = 'puzzle';
		public static const PUZZLE_PIECE_ALT:String = 'puzzle-piece-alt';
		public static const PUZZLE_PIECE_SIMPLE:String = 'puzzle-piece-simple';
		public static const QUESTION_SQUARE:String = 'question-square';
		public static const QUOTES:String = 'quotes';
		public static const RABBIT:String = 'rabbit';
		public static const RABBIT_FAST:String = 'rabbit-fast';
		public static const RABBIT_RUNNING:String = 'rabbit-running';
		public static const RACCOON:String = 'raccoon';
		public static const RACQUET:String = 'racquet';
		public static const RADAR:String = 'radar';
		public static const RADIO_ALT:String = 'radio-alt';
		public static const RADIO_TUNER:String = 'radio-tuner';
		public static const RAINDROPS:String = 'raindrops';
		public static const RAM:String = 'ram';
		public static const RAMP_LOADING:String = 'ramp-loading';
		public static const RAYGUN:String = 'raygun';
		public static const RECTANGLE:String = 'rectangle';
		public static const RECTANGLE_BARCODE:String = 'rectangle-barcode';
		public static const RECTANGLE_CODE:String = 'rectangle-code';
		public static const RECTANGLE_HD:String = 'rectangle-hd';
		public static const RECTANGLE_HISTORY:String = 'rectangle-history';
		public static const RECTANGLE_HISTORY_CIRCLE_PLUS:String = 'rectangle-history-circle-plus';
		public static const RECTANGLE_HISTORY_CIRCLE_USER:String = 'rectangle-history-circle-user';
		public static const RECTANGLE_LANDSCAPE:String = 'rectangle-landscape';
		public static const RECTANGLE_PORTRAIT:String = 'rectangle-portrait';
		public static const RECTANGLE_PRO:String = 'rectangle-pro';
		public static const RECTANGLE_SD:String = 'rectangle-sd';
		public static const RECTANGLES_MIXED:String = 'rectangles-mixed';
		public static const RECTANGLE_TERMINAL:String = 'rectangle-terminal';
		public static const RECTANGLE_VERTICAL:String = 'rectangle-vertical';
		public static const RECTANGLE_VERTICAL_HISTORY:String = 'rectangle-vertical-history';
		public static const RECTANGLE_WIDE:String = 'rectangle-wide';
		public static const REEL:String = 'reel';
		public static const REFLECT_BOTH:String = 'reflect-both';
		public static const REFLECT_HORIZONTAL:String = 'reflect-horizontal';
		public static const REFLECT_VERTICAL:String = 'reflect-vertical';
		public static const REFRIGERATOR:String = 'refrigerator';
		public static const REPEAT_1:String = 'repeat-1';
		public static const REPEAT_1_ALT:String = 'repeat-1-alt';
		public static const REPEAT_ALT:String = 'repeat-alt';
		public static const REPLY_CLOCK:String = 'reply-clock';
		public static const REPLY_TIME:String = 'reply-time';
		public static const RESTROOM_SIMPLE:String = 'restroom-simple';
		public static const RETWEET_ALT:String = 'retweet-alt';
		public static const RHOMBUS:String = 'rhombus';
		public static const RIGHT:String = 'right';
		public static const RIGHT_FROM_LINE:String = 'right-from-line';
		public static const RIGHT_LEFT_LARGE:String = 'right-left-large';
		public static const RIGHT_LONG_TO_LINE:String = 'right-long-to-line';
		public static const RIGHT_TO_LINE:String = 'right-to-line';
		public static const RING_DIAMOND:String = 'ring-diamond';
		public static const RINGS_WEDDING:String = 'rings-wedding';
		public static const ROBOT_ASTROMECH:String = 'robot-astromech';
		public static const ROCKET_LAUNCH:String = 'rocket-launch';
		public static const ROLLER_COASTER:String = 'roller-coaster';
		public static const ROTATE_EXCLAMATION:String = 'rotate-exclamation';
		public static const ROTATE_REVERSE:String = 'rotate-reverse';
		public static const ROUTE_HIGHWAY:String = 'route-highway';
		public static const ROUTE_INTERSTATE:String = 'route-interstate';
		public static const ROUTER:String = 'router';
		public static const ROWS:String = 'rows';
		public static const RUGBY_BALL:String = 'rugby-ball';
		public static const RULER_TRIANGLE:String = 'ruler-triangle';
		public static const RV:String = 'rv';
		public static const SACK:String = 'sack';
		public static const SALAD:String = 'salad';
		public static const SALT_SHAKER:String = 'salt-shaker';
		public static const SANDWICH:String = 'sandwich';
		public static const SAUSAGE:String = 'sausage';
		public static const SAVE_CIRCLE_ARROW_RIGHT:String = 'save-circle-arrow-right';
		public static const SAVE_CIRCLE_XMARK:String = 'save-circle-xmark';
		public static const SAVE_TIMES:String = 'save-times';
		public static const SAX_HOT:String = 'sax-hot';
		public static const SAXOPHONE:String = 'saxophone';
		public static const SAXOPHONE_FIRE:String = 'saxophone-fire';
		public static const SCALPEL:String = 'scalpel';
		public static const SCALPEL_LINE_DASHED:String = 'scalpel-line-dashed';
		public static const SCALPEL_PATH:String = 'scalpel-path';
		public static const SCANNER:String = 'scanner';
		public static const SCANNER_GUN:String = 'scanner-gun';
		public static const SCANNER_IMAGE:String = 'scanner-image';
		public static const SCANNER_KEYBOARD:String = 'scanner-keyboard';
		public static const SCANNER_TOUCHSCREEN:String = 'scanner-touchscreen';
		public static const SCARECROW:String = 'scarecrow';
		public static const SCARF:String = 'scarf';
		public static const SCREENCAST:String = 'screencast';
		public static const SCREENSHOT:String = 'screenshot';
		public static const SCREEN_USERS:String = 'screen-users';
		public static const SCRIBBLE:String = 'scribble';
		public static const SCROLL_OLD:String = 'scroll-old';
		public static const SCROLL_RIBBON:String = 'scroll-ribbon';
		public static const SCRUBBER:String = 'scrubber';
		public static const SCYTHE:String = 'scythe';
		public static const SD_CARDS:String = 'sd-cards';
		public static const SEAL:String = 'seal';
		public static const SEAL_EXCLAMATION:String = 'seal-exclamation';
		public static const SEAL_QUESTION:String = 'seal-question';
		public static const SEAT_AIRLINE:String = 'seat-airline';
		public static const SEMICOLON:String = 'semicolon';
		public static const SEND:String = 'send';
		public static const SEND_BACK:String = 'send-back';
		public static const SEND_BACKWARD:String = 'send-backward';
		public static const SENSOR:String = 'sensor';
		public static const SENSOR_ALERT:String = 'sensor-alert';
		public static const SENSOR_CLOUD:String = 'sensor-cloud';
		public static const SENSOR_FIRE:String = 'sensor-fire';
		public static const SENSOR_ON:String = 'sensor-on';
		public static const SENSOR_SMOKE:String = 'sensor-smoke';
		public static const SENSOR_TRIANGLE_EXCLAMATION:String = 'sensor-triangle-exclamation';
		public static const SHARE_ALL:String = 'share-all';
		public static const SHEEP:String = 'sheep';
		public static const SHELVES:String = 'shelves';
		public static const SHELVES_EMPTY:String = 'shelves-empty';
		public static const SHIELD_CHECK:String = 'shield-check';
		public static const SHIELD_CROSS:String = 'shield-cross';
		public static const SHIELD_EXCLAMATION:String = 'shield-exclamation';
		public static const SHIELD_KEYHOLE:String = 'shield-keyhole';
		public static const SHIELD_MINUS:String = 'shield-minus';
		public static const SHIELD_PLUS:String = 'shield-plus';
		public static const SHIELD_QUARTERED:String = 'shield-quartered';
		public static const SHIELD_SLASH:String = 'shield-slash';
		public static const SHIELD_TIMES:String = 'shield-times';
		public static const SHIELD_XMARK:String = 'shield-xmark';
		public static const SHIPPING_TIMED:String = 'shipping-timed';
		public static const SHIRT_LONG_SLEEVE:String = 'shirt-long-sleeve';
		public static const SHIRT_RUNNING:String = 'shirt-running';
		public static const SHIRT_TANK_TOP:String = 'shirt-tank-top';
		public static const SHISH_KEBAB:String = 'shish-kebab';
		public static const SHOPPING_BASKET_ALT:String = 'shopping-basket-alt';
		public static const SHORTCAKE:String = 'shortcake';
		public static const SHOVEL:String = 'shovel';
		public static const SHOVEL_SNOW:String = 'shovel-snow';
		public static const SHOWER_ALT:String = 'shower-alt';
		public static const SHOWER_DOWN:String = 'shower-down';
		public static const SHREDDER:String = 'shredder';
		public static const SHUTTERS:String = 'shutters';
		public static const SHUTTLECOCK:String = 'shuttlecock';
		public static const SICKLE:String = 'sickle';
		public static const SIDEBAR:String = 'sidebar';
		public static const SIDEBAR_FLIP:String = 'sidebar-flip';
		public static const SIGMA:String = 'sigma';
		public static const SIGNAL_1:String = 'signal-1';
		public static const SIGNAL_2:String = 'signal-2';
		public static const SIGNAL_3:String = 'signal-3';
		public static const SIGNAL_4:String = 'signal-4';
		public static const SIGNAL_ALT:String = 'signal-alt';
		public static const SIGNAL_ALT_1:String = 'signal-alt-1';
		public static const SIGNAL_ALT_2:String = 'signal-alt-2';
		public static const SIGNAL_ALT_3:String = 'signal-alt-3';
		public static const SIGNAL_ALT_4:String = 'signal-alt-4';
		public static const SIGNAL_ALT_SLASH:String = 'signal-alt-slash';
		public static const SIGNAL_BARS:String = 'signal-bars';
		public static const SIGNAL_BARS_FAIR:String = 'signal-bars-fair';
		public static const SIGNAL_BARS_GOOD:String = 'signal-bars-good';
		public static const SIGNAL_BARS_SLASH:String = 'signal-bars-slash';
		public static const SIGNAL_BARS_STRONG:String = 'signal-bars-strong';
		public static const SIGNAL_BARS_WEAK:String = 'signal-bars-weak';
		public static const SIGNAL_FAIR:String = 'signal-fair';
		public static const SIGNAL_GOOD:String = 'signal-good';
		public static const SIGNAL_SLASH:String = 'signal-slash';
		public static const SIGNAL_STREAM:String = 'signal-stream';
		public static const SIGNAL_STREAM_SLASH:String = 'signal-stream-slash';
		public static const SIGNAL_STRONG:String = 'signal-strong';
		public static const SIGNAL_WEAK:String = 'signal-weak';
		public static const SIGNATURE_LOCK:String = 'signature-lock';
		public static const SIGNATURE_SLASH:String = 'signature-slash';
		public static const SIGN_POST:String = 'sign-post';
		public static const SIGN_POSTS:String = 'sign-posts';
		public static const SIGN_POSTS_WRENCH:String = 'sign-posts-wrench';
		public static const SIM_CARDS:String = 'sim-cards';
		public static const SIREN:String = 'siren';
		public static const SIREN_ON:String = 'siren-on';
		public static const SKELETON:String = 'skeleton';
		public static const SKELETON_RIBS:String = 'skeleton-ribs';
		public static const SKI_BOOT:String = 'ski-boot';
		public static const SKI_BOOT_SKI:String = 'ski-boot-ski';
		public static const SKI_JUMP:String = 'ski-jump';
		public static const SKI_LIFT:String = 'ski-lift';
		public static const SKULL_COW:String = 'skull-cow';
		public static const SLASH_BACK:String = 'slash-back';
		public static const SLASH_FORWARD:String = 'slash-forward';
		public static const SLEDDING:String = 'sledding';
		public static const SLIDER:String = 'slider';
		public static const SLIDERS_H_SQUARE:String = 'sliders-h-square';
		public static const SLIDERS_SIMPLE:String = 'sliders-simple';
		public static const SLIDERS_UP:String = 'sliders-up';
		public static const SLIDERS_V:String = 'sliders-v';
		public static const SLIDERS_V_SQUARE:String = 'sliders-v-square';
		public static const SLOT_MACHINE:String = 'slot-machine';
		public static const SMILE_PLUS:String = 'smile-plus';
		public static const SMOKE:String = 'smoke';
		public static const SNAKE:String = 'snake';
		public static const SNOOZE:String = 'snooze';
		public static const SNOW_BLOWING:String = 'snow-blowing';
		public static const SNOWFLAKE_DROPLETS:String = 'snowflake-droplets';
		public static const SNOWFLAKES:String = 'snowflakes';
		public static const SNOWMAN_HEAD:String = 'snowman-head';
		public static const SNOWMOBILE:String = 'snowmobile';
		public static const SOFT_SERVE:String = 'soft-serve';
		public static const SOLAR_SYSTEM:String = 'solar-system';
		public static const SORT_ALT:String = 'sort-alt';
		public static const SORT_CIRCLE:String = 'sort-circle';
		public static const SORT_CIRCLE_DOWN:String = 'sort-circle-down';
		public static const SORT_CIRCLE_UP:String = 'sort-circle-up';
		public static const SORT_SHAPES_DOWN:String = 'sort-shapes-down';
		public static const SORT_SHAPES_DOWN_ALT:String = 'sort-shapes-down-alt';
		public static const SORT_SHAPES_UP:String = 'sort-shapes-up';
		public static const SORT_SHAPES_UP_ALT:String = 'sort-shapes-up-alt';
		public static const SORT_SIZE_DOWN:String = 'sort-size-down';
		public static const SORT_SIZE_DOWN_ALT:String = 'sort-size-down-alt';
		public static const SORT_SIZE_UP:String = 'sort-size-up';
		public static const SORT_SIZE_UP_ALT:String = 'sort-size-up-alt';
		public static const SORT_UP_DOWN:String = 'sort-up-down';
		public static const SOUP:String = 'soup';
		public static const SPACE_STATION_MOON:String = 'space-station-moon';
		public static const SPACE_STATION_MOON_ALT:String = 'space-station-moon-alt';
		public static const SPACE_STATION_MOON_CONSTRUCTION:String = 'space-station-moon-construction';
		public static const SPADE:String = 'spade';
		public static const SPARKLE:String = 'sparkle';
		public static const SPARKLES:String = 'sparkles';
		public static const SPEAKER:String = 'speaker';
		public static const SPEAKERS:String = 'speakers';
		public static const SPIDER_BLACK_WIDOW:String = 'spider-black-widow';
		public static const SPIDER_WEB:String = 'spider-web';
		public static const SPINNER_SCALE:String = 'spinner-scale';
		public static const SPINNER_THIRD:String = 'spinner-third';
		public static const SPLIT:String = 'split';
		public static const SPORTSBALL:String = 'sportsball';
		public static const SPRINKLER:String = 'sprinkler';
		public static const SPRINKLER_CEILING:String = 'sprinkler-ceiling';
		public static const SQUARE_0:String = 'square-0';
		public static const SQUARE_1:String = 'square-1';
		public static const SQUARE_2:String = 'square-2';
		public static const SQUARE_3:String = 'square-3';
		public static const SQUARE_4:String = 'square-4';
		public static const SQUARE_5:String = 'square-5';
		public static const SQUARE_6:String = 'square-6';
		public static const SQUARE_7:String = 'square-7';
		public static const SQUARE_8:String = 'square-8';
		public static const SQUARE_9:String = 'square-9';
		public static const SQUARE_A:String = 'square-a';
		public static const SQUARE_A_LOCK:String = 'square-a-lock';
		public static const SQUARE_AMPERSAND:String = 'square-ampersand';
		public static const SQUARE_ARROW_DOWN:String = 'square-arrow-down';
		public static const SQUARE_ARROW_DOWN_LEFT:String = 'square-arrow-down-left';
		public static const SQUARE_ARROW_DOWN_RIGHT:String = 'square-arrow-down-right';
		public static const SQUARE_ARROW_LEFT:String = 'square-arrow-left';
		public static const SQUARE_ARROW_RIGHT:String = 'square-arrow-right';
		public static const SQUARE_ARROW_UP:String = 'square-arrow-up';
		public static const SQUARE_ARROW_UP_LEFT:String = 'square-arrow-up-left';
		public static const SQUARE_B:String = 'square-b';
		public static const SQUARE_BOLT:String = 'square-bolt';
		public static const SQUARE_C:String = 'square-c';
		public static const SQUARE_CHEVRON_DOWN:String = 'square-chevron-down';
		public static const SQUARE_CHEVRON_LEFT:String = 'square-chevron-left';
		public static const SQUARE_CHEVRON_RIGHT:String = 'square-chevron-right';
		public static const SQUARE_CHEVRON_UP:String = 'square-chevron-up';
		public static const SQUARE_CODE:String = 'square-code';
		public static const SQUARE_D:String = 'square-d';
		public static const SQUARE_DASHED:String = 'square-dashed';
		public static const SQUARE_DASHED_CIRCLE_PLUS:String = 'square-dashed-circle-plus';
		public static const SQUARE_DIVIDE:String = 'square-divide';
		public static const SQUARE_DOLLAR:String = 'square-dollar';
		public static const SQUARE_DOWN:String = 'square-down';
		public static const SQUARE_DOWN_LEFT:String = 'square-down-left';
		public static const SQUARE_DOWN_RIGHT:String = 'square-down-right';
		public static const SQUARE_E:String = 'square-e';
		public static const SQUARE_ELLIPSIS:String = 'square-ellipsis';
		public static const SQUARE_ELLIPSIS_VERTICAL:String = 'square-ellipsis-vertical';
		public static const SQUARE_EXCLAMATION:String = 'square-exclamation';
		public static const SQUARE_F:String = 'square-f';
		public static const SQUARE_FRAGILE:String = 'square-fragile';
		public static const SQUARE_G:String = 'square-g';
		public static const SQUARE_HEART:String = 'square-heart';
		public static const SQUARE_I:String = 'square-i';
		public static const SQUARE_INFO:String = 'square-info';
		public static const SQUARE_J:String = 'square-j';
		public static const SQUARE_K:String = 'square-k';
		public static const SQUARE_KANBAN:String = 'square-kanban';
		public static const SQUARE_L:String = 'square-l';
		public static const SQUARE_LEFT:String = 'square-left';
		public static const SQUARE_LIST:String = 'square-list';
		public static const SQUARE_M:String = 'square-m';
		public static const SQUARE_N:String = 'square-n';
		public static const SQUARE_O:String = 'square-o';
		public static const SQUARE_P:String = 'square-p';
		public static const SQUARE_PARKING_SLASH:String = 'square-parking-slash';
		public static const SQUARE_PHONE_HANGUP:String = 'square-phone-hangup';
		public static const SQUARE_Q:String = 'square-q';
		public static const SQUARE_QUARTERS:String = 'square-quarters';
		public static const SQUARE_QUESTION:String = 'square-question';
		public static const SQUARE_QUOTE:String = 'square-quote';
		public static const SQUARE_R:String = 'square-r';
		public static const SQUARE_RIGHT:String = 'square-right';
		public static const SQUARE_RING:String = 'square-ring';
		public static const SQUARE_ROOT:String = 'square-root';
		public static const SQUARE_S:String = 'square-s';
		public static const SQUARE_SLIDERS:String = 'square-sliders';
		public static const SQUARE_SLIDERS_VERTICAL:String = 'square-sliders-vertical';
		public static const SQUARE_SMALL:String = 'square-small';
		public static const SQUARE_STAR:String = 'square-star';
		public static const SQUARE_T:String = 'square-t';
		public static const SQUARE_TERMINAL:String = 'square-terminal';
		public static const SQUARE_THIS_WAY_UP:String = 'square-this-way-up';
		public static const SQUARE_U:String = 'square-u';
		public static const SQUARE_UP:String = 'square-up';
		public static const SQUARE_UP_LEFT:String = 'square-up-left';
		public static const SQUARE_USER:String = 'square-user';
		public static const SQUARE_V:String = 'square-v';
		public static const SQUARE_W:String = 'square-w';
		public static const SQUARE_WINE_GLASS_CRACK:String = 'square-wine-glass-crack';
		public static const SQUARE_X:String = 'square-x';
		public static const SQUARE_Y:String = 'square-y';
		public static const SQUARE_Z:String = 'square-z';
		public static const SQUID:String = 'squid';
		public static const SQUIRREL:String = 'squirrel';
		public static const STAFF:String = 'staff';
		public static const STANDARD_DEFINITION:String = 'standard-definition';
		public static const STAR_CHRISTMAS:String = 'star-christmas';
		public static const STAR_CIRCLE:String = 'star-circle';
		public static const STAR_EXCLAMATION:String = 'star-exclamation';
		public static const STARFIGHTER:String = 'starfighter';
		public static const STARFIGHTER_ALT:String = 'starfighter-alt';
		public static const STARFIGHTER_ALT_ADVANCED:String = 'starfighter-alt-advanced';
		public static const STARFIGHTER_TWIN_ION_ENGINE:String = 'starfighter-twin-ion-engine';
		public static const STARFIGHTER_TWIN_ION_ENGINE_ADVANCED:String = 'starfighter-twin-ion-engine-advanced';
		public static const STARS:String = 'stars';
		public static const STAR_SHARP:String = 'star-sharp';
		public static const STAR_SHARP_HALF:String = 'star-sharp-half';
		public static const STAR_SHARP_HALF_ALT:String = 'star-sharp-half-alt';
		public static const STAR_SHARP_HALF_STROKE:String = 'star-sharp-half-stroke';
		public static const STARSHIP:String = 'starship';
		public static const STARSHIP_FREIGHTER:String = 'starship-freighter';
		public static const STAR_SHOOTING:String = 'star-shooting';
		public static const STEAK:String = 'steak';
		public static const STEERING_WHEEL:String = 'steering-wheel';
		public static const STOCKING:String = 'stocking';
		public static const STOMACH:String = 'stomach';
		public static const STORE_LOCK:String = 'store-lock';
		public static const STRAWBERRY:String = 'strawberry';
		public static const STRETCHER:String = 'stretcher';
		public static const SUBTITLES:String = 'subtitles';
		public static const SUBTITLES_SLASH:String = 'subtitles-slash';
		public static const SUBWAY_TUNNEL:String = 'subway-tunnel';
		public static const SUN_ALT:String = 'sun-alt';
		public static const SUN_BRIGHT:String = 'sun-bright';
		public static const SUN_CLOUD:String = 'sun-cloud';
		public static const SUN_DUST:String = 'sun-dust';
		public static const SUNGLASSES:String = 'sunglasses';
		public static const SUN_HAZE:String = 'sun-haze';
		public static const SUNRISE:String = 'sunrise';
		public static const SUNSET:String = 'sunset';
		public static const SUSHI:String = 'sushi';
		public static const SUSHI_ROLL:String = 'sushi-roll';
		public static const SWAP:String = 'swap';
		public static const SWAP_ARROWS:String = 'swap-arrows';
		public static const SWORD:String = 'sword';
		public static const SWORD_LASER:String = 'sword-laser';
		public static const SWORD_LASER_ALT:String = 'sword-laser-alt';
		public static const SWORDS:String = 'swords';
		public static const SWORDS_LASER:String = 'swords-laser';
		public static const SYMBOLS:String = 'symbols';
		public static const TABLE_CELLS_LOCK:String = 'table-cells-lock';
		public static const TABLE_LAYOUT:String = 'table-layout';
		public static const TABLE_PICNIC:String = 'table-picnic';
		public static const TABLE_PIVOT:String = 'table-pivot';
		public static const TABLE_ROWS:String = 'table-rows';
		public static const TABLET_ANDROID_ALT:String = 'tablet-android-alt';
		public static const TABLE_TREE:String = 'table-tree';
		public static const TABLET_RUGGED:String = 'tablet-rugged';
		public static const TABLET_SCREEN:String = 'tablet-screen';
		public static const TACHOMETER_ALT_FASTEST:String = 'tachometer-alt-fastest';
		public static const TACHOMETER_ALT_SLOW:String = 'tachometer-alt-slow';
		public static const TACHOMETER_ALT_SLOWEST:String = 'tachometer-alt-slowest';
		public static const TACHOMETER_FASTEST:String = 'tachometer-fastest';
		public static const TACHOMETER_SLOW:String = 'tachometer-slow';
		public static const TACHOMETER_SLOWEST:String = 'tachometer-slowest';
		public static const TACO:String = 'taco';
		public static const TALLY:String = 'tally';
		public static const TALLY_1:String = 'tally-1';
		public static const TALLY_2:String = 'tally-2';
		public static const TALLY_3:String = 'tally-3';
		public static const TALLY_4:String = 'tally-4';
		public static const TALLY_5:String = 'tally-5';
		public static const TAMALE:String = 'tamale';
		public static const TANK_WATER:String = 'tank-water';
		public static const TAXI_BUS:String = 'taxi-bus';
		public static const TEDDY_BEAR:String = 'teddy-bear';
		public static const TELESCOPE:String = 'telescope';
		public static const TELETYPE_ANSWER:String = 'teletype-answer';
		public static const TEMPERATURE_FRIGID:String = 'temperature-frigid';
		public static const TEMPERATURE_HOT:String = 'temperature-hot';
		public static const TEMPERATURE_LIST:String = 'temperature-list';
		public static const TEMPERATURE_SNOW:String = 'temperature-snow';
		public static const TEMPERATURE_SUN:String = 'temperature-sun';
		public static const TENNIS_BALL:String = 'tennis-ball';
		public static const TENT_DOUBLE_PEAK:String = 'tent-double-peak';
		public static const TEXT:String = 'text';
		public static const TEXT_SIZE:String = 'text-size';
		public static const THETA:String = 'theta';
		public static const THOUGHT_BUBBLE:String = 'thought-bubble';
		public static const THUNDERSTORM_MOON:String = 'thunderstorm-moon';
		public static const THUNDERSTORM_SUN:String = 'thunderstorm-sun';
		public static const TICK:String = 'tick';
		public static const TICKET_AIRLINE:String = 'ticket-airline';
		public static const TICKET_PERFORATED:String = 'ticket-perforated';
		public static const TICKET_PERFORATED_PLANE:String = 'ticket-perforated-plane';
		public static const TICKET_PLANE:String = 'ticket-plane';
		public static const TICKETS:String = 'tickets';
		public static const TICKETS_AIRLINE:String = 'tickets-airline';
		public static const TICKETS_PERFORATED:String = 'tickets-perforated';
		public static const TICKETS_PERFORATED_PLANE:String = 'tickets-perforated-plane';
		public static const TICKETS_PLANE:String = 'tickets-plane';
		public static const TICKETS_SIMPLE:String = 'tickets-simple';
		public static const TILDE:String = 'tilde';
		public static const TIMELINE_ARROW:String = 'timeline-arrow';
		public static const TIMER:String = 'timer';
		public static const TIMES_HEXAGON:String = 'times-hexagon';
		public static const TIMES_OCTAGON:String = 'times-octagon';
		public static const TIMES_TO_SLOT:String = 'times-to-slot';
		public static const TIRE:String = 'tire';
		public static const TIRE_FLAT:String = 'tire-flat';
		public static const TIRE_PRESSURE_WARNING:String = 'tire-pressure-warning';
		public static const TIRE_RUGGED:String = 'tire-rugged';
		public static const TOGGLE_LARGE_OFF:String = 'toggle-large-off';
		public static const TOGGLE_LARGE_ON:String = 'toggle-large-on';
		public static const TOILET_PAPER_ALT:String = 'toilet-paper-alt';
		public static const TOILET_PAPER_BLANK:String = 'toilet-paper-blank';
		public static const TOILET_PAPER_BLANK_UNDER:String = 'toilet-paper-blank-under';
		public static const TOILET_PAPER_CHECK:String = 'toilet-paper-check';
		public static const TOILET_PAPER_REVERSE:String = 'toilet-paper-reverse';
		public static const TOILET_PAPER_REVERSE_ALT:String = 'toilet-paper-reverse-alt';
		public static const TOILET_PAPER_REVERSE_SLASH:String = 'toilet-paper-reverse-slash';
		public static const TOILET_PAPER_UNDER:String = 'toilet-paper-under';
		public static const TOILET_PAPER_UNDER_SLASH:String = 'toilet-paper-under-slash';
		public static const TOILET_PAPER_XMARK:String = 'toilet-paper-xmark';
		public static const TOMATO:String = 'tomato';
		public static const TOMBSTONE:String = 'tombstone';
		public static const TOMBSTONE_ALT:String = 'tombstone-alt';
		public static const TOMBSTONE_BLANK:String = 'tombstone-blank';
		public static const TOOTHBRUSH:String = 'toothbrush';
		public static const TOWER_CONTROL:String = 'tower-control';
		public static const TRAFFIC_CONE:String = 'traffic-cone';
		public static const TRAFFIC_LIGHT_GO:String = 'traffic-light-go';
		public static const TRAFFIC_LIGHT_SLOW:String = 'traffic-light-slow';
		public static const TRAFFIC_LIGHT_STOP:String = 'traffic-light-stop';
		public static const TRAIN_SUBWAY_TUNNEL:String = 'train-subway-tunnel';
		public static const TRAIN_TRACK:String = 'train-track';
		public static const TRAIN_TUNNEL:String = 'train-tunnel';
		public static const TRANSFORMER_BOLT:String = 'transformer-bolt';
		public static const TRANSPORTER:String = 'transporter';
		public static const TRANSPORTER_1:String = 'transporter-1';
		public static const TRANSPORTER_2:String = 'transporter-2';
		public static const TRANSPORTER_3:String = 'transporter-3';
		public static const TRANSPORTER_4:String = 'transporter-4';
		public static const TRANSPORTER_5:String = 'transporter-5';
		public static const TRANSPORTER_6:String = 'transporter-6';
		public static const TRANSPORTER_7:String = 'transporter-7';
		public static const TRANSPORTER_EMPTY:String = 'transporter-empty';
		public static const TRASH_ALT_SLASH:String = 'trash-alt-slash';
		public static const TRASH_ARROW_TURN_LEFT:String = 'trash-arrow-turn-left';
		public static const TRASH_CAN_ARROW_TURN_LEFT:String = 'trash-can-arrow-turn-left';
		public static const TRASH_CAN_CHECK:String = 'trash-can-check';
		public static const TRASH_CAN_CLOCK:String = 'trash-can-clock';
		public static const TRASH_CAN_LIST:String = 'trash-can-list';
		public static const TRASH_CAN_PLUS:String = 'trash-can-plus';
		public static const TRASH_CAN_SLASH:String = 'trash-can-slash';
		public static const TRASH_CAN_UNDO:String = 'trash-can-undo';
		public static const TRASH_CAN_XMARK:String = 'trash-can-xmark';
		public static const TRASH_CHECK:String = 'trash-check';
		public static const TRASH_CIRCLE:String = 'trash-circle';
		public static const TRASH_CLOCK:String = 'trash-clock';
		public static const TRASH_LIST:String = 'trash-list';
		public static const TRASH_PLUS:String = 'trash-plus';
		public static const TRASH_SLASH:String = 'trash-slash';
		public static const TRASH_UNDO:String = 'trash-undo';
		public static const TRASH_UNDO_ALT:String = 'trash-undo-alt';
		public static const TRASH_XMARK:String = 'trash-xmark';
		public static const TREASURE_CHEST:String = 'treasure-chest';
		public static const TREE_ALT:String = 'tree-alt';
		public static const TREE_CHRISTMAS:String = 'tree-christmas';
		public static const TREE_DECIDUOUS:String = 'tree-deciduous';
		public static const TREE_DECORATED:String = 'tree-decorated';
		public static const TREE_LARGE:String = 'tree-large';
		public static const TREE_PALM:String = 'tree-palm';
		public static const TREES:String = 'trees';
		public static const T_REX:String = 't-rex';
		public static const TRIAN_BALBOT:String = 'trian-balbot';
		public static const TRIANGLE:String = 'triangle';
		public static const TRIANGLE_INSTRUMENT:String = 'triangle-instrument';
		public static const TRIANGLE_MUSIC:String = 'triangle-music';
		public static const TRIANGLE_PERSON_DIGGING:String = 'triangle-person-digging';
		public static const TRICYCLE:String = 'tricycle';
		public static const TRICYCLE_ADULT:String = 'tricycle-adult';
		public static const TRILLIUM:String = 'trillium';
		public static const TROPHY_ALT:String = 'trophy-alt';
		public static const TROPHY_STAR:String = 'trophy-star';
		public static const TRUCK_BOLT:String = 'truck-bolt';
		public static const TRUCK_CLOCK:String = 'truck-clock';
		public static const TRUCK_CONTAINER:String = 'truck-container';
		public static const TRUCK_CONTAINER_EMPTY:String = 'truck-container-empty';
		public static const TRUCK_COUCH:String = 'truck-couch';
		public static const TRUCK_FIRE:String = 'truck-fire';
		public static const TRUCK_FLATBED:String = 'truck-flatbed';
		public static const TRUCK_LADDER:String = 'truck-ladder';
		public static const TRUCK_PLOW:String = 'truck-plow';
		public static const TRUCK_RAMP:String = 'truck-ramp';
		public static const TRUCK_RAMP_COUCH:String = 'truck-ramp-couch';
		public static const TRUCK_TOW:String = 'truck-tow';
		public static const TRUCK_UTENSILS:String = 'truck-utensils';
		public static const TRUMPET:String = 'trumpet';
		public static const TTY_ANSWER:String = 'tty-answer';
		public static const TUGRIK_SIGN:String = 'tugrik-sign';
		public static const TURKEY:String = 'turkey';
		public static const TURN_DOWN_LEFT:String = 'turn-down-left';
		public static const TURN_DOWN_RIGHT:String = 'turn-down-right';
		public static const TURN_LEFT:String = 'turn-left';
		public static const TURN_LEFT_DOWN:String = 'turn-left-down';
		public static const TURN_LEFT_UP:String = 'turn-left-up';
		public static const TURN_RIGHT:String = 'turn-right';
		public static const TURNTABLE:String = 'turntable';
		public static const TURTLE:String = 'turtle';
		public static const TV_MUSIC:String = 'tv-music';
		public static const TV_RETRO:String = 'tv-retro';
		public static const TYPEWRITER:String = 'typewriter';
		public static const UFO:String = 'ufo';
		public static const UFO_BEAM:String = 'ufo-beam';
		public static const UMBRELLA_ALT:String = 'umbrella-alt';
		public static const UMBRELLA_SIMPLE:String = 'umbrella-simple';
		public static const UNICORN:String = 'unicorn';
		public static const UNIFORM_MARTIAL_ARTS:String = 'uniform-martial-arts';
		public static const UNION:String = 'union';
		public static const UP:String = 'up';
		public static const UP_FROM_BRACKET:String = 'up-from-bracket';
		public static const UP_FROM_DOTTED_LINE:String = 'up-from-dotted-line';
		public static const UP_FROM_LINE:String = 'up-from-line';
		public static const UP_LEFT:String = 'up-left';
		public static const UP_RIGHT:String = 'up-right';
		public static const UP_TO_BRACKET:String = 'up-to-bracket';
		public static const UP_TO_DOTTED_LINE:String = 'up-to-dotted-line';
		public static const UP_TO_LINE:String = 'up-to-line';
		public static const USB_DRIVE:String = 'usb-drive';
		public static const USD_CIRCLE:String = 'usd-circle';
		public static const USD_SQUARE:String = 'usd-square';
		public static const USER_ALIEN:String = 'user-alien';
		public static const USER_BOUNTY_HUNTER:String = 'user-bounty-hunter';
		public static const USER_CHART:String = 'user-chart';
		public static const USER_CHEF:String = 'user-chef';
		public static const USER_CONSTRUCTION:String = 'user-construction';
		public static const USER_COWBOY:String = 'user-cowboy';
		public static const USER_CROWN:String = 'user-crown';
		public static const USER_DOCTOR_HAIR:String = 'user-doctor-hair';
		public static const USER_DOCTOR_HAIR_LONG:String = 'user-doctor-hair-long';
		public static const USER_DOCTOR_MESSAGE:String = 'user-doctor-message';
		public static const USER_GROUP_CROWN:String = 'user-group-crown';
		public static const USER_GROUP_SIMPLE:String = 'user-group-simple';
		public static const USER_HAIR:String = 'user-hair';
		public static const USER_HAIR_BUNS:String = 'user-hair-buns';
		public static const USER_HAIR_LONG:String = 'user-hair-long';
		public static const USER_HAIR_MULLET:String = 'user-hair-mullet';
		public static const USER_HARD_HAT:String = 'user-hard-hat';
		public static const USER_HEADSET:String = 'user-headset';
		public static const USER_HELMET_SAFETY:String = 'user-helmet-safety';
		public static const USER_MAGNIFYING_GLASS:String = 'user-magnifying-glass';
		public static const USER_MD_CHAT:String = 'user-md-chat';
		public static const USER_MUSIC:String = 'user-music';
		public static const USER_NURSE_HAIR:String = 'user-nurse-hair';
		public static const USER_NURSE_HAIR_LONG:String = 'user-nurse-hair-long';
		public static const USER_PILOT:String = 'user-pilot';
		public static const USER_PILOT_TIE:String = 'user-pilot-tie';
		public static const USER_POLICE:String = 'user-police';
		public static const USER_POLICE_TIE:String = 'user-police-tie';
		public static const USER_ROBOT:String = 'user-robot';
		public static const USER_ROBOT_XMARKS:String = 'user-robot-xmarks';
		public static const USERS_CLASS:String = 'users-class';
		public static const USERS_CROWN:String = 'users-crown';
		public static const USER_SHAKESPEARE:String = 'user-shakespeare';
		public static const USERS_MEDICAL:String = 'users-medical';
		public static const USER_TIE_HAIR:String = 'user-tie-hair';
		public static const USER_TIE_HAIR_LONG:String = 'user-tie-hair-long';
		public static const USER_UNLOCK:String = 'user-unlock';
		public static const USER_VISOR:String = 'user-visor';
		public static const USER_VNECK:String = 'user-vneck';
		public static const USER_VNECK_HAIR:String = 'user-vneck-hair';
		public static const USER_VNECK_HAIR_LONG:String = 'user-vneck-hair-long';
		public static const UTENSIL_FORK:String = 'utensil-fork';
		public static const UTENSIL_KNIFE:String = 'utensil-knife';
		public static const UTENSILS_ALT:String = 'utensils-alt';
		public static const UTENSILS_SLASH:String = 'utensils-slash';
		public static const UTILITY_POLE:String = 'utility-pole';
		public static const UTILITY_POLE_DOUBLE:String = 'utility-pole-double';
		public static const VACUUM:String = 'vacuum';
		public static const VACUUM_ROBOT:String = 'vacuum-robot';
		public static const VALUE_ABSOLUTE:String = 'value-absolute';
		public static const VECTOR_CIRCLE:String = 'vector-circle';
		public static const VECTOR_POLYGON:String = 'vector-polygon';
		public static const VENT_DAMPER:String = 'vent-damper';
		public static const VHS:String = 'vhs';
		public static const VIDEO_ARROW_DOWN_LEFT:String = 'video-arrow-down-left';
		public static const VIDEO_ARROW_UP_RIGHT:String = 'video-arrow-up-right';
		public static const VIDEO_CIRCLE:String = 'video-circle';
		public static const VIDEO_HANDHELD:String = 'video-handheld';
		public static const VIDEO_PLUS:String = 'video-plus';
		public static const VIOLIN:String = 'violin';
		public static const VOLUME:String = 'volume';
		public static const VOLUME_MEDIUM:String = 'volume-medium';
		public static const VOLUME_SLASH:String = 'volume-slash';
		public static const VOTE_NAY:String = 'vote-nay';
		public static const WAFFLE:String = 'waffle';
		public static const WAGON_COVERED:String = 'wagon-covered';
		public static const WALKER:String = 'walker';
		public static const WALL_BRICK:String = 'wall-brick';
		public static const WAND:String = 'wand';
		public static const WAREHOUSE_ALT:String = 'warehouse-alt';
		public static const WAREHOUSE_FULL:String = 'warehouse-full';
		public static const WASHER:String = 'washer';
		public static const WASHING_MACHINE:String = 'washing-machine';
		public static const WATCH:String = 'watch';
		public static const WATCH_APPLE:String = 'watch-apple';
		public static const WATCH_CALCULATOR:String = 'watch-calculator';
		public static const WATCH_FITNESS:String = 'watch-fitness';
		public static const WATCH_SMART:String = 'watch-smart';
		public static const WATER_ARROW_DOWN:String = 'water-arrow-down';
		public static const WATER_ARROW_UP:String = 'water-arrow-up';
		public static const WATER_LOWER:String = 'water-lower';
		public static const WATERMELON_SLICE:String = 'watermelon-slice';
		public static const WATER_RISE:String = 'water-rise';
		public static const WAVE:String = 'wave';
		public static const WAVEFORM:String = 'waveform';
		public static const WAVEFORM_CIRCLE:String = 'waveform-circle';
		public static const WAVEFORM_LINES:String = 'waveform-lines';
		public static const WAVEFORM_PATH:String = 'waveform-path';
		public static const WAVE_PULSE:String = 'wave-pulse';
		public static const WAVE_SINE:String = 'wave-sine';
		public static const WAVES_SINE:String = 'waves-sine';
		public static const WAVE_TRIANGLE:String = 'wave-triangle';
		public static const WEBCAM:String = 'webcam';
		public static const WEBCAM_SLASH:String = 'webcam-slash';
		public static const WEBHOOK:String = 'webhook';
		public static const WHALE:String = 'whale';
		public static const WHEAT:String = 'wheat';
		public static const WHEAT_AWN_SLASH:String = 'wheat-awn-slash';
		public static const WHEAT_SLASH:String = 'wheat-slash';
		public static const WHISKEY_GLASS_ICE:String = 'whiskey-glass-ice';
		public static const WHISTLE:String = 'whistle';
		public static const WIFI_1:String = 'wifi-1';
		public static const WIFI_2:String = 'wifi-2';
		public static const WIFI_EXCLAMATION:String = 'wifi-exclamation';
		public static const WIFI_FAIR:String = 'wifi-fair';
		public static const WIFI_SLASH:String = 'wifi-slash';
		public static const WIFI_WEAK:String = 'wifi-weak';
		public static const WIND_CIRCLE_EXCLAMATION:String = 'wind-circle-exclamation';
		public static const WINDOW:String = 'window';
		public static const WINDOW_ALT:String = 'window-alt';
		public static const WINDOW_FLIP:String = 'window-flip';
		public static const WINDOW_FRAME:String = 'window-frame';
		public static const WINDOW_FRAME_OPEN:String = 'window-frame-open';
		public static const WINDSOCK:String = 'windsock';
		public static const WIND_TURBINE:String = 'wind-turbine';
		public static const WIND_WARNING:String = 'wind-warning';
		public static const WINE_GLASS_CRACK:String = 'wine-glass-crack';
		public static const WREATH:String = 'wreath';
		public static const WREATH_LAUREL:String = 'wreath-laurel';
		public static const WRENCH_SIMPLE:String = 'wrench-simple';
		public static const XMARK_HEXAGON:String = 'xmark-hexagon';
		public static const XMARK_LARGE:String = 'xmark-large';
		public static const XMARK_OCTAGON:String = 'xmark-octagon';
		public static const XMARK_TO_SLOT:String = 'xmark-to-slot';
		public static const ZZZ:String = 'zzz';

    }
}