/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.mxml;

import org.apache.royale.compiler.common.SourceLocation;
import org.apache.royale.compiler.filespecs.FileSpecification;
import org.apache.royale.compiler.filespecs.IFileSpecification;
import org.apache.royale.compiler.internal.mxml.MXMLData;
import org.apache.royale.compiler.internal.mxml.MXMLDialect;
import org.apache.royale.compiler.mxml.IMXMLData;
import org.apache.royale.compiler.mxml.IMXMLTagData;
import org.apache.royale.compiler.mxml.IMXMLUnitData;
import org.apache.royale.utils.FastStack;

public abstract class MXMLUnitData
extends SourceLocation
implements IMXMLUnitData {
    private MXMLData parent;
    protected int index;
    private int parentIndex;

    public MXMLUnitData() {
        this.parent = null;
        this.index = -1;
    }

    public MXMLUnitData(MXMLUnitData other) {
        this.parent = other.parent;
        this.index = other.index;
    }

    @Override
    public int getContentStart() {
        return this.getAbsoluteStart();
    }

    @Override
    public int getContentEnd() {
        return this.getAbsoluteEnd();
    }

    public void setLocation(MXMLData parent, int index) {
        this.parent = parent;
        this.index = index;
        this.setSourcePath(parent.getPath());
    }

    public void setParentUnitDataIndex(int parentIndex) {
        this.parentIndex = parentIndex;
    }

    @Override
    public final IMXMLUnitData getParentUnitData() {
        return this.parent.getUnit(this.parentIndex);
    }

    public final int getParentUnitDataIndex() {
        return this.parentIndex;
    }

    public void setOffsets(int start, int end) {
        this.setStart(start);
        this.setEnd(end);
    }

    public void adjustOffsets(int offsetAdjustment) {
        this.setStart(this.getAbsoluteStart() + offsetAdjustment);
        this.setEnd(this.getAbsoluteEnd() + offsetAdjustment);
    }

    @Override
    public final IFileSpecification getSource() {
        return new FileSpecification(this.getParent().getPath().toString());
    }

    @Override
    public final int getIndex() {
        return this.index;
    }

    @Override
    public boolean isText() {
        return false;
    }

    @Override
    public boolean isTag() {
        return false;
    }

    @Override
    public boolean isOpenTag() {
        return false;
    }

    @Override
    public boolean isOpenAndNotEmptyTag() {
        return false;
    }

    @Override
    public boolean isCloseTag() {
        return false;
    }

    @Override
    public final IMXMLData getParent() {
        return this.parent;
    }

    @Override
    public final IMXMLUnitData getPrevious() {
        return this.parent.getUnit(this.index - 1);
    }

    @Override
    public final IMXMLUnitData getNext() {
        return this.parent.getUnit(this.index + 1);
    }

    @Override
    public final IMXMLUnitData getNextSiblingUnit() {
        IMXMLUnitData unit = this;
        if (this.isOpenAndNotEmptyTag()) {
            unit = ((IMXMLTagData)unit).findMatchingEndTag();
        }
        if (unit != null && (unit = unit.getNext()) != null && unit.getParentUnitData() != this.getParentUnitData()) {
            unit = null;
        }
        return unit;
    }

    @Override
    public final IMXMLTagData getNextTag() {
        IMXMLUnitData nextUnit = this.getNext();
        while (nextUnit != null) {
            if (nextUnit.isTag()) {
                return (IMXMLTagData)nextUnit;
            }
            nextUnit = nextUnit.getNext();
        }
        return null;
    }

    @Override
    public boolean containsOffset(int offset) {
        return MXMLData.contains(this.getAbsoluteStart(), this.getAbsoluteEnd(), offset);
    }

    @Override
    public final IMXMLTagData getContainingTag(int offset) {
        FastStack<String> tagNames = new FastStack<String>();
        IMXMLUnitData current = this.getPrevious();
        IMXMLTagData containingTag = null;
        if (this.containsOffset(offset) && this.isCloseTag()) {
            IMXMLTagData tag = (IMXMLTagData)((Object)this);
            tagNames.push(tag.getName());
        }
        while (current != null && containingTag == null) {
            if (current.isTag()) {
                IMXMLTagData currentTag = (IMXMLTagData)current;
                if (currentTag.isCloseTag()) {
                    tagNames.push(currentTag.getName());
                } else if (currentTag.isOpenTag() && !currentTag.isEmptyTag()) {
                    String stackName = "";
                    while (stackName.compareTo(currentTag.getName()) != 0 && !tagNames.isEmpty()) {
                        stackName = (String)tagNames.pop();
                    }
                    if (stackName.compareTo(currentTag.getName()) != 0) {
                        containingTag = currentTag;
                    }
                }
            }
            current = current.getPrevious();
        }
        return containingTag;
    }

    @Override
    public MXMLDialect getMXMLDialect() {
        return this.getParent().getMXMLDialect();
    }

    protected String getTypeString() {
        return this.getClass().getSimpleName();
    }

    public String toDumpString() {
        return this.buildDumpString(false);
    }

    public String buildDumpString(boolean skipSrcPath) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(this.getIndex());
        sb.append(']');
        sb.append('\t');
        if (!skipSrcPath) {
            sb.append(this.getLine() + 1);
            sb.append('\t');
            sb.append(this.getColumn() + 1);
            sb.append('\t');
        }
        sb.append(this.getAbsoluteStart());
        sb.append('\t');
        sb.append(this.getAbsoluteEnd());
        sb.append('\t');
        String type = this.getTypeString();
        sb.append(type);
        int n = 32 - type.length();
        for (int i = 0; i < n; ++i) {
            sb.append(' ');
        }
        sb.append('\t');
        sb.append('^');
        sb.append('[');
        sb.append(this.parentIndex);
        sb.append(']');
        return sb.toString();
    }

    public boolean verify() {
        assert (this.getSourcePath() != null) : "MXMLUnitData has null source path: " + this.toString();
        assert (this.getStart() != -1) : "MXMLUnitData has unknown start: " + this.toString();
        assert (this.getEnd() != -1) : "MXMLUnitData has unknown end: " + this.toString();
        assert (this.getLine() != -1) : "MXMLUnitData has unknown line: " + this.toString();
        assert (this.getColumn() != -1) : "MXMLUnitData has unknown column: " + this.toString();
        return true;
    }
}

