/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.definition;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.servicecomb.config.inject.InjectProperties;
import org.apache.servicecomb.config.inject.InjectProperty;

@InjectProperties(prefix="servicecomb")
public class OperationConfig {
    public static final List<String> CONSUMER_OP_ANY_PRIORITY = Arrays.asList("${service}.${schema}.${operation}", "${service}.${schema}", "${service}");
    public static final List<String> PRODUCER_OP_ANY_PRIORITY = Arrays.asList("${schema}.${operation}", "${schema}");
    public static final List<String> CONSUMER_OP_PRIORITY = Arrays.asList(".${service}.${schema}.${operation}", ".${service}.${schema}", ".${service}", "");
    public static final List<String> PRODUCER_OP_PRIORITY = Arrays.asList(".${schema}.${operation}", ".${schema}", "");
    @InjectProperty(keys={"metrics.${consumer-producer}.invocation.slow.enabled${op-priority}", "${consumer-producer}.invocation.slow.enabled${op-priority}"}, defaultValue="false")
    private boolean slowInvocationEnabled;
    @InjectProperty(keys={"metrics.${consumer-producer}.invocation.slow.msTime${op-priority}", "${consumer-producer}.invocation.slow.msTime${op-priority}"}, defaultValue="1000")
    private long msSlowInvocation;
    private long nanoSlowInvocation;
    @InjectProperty(keys={"request.${op-any-priority}.timeout", "request.timeout"}, defaultValue="30000")
    private long msRequestTimeout;
    @InjectProperty(keys={"Provider.requestWaitInPoolTimeout${op-priority}", "highway.server.requestWaitInPoolTimeout"}, defaultValue="30000")
    private long msHighwayRequestWaitInPoolTimeout;
    private long nanoHighwayRequestWaitInPoolTimeout;
    @InjectProperty(keys={"Provider.requestWaitInPoolTimeout${op-priority}", "rest.server.requestWaitInPoolTimeout"}, defaultValue="30000")
    private long msRestRequestWaitInPoolTimeout;
    private long nanoRestRequestWaitInPoolTimeout;

    public boolean isSlowInvocationEnabled() {
        return this.slowInvocationEnabled;
    }

    public void setSlowInvocationEnabled(boolean slowInvocationEnabled) {
        this.slowInvocationEnabled = slowInvocationEnabled;
    }

    public long getMsSlowInvocation() {
        return this.msSlowInvocation;
    }

    public void setMsSlowInvocation(long msSlowInvocation) {
        this.msSlowInvocation = msSlowInvocation;
        this.nanoSlowInvocation = TimeUnit.MILLISECONDS.toNanos(msSlowInvocation);
    }

    public long getNanoSlowInvocation() {
        return this.nanoSlowInvocation;
    }

    public long getMsRequestTimeout() {
        return this.msRequestTimeout;
    }

    public void setMsRequestTimeout(long msRequestTimeout) {
        this.msRequestTimeout = msRequestTimeout;
    }

    public long getMsHighwayRequestWaitInPoolTimeout() {
        return this.msHighwayRequestWaitInPoolTimeout;
    }

    public void setMsHighwayRequestWaitInPoolTimeout(long msHighwayRequestWaitInPoolTimeout) {
        this.msHighwayRequestWaitInPoolTimeout = msHighwayRequestWaitInPoolTimeout;
        this.nanoHighwayRequestWaitInPoolTimeout = TimeUnit.MILLISECONDS.toNanos(msHighwayRequestWaitInPoolTimeout);
    }

    public long getNanoHighwayRequestWaitInPoolTimeout() {
        return this.nanoHighwayRequestWaitInPoolTimeout;
    }

    public long getMsRestRequestWaitInPoolTimeout() {
        return this.msRestRequestWaitInPoolTimeout;
    }

    public void setMsRestRequestWaitInPoolTimeout(long msRestRequestWaitInPoolTimeout) {
        this.msRestRequestWaitInPoolTimeout = msRestRequestWaitInPoolTimeout;
        this.nanoRestRequestWaitInPoolTimeout = TimeUnit.MILLISECONDS.toNanos(msRestRequestWaitInPoolTimeout);
    }

    public long getNanoRestRequestWaitInPoolTimeout() {
        return this.nanoRestRequestWaitInPoolTimeout;
    }
}

