/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.search.jpa;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.apache.cxf.jaxrs.ext.search.ConditionType;
import org.apache.cxf.jaxrs.ext.search.OrSearchCondition;
import org.apache.cxf.jaxrs.ext.search.PrimitiveStatement;
import org.apache.cxf.jaxrs.ext.search.SearchCondition;
import org.apache.cxf.jaxrs.ext.search.SearchUtils;
import org.apache.cxf.jaxrs.ext.search.collections.CollectionCheckInfo;
import org.apache.cxf.jaxrs.ext.search.visitor.AbstractSearchConditionVisitor;

public abstract class AbstractJPATypedQueryVisitor<T, T1, E>
extends AbstractSearchConditionVisitor<T, E> {
    private EntityManager em;
    private Class<T> tClass;
    private Class<T1> queryClass;
    private Root<T> root;
    private CriteriaBuilder builder;
    private CriteriaQuery<T1> cq;
    private Stack<List<Predicate>> predStack = new Stack();
    private boolean criteriaFinalized;
    private Set<String> joinProperties;

    protected AbstractJPATypedQueryVisitor(EntityManager em, Class<T> tClass) {
        this(em, tClass, null, null, null);
    }

    protected AbstractJPATypedQueryVisitor(EntityManager em, Class<T> tClass, Class<T1> queryClass) {
        this(em, tClass, queryClass, null, null);
    }

    protected AbstractJPATypedQueryVisitor(EntityManager em, Class<T> tClass, Map<String, String> fieldMap) {
        this(em, tClass, null, fieldMap, null);
    }

    protected AbstractJPATypedQueryVisitor(EntityManager em, Class<T> tClass, List<String> joinProps) {
        this(em, tClass, null, null, joinProps);
    }

    protected AbstractJPATypedQueryVisitor(EntityManager em, Class<T> tClass, Map<String, String> fieldMap, List<String> joinProps) {
        this(em, tClass, null, fieldMap, joinProps);
    }

    protected AbstractJPATypedQueryVisitor(EntityManager em, Class<T> tClass, Class<T1> queryClass, Map<String, String> fieldMap) {
        this(em, tClass, queryClass, fieldMap, null);
    }

    protected AbstractJPATypedQueryVisitor(EntityManager em, Class<T> tClass, Class<T1> queryClass, Map<String, String> fieldMap, List<String> joinProps) {
        super(fieldMap);
        this.em = em;
        this.tClass = tClass;
        this.queryClass = AbstractJPATypedQueryVisitor.toQueryClass(queryClass, tClass);
        this.joinProperties = joinProps == null ? null : new HashSet<String>(joinProps);
    }

    private static <E> Class<E> toQueryClass(Class<E> queryClass, Class<?> tClass) {
        return queryClass != null ? queryClass : tClass;
    }

    protected EntityManager getEntityManager() {
        return this.em;
    }

    @Override
    public void visit(SearchCondition<T> sc) {
        if (this.builder == null) {
            this.builder = this.em.getCriteriaBuilder();
            this.cq = this.builder.createQuery(this.queryClass);
            this.root = this.cq.from(this.tClass);
            this.predStack.push(new ArrayList());
        }
        if (sc.getStatement() != null) {
            this.predStack.peek().add(this.buildPredicate(sc.getStatement()));
        } else {
            this.predStack.push(new ArrayList());
            for (SearchCondition<T> condition : sc.getSearchConditions()) {
                condition.accept(this);
            }
            List<Predicate> predsList = this.predStack.pop();
            Predicate[] preds = predsList.toArray(new Predicate[predsList.size()]);
            Predicate newPred = sc instanceof OrSearchCondition ? this.builder.or(preds) : this.builder.and(preds);
            this.predStack.peek().add(newPred);
        }
    }

    protected CriteriaBuilder getCriteriaBuilder() {
        return this.builder;
    }

    protected Class<T1> getQueryClass() {
        return this.queryClass;
    }

    public Root<T> getRoot() {
        return this.root;
    }

    public TypedQuery<T1> getTypedQuery() {
        return this.em.createQuery(this.getCriteriaQuery());
    }

    public CriteriaQuery<T1> getCriteriaQuery() {
        if (!this.criteriaFinalized) {
            List<Predicate> predsList = this.predStack.pop();
            this.cq.where(predsList.toArray(new Predicate[predsList.size()]));
            this.criteriaFinalized = true;
        }
        return this.cq;
    }

    private Predicate buildPredicate(PrimitiveStatement ps) {
        String name = ps.getProperty();
        Object propertyValue = ps.getValue();
        this.validatePropertyValue(name, propertyValue);
        name = super.getRealPropertyName(name);
        AbstractSearchConditionVisitor.ClassValue cv = this.getPrimitiveFieldClass(ps, name, ps.getValue().getClass(), ps.getValueType(), propertyValue);
        CollectionCheckInfo collInfo = cv.getCollectionCheckInfo();
        Path<T> path = this.getPath((Path<?>)this.root, name, cv, collInfo);
        Predicate pred = collInfo == null ? this.doBuildPredicate(ps.getCondition(), path, cv.getCls(), cv.getValue()) : this.doBuildCollectionPredicate(ps.getCondition(), path, collInfo);
        return pred;
    }

    private Predicate doBuildPredicate(ConditionType ct, Path<?> path, Class<?> valueClazz, Object value) {
        Class<?> clazz = valueClazz;
        Expression exp = path.as(clazz);
        Predicate pred = null;
        switch (ct) {
            case GREATER_THAN: {
                pred = this.builder.greaterThan(exp, (Comparable)clazz.cast(value));
                break;
            }
            case EQUALS: {
                if (clazz.equals(String.class)) {
                    String originalValue = value.toString();
                    String theValue = SearchUtils.toSqlWildcardString(originalValue, this.isWildcardStringMatch());
                    if (SearchUtils.containsWildcard(originalValue)) {
                        if (SearchUtils.containsEscapedChar(theValue)) {
                            pred = this.builder.like(exp, theValue, '\\');
                            break;
                        }
                        pred = this.builder.like(exp, theValue);
                        break;
                    }
                    pred = this.builder.equal(exp, clazz.cast(value));
                    break;
                }
                pred = this.builder.equal(exp, clazz.cast(value));
                break;
            }
            case NOT_EQUALS: {
                if (clazz.equals(String.class)) {
                    String originalValue = value.toString();
                    String theValue = SearchUtils.toSqlWildcardString(originalValue, this.isWildcardStringMatch());
                    if (SearchUtils.containsWildcard(originalValue)) {
                        if (SearchUtils.containsEscapedChar(theValue)) {
                            pred = this.builder.notLike(exp, theValue, '\\');
                            break;
                        }
                        pred = this.builder.notLike(exp, theValue);
                        break;
                    }
                    pred = this.builder.notEqual(exp, clazz.cast(value));
                    break;
                }
                pred = this.builder.notEqual(exp, clazz.cast(value));
                break;
            }
            case LESS_THAN: {
                pred = this.builder.lessThan(exp, (Comparable)clazz.cast(value));
                break;
            }
            case LESS_OR_EQUALS: {
                pred = this.builder.lessThanOrEqualTo(exp, (Comparable)clazz.cast(value));
                break;
            }
            case GREATER_OR_EQUALS: {
                pred = this.builder.greaterThanOrEqualTo(exp, (Comparable)clazz.cast(value));
                break;
            }
        }
        return pred;
    }

    private Predicate doBuildCollectionPredicate(ConditionType ct, Path<?> path, CollectionCheckInfo collInfo) {
        Predicate pred = null;
        Expression exp = this.builder.size(path);
        Integer value = Integer.valueOf(collInfo.getCollectionCheckValue().toString());
        switch (ct) {
            case GREATER_THAN: {
                pred = this.builder.greaterThan(exp, (Comparable)value);
                break;
            }
            case EQUALS: {
                pred = this.builder.equal(exp, (Object)value);
                break;
            }
            case NOT_EQUALS: {
                pred = this.builder.notEqual(exp, (Object)value);
                break;
            }
            case LESS_THAN: {
                pred = this.builder.lessThan(exp, (Comparable)value);
                break;
            }
            case LESS_OR_EQUALS: {
                pred = this.builder.lessThanOrEqualTo(exp, (Comparable)value);
                break;
            }
            case GREATER_OR_EQUALS: {
                pred = this.builder.greaterThanOrEqualTo(exp, (Comparable)value);
                break;
            }
        }
        return pred;
    }

    private Path<?> getPath(Path<?> element, String name, AbstractSearchConditionVisitor.ClassValue cv, CollectionCheckInfo collSize) {
        if (name.contains(".")) {
            String pre = name.substring(0, name.indexOf(46));
            String post = name.substring(name.indexOf(46) + 1);
            Path<?> nextPath = this.getNextPath(element, pre, post, cv, null);
            return this.getPath(nextPath, post, cv, collSize);
        }
        return this.getNextPath(element, name, null, cv, collSize);
    }

    private Path<?> getNextPath(Path<?> element, String name, String postName, AbstractSearchConditionVisitor.ClassValue cv, CollectionCheckInfo collSize) {
        boolean isCollectionOrJoin;
        boolean bl = isCollectionOrJoin = !(collSize != null || !cv.isCollection(name) && !this.isJoinProperty(name) && !this.existingCollectionInPostName(cv, postName) || element != this.root && !(element instanceof Join));
        if (isCollectionOrJoin) {
            Path<?> path = this.getExistingJoinProperty((From)element, name);
            if (path != null) {
                return path;
            }
            return element == this.root ? this.root.join(name) : ((Join)element).join(name);
        }
        return element.get(name);
    }

    private boolean isJoinProperty(String prop) {
        return this.joinProperties == null ? false : this.joinProperties.contains(prop);
    }

    private Path<?> getExistingJoinProperty(From<?, ?> element, String prop) {
        Set joins = element.getJoins();
        for (Object object : joins) {
            Join join = (Join)object;
            if (!join.getAttribute().getName().equals(prop)) continue;
            return join;
        }
        return null;
    }

    private boolean existingCollectionInPostName(AbstractSearchConditionVisitor.ClassValue cv, String postName) {
        if (postName != null && postName.indexOf(46) != -1) {
            String[] splitName;
            for (String name : splitName = postName.split("\\.")) {
                if (!cv.isCollection(name)) continue;
                return true;
            }
        }
        return false;
    }
}

